/*
** $Id: ebnf.c,v 1.2 90/10/23 14:40:19 cogito Exp $
*/
static char rcs_id[]= "$Id: ebnf.c,v 1.2 90/10/23 14:40:19 cogito Exp $";

#include "ccomar.h"
#include "ccomarl.h"
#include "equality.h"
#include "ebnf.h"

#include <stdio.h>


#define NEWLISTELEM(d) cmr_add_to_list(cmr_new_list(), \
                                       cmr_new_elunit(d))

/**************************************************************************/
/*                          private functions                             */
/**************************************************************************/


/* Section 1: transformation of EBNF constructs */


/* in all functions ebnf_embalt_to_bnf .. ebnf_opt_to_bnf
 * rek and LR are boolean parameters.
 * LR == TRUE => this EBNF construct will be eliminated using left
 *               recursion.
 * LR == FALSE => this EBNF construct will be eliminated using right
 *                recursion.
 *
 * rek == TRUE  => only this production will be transformed recursively
 *                 to BNF without looking for structural equivalences
 *                 outside of this rule.
 * rek == FALSE => this production will be transformed to BNF and 
 *                 structural equivalences outside of this rule will
 *                 be substituted by the same new nonterminal.
 * newnt defines the nonterminal which will be the left hand side of
 *       new productions.
 */


/* ebnf_embalt_to_bnf - transforms embedded alt-nodes to BNF
 * on exit: if alt does not point to a node tagged with P_ALT
 *                      then CMR_UNKERR
 *                      else did of the last production generated in 
 *                               in this function.
 */
static DID ebnf_embalt_to_bnf(c, alt, newnt, rek, LR)
tCOMAR *c, *alt;
DID newnt;
boolean rek, LR;
{
  tCOMAR *listleft, *listright;
  DID d;
  int stat;

#ifdef DBUG
  fprintf(stderr,"ebnf_embalt_to_bnf startet.\n");
  fflush(stderr);
#endif

  if (cmr_get_tag(alt) != P_ALT)
    return(CMR_UNKERR);
  listleft = cmrl_copy_list(cmr_get_alt_units1(alt));
  listright = cmrl_copy_list(cmr_get_alt_units2(alt)); 
  d = cmr_new_prod(c, S_NONAME, newnt, listleft);
  if (rek) 
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, d, rek, LR)) != CMR_SUCCESS)
      return(stat);
  d = cmr_new_prod(c, S_NONAME, newnt, listright);
  if (rek) 
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, d, rek, LR)) != CMR_SUCCESS)
      return(stat);
  return(d);
}



/* ebnf_alonealt_to_bnf - transforms single alt-nodes to BNF
 * on entry : prod is the DID of a production
 * on exit  : CMR_UNKERR iff right hand side of production is longer 
 *                           than 1  or
 *                           first element is not an alt-node
 *            did of the generated production in this function.
 */
static DID ebnf_alonealt_to_bnf(c, prod, rek, LR)
tCOMAR *c;
DID prod;
boolean rek, LR;
{
  tCOMAR *list, *alt, *l1, *l2;
  DID d;
  int stat;

#ifdef DBUG
  fprintf(stderr,"ebnf_alonealt_to_bnf startet.\n");
  fflush(stderr);
#endif

  list = cmr_get_prod_units(c, prod);
  if (list == (tCOMAR *)NULL) 
    return(CMR_UNKERR); 
 
  if (cmrl_dlist_len(list) > 1 ||
      !cmrl_dlist_firstis(list, P_ALT))
    return(CMR_UNKERR);

  alt = cmr_list_head(cmr_get_begin_list(list));
  l1 = cmrl_copy_list(cmr_get_alt_units1(alt));
  l2 = cmrl_copy_list(cmr_get_alt_units2(alt));

  if (cmr_set_prod_units(c,prod,l1) == (tCOMAR *)NULL)
    return(CMR_UNKERR);
  if (rek) 
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, prod, rek, LR)) != CMR_SUCCESS)
      return(stat);
  
  d = cmr_new_prod(c,S_NONAME,cmr_get_prod_lhs(c,prod),l2);
  if (rek)
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, d, rek, LR)) != CMR_SUCCESS)
      return(stat);
  return(d);
}



/* ebnf_plus_to_bnf - transforms plus-nodes to BNF
 * on exit: if plus does not point to a node tagged with P_PLUS
 *                       then CMR_UNKERR
 *                       else did of the last production generated in 
 *                                this function
 */
static DID ebnf_plus_to_bnf(c,plus,newnt,rek,LR)
tCOMAR *c, *plus;
DID newnt;
boolean rek, LR;
{
  tCOMAR *list;
  DID nt2, d;
  int stat;

#ifdef DBUG
  fprintf(stderr,"ebnf_plus_to_bnf startet.\n");
  fflush(stderr);
#endif

  if (cmr_get_tag(plus) != P_PLUS) return(CMR_UNKERR);
  list = cmrl_copy_list(cmr_get_begin_list(cmr_get_plus_units(plus)));
  
  if ((nt2 = cmrl_gen_nterm(c)) == CMR_UNKERR) return(CMR_UNKERR);

  if (LR) {
    list = cmr_begin_list(cmr_cat_lists(NEWLISTELEM(nt2),
                                        list));
    }
  else {
    list = cmr_begin_list(cmr_cat_lists(list,
					NEWLISTELEM(nt2)));
    }
  d = cmr_new_prod(c,S_NONAME,newnt,list);
  if (rek)
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, d, rek, LR)) != CMR_SUCCESS)
      return(stat);
  d = cmr_new_prod(c,S_NONAME,nt2,
		   cmr_begin_list(NEWLISTELEM(newnt)));

  return(cmr_new_prod(c,S_NONAME,nt2,
		      cmr_begin_list(NEWLISTELEM(cmrl_get_eps_did(c)))));
}



/* ebnf_star_to_bnf - transforms star-nodes to BNF
 * on exit: if star does not point to a node tagged with P_STAR
 *                       then CMR_UNKERR
 *                       else did of the last production generated in
 *                                this function
 */
static DID ebnf_star_to_bnf(c,star,newnt,rek,LR)
tCOMAR *c, *star;
DID newnt;
boolean rek, LR;
{
  tCOMAR *list;
  DID d;
  int stat;

#ifdef DBUG
  fprintf(stderr,"ebnf_star_to_bnf startet.\n");
  fflush(stderr);
#endif

  if (cmr_get_tag(star) != P_STAR) return(CMR_UNKERR);
  list = cmrl_copy_list(cmr_get_begin_list(cmr_get_star_units(star)));

  if (LR) {
    list = cmr_begin_list(cmr_cat_lists(NEWLISTELEM(newnt),
                                        list));
   }
   else {
     list = cmr_begin_list(cmr_cat_lists(list,
					 NEWLISTELEM(newnt)));
     }
  d = cmr_new_prod(c,S_NONAME,newnt,list);
  if (rek)
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, d, rek, LR)) != CMR_SUCCESS)
      return(stat);
  return(cmr_new_prod(c,S_NONAME,newnt,
		      cmr_begin_list(NEWLISTELEM(cmrl_get_eps_did(c)))));
}



/* ebnf_delrep_to_bnf - transforms delrep-nodes to BNF
 * on exit: if delrep does not point to a node tagged with P_DELREP
 *                         then CMR_UNKERR
 *                         else did of the last production generated in
 *                                  this function
 */
static DID ebnf_delrep_to_bnf(c,delrep,newnt,rek,LR) 
tCOMAR *c, *delrep;
DID newnt;
boolean rek, LR;
{
  tCOMAR *list;
  DID nt2, d;
  int stat;

#ifdef DBUG
  fprintf(stderr,"ebnf_delrep_to_bnf startet.\n");
  fflush(stderr);
#endif

  if (cmr_get_tag(delrep) != P_DELREP) 
    return(CMR_UNKERR);
  if ((nt2 = cmrl_gen_nterm(c)) == CMR_UNKERR)
    return(CMR_UNKERR);
  list = cmrl_copy_list(cmr_get_begin_list(cmr_get_delrep_units1(delrep)));

  if (LR) {
    list = cmr_cat_lists(NEWLISTELEM(nt2),
                         list);
    }
  else {
    list = cmr_cat_lists(list,
			 NEWLISTELEM(nt2));
   }
  
  list = cmr_begin_list(list);
  d = cmr_new_prod(c,S_NONAME,newnt,list);
  if (rek)
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, d, rek, LR)) != CMR_SUCCESS)
      return(stat);

  list = cmrl_copy_list(cmr_get_begin_list(cmr_get_delrep_units2(delrep)));

  if (LR) { 
    list = cmr_cat_lists(NEWLISTELEM(newnt),
                         list);
    }
  else {
    list = cmr_cat_lists(list,
			 NEWLISTELEM(newnt));
    }

  list = cmr_begin_list(list);
  d = cmr_new_prod(c,S_NONAME,nt2,list);
  if (rek) 
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, d, rek, LR)) != CMR_SUCCESS)
      return(stat);

  return(cmr_new_prod(c,S_NONAME,nt2,
		      cmr_begin_list(NEWLISTELEM(cmrl_get_eps_did(c)))));
}


/* ebnf_opt_to_bnf - transforms opt nodes to BNF
 * on exit: if opt does not point to a node tagged with P_OPT
 *                      then CMR_UNKERR
 *                      else did of the last production generated in
 *                               this function
 */
static DID ebnf_opt_to_bnf(c, opt, newnt, rek, LR)
tCOMAR *c, *opt;
DID newnt;
boolean rek, LR;
{
  tCOMAR *list;
  DID d;
  int stat;

#ifdef DBUG
  fprintf(stderr,"ebnf_opt_to_bnf startet.\n");
  fflush(stderr);
#endif

  if (cmr_get_tag(opt) != P_OPT)
    return(CMR_UNKERR);
  list = cmrl_copy_list(cmr_get_opt_units(opt));

  d = cmr_new_prod(c,S_NONAME,newnt,list);
  if (rek) 
    if ((stat = cmrtl_ebnf_prod_to_bnf(c, d, rek, LR)) != CMR_SUCCESS)
      return(stat);

  return(cmr_new_prod(c,S_NONAME,newnt,
		      cmr_begin_list(NEWLISTELEM(cmrl_get_eps_did(c)))));
}


/* Section 2 : functions for getting a special ebnf-construct in a rule */
/* changed by Kalle: 
 *          lists and subtrees must be differed in IDL-implementation.
 */
static tCOMAR *get_ith_ebnfcons_in_rhs(c, units, tagkind, embedded, firstcall, i)
tCOMAR *c, *units; /* units must be a list */
int tagkind, i;
boolean embedded, firstcall;

/* embedded == true  <=>   embedded || len(list) > 1,
   dann muss auch ein alt-Knoten durch ein neues NT ersetzt werden  */

{
  static int cnt;
  int tag;
  tCOMAR *result;
  static  tCOMAR *firstelem;

#ifdef DBUG
  fprintf(stderr,"get_ith_ebnfcons_in_rhs startet.\n");
  fflush(stderr);
#endif

  if (units == (tCOMAR *)NULL) 
    return((tCOMAR *)NULL);

  if (firstcall) 
  {
    cnt = 0;
    firstelem = cmr_list_head(units);       /* added by Kalle */
  }
  else if ( firstelem != (tCOMAR *)NULL )
         firstelem = cmr_list_head(units);  /* added by Kalle */

  if (firstelem == cmr_list_head(units)) /* changed by Kalle */
    {
      int j;
      tCOMAR *q;
      j = cmrl_dlist_len(units);
      for (q = cmr_get_begin_list(units); !cmr_isempty_list(q); q = cmr_list_tail(q))
	 { 
            firstelem = (tCOMAR *)NULL; /* added by Kalle */
            result = get_ith_ebnfcons_in_rhs(c, q, tagkind, embedded || j>1, FALSE, i);
	    if (i == cnt) return(result);
         }
      return((tCOMAR *)NULL);
    }
  
  units = cmr_list_head(units);  		/* added by Kalle */
  /*  In the 'switch-statement' units represents a subtree */
  switch ( cmr_get_tag(units) )
  {
    case P_ALT    :  if (tagkind == P_ALT && embedded && ++cnt == i)
			return(units); 		/* changed by Kalle */
                     result = get_ith_ebnfcons_in_rhs(c, cmr_get_alt_units1(units),
                                                            tagkind, embedded, FALSE, i);
		     if (i == cnt) return(result);
		     return(get_ith_ebnfcons_in_rhs(c, cmr_get_alt_units2(units),
                                                           tagkind, embedded, FALSE, i));

    case P_OPT   :   if (tagkind == P_OPT && ++cnt ==i) 
			return(units); 		/* changed by Kalle */
                     return(get_ith_ebnfcons_in_rhs(c, cmr_get_opt_units(units),
                                                           tagkind, TRUE, FALSE, i));

    case P_PLUS  :  if (tagkind == P_PLUS && ++cnt == i)
		       return(units); 		/* changed by Kalle */
                    return(get_ith_ebnfcons_in_rhs(c, cmr_get_plus_units(units),
                                                          tagkind, TRUE, FALSE, i)); 

    case P_STAR  :  if (tagkind == P_STAR && ++cnt == i)
                      return(units); 		/* changed by Kalle */
		    return(get_ith_ebnfcons_in_rhs(c, cmr_get_star_units(units), 
                                                          tagkind, TRUE, FALSE, i)); 

    case P_DELREP : if (tagkind == P_DELREP && ++cnt == i) 
		       return(units);		 /* changed by Kalle */
                    result = get_ith_ebnfcons_in_rhs(c, cmr_get_delrep_units1(units),
                                                            tagkind, TRUE, FALSE, i);
		    if (i == cnt) return(result);
		    return(get_ith_ebnfcons_in_rhs(c, cmr_get_delrep_units2(units),
                                                          tagkind, TRUE, FALSE, i));

    default       :  return((tCOMAR *)NULL);
		     /* auch bei P_ELUNIT wird (tCOMAR *)NULL zurueckgegeben, da
			P_ELUNIT kein ebnf Konstrukt ist */

   }                 /* of switch  */
}                    /* of function */



static tCOMAR *get_ith_ebnfcons(c, units, tagkind, i)
tCOMAR *c, *units;
int tagkind, i;
{ 
  return(get_ith_ebnfcons_in_rhs(c, units, tagkind, 
                                        FALSE, TRUE, i));
}


/* Section 3 : eliminating all equals from the rest of the rules */

/* the ebnf construct which shall be compared with other ebnf constructs
 * is always the first ebnf construct tagged with tagkind in production prod
 */

static int ebnf_to_bnf_all_equals_in_prod(c, prod, newnt, tagkind)
tCOMAR *c;
DID prod, newnt;
int tagkind;
{
tCOMAR *x, *y, *z, *equals = cmr_new_list();
int j = 1;
int stat;

#ifdef DBUG
  fprintf(stderr,"ebnf_to_bnf_all_equals_in_prod startet.\n");
  fflush(stderr);
#endif

  x = get_ith_ebnfcons(c, cmr_get_prod_units(c, prod), tagkind, j);

  if (x == (tCOMAR *)NULL) return(CMR_UNKERR);
  
  y = get_ith_ebnfcons(c, cmr_get_prod_units(c, prod), tagkind, ++j);

  while (y != (tCOMAR *)NULL)
    {
      if (cmrl_equal_subtr(c, x, y, cmr_new_list(), &equals))
	{
	  if ((stat = cmrl_equal_nterms_elim(c, equals, cmr_get_prod_lhs(c, prod)))
	       != CMR_SUCCESS)
	    return(stat);
          equals = cmr_del_list(equals);

	  z = cmrl_copy_list_with_subst(cmr_get_prod_units(c, prod), y, cmr_new_elunit(newnt));
	  (void) cmr_set_prod_units(c, prod, z);
	  x = get_ith_ebnfcons(c, cmr_get_prod_units(c, prod), tagkind, 1);
	}
      else ++j;
      
      y = get_ith_ebnfcons(c, cmr_get_prod_units(c, prod), tagkind, j);
    }        /* of while */

  return(CMR_SUCCESS);
}                              /* of function */

/* ebnf_to_bnf_all_equals - substitutes all ebnf constructs in 
 *                  productions after prod that are equal to the i-th ebnf
 *                  construct tagged by tagkind in production prod
 */
static int ebnf_to_bnf_all_equals(c, prod, newnt, tagkind, i)
tCOMAR *c; 
DID prod, newnt; 
int tagkind;
int i;
{
  tCOMAR *x, *y, *z, *equals = cmr_new_list();
  DID p;
  DID prodlhs = cmr_get_prod_lhs(c, prod);
  int stat;

#ifdef DBUG
  fprintf(stderr,"ebnf_to_bnf_all_equals startet.\n");
  fflush(stderr);
#endif

  x = get_ith_ebnfcons(c, cmr_get_prod_units(c, prod), tagkind, i);
  p = cmrl_next_prod(c,prod);

  while (p != -1) 
    {
      int j = 0;
      y = get_ith_ebnfcons(c, cmr_get_prod_units(c, p), tagkind, ++j);

      while (y != (tCOMAR *)NULL)
	{
	  if (cmrl_equal_subtr(c, x, y, cmr_new_list(), &equals))
	    {  
	      if ((stat = cmrl_equal_nterms_elim(c, equals, prodlhs))
		   != CMR_SUCCESS)
		return(stat);
              equals = cmr_del_list(equals);
	      z = cmrl_copy_list_with_subst(cmr_get_prod_units(c, p), y, cmr_new_elunit(newnt));
	      (void) cmr_set_prod_units(c, p, z);
	    }            /* of then */
          else ++j;

          y = get_ith_ebnfcons(c, cmr_get_prod_units(c, p), tagkind, j);
	}         /* of while */
      
      p = cmrl_next_prod(c,p);
    }            /* of first while */
  return(CMR_SUCCESS);
}                /* of function */



/* Section 4 : private function for eliminating a special ebnf-construct 
 *             from the grammar
 */

static int ebnfcons_to_bnf_for_grammar(c, tag, LR)
tCOMAR *c;
int tag;
boolean LR;
{
  DID p;
  int stat;

#ifdef DBUG
  fprintf(stderr,"ebnfcons_to_bnf_for_grammar.\n");
  fflush(stderr);
#endif

  for (p = cmrl_first_prod(c);
       p != -1;
       p = cmrl_next_prod(c, p))
  {
    tCOMAR *units = cmr_get_prod_units(c, p);
    tCOMAR *ebnfcons = get_ith_ebnfcons(c, units, tag, 1);

    while (ebnfcons != (tCOMAR *)NULL)
    {
      DID newnt = cmrl_gen_nterm(c);

      if ((stat = ebnf_to_bnf_all_equals_in_prod(c, p, newnt, tag))
	   != CMR_SUCCESS)
	return(stat);

      if ((stat = ebnf_to_bnf_all_equals(c, p, newnt, tag, 1))
	   != CMR_SUCCESS)
	return(stat);

      units = cmr_get_prod_units(c, p);
      if ((ebnfcons = get_ith_ebnfcons(c, units, tag, 1))
	   == (tCOMAR *)NULL)
	return(CMR_UNKERR);

      switch (tag)
      {
	case P_ALT :
	  stat = ebnf_embalt_to_bnf(c, ebnfcons, newnt, FALSE, LR);
	  break;

        case P_DELREP :
	  stat = ebnf_delrep_to_bnf(c, ebnfcons, newnt, FALSE, LR);
	  break;

        case P_STAR :
	  stat = ebnf_star_to_bnf(c, ebnfcons, newnt, FALSE, LR);
	  break;

        case P_PLUS :
	  stat = ebnf_plus_to_bnf(c, ebnfcons, newnt, FALSE, LR);
	  break;

        case P_OPT :
	  stat = ebnf_opt_to_bnf(c, ebnfcons, newnt, FALSE, LR);
	  break;

        default :
	  return(CMR_UNKERR);
      }

      if (stat < 0)
	return(stat);
	
      units = cmrl_copy_list_with_subst(units, ebnfcons, cmr_new_elunit(newnt));
      (void) cmr_set_prod_units(c, p, units);
      ebnfcons = get_ith_ebnfcons(c, units, tag, 1);
    }
  }

  return(CMR_SUCCESS);
}


/***************************************************************************/
/*                  exported functions                                     */
/***************************************************************************/

/* Part I : function for transforming a grammar rule prod  */

int cmrtl_ebnf_prod_to_bnf(c, prod, alone, LR)
tCOMAR *c; 
DID prod;
boolean alone, LR;
{
  tCOMAR *list, *z, *h;
  int tag;
  DID newnt;
  int len;
  int stat;

#ifdef DBUG
  fprintf(stderr,"cmrtl_ebnf_prod_to_bnf startet.\n");
  fflush(stderr);
#endif

  list = cmr_get_prod_units(c,prod);
  len = cmrl_dlist_len(list);

  while (len == 1 && cmrl_dlist_firstis(list, P_ALT))
    {
      if ((stat = ebnf_alonealt_to_bnf(c,prod,alone,LR)) < 0)
	return(stat);
     
      list = cmr_get_prod_units(c,prod);
      len = cmrl_dlist_len(list);
    }

  list = cmr_get_begin_list(list);

  while ( !cmr_isempty_list(list) && (tag = cmr_get_tag(h = cmr_list_head(list))) == P_ELUNIT)
     list = cmr_list_tail(list);
     /* read until you will find an ebnf-construct */


  if (cmr_isempty_list(list))
    return(CMR_SUCCESS);           /* production prod is in BNF */

  newnt = cmrl_gen_nterm(c);

  if ((stat = ebnf_to_bnf_all_equals_in_prod(c, prod, newnt, tag)) == CMR_SUCCESS)
    {
      if ( !alone ) 
         stat = ebnf_to_bnf_all_equals(c, prod, newnt, tag, 1);
    }
      
  if (stat != CMR_SUCCESS) 
    return(stat);

  list = cmr_get_prod_units(c,prod);

  h = get_ith_ebnfcons(c, list, tag, 1);

  if (h == (tCOMAR *)NULL) return(CMR_UNKERR);

  switch(tag)  {
    case P_ALT   :  stat = ebnf_embalt_to_bnf(c, h, newnt, alone, LR);
		    break;
    case P_STAR  :  stat = ebnf_star_to_bnf(c, h, newnt, alone, LR);
		    break;
    case P_PLUS  :  stat = ebnf_plus_to_bnf(c, h, newnt, alone, LR);
		    break;
    case P_DELREP : stat = ebnf_delrep_to_bnf(c, h, newnt, alone, LR);
		    break;
    case P_OPT   :  stat = ebnf_opt_to_bnf(c, h, newnt, alone, LR);
		    break;
    default      :  return(CMR_UNKERR);

    }             /* of switch  */

  if (stat < 0)
    return(stat);

  z = cmrl_copy_list_with_subst(list, h, cmr_new_elunit(newnt));
  (void) cmr_set_prod_units(c, prod, z);
 
  return(cmrtl_ebnf_prod_to_bnf(c, prod, alone, LR));
}


/* Part II : functions for eliminating special constructs from the grammar  */

int cmrtl_ebnf_alonealt_to_bnf_for_grammar(c)
tCOMAR *c;
{
  DID p;
  int stat;

#ifdef DBUG
  fprintf(stderr,"cmrtl_ebnf_alonealt_to_bnf_for_grammar startet.\n");
  fflush(stderr);
#endif

  for (p = cmrl_first_prod(c);
       p != -1;
       p = cmrl_next_prod(c, p))
  {
    tCOMAR *units = cmr_get_prod_units(c, p);

    while (cmrl_dlist_len(units) == 1 &&
           cmrl_dlist_firstis(units, P_ALT))
    {
      /* last argument FALSE is not important for this function */
      if ((stat = ebnf_alonealt_to_bnf(c, p, FALSE, FALSE)) < 0)
	return(stat);

      units = cmr_get_prod_units(c, p);
    }
  }

  return(CMR_SUCCESS);
}


int cmrtl_ebnf_embalt_to_bnf_for_grammar(c)
tCOMAR *c;
{
  return(ebnfcons_to_bnf_for_grammar(c, P_ALT, FALSE));
  /* the last argument FALSE has no influence on grammar transformation */
}


int cmrtl_ebnf_opt_to_bnf_for_grammar(c)
tCOMAR *c;
{
  return(ebnfcons_to_bnf_for_grammar(c, P_OPT, FALSE));
  /* the last argument FALSE has no influence on grammar transformation */
}


int cmrtl_ebnf_delrep_to_bnf_for_grammar(c, LR)
tCOMAR *c;
boolean LR;
{
  return(ebnfcons_to_bnf_for_grammar(c, P_DELREP, LR));
}


int cmrtl_ebnf_plus_to_bnf_for_grammar(c, LR)
tCOMAR *c; 
boolean LR; 
{
  return(ebnfcons_to_bnf_for_grammar(c, P_PLUS, LR));
}


int cmrtl_ebnf_star_to_bnf_for_grammar(c, LR)
tCOMAR *c; 
boolean LR;  
{
  return(ebnfcons_to_bnf_for_grammar(c, P_STAR, LR));
}


/* Part III : Function for transforming the whole grammar    */

int cmrtl_ebnf_grammar_to_bnf(c, LR)
tCOMAR *c;
boolean LR;
{
  DID p;
  int stat;

  p = cmrl_first_prod(c);

#ifdef DBUG
  fprintf(stderr,"cmrtl_ebnf_grammar_to_bnf startet.\n");
  fflush(stderr);
#endif

  while (p != -1)  
   {
      if((stat = cmrtl_ebnf_prod_to_bnf(c, p, FALSE, LR))
	   != CMR_SUCCESS) return(stat);

      p = cmrl_next_prod(c,p);
   }

  return(CMR_SUCCESS);
}
