# $Id: src.lib.Makefile.cpp,v 1.8 1992/11/30 08:36:15 cogito Exp $
# make library "lib.a", which consists of standard COMAR functions
# and a bitset module 
# 
DESTDIR = ELISYS
DISTRIB = ELISYS

IDL = ../idl

SRC = cmrlib.c cmrio.c bitset.c
OBJ = cmrlib.o cmrio.o bitset.o
HDR = cmrlib.h cmrio.h bitset.h cmrinternal.h

# causes additional tests which can be helpful to search bugs
# ALLDEB = -DDEBUG_LIB -DDEBUG_BIT

CFLAGS =  $(ALLDEB) -I$(IDL)

TIDY    = core a.out  *% *.o ERRS lintmsg
CLEAN   = $(TIDY) *.exe *.a

###########################################################################

all:	lib.a

install: lib.a

distrib:        $(SRC) $(HDR)
	@if test ! -d $(DISTRIB)/lib; \
		then umask 002; mkdir $(DISTRIB)/lib; \
		else :;\
		fi
	cp $(SRC) $(HDR) Makefile.cpp $(DISTRIB)/lib
	cd $(DISTRIB)/lib; chmod 0644 $(SRC) $(HDR) Makefile.cpp

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

###########################################################################

#if defined(NO_RANLIB)
lib.a:  $(OBJ)
	rm -f lib.a
	ar crus lib.a $(OBJ)
#else
lib.a:  $(OBJ)
	rm -f lib.a
	ar cru lib.a $(OBJ)
	ranlib lib.a
#endif

cmrlib.o: $(IDL)/comar.h $(IDL)/comar_func.h cmrlib.h cmrinternal.h

cmrio.o:  $(IDL)/comar.h cmrlib.h cmrio.h

bitset.o: bitset.h


###########################################################################
lint:
	lint $(CFLAGS) $(SRC) >! lintmsg

