/* Implementation of DeRemer's and Pennello's digraph algorithm:
 * TOPLAS, Vol.4, No.4, October 1982, section4
 */

typedef	unsigned int	Cardinal;

/* Let X the finite set {0,...,Max-1} and B a set of type BitSet,
 * R a relation on X and F0: X -> 2^B a function. Then Digraph computes
 * the function F(a) = union of all sets {F0(b)| a R* b}
 * see also: Theorem 2.24 in "Parsing Theory" of Sippu and Soisalon-Soininen
 *
 * Input: F0[0...Max-1]	: Array of equal sized sets of type BitSet
 *	  Max	   	: cardinality of X
 * Output: F[0...Max-1] : F0 will be recomputed to F
 */
void	DiGraph(/* Cardinal Max, BitSet *F0 */);


/* Adds the element/edge (a,b) to relation R: AddToRelation() must be
 * used to define the relation R needed for DiGraph(). Before the first
 * call of AddToRelation() function InitRelation() must be called.
 */
void	AddToRelation(/* Cardinal a,b */);


/* Initialization of A relation R on a set {0,...,card-1} */
void    InitRelation(/* Cardinal card */);


/* Frees all internal storage for representation of relation R:
 * should be used if R isn't needed any more.
 */
void    FreeRelation();
