/*
** $Id: contrafo.c,v 1.2 90/10/23 13:30:07 cogito Exp $
*/
static char rcs_id[]= "$Id: contrafo.c,v 1.2 90/10/23 13:30:07 cogito Exp $";

/***************************************************************************/
/* File: contrafo.c	First Edit: 17.10.88	  Last Edit: 18.11.88      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change:	23.03.89	From: Karl-Josef Prott			   */
/* 		14.02.90	From: Kalle				   */
/***************************************************************************/

#include <stdio.h>

#include "comar.h"
#include "comar_func.h"
#include "cmrlib.h"
#include "privatlib.h"
#include "name.h"	/* definition of CONNECTION and CONNECTTYPE */

#include "contrafo.h"

#define CONTRAFO "Contrafo"


/* global variables */
Boolean simple, repetition;

/* dynamic array: exnullnt[i] == 0 : There exists no 'Nullnonterminal' to
 *				     connection with sid 'i'. 
 *		  exnullnt[i]  > 0 : did of 'Nullnonterminal' to connection
 *				     with sid 'i'.
 */
DID	*exnullnt = NULL;


Boolean	isconnect(def, consid)
def_entry	def;
SID		consid;
{
  SEQprop_entry travel;
  prop_entry    prop;

  if ( typeof(def) == Kp_other )
    foreachinSEQprop_entry(def.Vp_other->prop, travel, prop)
      {
	if ( typeof(prop) == Kp_prop && prop.Vp_prop->sid == consid )
	  return(TRUE);
      }

  return(FALSE);
}



DID gen_nullNT_withcon(elu)
unit elu;
{
  p_nterm	newNT;
  SEQunit	u_seq;

  newNT = cmrlib_genNTerm(CONTRAFO);
  initializeSEQunit(u_seq);
  appendfrontSEQunit(u_seq, elu);
  cmrlib_newprod(S_NONAME, newNT->did, u_seq);

  return(newNT->did);
}



void trafo_all_con_inlist(unitseq, sid, endnotposs)
SEQunit	* unitseq;   /* call by reference */
SID	sid;
Boolean	endnotposs;
{
  SEQunit	*formanipul, travel;
  unit		un, help;
  def_entry	def, def2;
  DID		newNTdid;

  manipulSEQunit(*unitseq, formanipul, un)
    {
      switch ( typeof(un) )
      {
	case Kp_elunit	:
	    def = cmrlib_getdef(CMR->definitions, un.Vp_elunit->did);
	    if ( isconnect(def, sid) )
	      {
		/* Jump behind Other-objects */
		foreachinSEQunit(tailSEQunit((*formanipul)), travel, help)
		  {
		    if ( typeof(help) != Kp_elunit )
		      break;
		    def2 = cmrlib_getdef(CMR->definitions, help.Vp_elunit->did);
		    if ( typeof(def2) != Kp_other )
		      break;
		  }
		if ( endnotposs || !emptySEQunit(travel) )
	          {   /* kalle: 12.12.89 tailSEQunit eliminated  */
		    removefirstSEQunit(*formanipul);
		    if ( (newNTdid = exnullnt[def.Vp_other->sid - 1]) == NULL )
		      {
		        newNTdid = gen_nullNT_withcon(un);
		        exnullnt[def.Vp_other->sid - 1] = newNTdid;
		      }
		    help.Vp_elunit = Mkp_elunit(newNTdid);
		    appendfrontSEQunit(*formanipul, help);
	          }
	      }
	    break;
	case Kp_alt	:
		trafo_all_con_inlist(&un.Vp_alt->rhs1, sid, simple);
		trafo_all_con_inlist(&un.Vp_alt->rhs2, sid, simple);
		break;
	case Kp_opt	:
		trafo_all_con_inlist(&un.Vp_opt->rhs, sid, simple);
		break;
	case Kp_star	: 
		trafo_all_con_inlist(&un.Vp_star->rhs, sid, repetition);
		break;
	case Kp_plus	: 
		trafo_all_con_inlist(&un.Vp_plus->rhs, sid, repetition);
		break;
	case Kp_delrep	: 
		trafo_all_con_inlist(&un.Vp_delrep->rhs, sid,repetition);
		trafo_all_con_inlist(&un.Vp_delrep->sep, sid,repetition);
		break;
	default		: 
		INT_TAG_ERR("trafo_all_con_inlist", typeof(un));
      }
    }
}



ERR cmrtl_trafo_allconnect(c, opt)
p_comar	c;
short	opt;
{
  p_comar	sav;
  p_name	connectname;
  p_string	connectstring;
  SID 		connectsid;
  SEQdef_entry	travel;
  def_entry	def;

  switch (opt)
    {
      case TRF_ALL: repetition = simple = TRUE;
		    break;
      case TRF_S  : simple = FALSE;
		    repetition = TRUE;
		    break;
      case TRF_R  : simple = TRUE;
		    repetition = FALSE;
		    break;
      case TRF_SR : repetition = simple = FALSE;
		    break;
      default     : return(TRF_WRONGOPT);
    }

  sav = cmrlib_changeglobalcmrvar(c);
  if ( CONNECTTYPE == Kp_string )
    {
      if ( (connectstring = cmrlib_strtopstring(CMR->symbols, CONNECTION))
	   == NULL )
	{
	  (void)cmrlib_changeglobalcmrvar(sav);
	  return(TRF_CONUNK);
	}
      connectsid = connectstring->sid;
    }
  else
    if ( CONNECTTYPE == Kp_name )
      {
        if ( (connectname = cmrlib_strtopname(CMR->symbols, CONNECTION))
	     == NULL )
	  {
	    (void)cmrlib_changeglobalcmrvar(sav);
	    return(TRF_CONUNK);
	  }
        connectsid = connectname->sid;
      }
    else
      {
	(void)cmrlib_changeglobalcmrvar(sav);
	return(TRF_WRONGTAG);
      }

  /* initializing of exnullnt */
  if ( (exnullnt = (DID *)calloc(cmrlib_getmaxsid(CMR->symbols),
						 sizeof(DID))) == NULL )
    {
      INT_ALLOC_ERR("cmrtl_trafo_allconnect()");
      exit(1);
    }

  foreachinSEQdef_entry(CMR->definitions, travel, def)
    {
      if ( typeof(def) == Kp_prod )
        trafo_all_con_inlist(&def.Vp_prod->rhs, connectsid, FALSE);
    }

  free(exnullnt);
  exnullnt = NULL;
  (void)cmrlib_changeglobalcmrvar(sav);
  return(CMR_SUCCESS);
}

