/***************************************************************************/
/* filename : write_help.h                         first edit  : 16.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 05.06.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
/* $Id: write_help.h,v 1.1 1992/01/10 14:38:40 cogito Exp $ */


/****************************** FUNCTIONS **********************************/


extern void Print_If( /* fp,user_data,out_list,pos,space,eq_string,
			 shred_mark,shift_mark,default_mark,comp,
			 extra_info */ );

/*
   FILE                       *fp;   file pointer to the external output
				     file, where the complete parser
				     should be written
   struct equality      *out_list;   pointer to structure equality, which
				     represents a part of code, where
				     some comparisons lead through
   struct user         *user_data;   internal interface vector, which
				     saves informations fixed by the
				     user
   short                      pos,   position in vector out_list which
				     should be printed out yet
			    space;   the number of blanks which should
				     be printed out, before some code
				     will be printed
   char                *eq_string,   the string which should compared
				     with other data
		      *shred_mark,   this string would be printed out, if
				     a jump to a reduce - mark should
				     passed through
		      *shift_mark,   this string would be printed out, if
				     a jump to a shift - mark should
				     passed through
		    *default_mark,   this string would be printed out, if
				     a jump to a default - mark ( no
				     reduce - and no shift - mark )
				     should passed through

			     comp,   if comp == 1 then the code is
				     compressed and then a default action
				     exist
		       extra_info;   if extra_info == 1, then extra
				     informations about begin and end
				     of function are printed out
*/



extern void Print_Normal_If( /* fp,user_data,out_list,upper_bound,eq_string,
				shred_mark,shift_mark,default_mark,comp,
				extra_info */ );

/*
   FILE                       *fp;   file pointer to the external output
				     file, where the complete parser
				     should be written
   struct equality      *out_list;   pointer to structure equality, which
				     represents a part of code, where
				     some comparisons lead through
   struct user         *user_data;   internal interface vector, which
				     saves informations fixed by the
				     user
   short              upper_bound;   number of code elements which should
				     be printed out
   char                *eq_string,   the string which should compared
				     with other data
		      *shred_mark,   this string would be printed out, if
				     a jump to a reduce - mark should
				     passed through
		      *shift_mark,   this string would be printed out, if
				     a jump to a shift - mark should
				     passed through
		    *default_mark,   this string would be printed out, if
				     a jump to a default - mark ( no
				     reduce - and no shift - mark )
				     should passed through
			     comp,   if comp == 1 then the code is
				     compressed and then a default action
				     exist
		       extra_info;   if extra_info == 1, then extra
				     informations about begin and end
				     of function are printed out
*/



extern void Write_Semantic_Code( /* fp,nop,seman_list,seman_out,extra_info */ );

/*
   FILE              *fp;   File pointer to file semantic_productions.h  
   char_ptr  *seman_list;   a list of pointer to the semantic actions    
   short             nop;   number of productions                      
   char       extra_info,   if extra_info == 1, then extra information
                            about begin and end of function are printed 
                            out                                     
              *seman_out;   the productions, which have semantic
                            connections and should printed out are 
                            marked                                       

*/
