
/***************************************************************************/
/* filename : low_optim.c                          first edit  : 28.01.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 20.08.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: low_optim.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];


#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "over_types.h"

#include "determ.h"

#include "errors.h"

#include "low.h"

/***************************** FUNCTIONS *********************************/





static struct sd *Count_Equal_Pos( ttab,row1,row2,length,position,
				   shared_data,eq_pos,user_data,
				   changed_data,extra_info )


   short                 *ttab,  /* representation of the T - Table        */
			  row1,  /* the first row that will be examined    */
			  row2,  /* the second row that will be examined   */
			length,  /* the length of the rows respectively
				    (the number of columns)                */
		      position,  /* the position during the examination of
				    the two rows. 			   */
			eq_pos;  /* the number of equal entries at the
				    same position of the two rows          */

   struct sd      *shared_data;  /* internal interface vector              */
   struct user      *user_data;  /* information entered by the user[*right?*]*/
   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                        */


/* This function is the last in a chain of functions to be executed
   sequentially, so this function will only be executed if the two rows
   are not equal and the entries of one row are not a subset of the
   other row. This function determines the number of equal positions of
   both rows ( error entries are omitted ). The determination does not
   start at the beginning of the rows,  rather it uses the results of
   the previous functions to start from. When a lower bound is passed
   over, then the information will be saved.
*/

   {
     short                pos;  /* loop index                              */
     struct tsc   *search_ptr;  /* help pointer to allocate storage space
				   and put the information at the end of a
				   list                                    */


     if( extra_info )
	printf("begin of function Count_Equal_Pos()\n");
     pos = position;

     /* count the equal positions */
     while( pos<length )
       {
	 if( (ttab[row1*length+pos] != ERROR_ENTRY) &&
             (ttab[row2*length+pos] != ERROR_ENTRY)  )
	    if( Eq_Test( ttab[row1*length+pos],
			 ttab[row2*length+pos],
			 row1,row2,
			 user_data,
			 changed_data,
			 extra_info         ) )

	       eq_pos++;

	 pos++;
       } /* end of while( pos<leng... */

     /* if the number of equal positions is greater than the bound
	number_of_common_action, save the two states */
     if( eq_pos >= user_data->number_of_common_action )
	{
	  if( (search_ptr = (struct tsc*) malloc(
	       sizeof( struct tsc ) )) == NULL )
		  Error_Message( _COUNT_EQUAL_POS,MODULE_LOW_OPTIM,
                                 NO_SPACE_FOR_STRUCTURE,ABORT," search_ptr");
	  search_ptr->next   = shared_data->tsc_pt[row1];
	  shared_data->tsc_pt[row1] = search_ptr;
	  search_ptr->state  = row2;
	  search_ptr->eq_num = eq_pos;


	} /* end of if( eq_pos >= N... */

     if( extra_info )
	printf("end of function Count_Equal_Pos()\n");
     return( shared_data );

   } /* end of function Count_Equal_Pos() */









static struct sd *Compare_Under( ttab,row1,row2,length,position,shared_data,
				 eq_pos,user_data,changed_data,extra_info )



   short                 *ttab,  /* a representation of the T - Table      */
			  row1,  /* the first row to be examined	   */
			  row2,  /* the second row to be examined	   */
			length,  /* the length of the rows respectively
				    (the number of columns)                */
		      position,  /* the position during the examination of
				    the two rows.                          */
			eq_pos;  /* the number of equal entries at the
				    same position in the two rows          */

   struct sd      *shared_data;  /* internal interface vector              */
   struct user      *user_data;  /* information entered by the user        */
   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                         */

/* When this function starts, we know that the two rows cannot be
   equal in all positions and it is possible that the entries of row1
   are a subset of the entries of row2. Comparison goes on at the
   position where the comparison ended in function Compare_Equal.  If
   the function detects a position which is not equal in both rows, the
   control will be passed to function Count_Equal_Pos. This function
   counts the equal positions and the information is given to function
   Count_Equal_Pos.
   If all positions are equal or the unequal positions have an error
   entry in row1, then the entries of row1 are a subset of row2.
   Control will be passed to calling function.
*/

   {
     short            pos,  /* loop index                                  */
		      min,  /* minimum of the two rows which are mentioned
			       above                                       */
		      max;  /* maximum of the two rows which are mentioned
			       above                                       */
     char           equal=  /* variable to decide if two entries are equal */
		     TRUE;
     struct ur  *help_ptr;  /* used to allocate storage space and put
			       information to structure shared_data        */




     if( extra_info )
	printf("begin of function Compare_Under()\n");
     pos   = position;
     if( row1 < row2 )
        {  
          min = row1;
          max = row2;
	} /* end of if( row1 < row2 ) */
     else
	{
          min = row2;
	  max = row1;
	} /* end of else ( if( row1 < row2 ) ) */

     /* test if the entries of row1 are a subset of the entries of row2 */
     while( (pos<length) && equal )
	if( ttab[row1*length+pos] == ERROR_ENTRY )
	   pos++;
	else
	   if( ttab[row2*length+pos] == ERROR_ENTRY )
	      equal = FALSE;
           else
	      if( Eq_Test( ttab[min*length+pos],
			   ttab[max*length+pos],
			   min,max,
			   user_data,
			   changed_data,
			   extra_info                 ) )
		 {
		   eq_pos++;
		   pos++;
		 } /* end of if( Eq_Test( tt... */
	      else
		 equal = FALSE;
	if( equal && (eq_pos >= user_data->number_of_common_action) )
	   {
	     /* if row1 is a subset of row2, save the two rows */
	     if( (help_ptr = (struct ur*) malloc(
		   sizeof( struct ur ))) == NULL )
		      Error_Message( _COMPARE_UNDER,MODULE_LOW_OPTIM,
                                     NO_SPACE_FOR_STRUCTURE,ABORT," help_ptr" );
	     help_ptr->over  = row2;
	     help_ptr->under = row1;
	     help_ptr->next  = shared_data->max[eq_pos];
	     shared_data->max[eq_pos] = help_ptr;
	     shared_data->used[row2] = TRUE;
	   } /* end of if( equal ) */
	else
	   /* else, if both rows are unused, than test how many entries
	      are equal */

	   if( row1<row2 )
	      shared_data = Count_Equal_Pos( ttab,row1,row2,length,pos,
					     shared_data,eq_pos,
					     user_data,changed_data,
					     extra_info );
	   else
	      shared_data = Count_Equal_Pos( ttab,row2,row1,length,pos,
					     shared_data,eq_pos,
					     user_data,changed_data,
					     extra_info );

     if( extra_info )
	printf("end of function Compare_Under()\n");
     return( shared_data );

   } /* end of function Compare_Under() */






static struct sd *Compare_Equal( ttab,row1,row2,length,shared_data,user_data,
				 changed_data,extra_info )


   short                 *ttab,  /* a representation of the T - Table      */
			  row1,  /* the first row to be examined	   */
			  row2,  /* the second row to be examined	   */
			length;  /* the length of the rows respectively
				    (the number of columns)                */

   struct sd      *shared_data;  /* internal interface vector              */
   struct user      *user_data;  /* information entered by the user        */
   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                         */

/* This function is started first. It looks for two given rows, if all
   entries in both rows are equal at each position,  the code for the
   two rows can be shared. If it finds a position where the two entries
   are not equal, it tests to see if one entry is an error entry. Then
   it tests to see of it is possible that the entries of this row are a
   subset of the entries of the other row. To perform this comparison,
   control will be passed to function Compare_Under.  If both entries
   are different and neither is an error entry, control will be passed
   to function Count_Equal_Pos. This function must not start the
   comparison from the beginning because I count the equal positions
   here too, and pass this information and the actual position to
   the function.
*/


   {
     short  position = 0,  /* start comparison at position 0               */

	      eq_pos = 0;  /* count, how many equal entries exist in the
			      two rows, error entries are omitted          */
     char   equal = TRUE;  /* variable to decide if two entries are equal  */




     if( extra_info )
	printf("begin of function Compare_Equal()\n");
     /* test if the entries of both rows are equal and than save the two
	rows */
     while( (position<length) && equal )
	if( (ttab[row1*length+position] == ERROR_ENTRY) &&
	    (ttab[row2*length+position] == ERROR_ENTRY) )
	   position++;
	else
	   if( (ttab[row1*length+position] == ERROR_ENTRY) ||
	       (ttab[row2*length+position] == ERROR_ENTRY) )
              equal = FALSE;
           else
	      if( Eq_Test( ttab[row1*length+position],
			   ttab[row2*length+position],
			   row1,row2,
			   user_data,
			   changed_data,
			   extra_info         ) )
	         {
		   eq_pos++;
		   position++;
	         } /* end of if( ttab[row1*l... */
	      else
	         equal = FALSE;

     if( equal && (eq_pos >= user_data->number_of_common_action) )
	{
	  if( shared_data->equal_rows[row1] < 0 )
	     shared_data->equal_rows[row2] = row1;
	  else
	     shared_data->equal_rows[row2] = shared_data->equal_rows[row1];
	  shared_data->used[row1] = TRUE;
	  shared_data->used[row2] = TRUE;
	} /* end of if( equal ) */
     else
	/* if they aren't equal, decide if one could be a subset of
	   the other or count the equal positions */
	if( ttab[row1*length+position] == ERROR_ENTRY )
	   shared_data = Compare_Under( ttab,row1,row2,length,position,
					shared_data,eq_pos,user_data,
					changed_data,extra_info );
	else
	   if( ttab[row2*length+position] == ERROR_ENTRY )
	      shared_data = Compare_Under( ttab,row2,row1,length,position,
					   shared_data,eq_pos,user_data,
					   changed_data,extra_info );
	   else
	      shared_data = Count_Equal_Pos( ttab,row1,row2,length,
					     position,shared_data,eq_pos,
					     user_data,changed_data,
					     extra_info );

     if( extra_info )
	printf("end of function Compare_Equal()\n");
     return( shared_data );

   } /* end of function Compare_Equal() */








static struct sd *Det_Under_Rows( quick_data,shared_data,extra_info )


   readtype    *quick_data;  /* interface vector to optimization           */
   struct sd  *shared_data;  /* internal interface vector                  */
   char         extra_info;  /* if extra_info == 1, then extra information
				about begin and end of function is printed
				out                                        */




/* In function Compare_Under, it is determined which rows have entries
   which are subsets of another row. Because this possibility can occur
   more than once, I must now determine which row should really be a
   subset of another row.  To get a good result, I test how often a row
   can be a subset of another row. Then I connect the rows with the
   most entries first. Here it is possible that a row is a subset of
   more than one row. If I want to connect another row q to an
   already used row r,  I test if the row which is connected to r is
   connected to another row too. If this applies, I break this
   connection and let q be a subset of r, and so on.
*/

   {
     short            symb,  /* loop index                                 */
		     state,  /* loop index                                 */
		       nos,  /* number of states                           */
		       not,  /* number of terminals                        */
	       *numb_under;  /* store for each row, how often it can be
				used as a subset                           */
     struct ur   *help_ptr;  /* used to retrieve information from the
				structure shared_data                      */
     char 	    *count,  /* Each row can only be one subset of
				another row. By determination, it is possible
				that one row is set to be a subset of more
				than one row. So at the end of the function
				I must check to see if a row should be a
				subset of more than one row and then delete
				superfluous information.		   */

		  *eq_rows;  /* used to decide if a state is equal to
				another                                    */


     if( extra_info )
	printf("begin of function Det_Under_Rows()\n");
     not = *((*quick_data)[0]);
     nos = *((*quick_data)[9]);

     if( ((numb_under = (short*) calloc( nos,sht )) == NULL) ||
	 ((eq_rows    = (char*) calloc(
			      nos,sizeof( char ) )) == NULL) ||
	 ((count      = (char*)  calloc(
			      nos,sizeof( char ) )) == NULL) )
		Error_Message( _DET_UNDER_ROWS,MODULE_LOW_OPTIM,
                               NO_SPACE_FOR_VECTOR,ABORT," count");

     for( state=0;state<nos;state++ )
	if( shared_data->equal_rows[state] >= 0 )
	   {
	     eq_rows[state] = TRUE;
	     eq_rows[shared_data->equal_rows[state]] = TRUE;
	   }  /* end of if( shared_data... */


     /* count how often one row could be a subset of an other row */
     for( symb=0;symb<not;symb++ )
	{
	  help_ptr = shared_data->max[symb];
	  while( help_ptr != NULL )
	     {
	       if( (shared_data->equal_rows[help_ptr->over]<0)  &&
		   (shared_data->equal_rows[help_ptr->under]<0) )
		  numb_under[help_ptr->under]++;
	       help_ptr = help_ptr->next;
	     } /* end of while( help_ptr... */
	} /* end of for( symb=0;sym... */


     /* set the used under rows FALSE first */
     for( symb=not-1;symb>=0;symb-- )
	{
	  help_ptr = shared_data->max[symb];
	   while( help_ptr != NULL )
	     {
	       if( !(eq_rows[help_ptr->over]) )
		  shared_data->used[help_ptr->over] = FALSE;
               help_ptr = help_ptr->next;
	     }  /* end of while( help_ptr... */
	}  /* end of for( symb=not-1... */


     /* fix the row, which is a subset of another row and has the most
	entries, first */
     for( symb=not-1;symb>=0;symb-- )
	{
	  help_ptr = shared_data->max[symb];
	  while( help_ptr != NULL )
	     {
	       if( (shared_data->equal_rows[help_ptr->over]<0)  &&
		   (shared_data->equal_rows[help_ptr->under]<0) )
		  {
		    if( shared_data->under_rows[help_ptr->over]<0 )
		       {
			 shared_data->under_rows[help_ptr->over] =
					help_ptr->under;
			 shared_data->used[help_ptr->under] = TRUE;
		       } /* end of if( shared_data... */
		    else
		       if( numb_under[shared_data->under_rows[
					 help_ptr->over]]>1 )
			  {
			    numb_under[shared_data->under_rows[
					 help_ptr->over]]--;
			    shared_data->under_rows[help_ptr->over] =
					help_ptr->under;
			    shared_data->used[help_ptr->under] = TRUE;
			  } /* end of if( numb_under... */
		       else
			  numb_under[help_ptr->under]--;
		  } /* end of if( shared_data... */
	       help_ptr = help_ptr->next;
	     } /* end of while( help_ptr... */

	} /* end of for( symb=not-... */

     /* if one row is fixed more than once, loos the overfluous fixings */
     for( state=0;state<nos;state++ )
	if( shared_data->under_rows[state] >= 0 )
	   if( !count[shared_data->under_rows[state]] )
	      count[shared_data->under_rows[state]]++;
	   else
	      shared_data->under_rows[state] = -1;

     /* set the real used under rows to TRUE */
     for( symb=not-1;symb>=0;symb-- )
	{
	  help_ptr = shared_data->max[symb];
	  while( help_ptr != NULL )
	     {
	       if( shared_data->under_rows[help_ptr->over] ==
		   help_ptr->under )
		  shared_data->used[help_ptr->over] = TRUE;
               help_ptr = help_ptr->next;
	     } /* end of while( help_pt... */
	} /* end of for( symb=not-1... */

     free( shared_data->max );

     shared_data->max = NULL;
     if( extra_info )
	printf("end of function Det_Under_Rows()\n");
     return( shared_data );

   } /* end of function Det_Under_Rows( ) */











static struct sd *Det_Equal_Pos( quick_data,shared_data,user_data,
				 changed_data,extra_info )


   readtype        *quick_data;  /* interface vector to optimization       */
   struct sd      *shared_data;  /* internal interface vector              */
   struct user      *user_data;  /* informations fixed by the user         */
   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                        */



/* The pair of rows which have a certain number of equal positions are
   saved. Now I must determine which rows should share code. Therefore
   the rows with the most equal positions should share code first.
   Two rows can only share code with others when these other rows have
   the same identical entries at each position too.
*/

   {
     short           *ttab,  /* a representation of the T - Table          */
		       nos,  /* number of states                           */
		       not,  /* number of terminals                        */
		       max,  /* the maximum number of equal positions      */
		       row,  /* loop index                                 */
		      symb,  /* loop index                                 */
		       len,  /* loop index                                 */
		     count,  /* loop index                                 */
		      row1,  /* the first row to be examined		   */
		      row2,  /* the second row to be examined		   */
		       szc,  /* size of type character in bits             */
		      flag,  /* used to set bits in the bitset             */
		    length;  /* length of the used bitset                  */

     char            equal;  /* used to decide if two entries are equal    */

     struct tsc  *help_ptr;  /* help pointer to determine the two states
				which have the maximum number of equal
				positions                                  */





     if( extra_info )
	printf("begin of function Det_Equal_Pos()\n");
     nos  = *((*quick_data)[9]);
     not  = *((*quick_data)[0]);
     ttab = (*quick_data)[1];


     szc = sizeof( char ) * BYTE;
     length = (!(not%szc)) ? (not/szc) : ((not/szc)+1);

     /* determine the row with the most equal positions */
     max = 1;
     while( max > 0 )
	{
	  max = 0;
	  for( row=0;row<nos;row++ )
	     if( shared_data->used[row] )
		{
		  if( shared_data->tsc_pt[row] != NULL )
		     free( shared_data->tsc_pt[row] );
		  shared_data->tsc_pt[row] = NULL;
		} /* end of if( shared_data... */
	     else
		{
		  help_ptr = shared_data->tsc_pt[row];
		  while( help_ptr != NULL )
		     {
		       if( (max < help_ptr->eq_num) &&
			   !(shared_data->used[help_ptr->state]) )
			  {
			    max = help_ptr->eq_num;
			    row1 = row;
			    row2 = help_ptr->state;
			  } /* end of if( (max < help... */
		       help_ptr = help_ptr->next;
		     } /* end of while( help_ptr... */
		} /* end of else ( if( shared_data ) */
	  if( max>0 )
	     {
	       /* let the two rows share code */
	       if( shared_data->tsc_pt[row2] != NULL )
		  free( shared_data->tsc_pt[row2] );
	       shared_data->tsc_pt[row2] = NULL;
	       shared_data->ident_act_rows[row1] = row1;
	       if( (shared_data->bit_set[row1] = (char*) calloc(
		    length,sizeof( char ) )) == NULL )
			  Error_Message( _DET_EQUAL_POS,MODULE_LOW_OPTIM,
                                         NO_SPACE_FOR_VECTOR,ABORT,
                                         " shared_data->bit_set[row1]" );
	       shared_data->ident_act_rows[row2] = row1;
	       shared_data->used[row1] = TRUE;
	       shared_data->used[row2] = TRUE;

	       /* save the equal positions in a bitset */
	       for( symb=0;symb<not;symb++ )
		  {
		    if( (ttab[row1*not+symb] != ERROR_ENTRY) &&
                        (ttab[row2*not+symb] != ERROR_ENTRY)  )
		       if( Eq_Test( ttab[row1*not+symb],
				    ttab[row2*not+symb],
				    row1,row2,
				    user_data,
				    changed_data,
				    extra_info               ) )

			  {
			    (shared_data->bit_set[row1])[symb/szc] =
				 (shared_data->bit_set[row1])[symb/szc] |
					 (1<<(symb%szc));
			  } /* end of if( (ttab[row1*n... */
		  } /* end of for( symb=0;sym... */

	       help_ptr = shared_data->tsc_pt[row1];

	       /* are there other rows with the same equal positions? */
	       while( help_ptr != NULL )
	          {
	            if( (help_ptr->state != row2) &&
		        (help_ptr->eq_num == max) &&
		        !shared_data->used[help_ptr->state] )
		       {
		         row2  = help_ptr->state;
		         equal = TRUE;
		         len   = 0;
		         while( equal && (len<length) )
			    {
			      flag  = 1;
			      count = 0;
			      while( equal && (count<BYTE) )
			         {
			           if( shared_data->bit_set[row1][len] & flag )
				      if( !Eq_Test( ttab[row1*not+len*BYTE+count],
						ttab[row2*not+len*BYTE+count],
						row1,row2,
						user_data,
						changed_data,
						extra_info               ) )

				          equal = FALSE;
			           count++;
			           flag <<= 1;
			         } /* end of while( equal &... */
			      len++;
			    } /* end of while( equal &&... */
		         if( equal )
			    {
			      if( shared_data->tsc_pt[row2] != NULL )
			         free( shared_data->tsc_pt[row2] );
			      shared_data->tsc_pt[row2] = NULL;
			      shared_data->ident_act_rows[row2] = row1;
			      shared_data->used[row2] = TRUE;
			    } /* end of if( equal ) */
		       } /* end of if( (help_ptr->... */
	            help_ptr = help_ptr->next;
	          } /* end of while( help_ptr... */
	       if( shared_data->tsc_pt[row1] != NULL )
                  {
	            free( shared_data->tsc_pt[row1] );
	            shared_data->tsc_pt[row1] = NULL;
                  }
	     } /* end of if( max>0 ) */

	} /* end of while( max > 0 ) */

     if( extra_info )
	printf("end of function Det_Equal_Pos()\n");
     return( shared_data );

   } /* end of function Det_Equal_Pos() */






static struct sd *Det_Similar_Pos( quick_data,shared_data,user_data,
				   changed_data,extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */
   struct sd      *shared_data;  /* internal interface vector              */
   struct user      *user_data;  /* informations fixed by the user       */
   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation moduls                          */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tions about begin and end of function
				    are printed out                        */

/* It is possible, that there are some rows in the T - table and every row
   has equal positions with others. But this rows could not share code with
   others because the number of equal positions is lower than the upper 
   bound.
   It is possible that this rows share code, when the common actions grouped
   together. Therfore, I determine for each coloumn the action which is most
   used. Then I test for each row, how many entries are equal to an element
   of this group, at the same position. Is it greater than an upper
   bound, then this row could share code, by using this "group code".
*/

   {
     short               *ttab,  /* a representation of the T - Table      */
			   nos,  /* number of states                       */
			   not,  /* number of terminals                    */
			   col,  /* loop index                             */
			    st,  /* loop index                             */
			  row1,  /* the first row that will be examine yet */
			  row2,  /* the second row that will be examine
				    yet                                    */
			*count,  /* vector to determine which state has
				    the maximum number of equal positions
				    with all the other states, in one
				    column                                 */
			   max,  /* the described maximum                  */
			 state,  /* the corresponding state                */
			   num,  /* number of equal entries in one row and
				    pointer shared_data->sim_act           */
			   szc,  /* size of character in bits              */
			  flag,  /* used to set bits in the bitset         */
	    number_of_bit_sets=  /* number of bit sets, which are used for */
			     0,  /* similar action code                    */
			length;  /* length of the used bitset              */

     char            *help_ptr,  /* help pointer to allocate storage space
				    for the needed bitsets and store the
				    bitset                                 */
			 *used,
			 found;  /* used to decide if a while loop break
				    off                                    */


     if( extra_info )
	printf("begin of function Det_Similar_Pos() \n");
     nos  = *((*quick_data)[9]);
     not  = *((*quick_data)[0]);
     ttab = (*quick_data)[1];

     szc = sizeof( char ) * BYTE;
     length = (!(not%szc)) ? (not/szc) : ((not/szc)+1);

     if( ((count    = (short*) calloc( nos,sht )) == NULL) ||
	 ((used     = (char*)  calloc(
			    not,sizeof( char ) )) == NULL) ||
	 ((help_ptr = (char*)  calloc(
			 length,sizeof( char)  )) == NULL) )
	    Error_Message( _DET_SIMILAR_POS,MODULE_LOW_OPTIM,
                           NO_SPACE_FOR_VECTOR,ABORT," help_ptr");



     /* fix the symbol which occurs most in the unused rows to an
	equality row */
     for( col=0;col<not;col++ )
	{
	  for( row1=0;row1<nos;row1++ )
	     if( !shared_data->used[row1] )
		{
		  for( row2=row1+1;row2<nos;row2++ )
		     if( !shared_data->used[row1] )
			if( (ttab[row1*not+col] != ERROR_ENTRY) &&
                            (ttab[row2*not+col] != ERROR_ENTRY)  )
			   if( (!(IS_REDUCEACT( ttab[row1*not+col] ))) &&
			       (!(IS_SHREDACT( ttab[row1*not+col] )))  )
			      if( Eq_Test( ttab[row1*not+col],
					   ttab[row2*not+col],
					   row1,row2,
					   user_data,
					   changed_data,
					   extra_info              ) )

				  {
				    count[row1]++;
				    count[row2]++;
				  } /* end of if( (ttab[row1*... */
		} /* end of if( !shared_dat... */
	  max   = 0;
	  state = 0;
	  for( row2=0;row2<nos;row2++)
	     {
	       if( max<count[row2] )
		  {
		    max   = count[row2];
		    state = row2;
		  } /* end of if( max<count[r... */
	       count[row2] = 0;
	     } /* end of for( row2=0;row... */
	  if( max )
	     shared_data->sim_act[col] = state;

	} /* end of for( col=0;col<... */


     /* Count for each unused row, how many positions are equal to the
	equality row. Is it greater then a bound, save the equal
	positions in a bitset. */
     for( row1=0;row1<nos;row1++ )
	if( !shared_data->used[row1] )
	   {
	     num = 0;
	     for( col=0;col<not;col++ )
	       if( shared_data->sim_act[col] >= 0 )
                  if( (ttab[shared_data->sim_act[col]*not+col] 
                                                != ERROR_ENTRY) &&
                      (ttab[row1*not+col]       != ERROR_ENTRY)  )   
		     if( Eq_Test( ttab[shared_data->sim_act[col]*not+col],
			          ttab[row1*not+col],
			          shared_data->sim_act[col],row1,
			          user_data,
			          changed_data,
			          extra_info              ) )
		         {
			   num++;
			   flag = 1;
			   used[col] = TRUE;
			   help_ptr[col/szc] = help_ptr[col/szc] |
					        (flag<<(col%szc));
		         } /* end of if( ttab[shared... */
		  if( num >= user_data->number_of_similar_action )
		     {
		       number_of_bit_sets++;
		       st=0;
		       found = FALSE;
		       while( (st<nos) && !found )
			  {
			    if( (shared_data->similar_act_rows[st]>=0) &&
				(shared_data->bit_set[st] != NULL)  )
			       {
				 row2=0;
				 found = TRUE;
				 while( (row2<length) && found )
				   if( shared_data->bit_set[st][row2] !=
				       help_ptr[row2] )
				      found = FALSE;
				   else
				      row2++;
				 if( found )
				    {
				      shared_data->similar_act_rows[row1] =
					   st;
				      shared_data->bit_set[row1] =
					   shared_data->bit_set[st];
				    } /* end of if( found ) */
			       } /* end of if( shared_data... */
			    st++;
			  } /* end of while( (st<nos)... */
		       if( !found )
			  {

			    shared_data->similar_act_rows[row1] = row1;
			    shared_data->bit_set[row1] = help_ptr;
			    if( (help_ptr = (char*) calloc(
				       length,sizeof( char)  )) == NULL )
					    Error_Message( _DET_SIMILAR_POS,
                                                           MODULE_LOW_OPTIM,
                                                           NO_SPACE_FOR_VECTOR,
                                                           ABORT," help_ptr" );
			  } /* end of if( !found ) */
		       else
			  for( row2=0;row2<length;row2++ )
			      help_ptr[row2] = 0;
		     } /* end of if( num >= us... */
		  else
		     for( row2=0;row2<length;row2++ )
			 help_ptr[row2] = 0;
	   } /* end of if( !shared_dat... */
     if( number_of_bit_sets == 1 )
	{
	  for( st=0;st<nos;st++ )
	    shared_data->similar_act_rows[st] = -1;
	  number_of_bit_sets = 0;
	} /* end of if( number_of_... */
     if( number_of_bit_sets )
	shared_data->similar_act_branches = TRUE;
     else
	shared_data->similar_act_branches = FALSE;

     for( col=0;col<not;col++ )
	if( !used[col] )
	   shared_data->sim_act[col] = -1;


     if( extra_info )
	printf("end of function Det_Similar_Pos() \n");
     return( shared_data );

   } /* end of function Det_Similar_Pos() */







void Low_Optim( quick_data,user_data,changed_data,extra_info )


   readtype        *quick_data;  /* interface vector to optimization       */
   struct user      *user_data;  /* information fixed by the user          */
   struct inter  *changed_data;  /* internal interface between the optimi-
				    zation modules                         */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                         */



/* This is the control function of the module Low_Optim. It calls the other
   functions in the correct order and if TESTOPT is set, some information
   will be writen on file Low.wrt.
*/


   {
     short             nos,  /* number of states                           */
		       not,  /* number of terminals                        */
	              row1,  /* the first row to be examined 		   */
	              row2,  /* the second row to be examined 		   */
	             state,  /* loop index                                 */
	              symb,  /* loop index                                 */
	             *ttab;  /* a representation of the T - Table          */
   struct sd  *shared_data;  /* internal interface vector                  */

#ifdef TESTOPT

     FILE      *fp;  /* file pointer to the test output file               */
     short     col,  /* loop index                                         */
	       len,  /* loop index                                         */
	     count,  /* loop index                                         */
	    length,  /* length of the bitset                               */
	       szc,  /* size of char in bits                               */
	      flag,  /* used to set bits in the bitset                     */
	      numb;  /* used to control the format of printing out         */


#endif

     if( extra_info )
	printf(" begin of function Low_Optim()\n");
     nos  = *((*quick_data)[9]);
     not  = *((*quick_data)[0]);
     ttab = (*quick_data)[1];


     if( (shared_data = (struct sd*) malloc( sizeof( struct sd ) )) == NULL )
	Error_Message( _LOW_OPTIM,MODULE_LOW_OPTIM,NO_SPACE_FOR_STRUCTURE,
                       ABORT," shared_data");

     if( ((shared_data->used       = (char*) malloc(
				      nos * sizeof( char ) )) == NULL) ||
	 ((shared_data->equal_rows = (short*) malloc(
				      nos * sht )) == NULL) ||
	 ((shared_data->under_rows = (short*) malloc(
				      nos * sht )) == NULL) ||
	 ((shared_data->max        = (pos_under*) malloc(
				      not * sizeof( pos_under ) )) == NULL) ||
	 ((shared_data->tsc_pt     = (share_two*) malloc(
				    nos * sizeof( share_two ) )) == NULL) ||
	 ((shared_data->ident_act_rows     = (short*) malloc(
				    nos * sht )) == NULL) ||
	 ((shared_data->bit_set     = (char_ptr*) malloc(
				    nos * sizeof( char_ptr ) )) == NULL) ||
	 ((shared_data->similar_act_rows = (short*) malloc(
				    nos * sizeof( short ) )) == NULL) ||
	 ((shared_data->sim_act     = (short*) malloc(
				    not * sht )) == NULL) )
	  Error_Message( _LOW_OPTIM,MODULE_LOW_OPTIM,NO_SPACE_FOR_VECTOR,
                         ABORT," shared_data->sim_act" );


     for( state=0;state<nos;state++ )
	{
	  shared_data->used[state]              = FALSE;
	  shared_data->equal_rows[state]        = -1;
	  shared_data->under_rows[state]        = -1;
	  shared_data->tsc_pt[state]            = NULL;
	  shared_data->ident_act_rows[state]    = -1;
	  shared_data->bit_set[state]           = NULL;
	  shared_data->similar_act_rows[state]  = -1;

	} /* end of for( state=0;st... */

     for( symb=0;symb<not;symb++ )
	{
	  shared_data->sim_act[symb] = -1;
	  shared_data->max[symb]     = NULL;
	} /* end of for( symb=0;sym... */
     shared_data->similar_act_branches = FALSE;


     if( user_data->lower_optimization )
	{
	  for( row1=0;row1<nos;row1++ )
	       for( row2=row1+1;row2<nos;row2++ )
		  shared_data = Compare_Equal( ttab,row1,row2,not,shared_data,
					       user_data,changed_data,
					       extra_info );

	  shared_data = Det_Under_Rows( quick_data,shared_data,extra_info );

	  shared_data = Det_Equal_Pos( quick_data,shared_data,user_data,
				       changed_data,extra_info );

	  shared_data = Det_Similar_Pos( quick_data,shared_data,user_data,
					 changed_data,extra_info );
	} /* end of if( user_data->... */

     changed_data->equal_rows           = shared_data->equal_rows;
     changed_data->under_rows           = shared_data->under_rows;
     changed_data->ident_act_rows       = shared_data->ident_act_rows;
     changed_data->bit_set              = shared_data->bit_set;
     changed_data->sim_act              = shared_data->sim_act;
     changed_data->similar_act_rows     = shared_data->similar_act_rows;
     changed_data->similar_act_branches = shared_data->similar_act_branches;


     if( user_data->high_before_low         && 
         user_data->lower_optimization      &&
         !user_data->individual_reduce_code  )
	Delete_Shared_Red_Sits( quick_data,changed_data,extra_info );


#ifdef TESTOPT

     szc = sizeof( char ) * BYTE;
     length = (!(not%szc)) ? (not/szc) : ((not/szc)+1);
     fp = fopen("LOW.wrt","w");


     fprintf(fp,"The following pairs of states have identical T - table\n");
     fprintf(fp,"entries in each position :\n");
     fprintf(fp,"\n");

     for( state=0;state<nos;state++ )
	if( shared_data->equal_rows[state] >=0 )
	   fprintf(fp,"          %4d  <--->  %-4d\n",state,
		      shared_data->equal_rows[state]);

     fprintf(fp,"\n");
     fprintf(fp,"\n");
     fprintf(fp,"\n");



     fprintf(fp,"The T - table entries of the first state are a subset\n");
     fprintf(fp,"of the second state :\n");
     fprintf(fp,"\n");

     for( state=0;state<nos;state++ )
	if( shared_data->under_rows[state] >= 0 )
	  fprintf(fp,"          %4d  <--->   %-4d\n",
		     shared_data->under_rows[state],state);
     fprintf(fp,"\n");
     fprintf(fp,"\n");
     fprintf(fp,"\n");


     fprintf(fp,"The following pairs of states have more than %d common\n",
		(user_data->number_of_common_action-1) );
     fprintf(fp,"actions in the T - table :\n" );
     fprintf(fp,"\n");

     for( state=0;state<nos;state++ )
	if( (shared_data->ident_act_rows[state] >= 0) &&
	    (shared_data->ident_act_rows[state] != state) )
	       {
		 fprintf(fp,"State %d and state %d have the same entries",
			    state,shared_data->ident_act_rows[state] );
		 fprintf(fp," in the following coloumns : \n");
		 len   = 0;
		 numb  = 0;
		 while( len<length )
		   {
		     flag  = 1;
		     count = 0;
		     while( count<BYTE )
		       {
			if( shared_data->bit_set[
			    shared_data->ident_act_rows[state]][len] & flag )
			   if( !numb++ )
			      fprintf(fp," %-4d",len*BYTE+count);
			   else
			      fprintf(fp," , %-4d",len*BYTE+count);
			if( numb == 10 )
			   {
			     numb = 0;
			     fprintf(fp,"\n");
			   } /* end of if( numb ==... */
			count++;
			flag <<= 1;
		       } /* end of while( count<BYTE ) */
		     len++;
		   } /* end of while( len<length ) */
		 fprintf(fp,"\n");
	       } /* end of if( (shared_dat... */

     fprintf(fp,"\n");
     fprintf(fp,"\n");
     fprintf(fp,"\n");



     fprintf(fp,"It exist the following action group. States, which have\n");
     fprintf(fp,"more than %d equal actions at same position as this \n",
		user_data->number_of_similar_action-1);
     fprintf(fp,"group, have a jump to this group.\n");
     fprintf(fp,"\n");

     for( col=0;col<not;col++ )
	if( shared_data->sim_act[col] >= 0 )
	   fprintf(fp,"Coloumn %-4d : action of state %d is bounded\n",
		       col,shared_data->sim_act[col] );
	else
	   fprintf(fp,"Coloumn %-4d : No action bounded\n",
		       col );

     fprintf(fp,"\n");
     fprintf(fp,"\n");
     fprintf(fp,"\n");

     fprintf(fp,"The following states have a jump to the combined action ");
     fprintf(fp,"group :\n");
     fprintf(fp,"\n");

     for( state=0;state<nos;state++ )
       if( shared_data->similar_act_rows[state] >= 0 )
	 {
	   fprintf(fp,"State number %d has equal entries with the combined\n",
		      state );
	   fprintf(fp,"action group, at following coloumns :\n");
	   len   = 0;
	   numb  = 0;
	   while( len<length )
	      {
		flag  = 1;
		count = 0;
		while( count<BYTE )
		   {
		     if( shared_data->bit_set[state][len] & flag )
			if( !numb++ )
			   fprintf(fp," %-4d",len*BYTE+count);
			else
			   fprintf(fp," , %-4d",len*BYTE+count);
		     if( numb == 10 )
			{
			  numb = 0;
			  fprintf(fp,"\n");
			} /* end of if( numb ==... */
		     count++;
		     flag <<= 1;
		   } /* end of while( count<BYTE ) */
		len++;
	      } /* end of while( len<length ) */
	   fprintf(fp,"\n\n");
	 } /* end of if( shared_data... */

     fprintf(fp,"\n");
     fprintf(fp,"\n");
     fprintf(fp,"\n");

     fclose( fp );

#endif

     if( extra_info )
	printf(" end of function Low_Optim()\n");
   } /* end of function Low_Optim() */






