/***************************************************************************/
/* filename : errors.c                             first edit  : 23.02.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 05.06.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: errors.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

#include<stdio.h>

#include "errors.h"

#include "error_text.h"

/***************************** FUNCTIONS **********************************/






void Error_Message( func_number,module_number,errortext,error_class,
                    add_info )

   short    func_number,  /* Each function has a number, which represents 
                             the position in vector func. The corresponding 
                             function name is stored at this location.     */
	  module_number,  /* Same as above, but only for modules in
                             vector modules                                */
	      errortext,  /* Same as above, but only for error text in
                             vector error                                  */
	    error_class;  /* The number of error class. Two error classes 
                             are allowed, ERROR ( != 0 ) and WARNING 
                             ( == 0 )                                      */
   char       *add_info;  /* if additional information should printed out,
                             add_info can be used.                         */


/* This is the internal error module. Normally only errors for user's input
   or allocation of storage space should occur. All other errors are  
   internal errors, which point to wrong program code. If an internal 
   error appears, please contact the author.                                       

*/

   {
     if( (module_number>max_module) ||
	 (module_number<0)          ||
	 (func_number>max_func)     ||
	 (func_number<0)            ||
	 (errortext>max_error)      ||
	 (errortext<0)              )
	 Error_Message( _ERROR_MESSAGE,MODULE_ERROR,WRONG_ERROR,ABORT,"" );

     else
	{
	  fprintf( (error_class ? stderr : stdout),
		   "\n%s_%-2d : Module %s : Function %s() !\n",
		   (error_class ? "ERROR" : "WARNING"),
		   errortext,
		   module[module_number],
                   func[func_number] );

	  fprintf( (error_class ? stderr : stdout),
		   "%s %s %s\n",
                   (error_class ? "MESSAGE  :" : "MESSAGE    :"),
                   error[errortext],
		   add_info );

	} /* end of else ( if( (module_n... ) */
     if( error_class )
	{
	  fprintf( stderr,"\n!!!Program aborted with errors!!!\n");
	  exit(1);
	} /* end of if( error_... */


   } /* end of function Error_Message() */

