/***************************************************************************/
/* filename : error_out.h                          first edit  : 02.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 05.06.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
/* $Id: error_out.h,v 1.1 1992/01/10 14:38:40 cogito Exp $ */


/************************* MACRO - DEFINITIONS *****************************/



#define IS_SEPASYMBOL( entry )           entry & 0x0002
#define IS_SKIPSYMBOL( entry )           entry & 0x0001
#define IS_BRACSYMBOL( entry )           entry & 0x0004
#define IS_REP( entry )                  entry & 0x2000

#define SET_REP( entry )                 entry | 0x2000
#define SET_F_REDACT( entry )            entry | 0x2000
#define SET_R_REDACT( entry )            entry | 0x4000
#define SET_F_GOTOACT( entry )           entry | 0x1000
#define SET_R_GOTOACT( entry )           entry | 0x8000



/*
struct error_code
   {
     short             sem1,
		       sem2,
			pop,
		       scan,
		      state,
		       kind,
		       mark;
     struct pcc_elem   *pcc;
   };
*/



struct shift_trans
   {
     short number;
     union 
        {
          short rep;
          short *list;
        } addr;
   };



struct error
   {
     char                                   push,
				     stack_check;
     short                            fr_red_act;

     union
	{
	  short              fsymbol_goto_action;
	  struct error_code             *fsymbol;
	} fsym;

     union
	{
	  short              rsymbol_goto_action;
	  struct error_code             *rsymbol;
	} rsym;
   };


typedef struct pcc_elem  *pcc_list;

struct error_out
   {
     short                             nos,
				       not,
				       nop,
                                       eof,
			      longest_path,
			      numb_of_para,
                             *sx_code_list,
				  *par_set,
				  *fsymbol,
				  *rsymbol,
                             *fsymbol_sem1,
                             *rsymbol_sem1,
                             *fsymbol_sem2,
                             *rsymbol_sem2,
                           *fsymbol_action,
                           *rsymbol_action,
                            fsymbol_accept,
                            rsymbol_accept,
                                  max_term,
                                  min_term;
     int             number_of_shift_trans;
     char            fsymbol_equal_rsymbol,
                             share_address,
                                  *visited,
                                *print_out,
                                *seman_out,
                                     *push,
                              *fsymbol_pop,
                              *rsymbol_pop,
                             *fsymbol_scan,
                             *rsymbol_scan;
     pcc_list            *fsymbol_pcc_list,
                         *rsymbol_pcc_list;
     struct red_out_code         *red_code;
     struct shift_trans      *address_list;
     char_ptr                  *seman_list;
   };


/*************************** FUNCTIONS *************************************/

extern struct error_out *Build_Error_Out(  /*quick_data,user_data,
                                             optim_out_data,extra_info */ );


/*
   readtype              *quick_data;
   struct user            *user_data;
   struct optim_out  *optim_out_data;
   char                   extra_info;   if extra_info == 1, then extra
				        information about begin and end
				        of function are printed out      
*/

extern struct red_out_code *Find_Red_Code( /* help_ptr,mark,state,kind,pos,
                                              extra_info */ );

/*
   struct red_out_code   *help_ptr;
   short                      mark,
                             state,
                              kind,
                              *pos;
   char                 extra_info;    if extra_info == 1, then extra
				       information about begin and end
				       of function are printed out      
*/


