# $Id: src.idl.idllib.Makefile.cpp,v 1.7 1992/10/14 13:15:08 cogito Exp $
#
# Makefile to produce the IDL-library "libidl.a": kalle 08.01.90 
#

INCDIR = ..

DESTDIR= ELISYS
DISTRIB= ELISYS

CFLAGS	= -I$(INCDIR)

DECLINC = $(INCDIR)/global.h
CODEINC = $(INCDIR)/writer.h
READINC = $(INCDIR)/reader.h

LIBDIR= ..

SRC    = nextOne.c  rmisc.c reader.c scanner.c labels.c wmisc.c \
	init.c list.c debug.c MsgChar.c \
	array.c wrat.c string.c basics.c alloc.c
OFILES = nextOne.o  rmisc.o reader.o scanner.o labels.o wmisc.o \
	init.o list.o debug.o MsgChar.o \
	array.o wrat.o string.o basics.o alloc.o

# generates libidl.a

all: $(LIBDIR)/libidl.a

install: $(LIBDIR)/libidl.a

#if defined(NO_RANLIB)
$(LIBDIR)/libidl.a: $(OFILES)
	ar rus $(LIBDIR)/libidl.a $(OFILES)
#else
$(LIBDIR)/libidl.a: $(OFILES)
	ar ru $(LIBDIR)/libidl.a $(OFILES)
	ranlib $(LIBDIR)/libidl.a
#endif

TIDY=	*.o
CLEAN=  $(TIDY) core $(LIBDIR)/idllib.a
CLOBBER= $(CLEAN)

# checkout

checkout:
	co -q $(SRC)

# distribution

distrib:	$(SRC)
	@if test ! -d $(DISTRIB)/idl/idllib; \
		then umask 002; mkdir $(DISTRIB)/idl/idllib; \
		else :; \
		fi
	cp $(SRC) Makefile.cpp $(DISTRIB)/idl/idllib
	cd $(DISTRIB)/idl/idllib; chmod 0644 $(SRC) Makefile.cpp

#
tidy:
	rm -f $(TIDY)

# clean
clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

# cleanall
rcsclean:
	rcsclean -q $(SRC)


array.o: $(DECLINC) $(READINC)

inseq.o: $(DECLINC) $(READINC)

tester.o: $(DECLINC) $(READINC)

rmisc.o: $(DECLINC) $(READINC)

reader.o: $(DECLINC) $(READINC)

labels.o: $(DECLINC) $(READINC)

wmisc.o: $(DECLINC) $(CODEINC)


.PRECIOUS: $(SRC)





