# $Id: src.idl.Makefile.cpp,v 1.9 1992/10/14 13:16:31 cogito Exp $
#
# Makefile of the directory idl to create IDL-Library for comar-system
#
DISTRIB = ELISYS
DESTDIR = ELISYS

SRC   = comar.c  comar_func.c  prsiface.c
HDR   = comar.h comarMacros.h comar_func.h prsiface.h prsifaceMacros.h name.h \
	global.h reader.h writer.h scalarlist.h
OBJ   = comar.o  comar_func.o  prsiface.o

CFLAGS	= 

TIDY    = core a.out  *% *.o ERRS lintmsg
CLEAN   = $(TIDY) *.exe *.a
CLOBBER = $(CLEAN)

###########################################################################

all:	IDL.a

#if defined(NO_RANLIB)
IDL.a:	$(OBJ) libidl.a
	cp libidl.a IDL.a
	ar rus IDL.a $(OBJ)
#else
IDL.a:	$(OBJ) libidl.a
	cp libidl.a IDL.a
	ar ru IDL.a $(OBJ)
	ranlib IDL.a
#endif

comar.o: comar.c comar.h global.h reader.h writer.h

prsiface.o: prsiface.c prsiface.h global.h reader.h writer.h

comar_func.o: comar_func.c comar_func.h global.h

libidl.a:
	(cd idllib; make all CC="$(CC)" )

###########################################################################

# checkout
checkout:	
	(cd idllib; make checkout );
	co -q $(SRC)
	co -q $(HDR)

# installation
install:	IDL.a


# distribution
distrib:
	@if test ! -d $(DISTRIB)/idl; \
		then umask 002; mkdir $(DISTRIB)/idl; \
		else :; \
		fi
	cp Makefile.cpp $(SRC) $(HDR) $(DISTRIB)/idl
	cd $(DISTRIB)/idl; chmod 0644 Makefile.cpp $(SRC) $(HDR)
	(cd idllib; make distrib DISTRIB=$(DISTRIB) );

# tidy
tidy:
	rm -f $(TIDY)
	cd idllib; make tidy

# clean
clean:	
	rm -f $(CLEAN)
	cd idllib; make clean

# clobber
clobber:
	rm -f $(CLOBBER)
	cd idllib; make clobber

# cleanall
rcsclean:	clean
	rcsclean -q $(SRC)
	rcsclean -q $(HDR)
	(cd idllib; make rcsclean);

