# $Id: src.Makefile.cpp,v 1.17 1992/06/15 11:06:09 cogito Exp $

SHELL   = /bin/sh
CFLAGS  =

# hack for Sun auto-mounter
PWD     = pwd | sed 's,^/tmp_mnt,,'

# Default master cache location
DESTDIR = ELISYS

COFLAGS = -q

SUBDIR  = Cmd Frames Info idl lib trafos oldcmr lalr option
CMRDIRS = ll cmrtools
INSTDIR = Cmd Frames Info
DELDIR  = idl lib trafos oldcmr lalr option

SKEL    =
AUX     =
EXE     = cola_absprs.exe cola_dep.exe cola_option.exe cola_cmr2pgs.exe \
	  cola_ebnf2bnf.exe cola_pgs2cmr.exe cola_connect.exe cola_ins_stop.exe \
	  cola_tbl.exe 

TIDY    = core a.out  *% lintmsg *.p *.o ERRS
CLEAN   = $(TIDY) *.exe
CLOBBER = $(CLEAN) Makefile


###########################################################################

all:
	@for dir in $(SUBDIR) ; do \
	  ( echo "Making Tool/cola/$$dir"; cd $$dir; \
		 make all CC="$(CC)" DESTDIR="$(DESTDIR)" ) ; \
	done

install:
	@if test ! -d $(DESTDIR)/Tool/cola; \
		then umask 002; mkdir $(DESTDIR)/Tool/cola; \
		else :; \
		fi
	@for f in $(EXE) ; do \
		echo install -c -m 755 $$f $(DESTDIR)/Tool/cola; \
		rm -f $(DESTDIR)/Tool/cola/$$f; \
		cp $$f $(DESTDIR)/Tool/cola; \
		chmod 755 $(DESTDIR)/Tool/cola/$$f; \
	done
	-@for dir in $(INSTDIR); do \
		if test ! -d $(DESTDIR)/Tool/cola/$$dir; \
			then umask 002; mkdir $(DESTDIR)/Tool/cola/$$dir; \
		fi; \
	done
	@for dir in $(INSTDIR); do echo; echo "Install Tool/cola/$$dir"; \
		(cd $$dir; make DESTDIR=$(DESTDIR) install); \
	done

distrib:        
	-mkdir $(DISTRIB)
	cp Makefile.cpp $(SKEL) $(DISTRIB)
	cd $(DISTRIB); chmod 0644 Makefile.cpp $(SKEL)
	@for dir in $(SUBDIR) ; do \
		( echo; echo "Distributing Tool/cola/$$dir"; echo; cd $$dir; \
		make distrib DISTRIB=$(DISTRIB)); \
	done

tidy:
	rm -f $(TIDY)
	-@for dir in $(SUBDIR) ; do \
	  ( echo "Tidying in Tool/cola/$$dir"; cd $$dir; make tidy );\
	done

clean:
	rm -f $(CLEAN)
	-@for dir in $(SUBDIR) ; do \
	  ( echo "Cleaning in Tool/cola/$$dir"; cd $$dir; make clean );\
	done

clobber:
	rm -f $(CLOBBER)
	-@for dir in $(SUBDIR) ; do \
	  ( echo "Clobbering in Tool/cola/$$dir"; cd $$dir; make clobber );\
	done

executable:
	@echo; echo "Making Tool/cola executable"
	-@for dir in $(DELDIR); do rm -rf $$dir; \
	done
	-rm -f Cmd/Makefile Cmd/cola.dg Frames/Makefile Frames/README? Info/Makefile Info/*.tnf Makefile*


