
#include <stdio.h>
#include <malloc.h>
#include "ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGcint *_PPTGcint;
struct _SPTGcint{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGstr *_PPTGstr;
struct _SPTGstr{
  _PTGProc _print;
  int _t0;
};

void _PrPTGfile(n)
_PPTG3 n;
{
  fputs ("#include <stdio.h>\n", f);
  fputs ("#include \"clplib.h\"\n", f);
  fputs ("#include \"pdl_gen.h\"\n", f);
  fputs ("\n", f);
  fputs ("DefTableKey CLP_InputFile = NoKey;\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("static int error_count = 0;\n", f);
  fputs ("\n", f);
  fputs ("void\n", f);
  fputs ("clp_init (argc, argv)\n", f);
  fputs ("int argc;\n", f);
  fputs ("char *argv[];\n", f);
  fputs ("{\n", f);
  fputs ("  int i, done = 0;\n", f);
  fputs ("  DefTableKey k;\n", f);
  fputs ("\n", f);
  fputs ("  for (i = 1; (!done) && (i < argc); i++)\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("      { done = 1; i--; }\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

void _PrPTGtail(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("  if (CLP_InputFile == NoKey)\n", f);
  fputs ("    if (i >= argc) error_count++;\n", f);
  fputs ("    else {\n", f);
  fputs ("      CLP_InputFile = NewKey();\n", f);
  fputs ("      SetValue (CLP_InputFile, clp_string(argv[i++]),0);\n", f);
  fputs ("  }\n", f);
  fputs ("  if (error_count > 0) {\n", f);
  fputs ("    fprintf (stderr, \"Usage: %s [options] parameters\\n\",\n", f);
  fputs ("             argv[0]);\n", f);
  fputs ("    fprintf (stderr, \"  options:\\n\");\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("    exit (1);\n", f);
  fputs ("  }\n", f);
  fputs ("}\n", f);
}

void _PrPTGkdecl(n)
_PPTG1 n;
{
  fputs ("DefTableKey ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NoKey;\n", f);
}

void _PrPTGkkdecl(n)
_PPTG3 n;
{
  fputs ("DefTableKeyList ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = (DefTableKeyList)0;\n", f);
  fputs ("static DefTableKeyList *", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end = &", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (";\n", f);
}

void _PrPTGbdecl(n)
_PPTG1 n;
{
  fputs ("int ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = 0;\n", f);
}

void _PrPTGidecl(n)
_PPTG1 n;
{
  fputs ("static int ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_count = 0;\n", f);
}

void _PrPTGterm(n)
_PPTG1 n;
{
  fputs ("    if (strcmp (argv[i], \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\") == 0)\n", f);
  fputs ("      done = 1;\n", f);
  fputs ("    else\n", f);
}

void _PrPTGcmp(n)
_PPTG2 n;
{
  fputs ("    if (strcmp (argv[i], \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\") == 0) {\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("    } else\n", f);
}

void _PrPTGvcmp(n)
_PPTG3 n;
{
  fputs ("    if (strcmp (argv[i], \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\") == 0) {\n", f);
  fputs ("      if (i == argc - 1) {\n", f);
  fputs ("        fprintf (stderr, \"Usage: \\\"", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\\\" must have a value.\\n\");\n", f);
  fputs ("        error_count++;\n", f);
  fputs ("      } else {\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("      }\n", f);
  fputs ("    } else\n", f);
}

void _PrPTGjcmp(n)
_PPTG3 n;
{
  fputs ("    if (strncmp (argv[i], \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\", ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (") == 0) {\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("    } else\n", f);
}

void _PrPTGbool(n)
_PPTG2 n;
{
  fputs ("      ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = 1;\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGbools(n)
_PPTG2 n;
{
  fputs ("      k = NewKey();\n", f);
  fputs ("      SetValue (k, 1, 0);\n", f);
  fputs ("      ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end, k);\n", f);
}

void _PrPTGintval(n)
_PPTG3 n;
{
  fputs ("        ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("        SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",atoi(argv[++i]),0);\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

void _PrPTGintvals(n)
_PPTG2 n;
{
  fputs ("        k = NewKey();\n", f);
  fputs ("        SetValue (k, atoi(argv[++i]), 0);\n", f);
  fputs ("        ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end, k);\n", f);
}

void _PrPTGjintval(n)
_PPTG4 n;
{
  fputs ("      ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("      SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",atoi(argv[i]+", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("),0);\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
}

void _PrPTGjintvals(n)
_PPTG3 n;
{
  fputs ("      k = NewKey();\n", f);
  fputs ("      SetValue (k, atoi(argv[i]+", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("), 0);\n", f);
  fputs ("      ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("_end, k);\n", f);
}

void _PrPTGstrval(n)
_PPTG3 n;
{
  fputs ("        ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("        SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",clp_string(argv[++i]),0);\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

void _PrPTGstrvals(n)
_PPTG2 n;
{
  fputs ("        k = NewKey();\n", f);
  fputs ("        SetValue (k, clp_string(argv[++i]), 0);\n", f);
  fputs ("        ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end, k);\n", f);
}

void _PrPTGjstrval(n)
_PPTG4 n;
{
  fputs ("      ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("      SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",clp_string(argv[i]+", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("),0);\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
}

void _PrPTGjstrvals(n)
_PPTG3 n;
{
  fputs ("      k = NewKey();\n", f);
  fputs ("      SetValue (k, clp_string(argv[i]+", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("), 0);\n", f);
  fputs ("      ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("_end, k);\n", f);
}

void _PrPTGctest(n)
_PPTG2 n;
{
  fputs ("      if (++ ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_count > 1) {\n", f);
  fputs ("        fprintf (stderr, \"Usage: \\\"", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\\\" can only be given once.\\n\");\n", f);
  fputs ("        error_count++;\n", f);
  fputs ("      }\n", f);
}

void _PrPTGparam(n)
_PPTG3 n;
{
  fputs ("  if (i >= argc)\n", f);
  fputs ("    error_count++;\n", f);
  fputs ("  else {\n", f);
  fputs ("    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("    SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",clp_string(argv[i++]),0);\n", f);
  fputs ("    if (CLP_InputFile == NoKey) CLP_InputFile = ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (";\n", f);
  fputs ("  }\n", f);
}

void _PrPTGmparam(n)
_PPTG2 n;
{
  fputs ("  for (; i < argc; i++) {\n", f);
  fputs ("    k = NewKey();\n", f);
  fputs ("    SetValue (k, clp_string(argv[i]), 0);\n", f);
  fputs ("    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end, k);\n", f);
  fputs ("    if (CLP_InputFile == NoKey) CLP_InputFile = k;\n", f);
  fputs ("  }\n", f);
}

void _PrPTGtuse(n)
_PPTG1 n;
{
  fputs ("    fprintf (stderr, \"    option terminator: ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\\n\");\n", f);
}

void _PrPTGbsuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

void _PrPTGbpuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

void _PrPTGisuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" int: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

void _PrPTGisjuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("int: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

void _PrPTGipuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" int: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

void _PrPTGipjuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("int: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

void _PrPTGssuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" str: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

void _PrPTGssjuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("str: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

void _PrPTGspuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" str: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

void _PrPTGspjuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("str: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

void _PrPTGpuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"  param ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\\n\");\n", f);
}

void _PrPTGppuse(n)
_PPTG2 n;
{
  fputs ("    fprintf (stderr, \"  param ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

void _PrPTGheader(n)
_PPTG1 n;
{
  fputs ("#include \"clplib.h\"\n", f);
  fputs ("\n", f);
  fputs ("extern DefTableKey CLP_InputFile;\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGkextern(n)
_PPTG1 n;
{
  fputs ("extern DefTableKey ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

void _PrPTGkkextern(n)
_PPTG1 n;
{
  fputs ("extern DefTableKeyList ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

void _PrPTGiextern(n)
_PPTG1 n;
{
  fputs ("extern int ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

void _PrPTGseq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGcint(n)
_PPTGcint n;
{
  fprintf (f, "%d",n->_t0);
}

extern void OutStr();

void _PrPTGstr(n)
_PPTGstr n;
{
OutStr(f,n->_t0);
}

PTGNode PTGfile(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGfile;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGtail(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGtail;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGkdecl(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGkdecl;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGkkdecl(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGkkdecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGbdecl(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGbdecl;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGidecl(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGidecl;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGterm(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGterm;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGcmp(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGcmp;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGvcmp(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGvcmp;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGjcmp(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGjcmp;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGbool(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGbool;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGbools(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGbools;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGintval(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGintval;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGintvals(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGintvals;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGjintval(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGjintval;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGjintvals(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGjintvals;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGstrval(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGstrval;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGstrvals(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGstrvals;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGjstrval(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGjstrval;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGjstrvals(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGjstrvals;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGctest(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGctest;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGparam(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGparam;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGmparam(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGmparam;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGtuse(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGtuse;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGbsuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGbsuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGbpuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGbpuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGisuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGisuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGisjuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGisjuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGipuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGipuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGipjuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGipjuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGssuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGssuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGssjuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGssjuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGspuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGspuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGspjuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGspjuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGpuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGpuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGppuse(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGppuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGheader(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGheader;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGkextern(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGkextern;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGkkextern(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGkkextern;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGiextern(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGiextern;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGseq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGseq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGcint(_t0)
  int _t0;
{
  _PPTGcint n;

  if ((n = (_PPTGcint) malloc (sizeof (struct _SPTGcint)))  ==  (_PPTGcint)NULL)
	MEMERR
  n->_print = _PrPTGcint;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGstr(_t0)
  int _t0;
{
  _PPTGstr n;

  if ((n = (_PPTGstr) malloc (sizeof (struct _SPTGstr)))  ==  (_PPTGstr)NULL)
	MEMERR
  n->_print = _PrPTGstr;
  n->_t0=_t0;
  return ((PTGNode) n);
}

