#!/bin/sh
# $Id: clp_gen.cmd,v 1.6 1992/06/23 22:24:47 kadhim Exp $
# Copyright, 1990, The University of Colorado

#clp_gen[.none] "Objects generated from CLP specifications"* :
#	USER
#		: (:clp.cmpd :cpp)

umask 0
cd (|<RUNDIR|)

# put the clp comment indicator '%' in front of cpp control lines
sed -e '/^#/s/^/%/' (|<(:clp.cmpd :cpp)|) > INFILE

# run the clp compiler
((|$/Tool/clp/clp.exe|) INFILE || echo 'CLP compiler failed') >ERRORS 2>&1
if test -s ERRORS
then
	echo '(''|(|$/Tool/clp/clp.err|):std_err:' > (|>ERROR|)
	echo '(''|(|<(:clp.cmpd :cpp)|):cpp_err:' >> (|>ERROR|)
	sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' ERRORS >>(|>ERROR|)
	echo '|'')' >> (|>ERROR|)
	echo '|'')' >> (|>ERROR|)
	exit 0
fi

# generated components
mv clp.c (|>clp_gen|)
mv clp.h (|>clp_gen|)

# library components
cp (|$/Tool/clp/lib/clp.head|) (|>clp_gen|)
cp (|$/Tool/clp/lib/clpintf.c|) (|>clp_gen|)
cp (|$/Tool/clp/lib/clplib.c|) (|>clp_gen|)
cp (|$/Tool/clp/lib/clplib.pdl|) (|>clp_gen|)
cp (|$/Tool/clp/lib/clplib.h|) (|>clp_gen|)
cp (|$/Tool/clp/lib/lists.h|) (|>clp_gen|)
