/* $Id: lextbl.h,v 1.4 1991/07/01 21:37:01 tony Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef lextbl_DEF
#define lextbl_DEF

        /* Initial token classification table */

char chtbl[128] = {
        EOPT,   /* NUL */
        NULT,   /* SOH */
        NULT,   /* STX */
        NULT,   /* ETX */
        NULT,   /* EOT */
        NULT,   /* ENQ */
        NULT,   /* ACK */
        NULT,   /* BEL */
        NULT,   /* BS */
        NULT,   /* HT */
        NULT,   /* LF */
        NULT,   /* VT */
        NULT,   /* FF */
        NULT,   /* CR */
        NULT,   /* SO */
        NULT,   /* SI */

        NULT,   /* DLE */
        NULT,   /* DC1 */
        NULT,   /* DC2 */
        NULT,   /* DC3 */
        NULT,   /* DC4 */
        NULT,   /* NAK */
        NULT,   /* SYN */
        NULT,   /* ETB */
        NULT,   /* CAN */
        NULT,   /* EM */
        NULT,   /* SUB */
        NULT,   /* ESC */
        NULT,   /* FS */
        NULT,   /* GS */
        NULT,   /* RS */
        NULT,   /* US */

        NULT,   /* SP */
        NULT,   /* ! */
        NULT,   /* " */
        NULT,   /* # */
        DOLT,   /* $ */
        CMNT,   /* % */
        AMPT,   /* & */
        LITT,   /* ' */
        LPNT,   /* ( */
        RPNT,   /* ) */
        ASTT,   /* * */
        PLST,   /* + */
        NULT,   /* , */
        NULT,   /* - */
        DOTT,   /* . */
        SLHT,   /* / */

        NULT,   /* 0 */
        NULT,   /* 1 */
        NULT,   /* 2 */
        NULT,   /* 3 */
        NULT,   /* 4 */
        NULT,   /* 5 */
        NULT,   /* 6 */
        NULT,   /* 7 */
        NULT,   /* 8 */
        NULT,   /* 9 */
        CLNT,   /* : */
        DOTT,   /* ; */			    /* YACC uses ';' instead of '.' */
        LSST,   /* < */
        NULT,   /* = */
        GTRT,   /* > */
        NULT,   /* ? */

        ATT,    /* @ */
        IDNT,   /* A */
        IDNT,   /* B */
        IDNT,   /* C */
        IDNT,   /* D */
        IDNT,   /* E */
        IDNT,   /* F */
        IDNT,   /* G */
        IDNT,   /* H */
        IDNT,   /* I */
        IDNT,   /* J */
        IDNT,   /* K */
        IDNT,   /* L */
        IDNT,   /* M */
        IDNT,   /* N */
        IDNT,   /* O */

        IDNT,   /* P */
        IDNT,   /* Q */
        IDNT,   /* R */
        IDNT,   /* S */
        IDNT,   /* T */
        IDNT,   /* U */
        IDNT,   /* V */
        IDNT,   /* W */
        IDNT,   /* X */
        IDNT,   /* Y */
        IDNT,   /* Z */
        LBKT,   /* [ */
        NULT,   /* \ */
        RBKT,   /* ] */
        NULT,   /* ^ */
        NULT,   /* _ */

        NULT,   /* ` */
        IDNT,   /* a */
        IDNT,   /* b */
        IDNT,   /* c */
        IDNT,   /* d */
        IDNT,   /* e */
        IDNT,   /* f */
        IDNT,   /* g */
        IDNT,   /* h */
        IDNT,   /* i */
        IDNT,   /* j */
        IDNT,   /* k */
        IDNT,   /* l */
        IDNT,   /* m */
        IDNT,   /* n */
        IDNT,   /* o */

        IDNT,   /* p */
        IDNT,   /* q */
        IDNT,   /* r */
        IDNT,   /* s */
        IDNT,   /* t */
        IDNT,   /* u */
        IDNT,   /* v */
        IDNT,   /* w */
        IDNT,   /* x */
        IDNT,   /* y */
        IDNT,   /* z */
        LBKT,   /* { */
        BART,   /* | */
        RBKT,   /* } */
        NULT,   /* ~ */
        NULT};  /* DEL */



/*      Characters that can continue tokens
 *      HLTM - Does not continue this token
 *      CMTM - Continues a comment
 *      LITM - Continues a literal
 *      IDNM - Continues an identifier
 *      OCTM - Continues an octal number
 *      DECM - Continues a decimal number
 *      HEXM - Continues a hexadecimal number
 */

#define HLTM 0
#define CMTM 0x1
#define LITM 0x2
#define IDNM 0x4
#define OCTM 0x8
#define DECM 0x10
#define HEXM 0x20

char sctb[128] = {
        HLTM | HLTM | HLTM | HLTM | HLTM | HLTM,        /* NUL */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* SOH */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* STX */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ETX */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* EOT */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ENQ */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ACK */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* BEL */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* BS */
        HLTM | HLTM | HLTM | HLTM | HLTM | HLTM,        /* HT */
        HLTM | HLTM | HLTM | HLTM | HLTM | HLTM,        /* LF */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* VT */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* FF */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* CR */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* SO */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* SI */

        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* DLE */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* DC1 */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* DC2 */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* DC3 */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* DC4 */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* NAK */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* SYN */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ETB */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* CAN */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* EM */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* SUB */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ESC */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* FS */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* GS */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* RS */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* US */

        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* SP */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ! */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* " */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* # */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* $ */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* % */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* & */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ' */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ( */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ) */
        LITM | HLTM | HLTM | HLTM | HLTM | HLTM,        /* * */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* + */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* , */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* - */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* . */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* / */

        LITM | IDNM | HEXM | DECM | OCTM | CMTM,        /* 0 */
        LITM | IDNM | HEXM | DECM | OCTM | CMTM,        /* 1 */
        LITM | IDNM | HEXM | DECM | OCTM | CMTM,        /* 2 */
        LITM | IDNM | HEXM | DECM | OCTM | CMTM,        /* 3 */
        LITM | IDNM | HEXM | DECM | OCTM | CMTM,        /* 4 */
        LITM | IDNM | HEXM | DECM | OCTM | CMTM,        /* 5 */
        LITM | IDNM | HEXM | DECM | OCTM | CMTM,        /* 6 */
        LITM | IDNM | HEXM | DECM | OCTM | CMTM,        /* 7 */
        LITM | IDNM | HEXM | DECM | HLTM | CMTM,        /* 8 */
        LITM | IDNM | HEXM | DECM | HLTM | CMTM,        /* 9 */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* : */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ; */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* < */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* = */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* > */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ? */

        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* @ */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* A */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* B */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* C */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* D */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* E */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* F */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* G */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* H */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* I */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* J */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* K */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* L */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* M */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* N */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* O */

        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* P */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* Q */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* R */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* S */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* T */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* U */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* V */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* W */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* X */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* Y */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* Z */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* [ */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* \ */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ] */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ^ */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* _ */

        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ` */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* a */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* b */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* c */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* d */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* e */
        LITM | IDNM | HEXM | HLTM | HLTM | CMTM,        /* f */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* g */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* h */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* i */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* j */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* k */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* l */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* m */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* n */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* o */

        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* p */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* q */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* r */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* s */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* t */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* u */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* v */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* w */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* x */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* y */
        LITM | IDNM | HLTM | HLTM | HLTM | CMTM,        /* z */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* { */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* | */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* } */
        LITM | HLTM | HLTM | HLTM | HLTM | CMTM,        /* ~ */
        HLTM | HLTM | HLTM | HLTM | HLTM | CMTM};       /* DEL */

        /* Operations to set up table access */

/*#define TABLE REGISTER char *scantbl = sctb;*/
#define TABLE char *scantbl = sctb;
        /* Operations to test character set memebership */

#define CMT(c) (scantbl[c] & CMTM)
#define IDN(c) (scantbl[c] & IDNM)
#define LIT(c) (scantbl[c] & LITM)
#define DEC(c) (scantbl[c] & DECM)
#define OCT(c) (scantbl[c] & OCTM)
#define HEX(c) (scantbl[c] & HEXM)

        /* Operations to modify character set membership */

#define NOTLIT(c) (scantbl[c] &= ~LITM)
#define INLIT(c)  (scantbl[c] |= LITM)



#endif /* ! lextbl_DEF */
