static char RCSid[] = "$Id: cagt_usr.c,v 1.18 1992/11/15 06:30:38 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

/*   The cagt_usr module implements the top-level user interface to CAGT.
 *
 *   Different (machine-specific) user interface modules may be implemented
 *   on top of the basic tool by rewriting those modules prefixed with 
 *   "cagt_usr_" while maintaining the interface specified by the associated
 *   header files. All cagt_usr_ modules must be consistent in the treatment
 *   of user-tool interaction.
 */

#include <stdio.h>
#include <curses.h>
#include <signal.h>


#include "cagt_config.h"
#include "support.h"
#include "gram.h"
#include "cagt.h"
#include "cagt_usr.h"
#include "cagt_usr_err.h"
#include "io_curses.h"
#include "op_chain.h"
#include "op_simcomb.h"
#include "op_misc.h"


/*
 * Every cagt user interface module exports this variable. cagt is
 * only linked with one such interface at a time, and this variable
 * represents the callable interface from cagt.
 */
public CAGT_USR_IF cagt_interface = { usr_init_forward,
				      usr_forward_loop, usr_shutdown };



/* the following routines are private to usr_forward_loop */

/* sigint_handler - handle SIGINT signal */
public void sigint_handler(sig)
	int	sig;
{
    /* Shut down curses */
    (void) usr_shutdown();
    (void) fprintf(stderr,"\n");		/* Force cursor to column 1 */
    cagt_msg(0, MSG_EXIT, (cagt_msg_text, msg_arr[-(CAGT_SIGINT)], sig));
}







/* routines exported by cagt_usr */

/* usr_init_forward - User interface dependent init for cagt_forward */
public int usr_init_forward()
{
    /* Start up curses */
    (void) initscr();
    (void) signal(SIGINT,sigint_handler);
#ifndef VAX11C
#ifndef lint    /* lint complains about stty, but I can't change the macros */
    (void) noecho();
    (void) nl();
    (void) crmode();
#endif
#endif
    /*
     * This variable is defined in io_curses:
     * Set it's length at runtime so that lines don't overlap margin
    */
    LINE[COLS] = '\0';
    return(0);

}			/* usr_init_forward */


/* usr_forward_loop - cagt_forward main loop and user interface */
public int usr_forward_loop()
{
  int done = FALSE;
  int completion_status = USR_SAVFWD;
  
  output_centered(stdscr,1,TRUE,"Concrete-Abstract Grammar Tool");
  mvaddstr( 2, 1,LINE);
  mvaddstr( 5,10,"1) Remove Chain Rules.");
  mvaddstr( 6,10,"2) Combine Rules That Differ In One Identifer");
  mvaddstr( 7,10,"   Or Literal.");
  mvaddstr( 8,10,"3) Change Chain Rule Settings.");
  mvaddstr( 9,10,"4) Rename Identifier(s)");
  
  mvaddstr(11,10,"5) Examine Current Grammar.");
  mvaddstr(12,10,"6) Examine Renamed Identifiers.");
  mvaddstr(13,10,"7) Output Current Grammar Listing To File");
  mvaddstr(14,10,"8) Output Current Chain Rules To Cull File");  

  mvaddstr(16,10,"9) Pause.");
  mvaddstr(17,9,"10) Exit.");
  mvaddstr(18,9,"11) Write Results And Exit.");
  mvaddstr(21, 5,">");
  
  while (!done)
    {
      move(21,6);
      clrtoeol();
      box(stdscr,'|','-');
      move(21,7);
      (void) refresh();
      switch (get_unsigned_int_response(stdscr,TRUE,FALSE,TRUE,1,11)) 
	{
	case 1:
	  process_chainrules(cagt_gram);
	  break;
	case 2:
	  combine_one_off(cagt_gram);
	  break;
	case 3:
	  change_chainrule_settings(cagt_gram);
	  break;
	case 4:
	  rename_arbitrary_identifiers(cagt_gram);
	  break;
	case 5:
	  c_output_grammar_listing(cagt_gram, "Current Grammar");
	  break;
	case 6:
	  view_symbol_eq();
	  break;
	case 7:
	  output_grammar_listing(cagt_gram);
	  break;
	case 8:
	  output_cull_file(cagt_gram);
	  break;
	case 9:
	  pause_cagt();
	  break;
	case 10:
	  mvaddstr(22,10, "Are you sure you want to exit? (y or n): ");
	  (void) refresh();
	  done = get_boolean_response(stdscr,FALSE);
	  move(22,1);
	  clrtoeol();
	  if (done) completion_status = USR_NOSAVFWD;
	  break;
	case 11:
	  done = TRUE;
	  break;
        }		/* switch */
      
    }		    /* while */
  
  return(completion_status);
  
}			/* usr_forward_loop */


/* usr_shutdown - reset user interface for operating system before exiting */
public int usr_shutdown()
{

    /* Shut down curses */
#ifndef VAX11C
#ifndef lint    /* lint complains about stty, but I can't change the macros */
    (void) nocrmode();
    (void) clear();
    (void) refresh();
#endif
#endif
    endwin();

    return(0);
 
}			/* usr_shutdown */

