# $Id: Makefile.cpp,v 1.43 1992/07/21 17:01:01 kadhim Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/cagt

COFLAGS	= -q

LIBS =	-lcurses -ltermcap -lm
HDRS =	cagt.h cagt_config.h cagt_lex.h cagt_usr.h\
	cagt_usr_err.h gram.h gram_fileio.h gram_parse.h\
	gram_rev.h gram_tools.h io_curses.h lextbl.h op_chain.h op_misc.h\
	op_simcomb.h queue.h support.h sym.h term.h token.h err.h csm.h \
	csmtbl.h source.h
DERIVED_HDRS = msg_codes.h
SRCS =	cagt.c cagt_usr.c cagt_usr_err.c\
	op_misc.c op_chain.c op_simcomb.c\
	gram_tools.c gram_fileio.c gram_rev.c queue.c\
	io_curses.c cagt_lex.c err.c sym.c csm.c source.c
DERIVED_SRCS = msg_arr.c y.tab.c
OBJS =	cagt.o cagt_usr.o cagt_usr_err.o msg_arr.o\
	op_misc.o op_chain.o op_simcomb.o\
	y.tab.o gram_tools.o gram_fileio.o gram_rev.o queue.o\
	io_curses.o cagt_lex.o sym.o err.o csm.o source.o
EXTRA = gram_parse.y cagt.msg mkmsg.awk
HELP  = specs_help_1 specs_help_2
AUX   = cagt.dg
CMD   = cagtf.cmd cagt_gen.cmd cagt_out.cmd cagtf_out.cmd

TIDY	= *.o core a.out lintmsg ERRS MAKEFILE.OLD \
	$(DERIVED_HDRS) $(DERIVED_SRCS)
CLEAN	= $(TIDY) *.dvi *.ps cagt.exe
CLOBBER	= $(CLEAN) Makefile

all:	$(HELP) $(AUX) $(CMD) ../../bin/cagt
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/cagt; \
		rm -f $(DESTDIR)/Tool/cagt/$$f; \
		cp $$f $(DESTDIR)/Tool/cagt/$$f; \
		chmod 644 $(DESTDIR)/Tool/cagt/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/cagt/$$f $(DESTDIR)/Cmd/$$f; \
	done
	rm -f $(DESTDIR)/Tool/cagt/cagt.exe
	cp cagt.exe $(DESTDIR)/Tool/cagt
	chmod 755 $(DESTDIR)/Tool/cagt/cagt.exe
	@for f in $(HELP); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/cagt; \
		rm -f $(DESTDIR)/Tool/cagt/$$f; \
		cp $$f $(DESTDIR)/Tool/cagt; \
		chmod 644 $(DESTDIR)/Tool/cagt/$$f; \
		done
	rm -f $(DESTDIR)/bin/cagt
	ln $(DESTDIR)/Tool/cagt/cagt.exe $(DESTDIR)/bin/cagt

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(HDRS) $(SRCS) $(EXTRA) $(AUX)

SourceDistr: $(HDRS) $(SRCS) $(EXTRA) $(HELP) $(AUX) $(CMD)

tidy:
	rm -rf $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(SRCS) $(HDRS) $(EXTRA) $(HELP) Makefile.cpp \
		 $(AUX) $(CMD)
	rm -f $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SRCS) $(HDRS) \
		$(EXTRA) $(HELP) $(AUX) $(CMD)
	-rcs -bOriginal.1 -q Makefile.cpp $(SRCS) $(HDRS) $(EXTRA) $(HELP) \
		$(AUX) $(CMD)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SRCS) $(HDRS) $(EXTRA) $(HELP) $(AUX) \
		$(CMD)

lint:	$(SRCS) $(DERIVED_SRCS) $(HDRS)
	lint -Dlint $(SRCS) $(DERIVED_SRCS)

.PRECIOUS:	$(HELP) $(AUX) $(CMD)

co_all:
	co $(SRCS) $(HDRS) $(EXTRA)
	@echo REMEMBER, NONE OF THESE FILES ARE LOCKED!!!!!!!

../../bin/cagt:	cagt.exe
	rm -f ../../bin/cagt
	ln cagt.exe ../../bin/cagt

cagt.exe: $(OBJS)
	$(CC) $(CFLAGS) -o cagt.exe $(OBJS) $(LIBS)


# Special Dependencies
msg_codes.h msg_arr.c : cagt.msg mkmsg.awk
	awk -f mkmsg.awk cagt.msg

y.tab.c : gram_parse.y
	yacc gram_parse.y


# C file dependencies
SUPP	= support.h source.h csm.h err.h sym.h term.h token.h cagt_lex.h

cagt.o:	$(SUPP) cagt.c cagt.h cagt_config.h cagt_usr.h \
         cagt_usr_err.h gram.h gram_fileio.h gram_parse.h \
         gram_rev.h gram_tools.h msg_codes.h queue.h

cagt_lex.o:	$(SUPP) cagt_config.h cagt_lex.c cagt_lex.h \
             cagt_usr_err.h gram.h gram_fileio.h gram_parse.h \
             gram_rev.h gram_tools.h lextbl.h msg_codes.h queue.h

cagt_usr.o:	$(SUPP) cagt.h cagt_config.h cagt_lex.h \
             cagt_usr.c cagt_usr.h cagt_usr_err.h gram.h gram_fileio.h \
             gram_parse.h gram_rev.h gram_tools.h io_curses.h msg_codes.h \
             op_chain.h op_misc.h op_simcomb.h queue.h

cagt_usr_err.o:	$(SUPP) cagt.h cagt_config.h \
                 cagt_lex.h cagt_usr.h \
                 cagt_usr_err.c cagt_usr_err.h \
                 gram.h gram_fileio.h gram_parse.h \
                 gram_rev.h gram_tools.h msg_codes.h queue.h

gram_fileio.o:	$(SUPP) cagt.h cagt_config.h cagt_lex.h \
                cagt_usr_err.h gram.h \
                gram_fileio.c gram_fileio.h gram_parse.h \
                gram_rev.h gram_tools.h msg_codes.h queue.h

gram_rev.o:	$(SUPP) cagt_config.h cagt_lex.h \
             cagt_usr_err.h gram.h gram_fileio.h \
             gram_parse.h gram_rev.c gram_rev.h \
             gram_tools.h msg_codes.h queue.h

gram_tools.o:	$(SUPP) cagt_config.h cagt_lex.h \
               cagt_usr_err.h gram.h gram_fileio.h \
               gram_parse.h gram_rev.h \
               gram_tools.c gram_tools.h msg_codes.h queue.h

io_curses.o:	$(SUPP) cagt_config.h cagt_lex.h \
              cagt_usr_err.h gram.h gram_fileio.h \
              gram_parse.h gram_rev.h \
              gram_tools.h io_curses.c io_curses.h msg_codes.h queue.h

msg_arr.o : msg_arr.c

op_chain.o:	$(SUPP) cagt_config.h cagt_lex.h \
             cagt_usr_err.h gram.h gram_fileio.h \
             gram_parse.h gram_rev.h \
             gram_tools.h io_curses.h \
             msg_codes.h op_chain.c queue.h

op_misc.o:	$(SUPP) cagt_config.h cagt_lex.h \
            cagt_usr_err.h gram.h gram_fileio.h \
            gram_parse.h gram_rev.h \
            gram_tools.h io_curses.h \
            msg_codes.h op_misc.c queue.h

op_simcomb.o:	$(SUPP) cagt_config.h cagt_lex.h \
               cagt_usr_err.h gram.h gram_fileio.h \
               gram_parse.h gram_rev.h \
               gram_tools.h io_curses.h \
               msg_codes.h op_simcomb.c queue.h

queue.o : cagt_config.h cagt_usr_err.h msg_codes.h \
          queue.c queue.h

sym.o:	$(SUPP) cagt_config.h cagt_lex.h \
        cagt_usr_err.h msg_codes.h queue.h

y.tab.o:	$(SUPP) cagt.h cagt_config.h cagt_lex.h \
          cagt_usr_err.h gram.h \
          gram_fileio.h gram_parse.h gram_rev.h \
          gram_tools.h msg_codes.h queue.h y.tab.c

csm.o:	csm.c csm.h err.h csmtbl.h

err.o: err.h source.h

source.o: source.h
