/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/ParseKind_.h"
#include "inc/Str.h"
#include "inc/TokTyp_.h"


int		TokNum = -1;

tps_Str		ParseBuf;
tp_Str		ParseStr;


tp_Nod
Parse(ParseKind, Str)
   tp_ParseKind ParseKind;
   tp_Str Str;
{
   if (Str == ERROR) return ERROR;
   switch (ParseKind) {
      case CMD_PARSE: {
	 (void)strcpy(ParseBuf, "C");
	 break;}/*case*/;
      case FILE_PARSE: {
	 (void)strcpy(ParseBuf, "F");
	 break;}/*case*/;
      case MACRO_PARSE: {
	 (void)strcpy(ParseBuf, "M");
	 break;}/*case*/;
      default: {
	 FatalError("bad parse kind"); };}/*switch*/;
   (void)strcat(ParseBuf, Str);
   ParseStr = ParseBuf;

   return Parser();
   }/*Parse*/;


ParseError(Str)
   tp_Str Str;
{
   Increment_Errors();
   SystemError(SystemErrorFD(), "%s at", Str);
   if (Line_Number() > 1) SystemError(SystemErrorFD(), " line %d,", Line_Number());
   SystemError(SystemErrorFD(), " token %d.\n", Token_Number());
   }/*ParseError*/;


Init_Lex()
{
   TokNum = -1;
   }/*Init_Lex*/;


EndLex()
{
   SystemError(SystemErrorFD(), "Unexpected call to EndLex");
   }/*EndLex*/;


yylex()
{
   char InitChr, Chr;
   tps_Str Str;
   int iStr;
   tp_Sym Sym;

   if (TokNum == -1) {
      TokNum = 0;
      InitChr = *ParseStr;
      ParseStr += 1;
      switch (InitChr) {
	 case 0: {
	    ParseStr -= 1;
	    break;}/*case*/;
	 case 'C': {
	    return CMDFLG;
	    break;}/*case*/;
	 case 'F': {
	    return FILFLG;
	    break;}/*case*/;
	 case 'M': {
	    return MACFLG;
	    break;}/*case*/;
	 default: {
	    FatalError("bad parse flag");
	    };}/*switch*/; }/*if*/;
   TokNum += 1;
   while (TRUE) {
      Chr = *ParseStr;
      ParseStr += 1;
      switch (Chr) {
	 case 0: {
	    ParseStr -= 1; /* in case yylex is called again */
	    return EOFTOK;
	    break;}/*case*/;
	 case ' ': case '\t': {
	    break;}/*case*/;
	 case '\\': {
	    if (*ParseStr != '\n') {
	       ScanError("\\ should be followed by <CR>");
	       ParseStr -= 1; }/*if*/;
	    ParseStr += 1;
	    break;}/*case*/;
	 case '#': {
	    while (*ParseStr != 0 && *ParseStr != '\n') ParseStr += 1;
	    if (*ParseStr == '\n') ParseStr += 1;
	    break;}/*case*/;
         case '?': {
	    return QUESMK;
	    break;}/*case*/;
         case '!': {
	    return EXCLPT;
	    break;}/*case*/;
         case '|': {
	    return VRTBAR;
	    break;}/*case*/;
         case '>': {
	    return RTANGL;
	    break;}/*case*/;
         case '<': {
	    return LFANGL;
	    break;}/*case*/;
         case '(': {
	    return LPAREN;
	    break;}/*case*/;
         case ')': {
	    return RPAREN;
	    break;}/*case*/;
         case ':': {
	    return COLON;
	    break;}/*case*/;
         case '=': {
	    return EQUALS;
	    break;}/*case*/;
         case '/': {
	    return SLASH;
	    break;}/*case*/;
         case '+': {
	    return PLUS;
	    break;}/*case*/;
/* allow "words" to have \'ed characters in them (i.e. to put operators in
   filenames */
	 case '\'': {
	    iStr = 0;
	    while (*ParseStr != '\'' && *ParseStr != 0) {
	       if (*ParseStr == '\\') {
		  ParseStr += 1;
		  if (*ParseStr == 0) {
		     ScanError("Unterminated string");
		     return ERRTOK; }/*if*/; }/*if*/;
	       Str[iStr] = *ParseStr; iStr += 1;
	       ParseStr += 1; }/*while*/;
	    if (*ParseStr == 0) {
	       ScanError("Unterminated string");
	       return ERRTOK; }/*if*/;
	    ParseStr += 1;
	    Str[iStr] = 0;
	    Sym = Str_Sym(Str);
	    Push_SymStack(Sym);
	    return WORDTK;
	    break;}/*case*/;
         case '%': {
	    iStr = 0;
	    while (*ParseStr != 0) {
	       Str[iStr] = *ParseStr; iStr += 1;
	       ParseStr += 1; }/*while*/;
	    Str[iStr] = 0;
	    Sym = Str_Sym(Str);
	    Push_SymStack(Sym);
	    return HOSTWD;
	    break;}/*case*/;
	 default: {
	    iStr = 0;
	    Str[iStr] = Chr; iStr += 1;
	    while (IsWordChr(*ParseStr)) {
	       Str[iStr] = *ParseStr; iStr += 1;
	       ParseStr += 1; }/*while*/;
	    Str[iStr] = 0;
	    Sym = Str_Sym(Str);
	    Push_SymStack(Sym);
	    return WORDTK; };}/*switch*/; }/*while*/;
   }/*yylex*/;


/*private*/ boolean
IsWordChr(Chr)
   char Chr;
{
   switch (Chr) {
      case '\0': case ' ': case '\t': case '\\': case '#': case '?':
      case '!': case '|': case '>': case '<': case '(': case ')':
      case ':': case '=': case '/': case '+': case '\'': case '%': {
	 return FALSE;
	 break;}/*case*/;
      default: {
	 return TRUE; };}/*switch*/;
/* NOTREACHED */
   }/*IsWordChr*/;


int
Line_Number()
{
   return 1;
   }/*Line_Number*/;


int
Token_Number()
{
   return TokNum;
   }/*Token_Number*/;


ScanError(Str)
   tp_Str Str;
{
   Increment_Warnings();
   SystemError(SystemErrorFD(), "%s at token %d\n", Str, TokNum);
   }/*ScanError*/;


