/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <ctype.h>
#include "inc/GMC.h"
#include "inc/Sym.h"


#define		MAX_HashedSyms 512
tp_Sym		HashedSyms [MAX_HashedSyms];

int		num_Syms = 0;


tp_Str
Tail(Str)
   tp_Str Str;
{
   return &Str[strlen(Str)];
   }/*Tail*/;


boolean
Is_SubWord(SearchStr, Str)
   tp_Str SearchStr, Str;
{
   int Length, i;

   Length = strlen(SearchStr);
   i = 0;
   while (Str[i] != 0) {
      while (Str[i] != 0 && !isalnum(Str[i])) i += 1;
      if (strncmp(SearchStr, &Str[i], Length) == 0) {
	 return TRUE; }/*if*/;
      while (isalnum(Str[i])) i += 1;
      }/*while*/;
   return FALSE;
   }/*Is_SubWord*/;


/*private*/ int
Str_HashInt(Str)
   tp_Str Str;
{
   int Length, HashInt;

   Length = strlen(Str);
   if (Length == 0) return 0;
   HashInt
      = (int)Str[0] + (int)Str[Length/2] + (int)Str[Length-1] + (Length << 5);
   return HashInt;
   }/*Str_HashInt*/;


tp_Sym
Str_Sym(Str)
   tp_Str Str;
{
   int HashInt;
   tp_Sym Sym;

   if (Str == ERROR) return ERROR;
   HashInt = Str_HashInt(Str) % MAX_HashedSyms;
   Sym = HashedSyms[HashInt];
   while (Sym != 0) {
      if (strcmp(Str, Sym->Str) == 0) {
         return Sym; }/*if*/;
      Sym = Sym->Next; }/*while*/;
   Sym = (tp_Sym)malloc(sizeof(tps_Sym));
   num_Syms += 1;
   Sym->Str = malloc((unsigned)strlen(Str) + 1);
   (void)strcpy(Sym->Str, Str);
   Sym->Att = 0;
   Sym->Next = HashedSyms[HashInt];
   HashedSyms[HashInt] = Sym;
   return Sym;
   }/*Str_Sym*/;


tp_Str
Sym_Str(Sym)
   tp_Sym Sym;
{
   if (Sym == ERROR) return ERROR;
   return Sym->Str;
   }/*Sym_Str*/;


tp_Att
Sym_Att(Sym)
   tp_Sym Sym;
{
   FORBIDDEN(Sym == ERROR);
   return Sym->Att;
   }/*Sym_Att*/;


Set_Sym_Att(Sym, Att)
   tp_Sym Sym;
   tp_Att Att;
{
   FORBIDDEN(Sym == ERROR);
   Sym->Att = Att;
   }/*Set_Sym_Att*/;


Write_Syms(FilDsc)
   tp_FilDsc FilDsc;
{
   int i, Used=0;
   tp_Sym Sym;

   for (i=0; i<MAX_HashedSyms; i++) {
      Sym = HashedSyms[i];
      if (Sym != 0) {
	 Used += 1;
	 WriteInt(FilDsc, i);
	 while (Sym != 0) {
	    Write(FilDsc, "\t: "); Writeln(FilDsc, Sym->Str);
	    Sym = Sym->Next; }/*while*/; }/*if*/; }/*for*/;
   if (Used > 0) {
      WriteInt(FilDsc, (int)(num_Syms/Used)); Writeln(FilDsc, ""); }/*if*/;
   }/*Write_Syms*/;

