/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Flag_.h"
#include "inc/InpKind_.h"
#include "inc/ModKind_.h"
#include "inc/Signal_.h"
#include "inc/Status_.h"
#include "inc/Str.h"


tp_FilHdr		SentinelFilHdr;


Init_Sentinel()
{
   tps_FileName SentinelFileName;
   tp_Signal Signal;

   Get_SentinelFileName(SentinelFileName);
   SentinelFilHdr = HostFN_FilHdr(SentinelFileName);
   SentinelFilHdr = Do_Deriv(SentinelFilHdr, DfltPrms, DfltPrms, CompoundFilTyp);
   FORBIDDEN(SentinelFilHdr == ERROR);
   Update_Sentinel(&Signal);
   }/*Init_Sentinel*/;


Update_Sentinel(SignalPtr)
   tp_Signal *SignalPtr;
{
   GetAllReqs(SignalPtr, SentinelFilHdr);
   }/*Update_Sentinel*/;


/*private*/ boolean
IsSignificant(ModKind, InpKind, LinkFlag)
   tp_ModKind ModKind;
   tp_InpKind InpKind;
   boolean LinkFlag;
{
   switch (InpKind) {
      case IK_Name: {
	 return FALSE; break;}/*case*/;
      case IK_Simple: case IK_ErrOK: case IK_Pntr: {
	 return ((ModKind >= MODKIND_Input)
		 || (LinkFlag && ModKind >= MODKIND_Elm)); break;}/*case*/;
      case IK_Trans: case IK_AnyOK: {
	 return TRUE; break;}/*case*/;
      case IK_TransName: {
	 return (ModKind >= MODKIND_ElmName); break;}/*case*/;
      default: {
	 FatalError("unknown InpKind"); };}/*switch*/;
   /* NOTREACHED */
   }/*IsSignificant*/;


Broadcast(FilHdr)
   tp_FilHdr FilHdr;
{
   Broadcast_Mod(FilHdr, MODKIND_Input);
   }/*Broadcast*/;


Broadcast_Mod(FilHdr, ModKind)
   tp_FilHdr FilHdr;
   tp_ModKind ModKind;
{
   boolean LinkFlag;
   tp_FilHdr OutFilHdr, CmpdFilHdr;
   tp_LocInp LocInpLink, FirstInpLink;
   tp_LocElm LocElmLink, FirstElmLink;
   tp_FilInp FilInpLink;
   tp_FilElm FilElmLink;

   LinkFlag = IsLink(FilHdr);
   FirstInpLink = 0;
   LocInpLink = FilHdr_InpLink(FilHdr);
   while (LocInpLink != FirstInpLink) {
      if (FirstInpLink == 0) FirstInpLink = LocInpLink;
      FilInpLink = LocInp_FilInp(LocInpLink);
      if (IsSignificant(ModKind, FilInp_InpKind(FilInpLink), LinkFlag)) {
	 OutFilHdr = LocHdr_FilHdr(FilInp_OutLocHdr(FilInpLink));
	 if (FilHdr_Status(OutFilHdr) != STAT_Unknown) {
	    Set_Status(OutFilHdr, STAT_Unknown);
	    if (LogLevel >= 6) Do_Log("Clearing Status of", OutFilHdr);
	    Broadcast_Mod(OutFilHdr, MODKIND_Input); }/*if*/;
	 Ret_FilHdr(OutFilHdr); }/*if*/;
      LocInpLink = FilInp_Link(FilInpLink);
      Ret_FilInp(FilInpLink); }/*while*/;

   if (ModKind == MODKIND_Input) {
      ModKind = (IsRef(FilHdr) ? MODKIND_ElmName : MODKIND_Elm); }/*if*/;
   
   FirstElmLink = 0;
   LocElmLink = FilHdr_ElmLink(FilHdr);
   while (LocElmLink != FirstElmLink) {
      if (FirstElmLink == 0) FirstElmLink = LocElmLink;
      FilElmLink = LocElm_FilElm(LocElmLink);
      CmpdFilHdr = FilElm_CmpdFilHdr(FilElmLink);
      switch (ModKind) {
	 case MODKIND_ElmName: {
	    if (FilHdr_ElmNameStatus(CmpdFilHdr) != STAT_Unknown) {
	       Set_ElmNameStatus(CmpdFilHdr, STAT_Unknown);
	       if (LogLevel >= 6) {
		  Do_Log("Clearing Element-Name Status of", CmpdFilHdr);
		  }/*if*/;
	       Broadcast_Mod(CmpdFilHdr, ModKind); }/*if*/; break;}/*case*/;
	 case MODKIND_Elm: {
	    if (FilHdr_ElmStatus(CmpdFilHdr) != STAT_Unknown) {
	       Set_ElmStatus(CmpdFilHdr, STAT_Unknown);
	       if (LogLevel >= 6) {
		  Do_Log("Clearing Element Status of", CmpdFilHdr);
		  }/*if*/;
	       Broadcast_Mod(CmpdFilHdr, ModKind); }/*if*/; break;}/*case*/;
	    default: {
	       FatalError("unexpected ModKind"); };}/*switch*/;
      Ret_FilHdr(CmpdFilHdr);
      LocElmLink = FilElm_Link(FilElmLink);
      Ret_FilElm(FilElmLink); }/*while*/;
   }/*Broadcast_Mod*/;


tp_LocElm
FilHdr_SentinelLocElm(FilHdr, CmpdFilHdr)
   tp_FilHdr FilHdr;
   tp_FilHdr CmpdFilHdr;
{
   tp_LocHdr LocHdr;
   tp_LocElm FirstLocElm, LastLocElm;
   boolean IsSentinel;

   LocHdr = FilHdr_LocHdr(FilHdr);
   FirstLocElm = 0; LastLocElm = 0;
   Do_Sentinel(&FirstLocElm, &LastLocElm, &IsSentinel, LocHdr, CmpdFilHdr);
   Clr_CmpdOutFlags(LocHdr);
   return FirstLocElm;
   }/*FilHdr_SentinelLocElm*/;


Do_Sentinel(FirstLocElmPtr, LastLocElmPtr, IsSentinelPtr, LocHdr, CmpdFilHdr)
   tp_LocElm *FirstLocElmPtr, *LastLocElmPtr;
   boolean *IsSentinelPtr;
   tp_LocHdr LocHdr;
   tp_FilHdr CmpdFilHdr;
{
   tp_FilHdr FilHdr;
   boolean IsSentinel;
   tp_LocElm NewLocElm;
   tp_LocHdr OutLocHdr, CmpdLocHdr;
   tp_LocInp LocInpLink, FirstInpLink, NxtLocInpLink;
   tp_LocElm LocElmLink, FirstElmLink, NxtLocElmLink;
   tp_FilInp FilInpLink;
   tp_FilElm FilElmLink;

   *IsSentinelPtr = FALSE;

   FilHdr = LocHdr_FilHdr(LocHdr);
   if (FilHdr_Flag(FilHdr, FLAG_Sentinel)) {
      Ret_FilHdr(FilHdr);
      return; }/*if*/;
   if (FilHdr == SentinelFilHdr) {
      *IsSentinelPtr = TRUE;
      Ret_FilHdr(FilHdr);
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_Sentinel);
   LocInpLink = FilHdr_InpLink(FilHdr);
   LocElmLink = FilHdr_ElmLink(FilHdr);
   Ret_FilHdr(FilHdr);

   FirstInpLink = LocInpLink;
   NxtLocInpLink = 0;
   while (NxtLocInpLink != FirstInpLink) {
      FilInpLink = LocInp_FilInp(LocInpLink);
      OutLocHdr = FilInp_OutLocHdr(FilInpLink);
      NxtLocInpLink = FilInp_Link(FilInpLink);
      Ret_FilInp(FilInpLink);
      Do_Sentinel
       (FirstLocElmPtr, LastLocElmPtr, &IsSentinel, OutLocHdr, CmpdFilHdr);
      LocInpLink = NxtLocInpLink; }/*while*/;

   FirstElmLink = LocElmLink;
   NxtLocElmLink = 0;
   while (NxtLocElmLink != FirstElmLink) {
      FilElmLink = LocElm_FilElm(LocElmLink);
      CmpdLocHdr = FilElm_CmpdLocHdr(FilElmLink);
      NxtLocElmLink = FilElm_Link(FilElmLink);
      Ret_FilElm(FilElmLink);
      Do_Sentinel
       (FirstLocElmPtr, LastLocElmPtr, &IsSentinel, CmpdLocHdr, CmpdFilHdr);
      if (IsSentinel) {
	 FilHdr = LocHdr_FilHdr(LocHdr);
	 /*select*/{
	    if (IsCompound(FilHdr)) {
	       Clr_Flag(FilHdr, FLAG_Sentinel);
	       *IsSentinelPtr = TRUE;
	    }else{
	       NewLocElm = Make_LocElm(FilHdr, DfltPrms, CmpdFilHdr);
	       Chain_LocElms(FirstLocElmPtr, LastLocElmPtr, NewLocElm);
	       };}/*select*/;
	 Ret_FilHdr(FilHdr); }/*if*/;
      LocElmLink = NxtLocElmLink; }/*while*/;
   }/*Do_Sentinel*/;


Clr_CmpdOutFlags(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   tp_LocHdr OutLocHdr, CmpdLocHdr;
   tp_LocInp LocInpLink, FirstInpLink;
   tp_LocElm LocElmLink, FirstElmLink;
   tp_FilInp FilInpLink;
   tp_FilElm FilElmLink;

   FilHdr = LocHdr_FilHdr(LocHdr);
   if (!FilHdr_Flag(FilHdr, FLAG_Sentinel)) {
      Ret_FilHdr(FilHdr);
      return; }/*if*/;
   Clr_Flag(FilHdr, FLAG_Sentinel);

   FirstInpLink = 0;
   LocInpLink = FilHdr_InpLink(FilHdr);
   while (LocInpLink != FirstInpLink) {
      FilInpLink = LocInp_FilInp(LocInpLink);
      OutLocHdr = FilInp_OutLocHdr(FilInpLink);
      Clr_CmpdOutFlags(OutLocHdr);
      LocInpLink = FilInp_Link(FilInpLink);
      Ret_FilInp(FilInpLink); }/*while*/;
   FirstElmLink = 0;
   LocElmLink = FilHdr_ElmLink(FilHdr);
   while (LocElmLink != FirstElmLink) {
      FilElmLink = LocElm_FilElm(LocElmLink);
      CmpdLocHdr = FilElm_CmpdLocHdr(FilElmLink);
      Clr_CmpdOutFlags(CmpdLocHdr);
      LocElmLink = FilElm_Link(FilElmLink);
      Ret_FilElm(FilElmLink); }/*while*/;
   Ret_FilHdr(FilHdr);
   }/*Clr_CmpdOutFlags*/;


