/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Str.h"
#include "inc/Filename.h"
#include "inc/RunSpc.h"
#include "inc/Signal_.h"
#include "inc/Status_.h"


Run(SignalPtr, RunSpc, DepStatus, IsRestore)
   tp_Signal *SignalPtr;
   tp_RunSpc RunSpc;
   tp_Status DepStatus;
   boolean IsRestore;
{
   tp_FilHdr InpFilHdr;
   tp_FilTyp FilTyp;
   tps_OutTyps OutTyps;
   tp_Tool Tool;
   tp_PrmFTLst PrmFTLst;
   int i;
   tps_FileName DirName;
   tp_Status MinStatus;
   boolean Abort, Succeed;
   tp_Date Old_CurrentDate;

   FORBIDDEN(RunSpc == ERROR);
   FORBIDDEN(DepStatus <= STAT_Error);

   ClearDir(RunDirName);
   ClearDir(WorkDirName);
   for (i=0; i<RunSpc->NumOuts; i++) {
      if (IsDrvDir(RunSpc->OutFilHdrs[i])) {
	 I_WorkDirFileName(DirName, i);
	 MakeDirFile(DirName, &Abort);
	 FORBIDDEN(Abort);
	 ClearDir(DirName); }/*if*/; }/*for*/;

   FilTyp = FilHdr_FilTyp(RunSpc->FilHdr);
   GetOutTyps(FilTyp, OutTyps, &i);
   Tool = FilHdr_Tool(RunSpc->FilHdr);
   PrmFTLst = Tool_PrmFTLst(Tool);
   for (i=0; i<RunSpc->NumInps; i++) {
      RunSpc->InpUsed[i] = FALSE;
      RunSpc->InpDir[i] = FALSE; }/*for*/;

   MakeRunFile(RunSpc, Tool, PrmFTLst, OutTyps);

   for (i=0; i<RunSpc->NumInps; i++) {
      InpFilHdr = RunSpc->InpFilHdrs[i];
      if (RunSpc->InpUsed[i]) Make_ElmData(InpFilHdr);
      if (RunSpc->InpDir[i]) {
	 Get_LinkedInputDirName(DirName, i);
	 MakeDirFile(DirName, &Abort);
	 FORBIDDEN(Abort);
	 ClearDir(DirName);
	 LinkCmpdFile(DirName, InpFilHdr); }/*if*/; }/*for*/;

   if (PrmFTLst != 0) {
      MakePrmFiles(PrmFTLst, GetToolPrms(Tool, RunSpc->Prms)); }/*if*/;

   Old_CurrentDate = CurrentDate;
   Unlock_Info(SignalPtr);
   if (*SignalPtr != NIL) {
      return; }/*if*/;
   Flush_StdIO();
   Succeed = SystemExec(RunFileName);
   Lock_Info(SignalPtr);
   if (*SignalPtr != NIL) {
      return; }/*if*/;
   if (!Succeed) {
      Write(StdErrFD, "** Request Aborted : command script ");
      Write(StdErrFD, RunFileName);
      Write(StdErrFD, " failed **\n");
      *SignalPtr = SIGNAL_ScriptError;
      return; }/*if*/;

   if (IsBrowser_Tool(Tool)) {
      Finish_Browse();
      *SignalPtr = SIGNAL_Interrupt;
      return; }/*if*/;

   if (CurrentDate != Old_CurrentDate) {
      *SignalPtr = SIGNAL_DBMod;
      return; }/*if*/;

   MinStatus = Get_RunStatus(RunSpc->FilHdr);
   if (MinStatus > DepStatus) MinStatus = DepStatus;
   Do_Compound(SignalPtr, RunSpc, MinStatus, IsRestore);
   }/*Run*/;


MakeRunFile(RunSpc, Tool, PrmFTLst, OutTyps)
   tp_RunSpc RunSpc;
   tp_Tool Tool;
   tp_PrmFTLst PrmFTLst;
   tps_OutTyps OutTyps;
{
   tp_FilDsc RunFileFD, CmdFileFD;
   tp_Str Str;
   tps_Str StrBuf, CmdFileName, Expansion;

   RunFileFD = FileName_WFilDsc(RunFileName);
   FORBIDDEN(RunFileFD == ERROR);

   Get_CmdFileName(CmdFileName, FilTyp_FTName(FilHdr_FilTyp(RunSpc->FilHdr)));
   CmdFileFD = FileName_RFilDsc(CmdFileName);
   FORBIDDEN(CmdFileFD == ERROR);

   Str = Readln(StrBuf, CmdFileFD);
   while (Str != ERROR) {
      /*select*/{
	 if (Has_Macro(Str)) {
            Expand_MacroLine(Expansion, (tp_FilDsc)NIL, Str,
			     RunSpc, Tool, PrmFTLst, OutTyps);
	    Writeln(RunFileFD, Expansion);
	 }else{
	    Writeln(RunFileFD, Str); };}/*select*/;
      Str = Readln(StrBuf, CmdFileFD); }/*while*/;

   Close(CmdFileFD);
   Close(RunFileFD);
   }/*MakeRunFile*/;


/*private*/ tp_Status
Get_RunStatus(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_Status Status;
   tps_FileName WarningFileName, ErrorFileName;

   Status = STAT_OK;

   if (Has_WarningFile(FilHdr)) {
      FilHdr_WarningFileName(WarningFileName, FilHdr);
      Remove(WarningFileName); }/*if*/;
   if (Exists(WarningFN)) {
      /*select*/{
	 if (Empty(WarningFN)) {
	    Remove(WarningFN);
	 }else{
	    FilHdr_WarningFileName(WarningFileName, FilHdr);
	    Rename(WarningFN, WarningFileName);
	    MakeReadOnly(WarningFileName);
	    Status = STAT_Warning;
	    if (LogLevel >= 3) {
	       Write(LogFD, "** ");
	       Write(LogFD, FilTyp_FTName(FilHdr_FilTyp(FilHdr)));
	       Writeln(LogFD, " generated warnings");
	       }/*if*/; };}/*select*/; }/*if*/;

   if (Has_ErrorFile(FilHdr)) {
      FilHdr_ErrorFileName(ErrorFileName, FilHdr);
      Remove(ErrorFileName); }/*if*/;
   if (Exists(ErrorFN)) {
      /*select*/{
	 if (Empty(ErrorFN)) {
	    Remove(ErrorFN);
	 }else{
	    FilHdr_ErrorFileName(ErrorFileName, FilHdr);
	    Rename(ErrorFN, ErrorFileName);
	    MakeReadOnly(ErrorFileName);
	    Status = STAT_Error;
	    if (LogLevel >= 3) {
	       Write(LogFD, "** ");
	       Write(LogFD, FilTyp_FTName(FilHdr_FilTyp(FilHdr)));
	       Writeln(LogFD, " generated errors");
	       }/*if*/; };}/*select*/; }/*if*/;

   return Status;
   }/*Get_RunStatus*/;


Finish_Browse()
{
   tps_FileName FileName, StrBuf;
   tp_FilDsc InFD;
   tp_FileName HostFileName;
   tp_FilHdr HostFilHdr;
   tp_Date OldCurrentDate;
   tp_Signal Signal;

   I_WorkFileName(FileName, 0);
   InFD = FileName_RFilDsc(FileName);
   if (InFD != ERROR) {
      HostFileName = Readln(StrBuf, InFD);
      OldCurrentDate = CurrentDate;
      while (HostFileName != ERROR) {
	 HostFilHdr = DataFileName_FilHdr(HostFileName);
	 if (HostFilHdr != ERROR) {
	    if (IsSource(HostFilHdr)) {
	       Test_SrcFilHdr(&Signal, HostFilHdr,
			      (OldCurrentDate == CurrentDate)); }/*if*/;
	    Ret_FilHdr(HostFilHdr); }/*if*/;
	 HostFileName = Readln(StrBuf, InFD); }/*while*/;
      FORBIDDEN(!EndOfFile(InFD));
      Close(InFD); }/*if*/;
   }/*Finish_Browse*/;


