/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/NodTyp_.h"
#include "inc/Str.h"
#include "inc/PrmClass_.h"
#include "inc/PrmFTLst.h"
#include "inc/Prms.h"
#include "inc/InpKind_.h"


#define			MAX_HashPrmsS 512
tp_Prms			HashPrmsS [MAX_HashPrmsS];

tp_Prms			DfltPrms;
int			num_PrmsS = 0;

/*private*/ tp_Prms
New_Prms(Parm)
   tp_Parm Parm;
{
   tp_Prms Prms;

   Prms = (tp_Prms)malloc(sizeof(tps_Prms));
   num_PrmsS += 1;
   Prms->LocPrm = NIL;
   Prms->Son = NIL;
   Prms->Brother = NIL;
   Prms->Next = NIL;
   Prms->PrmFT  = IFilTyp_FilTyp(Parm->PrmInf.IPrmFT);
   Prms->Parm = *Parm;
   Prms->Parm.PrmInf.Next = NIL;
   return Prms;
   }/*New_Prms*/;


boolean
Equal_Prms(Prms1, Prms2)
   tp_Prms Prms1, Prms2;
{
   FORBIDDEN(Prms1 == ERROR || Prms2 == ERROR);
   return Prms1 == Prms2;
   }/*Equal_Prms*/;


/*private*/ tp_Prms
Add_Parm(Parm, Prms)
   tp_Parm Parm;
   tp_Prms Prms;
{
   tp_Prms NewPrms;

   NewPrms = Prms->Son;
   while (NewPrms != NIL) {
      if (Equal_Parm(Parm, &NewPrms->Parm)) {
	 return NewPrms; }/*if*/;
      NewPrms = NewPrms->Brother; }/*while*/;

   NewPrms = New_Prms(Parm);
   NewPrms->Brother = Prms->Son; Prms->Son = NewPrms;
   NewPrms->Next = Prms;
   return NewPrms;
   }/*Add_Parm*/;


/*private*/ tp_Prms
Add_FrontPrms(OldPrms, EndOldPrms, NewPrms)
   tp_Prms OldPrms, EndOldPrms, NewPrms;
{
   if (OldPrms == EndOldPrms) {
      return NewPrms; }/*if*/;
   FORBIDDEN(OldPrms == DfltPrms);
   return Add_Parm(&OldPrms->Parm,
		     Add_FrontPrms(OldPrms->Next, EndOldPrms, NewPrms));
   }/*Add_FrontPrms*/;


tp_Prms
Union_Parm(Prms, Parm)
   tp_Prms Prms;
   tp_Parm Parm;
{
   tp_Prms TmpPrms;

   if (Prms == ERROR || Parm == ERROR) return ERROR;
   TmpPrms = Prms;
   while (TmpPrms != DfltPrms
	  && TmpPrms->Parm.PrmInf.IPrmFT <= Parm->PrmInf.IPrmFT) {
      if (Equal_Parm(&TmpPrms->Parm, Parm)) {
	 return Prms; }/*if*/;
      TmpPrms = TmpPrms->Next; }/*while*/;
   return Add_FrontPrms(Prms, TmpPrms, Add_Parm(Parm, TmpPrms));
   }/*Union_Parm*/;


tp_Prms
Union_Prms(Prms1, Prms2)
   tp_Prms Prms1, Prms2;
{
   tp_Prms Prms, AddPrms;

   if (Prms1 == ERROR || Prms2 == ERROR) return ERROR;
   if (Prms1 == Prms2) {
      return Prms1; }/*if*/;
   Prms = Prms1; AddPrms = Prms2;
   while (AddPrms != DfltPrms) {
      Prms = Union_Parm(Prms, &AddPrms->Parm);
      AddPrms = AddPrms->Next; }/*while*/;
   return Prms;
   }/*Union_Prms*/;


tp_LocPrm
Prms_LocPrm(Prms)
   tp_Prms Prms;
{
   FORBIDDEN(Prms == ERROR);
   if (Prms->LocPrm == NIL) {
      Prms->LocPrm = Alloc_Parm();
      Prms->Parm.PrmInf.LocPrmVal = WriteStr(Prms->Parm.PrmVal);
      Prms->Parm.PrmInf.Next = Prms_LocPrm(Prms->Next);
      WritePrmInf(&Prms->Parm.PrmInf, Prms->LocPrm); }/*if*/;
   return Prms->LocPrm;
   }/*Prms_LocPrm*/;


/*private*/ int
LocPrm_HashVal(LocPrm)
   tp_LocPrm LocPrm;
{
   return (LocPrm / sizeof(tps_PrmInf)) % MAX_HashPrmsS;
   }/*LocPrm_HashVal*/;


/*private*/ tp_Prms
Lookup_Prms(LocPrm)
   tp_LocPrm LocPrm;
{
   tp_Prms Prms;

   Prms = HashPrmsS[LocPrm_HashVal(LocPrm)];
   while (Prms != 0) {
      if (Prms->LocPrm == LocPrm) {
	 return Prms; }/*if*/;
      Prms = Prms->NextHash; }/*while*/;
   return ERROR;
   }/*Lookup_Prms*/;


tp_Prms
LocPrm_Prms(LocPrm)
   tp_LocPrm LocPrm;
{
   tp_Prms Prms, NextPrms;
   tps_Parm _Parm; tp_Parm Parm = &_Parm;
   int HashVal;

   if (LocPrm == ERROR) return ERROR;

   if (LocPrm == DfltLocPrm) {
      return DfltPrms; }/*if*/;

   Prms = Lookup_Prms(LocPrm);
   if (Prms != ERROR) {
      return Prms; }/*if*/;

   ReadPrmInf(&Parm->PrmInf, LocPrm);
   Parm->PrmVal = ReadStr(Parm->PrmInf.LocPrmVal);
   NextPrms = LocPrm_Prms(Parm->PrmInf.Next);
   Prms = Add_Parm(Parm, NextPrms);
   if (Prms->LocPrm == NIL) {
      Prms->LocPrm = LocPrm;
      HashVal = LocPrm_HashVal(LocPrm);
      Prms->NextHash = HashPrmsS[HashVal];
      HashPrmsS[HashVal] = Prms; }/*if*/;
   return Prms;
   }/*LocPrm_Prms*/;


Chain_PrmsLocInp(FirstLocInpPtr, LastLocInpPtr, Prms, OutFilHdr)
   tp_LocInp *FirstLocInpPtr, *LastLocInpPtr;
   tp_Prms Prms;
   tp_FilHdr OutFilHdr;
{
   tp_LocInp LocInp;
   tp_Prms TmpPrms;
   tp_FilHdr FilHdr;
   tp_PrmFTLst PrmFTLst;

   FORBIDDEN(Prms == ERROR || OutFilHdr == ERROR);

   if (Prms == DfltPrms) {
      return; }/*if*/;

   PrmFTLst = Tool_PrmFTLst(FilHdr_Tool(OutFilHdr));
   TmpPrms = Prms;
   while (TmpPrms != DfltPrms) {
      if (TmpPrms->Parm.PrmInf.PrmClass == PC_File
	  && In_PrmFTLst(TmpPrms->PrmFT, PrmFTLst)) {
	 FilHdr = LocHdr_FilHdr(TmpPrms->Parm.PrmInf.LocHdr);
	 LocInp = Make_LocInp(FilHdr, IK_Trans, OutFilHdr);
	 Ret_FilHdr(FilHdr);
	 Chain_LocInps(FirstLocInpPtr, LastLocInpPtr, LocInp); }/*if*/;
      TmpPrms = TmpPrms->Next; }/*while*/;
   }/*Chain_PrmsLocInp*/;


tp_Prms
Make_TestPrms(Prms, CheckFilHdr)
   tp_Prms Prms;
   tp_FilHdr CheckFilHdr;
{
   tps_Parm _Parm; tp_Parm Parm = &_Parm;
   tp_Prms NextPrms;
   tp_FilHdr FilHdr;

   FORBIDDEN(Prms == ERROR || CheckFilHdr == ERROR);

   if (Prms == DfltPrms) {
      return Prms; }/*if*/;

   NextPrms = Make_TestPrms(Prms->Next, CheckFilHdr);
   if (Prms->Parm.PrmInf.PrmClass != PC_File) {
      if (NextPrms == Prms->Next) {
	 return Prms; }/*if*/;
      return Add_Parm(&Prms->Parm, NextPrms); }/*if*/;

   *Parm = Prms->Parm;
   Parm->PrmInf.Next = NIL;
   FilHdr = Make_TestFilHdr(LocHdr_FilHdr(Prms->Parm.PrmInf.LocHdr), CheckFilHdr);
   Parm->PrmInf.LocHdr = FilHdr_LocHdr(FilHdr);
   Ret_FilHdr(FilHdr);

   return Add_Parm(Parm, NextPrms);
   }/*Make_TestPrms*/;


Chain_PrmsLocElm(FirstLocElmPtr, LastLocElmPtr, Prms, CmpdFilHdr)
   tp_LocElm *FirstLocElmPtr, *LastLocElmPtr;
   tp_Prms Prms;
   tp_FilHdr CmpdFilHdr;
{
   tp_LocElm LocElm;
   tp_Prms TmpPrms;
   tp_FilHdr FilHdr;

   FORBIDDEN(Prms == ERROR || CmpdFilHdr == ERROR);

   if (Prms == DfltPrms) {
      return; }/*if*/;

   TmpPrms = Prms;
   while (TmpPrms != DfltPrms) {
      if (TmpPrms->Parm.PrmInf.PrmClass == PC_File) {
	 FilHdr = LocHdr_FilHdr(TmpPrms->Parm.PrmInf.LocHdr);
	 LocElm = Make_LocElm(FilHdr, DfltPrms, CmpdFilHdr);
	 Ret_FilHdr(FilHdr);
	 Chain_LocElms(FirstLocElmPtr, LastLocElmPtr, LocElm); }/*if*/;
      TmpPrms = TmpPrms->Next; }/*while*/;
   }/*Chain_PrmsLocElm*/;


tp_LocElm
Prms_LocElm(Prms, CmpdFilHdr)
   tp_Prms Prms;
   tp_FilHdr CmpdFilHdr;
{
   tp_LocElm FirstLocElm, LastLocElm;

   FirstLocElm = 0; LastLocElm = 0;
   Chain_PrmsLocElm(&FirstLocElm, &LastLocElm, Prms, CmpdFilHdr);
   return FirstLocElm;
   }/*Prms_LocElm*/;


MakePrmFiles(PrmFTLst, Prms)
   tp_PrmFTLst PrmFTLst;
   tp_Prms Prms;
{
   tp_PrmFTLst PFTLst;
   tp_Prms TmpPrms;
   tps_FileName DirName;
   boolean Abort;

   for (PFTLst=PrmFTLst; PFTLst!=NIL; PFTLst=PFTLst->Next) {
      if (FilTyp_Mark(PFTLst->PrmFT)) {
	 Get_LinkedPrmInputDirName(DirName, FilTyp_FTName(PFTLst->PrmFT));
	 MakeDirFile(DirName, &Abort);
	 FORBIDDEN(Abort);
	 ClearDir(DirName); }/*if*/; }/*for*/;

   TmpPrms = Prms;
   while (TmpPrms != DfltPrms) {
      Print_Parm(&TmpPrms->Parm);
      TmpPrms = TmpPrms->Next; }/*while*/;

   for (PFTLst=PrmFTLst; PFTLst!=NIL; PFTLst=PFTLst->Next) {
      ClearFilTyp_Mark(PFTLst->PrmFT); }/*for*/;
   }/*MakePrmFiles*/;


tp_Parm
PrmFT_Parm(Parm, FilTyp)
   tp_Parm Parm;
   tp_FilTyp FilTyp;
{
   if (FilTyp == ERROR) return ERROR;
   Parm->PrmInf.IPrmFT = FilTyp_I(FilTyp);
   Parm->PrmInf.PrmClass = PC_Boolean;
   Parm->PrmInf.LocPrmVal = 0;
   Parm->PrmInf.LocHdr = 0;
   Parm->PrmVal = 0;
   return Parm;
   }/*PrmFT_Parm*/;


tp_Parm
PrmFTVal_Parm(Parm, FilTyp, Str)
   tp_Parm Parm;
   tp_FilTyp FilTyp;
   tp_Str Str;
{
   if (FilTyp == ERROR || Str == ERROR) return ERROR;

   Parm->PrmInf.IPrmFT = FilTyp_I(FilTyp);
   Parm->PrmInf.PrmClass = PC_String;
   Parm->PrmInf.LocHdr = 0;
   Parm->PrmInf.LocPrmVal = 0;
   Parm->PrmInf.Next = NIL;
   Parm->PrmVal = Str;
   return Parm;
   }/*PrmFTVal_Parm*/;


tp_Parm
PrmFTFile_Parm(Parm, FilTyp, FilHdr, PrecPrms)
   tp_Parm Parm;
   tp_FilTyp FilTyp;
   tp_FilHdr FilHdr;
   tp_Prms PrecPrms;
{
   tp_FilHdr ParmFilHdr;

   if (FilTyp == ERROR || FilHdr == ERROR || PrecPrms == ERROR) return ERROR;

   ParmFilHdr = Copy_FilHdr(FilHdr);
   if (!IsParameter_FilTyp(FilTyp)) {
      ParmFilHdr = Do_Deriv(ParmFilHdr, PrecPrms, PrecPrms, FilTyp); }/*if*/;
   if (ParmFilHdr == ERROR) {
      return ERROR; }/*if*/;

   Parm->PrmInf.IPrmFT = FilTyp_I(FilTyp);
   Parm->PrmInf.PrmClass = PC_File;
   Parm->PrmInf.LocHdr = FilHdr_LocHdr(ParmFilHdr);
   Parm->PrmInf.LocPrmVal = 0;
   Parm->PrmInf.Next = NIL;
   Parm->PrmVal = 0;
   Ret_FilHdr(ParmFilHdr);
   return Parm;
   }/*PrmFTFile_Parm*/;


tp_Parm
PrmFTValNod_Parm(Parm, FilTyp, PrmValNod)
   tp_Parm Parm;
   tp_FilTyp FilTyp;
   tp_Nod PrmValNod;
{
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr;
   tp_Prms TmpPrms;

   if (FilTyp == ERROR || PrmValNod == ERROR) return ERROR;

   switch (Nod_NodTyp(PrmValNod)) {
      case PVLFIL: {
	 PrmFHdr = Nod_PrmFHdr(Nod_Son(1, PrmValNod));
	 Use_PrmFHdr(&FilHdr, &TmpPrms, PrmFHdr);
	 if (FilHdr == ERROR) {
	    return ERROR; }/*if*/;
	 Parm = PrmFTFile_Parm(Parm, FilTyp, FilHdr, TmpPrms);
	 Ret_FilHdr(FilHdr);
	 break;}/*case*/;
      case WORD: {
	 Parm = PrmFTVal_Parm(Parm, FilTyp, Sym_Str(Nod_Sym(PrmValNod)));
	 break;}/*case*/;
      default: {
	 FatalError("illegal parameter value node"); };}/*select*/;
   
   return Parm;
   }/*PrmFTValNod_Parm*/;


tp_Parm
PrmNod_Parm(Parm, PrmNod)
   tp_Parm Parm;
   tp_Nod PrmNod;
{
   if (PrmNod == ERROR) return ERROR;

   switch (Nod_NodTyp(PrmNod)) {
      case PRMFLG: {
	 Parm = PrmFT_Parm(Parm, Nod_FilTyp(Nod_Son(1, PrmNod)));
	 break;}/*case*/;
      case PRMVAL: {
	 Parm = PrmFTValNod_Parm
	    (Parm, Nod_FilTyp(Nod_Son(1, PrmNod)), Nod_Son(2, PrmNod));
	 break;}/*case*/;
      default: {
	 FatalError("unexpected node type"); };}/*switch*/;
   return Parm;
   }/*PrmNod_Parm*/;


tp_Prms
Strip_Prms(Prms, PrmFTLst)
   tp_Prms Prms;
   tp_PrmFTLst PrmFTLst;
{
   tp_Prms NextPrms;

   if (Prms == DfltPrms) {
      return DfltPrms; }/*if*/;

   if (PrmFTLst == AllPrmFTLst) {
      return Prms; }/*if*/;

   NextPrms = Strip_Prms(Prms->Next, PrmFTLst);
   if (!In_PrmFTLst(Prms->PrmFT, PrmFTLst)) {
      return NextPrms; }/*if*/;
   if (NextPrms == Prms->Next) {
      return Prms; }/*if*/;
   return Add_Parm(&Prms->Parm, NextPrms);
   }/*Strip_Prms*/;


Prms_Str(Str, Prms)
   tp_Str Str;
   tp_Prms Prms;
{
   tp_Prms TmpPrms;
   tp_FilHdr FilHdr;

   FORBIDDEN(Prms == ERROR);
   (void)strcpy(Str, "");
   if (Prms == DfltPrms) {
      return; }/*if*/;

   TmpPrms = Prms;
   while (TmpPrms != DfltPrms) {
      (void)strcat(Str, " +");
      (void)strcat(Str, FilTyp_FTName(TmpPrms->PrmFT));
      switch (TmpPrms->Parm.PrmInf.PrmClass) {
	 case PC_Boolean: {
	    break;}/*case*/;
	 case PC_String: {
	    (void)strcat(Str, "='");
	    (void)strcat(Str, TmpPrms->Parm.PrmVal);
	    (void)strcat(Str, "'");
	    break;}/*case*/;
	 case PC_File: {
	    (void)strcat(Str, "=(");
	    FilHdr = LocHdr_FilHdr(TmpPrms->Parm.PrmInf.LocHdr);
	    FilHdr_OdinName(Tail(Str), FilHdr);
	    Ret_FilHdr(FilHdr);
	    (void)strcat(Str, ")");
	    break;}/*case*/;
	 default: {
	    FatalError("bad PrmClass"); };}/*switch*/;
      TmpPrms = TmpPrms->Next; }/*while*/;
   }/*Prms_Str*/;


Init_Prms()
{
   tps_Parm _Parm; tp_Parm Parm = &_Parm;

   Parm = PrmFT_Parm(Parm, NullFilTyp);
   DfltPrms = New_Prms(Parm);
   DfltPrms->LocPrm = DfltLocPrm;
   }/*Init_Prms*/;


/* PrmFTLst Module */

boolean
In_PrmFTLst(FilTyp, PrmFTLst)
   tp_FilTyp FilTyp;
   tp_PrmFTLst PrmFTLst;
{
   tp_PrmFTLst OKLElem;

   OKLElem = PrmFTLst;
   while (OKLElem != 0) {
      if (FilTyp == OKLElem->PrmFT) {
	 return TRUE; }/*if*/;
      OKLElem = OKLElem->Next; }/*while*/;
   return FALSE;
   }/*In_PrmFTLst*/;


SetPrmFTLst_Marks(PrmFTLst)
   tp_PrmFTLst PrmFTLst;
{
   tp_PrmFTLst TmpPrmFTLst;

   TmpPrmFTLst = PrmFTLst;
   while (TmpPrmFTLst != 0) {
      SetFilTyp_Mark(TmpPrmFTLst->PrmFT);
      TmpPrmFTLst = TmpPrmFTLst->Next; }/*while*/;
   }/*SetPrmFTLst_Marks*/;



