/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"

int		num_NodS = 0;
tp_Nod		FreeNod = NIL;

typedef struct _tps_Nod {
   tp_NodTyp NodTyp;
   tp_Sym Sym;
   tp_Nod Brother;
   tp_Nod Son;
#ifdef NODATT
   tp_Nod Att;
#endif
   }				tps_Nod;


tp_Nod
New_Nod()
{
   tp_Nod Nod;

   /*select*/{
      if (FreeNod == NIL) {
	 Nod = (tp_Nod)malloc(sizeof(tps_Nod));
	 num_NodS += 1;
      }else{
	 Nod = FreeNod;
	 FreeNod = FreeNod->Brother; };}/*select*/;
   Nod->NodTyp = NIL;
   Nod->Son = NIL;
   Nod->Brother = NIL;
   Nod->Sym = NIL;
   return Nod;
   }/*New_Nod*/;


Ret_Nod(Nod)
   tp_Nod Nod;
{
   if (Nod != ERROR) {
      Ret_Nod(Nod->Son);
      Ret_Nod(Nod->Brother);
      Nod->Brother = FreeNod;
      FreeNod = Nod; }/*if*/;
   }/*Ret_Nod*/;

   
tp_NodTyp
Nod_NodTyp(Nod)
   tp_Nod Nod;
{
   if (Nod == ERROR) return ERROR;
   return Nod->NodTyp;
   }/*Nod_NodTyp*/;


Set_Nod_NodTyp(Nod, NodTyp)
   tp_Nod Nod;
   tp_NodTyp NodTyp;
{
   Nod->NodTyp = NodTyp;
   }/*Set_Nod_NodTyp*/;


tp_Nod
Nod_FirstSon(Nod)
   tp_Nod Nod;
{
   FORBIDDEN(Nod == ERROR);
   return Nod->Son;
   }/*Nod_FirstSon*/;


Set_Nod_FirstSon(Nod, FirstSon)
   tp_Nod Nod;
   tp_Nod FirstSon;
{
   Nod->Son = FirstSon;
   }/*Set_Nod_FirstSon*/;


tp_Nod
Nod_Brother(Nod)
   tp_Nod Nod;
{
   FORBIDDEN(Nod == ERROR);
   return Nod->Brother;
   }/*Nod_Brother*/;


Set_Nod_Brother(Nod, Brother)
   tp_Nod Nod;
   tp_Nod Brother;
{
   Nod->Brother = Brother;
   }/*Set_Nod_Brother*/;


int
Nod_NumSons(Nod)
   tp_Nod Nod;
{
   tp_Nod SonNod;
   int NumSons;

   FORBIDDEN(Nod == ERROR);
   SonNod = Nod->Son;
   NumSons = 0;
   while (SonNod != 0) {
      NumSons += 1;
      SonNod = SonNod->Brother; }/*while*/;
   return NumSons;
   }/*Nod_NumSons*/;


tp_Nod
Nod_Son(I, Nod)
   int I;
   tp_Nod Nod;
{
   tp_Nod SonNod;
   int i;

   FORBIDDEN(Nod == ERROR);
   FORBIDDEN(I <= 0);
   SonNod = Nod->Son;
   for (i=1; i<I; i++) {
      if (SonNod == NIL) {
	 return NIL; }/*if*/;
      SonNod = SonNod->Brother; }/*for*/;
   return SonNod;
   }/*Nod_Son*/;


tp_Sym
Nod_Sym(Nod)
   tp_Nod Nod;
{
   if (Nod == ERROR) return ERROR;
   return Nod->Sym;
   }/*Nod_Sym*/;


Set_Nod_Sym(Nod, Sym)
   tp_Nod Nod;
   tp_Sym Sym;
{
   Nod->Sym = Sym;
   }/*Set_Nod_Sym*/;


#ifdef NODATT

tp_Nod
Get_NodAtt(Nod)
   tp_Nod Nod;
{
   FORBIDDEN(Nod == ERROR);
   return (Nod->Att);
   }/*Get_NodAtt*/;


tp_Nod
Set_NodAtt(Nod, Att)
   tp_Nod Nod, Att;
{
   FORBIDDEN(Nod == ERROR);
   Nod->Att = Att;
   }/*Set_NodAtt*/;


Set_All_NodAtts(Nod, Att)
   tp_Nod Nod, Att;
{
   FORBIDDEN(Nod == ERROR);
   Nod->Att = Att;
   if (Nod->Son != NIL) Set_All_NodAtts(Nod->Son, Att);
   if (Nod->Brother != NIL) Set_All_NodAtts(Nod->Brother, Att);
   }/*Set_All_NodAtts*/;
   
#endif

typedef char *			tp_Value;
typedef struct _tps_StackElm *	tp_StackElm;
typedef struct _tps_StackElm {
   tp_Value Value;
   tp_StackElm Next;
   }				tps_StackElm;

int		num_StackElmS = 0;
tp_StackElm	FreeStackElm = NIL;

/*private*/ tp_StackElm
New_StackElm()
{
   tp_StackElm StackElm;

   if (FreeStackElm == 0) {
      num_StackElmS += 1;
      return (tp_StackElm)malloc(sizeof(tps_StackElm)); }/*if*/;
   StackElm = FreeStackElm;
   FreeStackElm = FreeStackElm->Next;
   return StackElm;
   }/*New_StackElm*/;


tp_StackElm	SymStack = NIL;

boolean
Empty_SymStack()
{
   return (SymStack == NIL);
   }/*Empty_SymStack*/;


Push_SymStack(Sym)
   tp_Sym Sym;
{
   tp_StackElm StackElm;

   FORBIDDEN(Sym == ERROR);
   StackElm = New_StackElm();
   StackElm->Value = (tp_Value)Sym;
   StackElm->Next = SymStack;
   SymStack = StackElm;
   }/*Push_SymStack*/;


/*private*/ tp_Sym
TopOf_SymStack()
{
   FORBIDDEN(SymStack == NIL);
   return (tp_Sym)SymStack->Value;
   }/*TopOf_SymStack*/;


Pop_SymStack()
{
   tp_StackElm OldFreeStackElm;

   FORBIDDEN(SymStack == NIL);
   OldFreeStackElm = FreeStackElm;
   FreeStackElm = SymStack;
   SymStack = SymStack->Next;
   FreeStackElm->Next = OldFreeStackElm;
   }/*Pop_SymStack*/;


tp_StackElm	NodStack = NIL;

/*private*/ boolean
Empty_NodStack()
{
   return (NodStack == NIL);
   }/*Empty_NodStack*/;


Push_NodStack(Nod)
   tp_Nod Nod;
{
   tp_StackElm StackElm;

   FORBIDDEN(Nod == ERROR);
   StackElm = New_StackElm();
   StackElm->Value = (tp_Value)Nod;
   StackElm->Next = NodStack;
   NodStack = StackElm;
   }/*Push_NodStack*/;


/*private*/ tp_Nod
TopOf_NodStack()
{
   FORBIDDEN(NodStack == NIL);
   return (tp_Nod)NodStack->Value;
   }/*TopOf_NodStack*/;


Pop_NodStack()
{
   tp_StackElm OldFreeStackElm;

   FORBIDDEN(NodStack == NIL);
   OldFreeStackElm = FreeStackElm;
   FreeStackElm = NodStack;
   NodStack = NodStack->Next;
   FreeStackElm->Next = OldFreeStackElm;
   }/*Pop_NodStack*/;


tp_StackElm	SonStack = NIL;

/*private*/ boolean
Empty_SonStack()
{
   return (SonStack == NIL);
   }/*Empty_SonStack*/;


Push_SonStack(NumSons)
   int NumSons;
{
   tp_StackElm StackElm;

   FORBIDDEN(NumSons < 0);
   StackElm = New_StackElm();
   StackElm->Value = (tp_Value)NumSons;
   StackElm->Next = SonStack;
   SonStack = StackElm;
   }/*Push_SonStack*/;


/*private*/ int
TopOf_SonStack()
{
   FORBIDDEN(SonStack == NIL);
   return (int)SonStack->Value;
   }/*TopOf_SonStack*/;


Pop_SonStack()
{
   tp_StackElm OldFreeStackElm;

   FORBIDDEN(SonStack == NIL);
   OldFreeStackElm = FreeStackElm;
   FreeStackElm = SonStack;
   SonStack = SonStack->Next;
   FreeStackElm->Next = OldFreeStackElm;
   }/*Pop_SonStack*/;


Init_Build()
{
   while (!Empty_SymStack()) {
      Pop_SymStack(); }/*while*/;
   while (!Empty_NodStack()) {
      Ret_Nod(TopOf_NodStack());
      Pop_NodStack(); }/*while*/;
   while (!Empty_SonStack()) {
      Pop_SonStack(); }/*while*/;
   }/*Init_Build*/;


MakeLeaf(NodTyp, Sym)
   tp_NodTyp NodTyp;
   tp_Sym Sym;
{
   tp_Nod Nod;

   if (NodTyp == 0) {
      return; }/*if*/;
   Nod = New_Nod();
   Nod->NodTyp = NodTyp; Nod->Sym = Sym; Nod->Son = 0; Nod->Brother = 0;
   Push_NodStack(Nod); Push_SonStack(1);
   }/*MakeLeaf*/;
 

MakeEmptyNod(NodTyp)
   tp_NodTyp NodTyp;
{
   tp_Nod Nod;

   if (NodTyp == 0) return;
   Nod = New_Nod();
   Nod->NodTyp = NodTyp; Nod->Sym = 0; Nod->Son = 0; Nod->Brother = 0;
   Push_NodStack(Nod); Push_SonStack(1);
   }/*MakeEmptyNod*/;
 

MakeNod(Typ)
   int Typ;
{
   tp_NodTyp NodTyp;
   tp_Nod Nod, NewNod, Brother;
   int NumSons, i;

   NodTyp = Typ;
   NumSons = TopOf_SonStack();
   if (Typ < 0) {
      if (NumSons == 1) {
	 return; }/*if*/;
      NodTyp = -Typ; }/*if*/;
   Pop_SonStack();
   if (NumSons == 0) {
      MakeEmptyNod(NodTyp);
      return; }/*if*/;
   Brother = 0;
   for (i=0; i<NumSons; i++) {
      NewNod = TopOf_NodStack(); Pop_NodStack();
      NewNod->Brother = Brother;
      Brother = NewNod; }/*for*/;
   Nod = New_Nod();
   Nod->NodTyp = NodTyp; Nod->Sym = 0; Nod->Son = Brother; Nod->Brother = 0;
   Push_NodStack(Nod); Push_SonStack(1);
   }/*MakeNod*/;
 

CollectSons(Number)
   int Number;
{
   int NumSons, i;

   FORBIDDEN(Number < 0);
   NumSons = 0;
   for (i=0; i<Number; i++) {
      NumSons = NumSons + TopOf_SonStack();
      Pop_SonStack(); }/*for*/;
   Push_SonStack(NumSons);
   }/*CollectSons*/;


tp_Nod
EndBuild()
{
   tp_Nod Root;

   if (Num_Errors() > 0) {
      return ERROR; }/*if*/;
   if (Empty_NodStack()) {
      return ERROR; }/*if*/;
   Root = TopOf_NodStack();
   Pop_NodStack();
   Pop_SonStack();
   return Root;
   }/*EndBuild*/;


Action(Typ, NumSons)
   int Typ;
   int NumSons;
{
   tp_Sym Sym;

   if (Num_Errors() > 0) return;
   /*select*/{
      if (NumSons < 0) {
	 /*select*/{
	    if (Typ < 0) {
	       CollectSons(-NumSons);
	       MakeNod(-Typ);
	       EndLex();
	    }else{
	       Sym = TopOf_SymStack(); Pop_SymStack();
	       MakeLeaf(Typ, Sym); };}/*select*/;
      }else if (NumSons == 0) {
	 /*select*/{
	    if (Typ < 0) {
	       CollectSons(NumSons);
	       MakeNod(-Typ);
	       EndLex();
	    }else if (Typ == 0) {
	       CollectSons(NumSons);
	    }else{
	       MakeEmptyNod(Typ); };}/*select*/;
      }else{
	 if (NumSons > 1) CollectSons(NumSons);
	 if (Typ != 0) MakeNod(Typ);
	 };}/*select*/;
   }/*Action*/;


tp_Nod
Parser()
{
   tp_Nod Nod;

   Reset_Err();
   Init_Lex();
   Init_Build();

   (void)yyparse();
   Nod = EndBuild();

   if (Num_Errors() > 0) {
      return ERROR; }/*if*/;
   return Nod;
   }/*Parser*/;


yyerror(s)
   char *s;
{
   ParseError(s);
   }/*yerror*/;


