/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/CastEdg.h"
#include "inc/DPType_.h"
#include "inc/DrvEdg.h"
#include "inc/DrvPth.h"
#include "inc/EqvEdg.h"
#include "inc/FKind_.h"
#include "inc/FilTyp.h"
#include "inc/Lvl.h"
#include "inc/Pos.h"
#include "inc/PType_.h"


int		num_PosS = 0;
tp_Pos		FreePos = NIL;
int		num_FreePosS = 0;


Init_Lvls()
{
   FORBIDDEN(num_PosS != num_FreePosS);
   }/*Init_Lvls*/;


/*private*/ tp_Pos
New_Pos()
{
   tp_Pos Pos;

   /*select*/{
      if (FreePos == NIL) {
	 Pos = (tp_Pos)malloc(sizeof(tps_Pos));
	 num_PosS += 1;
      }else{
	 Pos = FreePos;
	 FreePos = FreePos->Next;
	 num_FreePosS -= 1; };}/*select*/;
   Pos->Next = 0;
   Pos->Last = Pos;
   return Pos;
   }/*New_Pos*/;


/*private*/ tp_Lvl
Begin_Lvl()
{
   return 0;
   }/*Begin_Lvl*/;


/*private*/ boolean
IsEmpty_Lvl(Lvl)
   tp_Lvl Lvl;
{
   return (Lvl == 0);
   }/*IsEmpty_Lvl*/;


/*private*/ tp_Pos
First_Pos(Lvl)
   tp_Lvl Lvl;
{
   return Lvl;
   }/*First_Pos*/;


/*private*/ tp_Pos
Next_Pos(Pos)
   tp_Pos Pos;
{
   return Pos->Next;
   }/*Next_Pos*/;


/*private*/ tp_FilTyp
Pos_FilTyp(Pos)
   tp_Pos Pos;
{
   return Pos->FilTyp;
   }/*Pos_FilTyp*/;


/*private*/ boolean
IsInLvl(FilTyp)
   tp_FilTyp FilTyp;
{
   return (FilTyp->Pos != 0);
   }/*IsInLvl*/;


tp_DrvPth
Make_ImHoDrvPth(ToFilTyp)
   tp_FilTyp ToFilTyp;
{
   tp_DrvPth DrvPth;

   DrvPth = FilTyp_Drv_DrvPth(ToFilTyp, (tp_DrvEdg)NIL);
   DrvPth->FKind = FK_ImHo;
   return DrvPth;
   }/*Make_ImHoDrvPth*/;


Convert_To_ImHoDrvPth(DrvPthPtr, FilTyp)
   tp_DrvPth *DrvPthPtr;
   tp_FilTyp FilTyp;
{
   tp_DrvPth LastDrvPth;
   tp_FilTyp LastFilTyp;

   LastFilTyp = FilTyp;
   if (*DrvPthPtr != NIL) {
      for (LastDrvPth = *DrvPthPtr;
	   LastDrvPth->Next != NIL;
	   LastDrvPth = LastDrvPth->Next);
      LastFilTyp = LastDrvPth->FilTyp;
      Ret_DrvPth(*DrvPthPtr); }/*if*/;
   *DrvPthPtr = Make_ImHoDrvPth(LastFilTyp);
   }/*Convert_To_ImHoDrvPth*/;


/*private*/ tp_DrvPth
Pos_DrvPth(EndPos)
   tp_Pos EndPos;
{
   tp_Pos Pos;
   tp_DrvPth DrvPth, NextDrvPth;

   FORBIDDEN(EndPos == NIL);
   Pos = EndPos;
   NextDrvPth = NIL;
   while (Pos->PType != PT_Inp) {
      switch (Pos->PType) {
	 case PT_Cast: {
	    DrvPth = FilTyp_Cast_DrvPth(Pos->FilTyp);
	    DrvPth->Next = NextDrvPth;
	    NextDrvPth = DrvPth;
	    break;}/*case*/;
	 case PT_Eqv: {
	    DrvPth = FilTyp_Eqv_DrvPth(Pos->FilTyp);
	    DrvPth->Next = NextDrvPth;
	    NextDrvPth = DrvPth;
	    break;}/*case*/;
	 case PT_ImHo: {
	    Convert_To_ImHoDrvPth(&NextDrvPth, Pos->FilTyp);
	    break;}/*case*/;
	 case PT_Drv: {
	    DrvPth = FilTyp_Drv_DrvPth(Pos->FilTyp, Pos->DrvEdg);
	    DrvPth->Next = NextDrvPth;
	    NextDrvPth = DrvPth;
	    break;}/*case*/;
	 default: {
	    FatalError("Bad PType"); };}/*switch*/;
      Pos = Pos->Base; }/*while*/;
   return NextDrvPth;
   }/*Pos_DrvPth*/;


AddInpToLvl(PosPtr, LvlPtr, FilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_FilTyp FilTyp;
{
   tp_Pos Pos;

   FORBIDDEN(FilTyp->Pos != 0);
   Pos = New_Pos();
   FilTyp->Pos = Pos;
   Pos->PType = PT_Inp;
   Pos->FilTyp = FilTyp;
   Pos->Base = 0;
   *PosPtr = Pos;
   if (*LvlPtr == 0) {
      *LvlPtr = Pos;
      return; }/*if*/;
   (*LvlPtr)->Last->Next = Pos;
   (*LvlPtr)->Last = Pos;
   }/*AddInpToLvl*/;


AddCastEdgToLvl(LvlPtr, FilTyp, BasePos)
   tp_Lvl *LvlPtr;
   tp_FilTyp FilTyp;
   tp_Pos BasePos;
{
   tp_Pos Pos;

   FORBIDDEN(FilTyp->Pos != 0);
   Pos = New_Pos();
   FilTyp->Pos = Pos;
   Pos->PType = PT_Cast;
   Pos->FilTyp = FilTyp;
   Pos->Base = BasePos;
   if (*LvlPtr == 0) {
      *LvlPtr = Pos;
      return; }/*if*/;
   (*LvlPtr)->Last->Next = Pos;
   (*LvlPtr)->Last = Pos;
   }/*AddCastEdgToLvl*/;


AddEqvEdgToLvl(LvlPtr, FilTyp, BasePos)
   tp_Lvl *LvlPtr;
   tp_FilTyp FilTyp;
   tp_Pos BasePos;
{
   tp_Pos Pos;

   FORBIDDEN(FilTyp->Pos != 0);
   Pos = New_Pos();
   FilTyp->Pos = Pos;
   Pos->PType = PT_Eqv;
   Pos->FilTyp = FilTyp;
   Pos->Base = BasePos;
   if (*LvlPtr == 0) {
      *LvlPtr = Pos;
      return; }/*if*/;
   (*LvlPtr)->Last->Next = Pos;
   (*LvlPtr)->Last = Pos;
   }/*AddEqvEdgToLvl*/;


AddImHoToLvl(LvlPtr, FilTyp, BasePos)
   tp_Lvl *LvlPtr;
   tp_FilTyp FilTyp;
   tp_Pos BasePos;
{
   tp_Pos Pos;

   FORBIDDEN(FilTyp->Pos != 0);
   Pos = New_Pos();
   FilTyp->Pos = Pos;
   Pos->PType = PT_ImHo;
   Pos->FilTyp = FilTyp;
   Pos->Base = BasePos;
   if (*LvlPtr == 0) {
      *LvlPtr = Pos;
      return; }/*if*/;
   (*LvlPtr)->Last->Next = Pos;
   (*LvlPtr)->Last = Pos;
   }/*AddImHoToLvl*/;


AddDrvEdgToLvl(LvlPtr, FilTyp, DrvEdg, BasePos)
   tp_Lvl *LvlPtr;
   tp_FilTyp FilTyp;
   tp_DrvEdg DrvEdg;
   tp_Pos BasePos;
{
   tp_Pos Pos;

   FORBIDDEN(FilTyp->Pos != 0);
   Pos = New_Pos();
   FilTyp->Pos = Pos;
   Pos->PType = PT_Drv;
   Pos->FilTyp = FilTyp;
   Pos->DrvEdg = DrvEdg;
   Pos->Base = BasePos;
   if (*LvlPtr == 0) {
      *LvlPtr = Pos;
      return; }/*if*/;
   (*LvlPtr)->Last->Next = Pos;
   (*LvlPtr)->Last = Pos;
   }/*AddDrvEdgToLvl*/;


AddCastEdgsToLvl(PosPtr, LvlPtr, Pos, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_Pos Pos;
   tp_FilTyp ToFilTyp;
{
   tp_CastEdg CastEdg;
   tp_FilTyp CastFilTyp;
   tp_Pos CastPos;

   *PosPtr = 0;
   CastEdg = (Pos_FilTyp(Pos))->CastEdg;
   while (CastEdg != 0) {
      CastFilTyp = CastEdg->FilTyp;
      if (!IsInLvl(CastFilTyp)) {
	 AddCastEdgToLvl(LvlPtr, CastFilTyp, Pos);
	 CastPos = CastFilTyp->Pos;
	 if (CastFilTyp == ToFilTyp) {
	    *PosPtr = CastPos;
	    FORBIDDEN(*PosPtr == 0);
	    return; }/*if*/;
	 AddCastEdgsToLvl(PosPtr, LvlPtr, CastPos, ToFilTyp);
	 if (*PosPtr != NIL) {
	    return; }/*if*/;
	 AddEqvEdgsToLvl(PosPtr, LvlPtr, CastPos, ToFilTyp);
	 if (*PosPtr != NIL) {
	    return; }/*if*/; }/*if*/;
      CastEdg = CastEdg->Next; }/*while*/;
   }/*AddCastEdgsToLvl*/;


AddImHoCastEdgsToLvl(PosPtr, LvlPtr, FrmFilTyp, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_FilTyp FrmFilTyp, ToFilTyp;
{
   tp_FilTyp ElmFilTyp;
   tp_Pos ImHoPos;

   *PosPtr = 0;
   ElmFilTyp = FrmFilTyp->ElmFilTyp;
   FORBIDDEN(ElmFilTyp == ERROR);
   FORBIDDEN(ElmFilTyp->Pos == 0);
   ImHoPos = ElmFilTyp->Pos;
   if (ImHoPos->PType != PT_ImHo) {
      return; }/*if*/;
   FORBIDDEN(ElmFilTyp == ToFilTyp);
   AddCastEdgsToLvl(PosPtr, LvlPtr, ImHoPos, ToFilTyp);
   }/*AddImHoCastEdgsToLvl*/;


AddEqvEdgsToLvl(PosPtr, LvlPtr, Pos, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_Pos Pos;
   tp_FilTyp ToFilTyp;
{
   tp_EqvEdg EqvEdg;
   tp_FilTyp EqvFilTyp;
   tp_Pos EqvPos;

   *PosPtr = 0;
   EqvEdg = (Pos_FilTyp(Pos))->EqvEdg;
   while (EqvEdg != 0) {
      EqvFilTyp = EqvEdg->FilTyp;
      if (!IsInLvl(EqvFilTyp)) {
	 AddEqvEdgToLvl(LvlPtr, EqvFilTyp, Pos);
	 EqvPos = EqvFilTyp->Pos;
	 if (EqvFilTyp == ToFilTyp) {
	    *PosPtr = EqvPos;
	    FORBIDDEN(*PosPtr == 0);
	    return; }/*if*/;
	 AddEqvEdgsToLvl(PosPtr, LvlPtr, EqvPos, ToFilTyp);
	 if (*PosPtr != NIL) {
	    return; }/*if*/; }/*if*/;
      EqvEdg = EqvEdg->Next; }/*while*/;
   }/*AddEqvEdgsToLvl*/;


AddImHosToLvl(PosPtr, LvlPtr, Pos, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_Pos Pos;
   tp_FilTyp ToFilTyp;
{
   tp_FilTyp ElmFilTyp;
   tp_Pos ImHoPos;

   *PosPtr = 0;
   ElmFilTyp = (Pos_FilTyp(Pos))->ElmFilTyp;
   FORBIDDEN(ElmFilTyp == ERROR);
   if (!IsInLvl(ElmFilTyp)) {
      AddImHoToLvl(LvlPtr, ElmFilTyp, Pos);
      ImHoPos = ElmFilTyp->Pos;
      if (ElmFilTyp == ToFilTyp) {
	 *PosPtr = ImHoPos;
	 FORBIDDEN(*PosPtr == 0);
	 return; }/*if*/;
      AddEqvEdgsToLvl(PosPtr, LvlPtr, ImHoPos, ToFilTyp); }/*if*/;
   }/*AddImHosToLvl*/;


AddDrvEdgsToLvl(PosPtr, LvlPtr, Pos, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_Pos Pos;
   tp_FilTyp ToFilTyp;
{
   tp_DrvEdg DrvEdg;
   tp_FilTyp DrvFilTyp;
   tp_Pos DrvPos;

   *PosPtr = 0;
   DrvEdg = (Pos_FilTyp(Pos))->DrvEdg;
   while (DrvEdg != 0) {
      DrvFilTyp = DrvEdg->FilTyp;
      if (!IsInLvl(DrvFilTyp)) {
	 AddDrvEdgToLvl(LvlPtr, DrvFilTyp, DrvEdg, Pos);
	 DrvPos = DrvFilTyp->Pos;
	 if (DrvFilTyp == ToFilTyp) {
	    *PosPtr = DrvPos;
	    FORBIDDEN(*PosPtr == 0);
	    return; }/*if*/;
	 AddEqvEdgsToLvl(PosPtr, LvlPtr, DrvPos, ToFilTyp);
	 if (*PosPtr != NIL) {
	    return; }/*if*/; }/*if*/;
      DrvEdg = DrvEdg->Next; }/*while*/;
   }/*AddDrvEdgsToLvl*/;


AppendLvl(LvlPtr, AddLvl)
   tp_Lvl *LvlPtr, AddLvl;
{
   tp_Lvl Lvl;

   if (AddLvl == 0) return;
   Lvl = *LvlPtr;
   if (Lvl == 0) {
      *LvlPtr = AddLvl;
      return; }/*if*/;
   Lvl->Last->Next = AddLvl;
   Lvl->Last = AddLvl->Last;
   }/*AppendLvl*/;


Clear_InLvls(Lvl)
   tp_Lvl Lvl;
{
   tp_Pos Pos, LastPos;

   if (Lvl == NIL) return;
   for (Pos = Lvl; Pos != NIL; Pos = Pos->Next) {
      num_FreePosS += 1;
      Pos->FilTyp->Pos = 0;
      LastPos = Pos; }/*for*/;
   LastPos->Next = FreePos;
   FreePos = Lvl;
   }/*Clear_InLvls*/;


AddDrvLvls(PosPtr, LvlPtr, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_FilTyp ToFilTyp;
{
   tp_Lvl OldLvls, Lvl, NewLvl;
   tp_Pos Pos;

   OldLvls = Begin_Lvl();
   Lvl = *LvlPtr; NewLvl = Begin_Lvl();
   while (!IsEmpty_Lvl(Lvl)) {
      Pos = First_Pos(Lvl);
      while (Pos != NIL) {
	 AddDrvEdgsToLvl(PosPtr, &NewLvl, Pos, ToFilTyp);
	 if (*PosPtr != NIL) {
	    goto done; }/*if*/;
	 Pos = Next_Pos(Pos); }/*while*/;
      AppendLvl(&OldLvls, Lvl);
      Lvl = NewLvl; NewLvl = Begin_Lvl(); }/*while*/;
   *PosPtr = NIL;
done:
   AppendLvl(&OldLvls, Lvl);
   AppendLvl(&OldLvls, NewLvl);
   *LvlPtr = OldLvls;
   }/*AddDrvLvls*/;


AddCastLvls(PosPtr, LvlPtr, InpPos, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_Pos InpPos;
   tp_FilTyp ToFilTyp;
{
   tp_Lvl CastLvl;

   CastLvl = Begin_Lvl();
   AddCastEdgsToLvl(PosPtr, &CastLvl, InpPos, ToFilTyp);
   if (*PosPtr != NIL) {
      goto done; }/*if*/;
   AddDrvLvls(PosPtr, &CastLvl, ToFilTyp);

done:;
   AppendLvl(LvlPtr, CastLvl);
   }/*AddCastLvls*/;


AddImHoDrvLvls(PosPtr, LvlPtr, FrmFilTyp, ToFilTyp, PntrFlag)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_FilTyp FrmFilTyp, ToFilTyp;
   boolean PntrFlag;
{
   tp_Lvl OldLvls, Lvl, NewLvl;
   tp_Pos Pos;

   OldLvls = Begin_Lvl();
   Lvl = *LvlPtr;
   NewLvl = Begin_Lvl();

   Pos = First_Pos(Lvl);
   while (Pos != NIL) {
      if (PntrFlag ? IsPntr_FilTyp(Pos_FilTyp(Pos))
	   : IsCompound_FilTyp(Pos_FilTyp(Pos))) {
	 AddImHosToLvl(PosPtr, &NewLvl, Pos, ToFilTyp);
	 if (*PosPtr != NIL) {
	    goto done; }/*if*/; }/*if*/;
      Pos = Next_Pos(Pos); }/*while*/;

   if (PntrFlag ? IsPntr_FilTyp(FrmFilTyp) : IsCompound_FilTyp(FrmFilTyp)) {
      AddImHoCastEdgsToLvl(PosPtr, &NewLvl, FrmFilTyp, ToFilTyp);
      if (*PosPtr != NIL) {
	 goto done; }/*if*/; }/*if*/;

   AppendLvl(&OldLvls, Lvl);
   Lvl = NewLvl;
   NewLvl = Begin_Lvl();

   while (!IsEmpty_Lvl(Lvl)) {
      Pos = First_Pos(Lvl);
      while (Pos != NIL) {
	 AddDrvEdgsToLvl(PosPtr, &NewLvl, Pos, ToFilTyp);
	 if (*PosPtr != NIL) {
	    goto done; }/*if*/;
	 if (PntrFlag ? IsPntr_FilTyp(Pos_FilTyp(Pos))
	     : IsCompound_FilTyp(Pos_FilTyp(Pos))) {
	    AddImHosToLvl(PosPtr, &NewLvl, Pos, ToFilTyp);
	    if (*PosPtr != NIL) {
	       goto done; }/*if*/; }/*if*/;
	 Pos = Next_Pos(Pos); }/*while*/;
      AppendLvl(&OldLvls, Lvl);
      Lvl = NewLvl; NewLvl = Begin_Lvl(); }/*while*/;
   *PosPtr = NIL;
done:
   AppendLvl(&OldLvls, Lvl);
   AppendLvl(&OldLvls, NewLvl);
   *LvlPtr = OldLvls;
   }/*AddImHoDrvLvls*/;


Find_Pos(PosPtr, LvlPtr, FrmFilTyp, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_FilTyp FrmFilTyp;
   tp_FilTyp ToFilTyp;
{
   tp_Pos InpPos;

   AddInpToLvl(&InpPos, LvlPtr, FrmFilTyp);
   AddEqvEdgsToLvl(PosPtr, LvlPtr, InpPos, ToFilTyp);
   if (*PosPtr != NIL) {
      return; }/*if*/;
   AddDrvLvls(PosPtr, LvlPtr, ToFilTyp);
   if (*PosPtr != NIL) {
      return; }/*if*/;
   AddCastLvls(PosPtr, LvlPtr, InpPos, ToFilTyp);
   if (*PosPtr != NIL) {
      return; }/*if*/;
   }/*Find_Pos*/;


ExtendLvl(PosPtr, LvlPtr, FrmFilTyp, ToFilTyp)
   tp_Pos *PosPtr;
   tp_Lvl *LvlPtr;
   tp_FilTyp FrmFilTyp;
   tp_FilTyp ToFilTyp;
{
   tp_Lvl NewLvl;

   NewLvl = Begin_Lvl();
   Find_Pos(PosPtr, &NewLvl, FrmFilTyp, ToFilTyp);
   AppendLvl(LvlPtr, NewLvl);
   }/*ExtendLvl*/;


Do_Search(DrvPthPtr, IsGenericPtr, FrmFKind, FrmFilTyp, ToFilTyp)
   tp_DrvPth *DrvPthPtr;
   boolean *IsGenericPtr;
   tp_FKind FrmFKind;
   tp_FilTyp FrmFilTyp;
   tp_FilTyp ToFilTyp;
{
   tp_Lvl Lvl;
   tp_Pos Pos, GenericPos;
   boolean ImHoFlag, CmpdFlag;

   FORBIDDEN(ToFilTyp == FrmFilTyp);
   *DrvPthPtr = NIL;
   *IsGenericPtr = FALSE;

   ImHoFlag = CanImHo_FKind(FrmFKind);
   CmpdFlag = (ImHoFlag || IsCompound_FilTyp(FrmFilTyp));

   Init_Lvls();
   Lvl = NIL;
   ExtendLvl(&Pos, &Lvl, FrmFilTyp, ToFilTyp);
   if (Pos != NIL) {
      goto done; }/*if*/;
   /*select*/{
      if (FrmFKind == FK_User && IsStructure_FilTyp(FrmFilTyp)) {
	 if (ToFilTyp == DfltCpsFilTyp) {
	    *DrvPthPtr = FilTyp_Eqv_DrvPth(ToFilTyp);
	    goto done; }/*if*/;
	 if (FrmFilTyp != DfltCpsFilTyp) {
	    ExtendLvl(&Pos, &Lvl, DfltCpsFilTyp, ToFilTyp);
	    if (Pos != NIL) {
	       goto done; }/*if*/; }/*if*/;
      }else if (CmpdFlag) {
	 if (ToFilTyp == DfltCpdFilTyp) {
	    *DrvPthPtr = FilTyp_Eqv_DrvPth(ToFilTyp);
	    goto done; }/*if*/;
	 if (FrmFilTyp != DfltCpdFilTyp) {
	    ExtendLvl(&Pos, &Lvl, DfltCpdFilTyp, ToFilTyp);
	    if (Pos != NIL) {
	       ImHoFlag = FALSE;
	       goto done; }/*if*/; }/*if*/;
      }else{
	 if (ToFilTyp == DfltAtmFilTyp) {
	    *DrvPthPtr = FilTyp_Eqv_DrvPth(ToFilTyp);
	    goto done; }/*if*/;
	 if (FrmFilTyp != DfltAtmFilTyp) {
	    ExtendLvl(&Pos, &Lvl, DfltAtmFilTyp, ToFilTyp);
	    if (Pos != NIL) {
	       goto done; }/*if*/; }/*if*/; };}/*select*/;

   if (ToFilTyp == DfltAnyFilTyp) {
      *DrvPthPtr = FilTyp_Eqv_DrvPth(ToFilTyp);
      goto done; }/*if*/;
   if (FrmFilTyp != DfltAnyFilTyp) {
      ExtendLvl(&Pos, &Lvl, DfltAnyFilTyp, ToFilTyp);
      if (Pos != NIL) {
	 ImHoFlag = FALSE;
	 goto done; }/*if*/; }/*if*/;

   GenericPos = GenericFilTyp->Pos;

   if (!IsHook_FilTyp(ToFilTyp)) {
      AddImHoDrvLvls(&Pos, &Lvl, FrmFilTyp, ToFilTyp, TRUE);
      if (Pos != NIL) {
	 goto done; }/*if*/;

      AddImHoDrvLvls(&Pos, &Lvl, FrmFilTyp, ToFilTyp, FALSE);
      if (Pos != NIL) {
	 goto done; }/*if*/;

      if (CmpdFlag && !IsImplicit_FilTyp(ToFilTyp)) {
	 ImHoFlag = TRUE;
	 FORBIDDEN(FrmFilTyp->Pos == NIL);
	 AddDrvEdgToLvl(&Lvl, ToFilTyp, (tp_DrvEdg)NIL, FrmFilTyp->Pos);
	 Pos = ToFilTyp->Pos;
	 FORBIDDEN(Pos == NIL);
	 goto done; }/*if*/;

      if (DfltAllFilTyp->Pos != NIL && !IsImplicit_FilTyp(ToFilTyp)) {
	 FORBIDDEN(DfltAllFilTyp->Pos->PType != PT_ImHo);
	 AddEqvEdgToLvl(&Lvl, ToFilTyp, DfltAllFilTyp->Pos);
	 Pos = ToFilTyp->Pos;
	 goto done; }/*if*/; }/*if*/;

   if (GenericPos != NIL) {
      *IsGenericPtr = TRUE;
      Pos = GenericPos;
      goto done; }/*if*/;

done:;
   if (Pos != NIL) {
      *DrvPthPtr = Pos_DrvPth(Pos);
      if (ImHoFlag) {
	 Convert_To_ImHoDrvPth(DrvPthPtr, FrmFilTyp); }/*if*/; }/*if*/;

   Clear_InLvls(Lvl);
   }/*Do_Search*/;

