/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/FilHdr.h"
#include "inc/Flag_.h"
#include "inc/Status_.h"


Set_Older(FilHdr, LocHdr)
   tp_FilHdr FilHdr;
   tp_LocHdr LocHdr;
{
   FORBIDDEN(FilHdr == ERROR || LocHdr == ERROR);
   if (LocHdr != FilHdr->HdrInf.Older) {
      FilHdr->HdrInf.Older = LocHdr;
      SetModified(FilHdr); }/*if*/;
   }/*Set_Older*/;


Set_Newer(FilHdr, LocHdr)
   tp_FilHdr FilHdr;
   tp_LocHdr LocHdr;
{
   FORBIDDEN(FilHdr == ERROR || LocHdr == ERROR);
   if (LocHdr != FilHdr->HdrInf.Newer) {
      FilHdr->HdrInf.Newer = LocHdr;
      SetModified(FilHdr); }/*if*/;
   }/*Set_Newer*/;


Set_OldStatus(FilHdr, OldStatus)
   tp_FilHdr FilHdr;
   tp_Status OldStatus;
{
   FORBIDDEN(OldStatus == ERROR || FilHdr == ERROR);
   if (OldStatus != FilHdr->HdrInf.OldStatus) {
      FilHdr->HdrInf.OldStatus = OldStatus;
      SetModified(FilHdr); }/*if*/;
   }/*Set_OldStatus*/;


tp_Status
FilHdr_OldStatus(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   FORBIDDEN(IsSource(FilHdr));
   return FilHdr->HdrInf.OldStatus;
   }/*FilHdr_OldStatus*/;


Set_Status(FilHdr, Status)
   tp_FilHdr FilHdr;
   tp_Status Status;
{
   FORBIDDEN(Status == ERROR || FilHdr == ERROR);
   if (Status != FilHdr->HdrInf.Status) {
      FilHdr->HdrInf.Status = Status;
      if (Status == STAT_Unknown) {
	 Set_ElmNameStatus(FilHdr, STAT_Unknown); }/*if*/;
      SetModified(FilHdr); }/*if*/;
   if (Status != STAT_Unknown) {
      FilHdr->VerifyDate = CurrentDate; }/*if*/;
   }/*Set_Status*/;


tp_Status
FilHdr_Status(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   return FilHdr->HdrInf.Status;
   }/*FilHdr_Status*/;


Set_ElmNameStatus(FilHdr, Status)
   tp_FilHdr FilHdr;
   tp_Status Status;
{
   FORBIDDEN(Status == ERROR || FilHdr == ERROR);
   if (Status != FilHdr->HdrInf.ElmNameStatus) {
      FORBIDDEN(!IsRef(FilHdr));
      FORBIDDEN (Status != STAT_Unknown && FilHdr->HdrInf.Status == STAT_Unknown);
      FilHdr->HdrInf.ElmNameStatus = Status;
      if (Status == STAT_Unknown) {
	 FilHdr->HdrInf.ElmNameModDate = 0;
	 Set_ElmStatus(FilHdr, STAT_Unknown); }/*if*/;
      SetModified(FilHdr); }/*if*/;
   if (Status != STAT_Unknown) {
      FilHdr->ElmNameVerifyDate = CurrentDate; }/*if*/;
   }/*Set_ElmNameStatus*/;


tp_Status
FilHdr_ElmNameStatus(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_Status Status;

   if (FilHdr == ERROR) return ERROR;
   Status = FilHdr->HdrInf.Status;
   if (!IsRef(FilHdr)) {
      return Status; }/*if*/;
   if (Status <= STAT_Error) {
      return Status; }/*if*/;
   return FilHdr->HdrInf.ElmNameStatus;
   }/*FilHdr_ElmNameStatus*/;


Set_ElmStatus(FilHdr, Status)
   tp_FilHdr FilHdr;
   tp_Status Status;
{
   FORBIDDEN(Status == ERROR || FilHdr == ERROR);
   if (Status != FilHdr->HdrInf.ElmStatus) {
      FORBIDDEN(!IsRef(FilHdr));
      FORBIDDEN (Status != STAT_Unknown && (FilHdr->HdrInf.Status == STAT_Unknown || FilHdr->HdrInf.ElmNameStatus == STAT_Unknown));
      FilHdr->HdrInf.ElmStatus = Status;
      if (Status == STAT_Unknown) {
	 FilHdr->HdrInf.ElmModDate = 0; }/*if*/;
      SetModified(FilHdr); }/*if*/;
   if (Status != STAT_Unknown) {
      FilHdr->ElmVerifyDate = CurrentDate; }/*if*/;
   }/*Set_ElmStatus*/;


tp_Status
FilHdr_ElmStatus(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_Status Status;

   if (FilHdr == ERROR) return ERROR;
   Status = FilHdr->HdrInf.Status;
   if (Status <= STAT_Error || !IsRef(FilHdr)) {
      return Status; }/*if*/;
   return FilHdr->HdrInf.ElmStatus;
   }/*FilHdr_ElmStatus*/;


tp_Status
FilHdr_MinStatus(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_Status Status, ElmStatus;

   if (FilHdr == ERROR) return ERROR;
   Status = FilHdr_Status(FilHdr);
   ElmStatus = FilHdr_ElmStatus(FilHdr);
   if (Status > ElmStatus) Status = ElmStatus;
   return Status;
   }/*FilHdr_MinStatus*/;


Set_ModDate(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.ModDate < CurrentDate) {
      FilHdr->HdrInf.ModDate = CurrentDate;
      SetModified(FilHdr); }/*if*/;
   }/*Set_ModDate*/;


tp_Date
FilHdr_ModDate(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   return FilHdr->HdrInf.ModDate;
   }/*FilHdr_ModDate*/;


Set_ConfirmDate(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.ConfirmDate < CurrentDate) {
      FilHdr->HdrInf.ConfirmDate = CurrentDate;
      SetModified(FilHdr); }/*if*/;
   }/*Set_ConfirmDate*/;


tp_Date
FilHdr_ConfirmDate(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   return FilHdr->HdrInf.ConfirmDate;
   }/*FilHdr_ConfirmDate*/;


Set_ElmNameConfirmDate(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.ElmNameConfirmDate < CurrentDate) {
      FilHdr->HdrInf.ElmNameConfirmDate = CurrentDate;
      SetModified(FilHdr); }/*if*/;
   }/*Set_ElmNameConfirmDate*/;


Set_ElmConfirmDate(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.ElmConfirmDate < CurrentDate) {
      FilHdr->HdrInf.ElmConfirmDate = CurrentDate;
      SetModified(FilHdr); }/*if*/;
   }/*Set_ElmConfirmDate*/;


Set_ElmModDate(FilHdr, ElmModDate)
   tp_FilHdr FilHdr;
   tp_Date ElmModDate;
{
   FORBIDDEN(ElmModDate == ERROR || FilHdr == ERROR);
   if (ElmModDate != FilHdr->HdrInf.ElmModDate) {
      FilHdr->HdrInf.ElmModDate = ElmModDate;
      SetModified(FilHdr); }/*if*/;
   }/*Set_ElmModDate*/;


tp_Date
FilHdr_ElmModDate(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   if (FilHdr->HdrInf.Status <= STAT_Error) {
      return FilHdr->HdrInf.ModDate; }/*if*/;
   return FilHdr->HdrInf.ElmModDate;
   }/*FilHdr_ElmModDate*/;


Set_ElmNameModDate(FilHdr, ElmNameModDate)
   tp_FilHdr FilHdr;
   tp_Date ElmNameModDate;
{
   FORBIDDEN(ElmNameModDate == ERROR || FilHdr == ERROR);
   if (ElmNameModDate != FilHdr->HdrInf.ElmNameModDate) {
      FilHdr->HdrInf.ElmNameModDate = ElmNameModDate;
      if (Data_Exists(FilHdr) && !IsSource(FilHdr)) Delete_Data(FilHdr);
      SetModified(FilHdr); }/*if*/;
   }/*Set_ElmNameModDate*/;


tp_Date
FilHdr_ElmNameModDate(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   if (FilHdr->HdrInf.Status <= STAT_Error) {
      return FilHdr->HdrInf.ModDate; }/*if*/;
   return FilHdr->HdrInf.ElmNameModDate;
   }/*FilHdr_ElmNameModDate*/;


Clear_Purged(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.Purged) {
      FilHdr->HdrInf.Purged = FALSE;
      SetModified(FilHdr); }/*if*/;
   }/*Clear_Purged*/;


boolean
FilHdr_Purged(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->HdrInf.Purged;
   }/*FilHdr_Purged*/;


Clear_TransPurged(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.TransPurged) {
      FilHdr->HdrInf.TransPurged = FALSE;
      SetModified(FilHdr); }/*if*/;
   }/*Clear_TransPurged*/;


boolean
FilHdr_TransPurged(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->HdrInf.TransPurged;
   }/*FilHdr_TransPurged*/;


Set_Flag(FilHdr, Flag)
   tp_FilHdr FilHdr;
   tp_Flag Flag;
{
   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN((FilHdr->Flag & 1<<Flag) != 0);
   FilHdr->Flag |= 1<<Flag;
   }/*Set_Flag*/;


Clr_Flag(FilHdr, Flag)
   tp_FilHdr FilHdr;
   tp_Flag Flag;
{
   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN((FilHdr->Flag & (1<<Flag)) == 0);
   FilHdr->Flag &= ~(1<<Flag);
   }/*Clr_Flag*/;


boolean
FilHdr_Flag(FilHdr, Flag)
   tp_FilHdr FilHdr;
   tp_Flag Flag;
{
   if (FilHdr == ERROR) return ERROR;
   return ((FilHdr->Flag & (1<<Flag)) != 0);
   }/*FilHdr_Flag*/;


Set_Tag(FilHdr, Tag)
   tp_FilHdr FilHdr;
   int Tag;
{
   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN(FilHdr->Tag == Tag);
   FilHdr->Tag = Tag;
   }/*Set_Tag*/;


int
FilHdr_Tag(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   return FilHdr->Tag;
   }/*FilHdr_Tag*/;


Set_SCC(FilHdr, SCC)
   tp_FilHdr FilHdr;
   tp_FilHdr SCC;
{
   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN(FilHdr->SCC == SCC);
   Ret_FilHdr(FilHdr->SCC);
   FilHdr->SCC = Copy_FilHdr(SCC);
   }/*Set_SCC*/;


tp_FilHdr
FilHdr_SCC(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN(FilHdr->SCC == NIL);
   while (FilHdr->SCC != FilHdr) FilHdr = FilHdr->SCC;
   return Copy_FilHdr(FilHdr);
   }/*FilHdr_SCC*/;


Set_TestLocHdr(FilHdr, TestLocHdr)
   tp_FilHdr FilHdr;
   tp_LocHdr TestLocHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN(FilHdr->TestLocHdr == TestLocHdr);
   FilHdr->TestLocHdr = TestLocHdr;
   }/*Set_TestLocHdr*/;


tp_LocHdr
FilHdr_TestLocHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   return FilHdr->TestLocHdr;
   }/*FilHdr_TestLocHdr*/;


tp_LocInp
FilHdr_LocInp(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->HdrInf.LocInp;
   }/*FilHdr_LocInp*/;


Set_LocElm(FilHdr, LocElm)
   tp_FilHdr FilHdr;
   tp_LocElm LocElm;
{
   tp_FilHdr CheckFilHdr;

   FORBIDDEN(FilHdr == ERROR);
   if (DebugLocElm) Validate_LocElm(FilHdr, LocElm);

   if (LocElm == FilHdr->HdrInf.LocElm) {
      FORBIDDEN(LocElm != 0);
      return; }/*if*/;

   if (FilHdr->HdrInf.LocElm != FilHdr->HdrInf.OldLocElm) {
      DeAlloc_ElmInf(FilHdr->HdrInf.LocElm); }/*if*/;
   CheckFilHdr = FilHdr_CheckFilHdr(Copy_FilHdr(FilHdr));
   if (CheckFilHdr != ERROR) {
      Make_TestLocElm(LocElm, CheckFilHdr);
      Ret_FilHdr(CheckFilHdr); }/*if*/;
   FilHdr->HdrInf.LocElm = LocElm;
   SetModified(FilHdr);
   }/*Set_LocElm*/;


tp_LocElm
FilHdr_LocElm(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->HdrInf.LocElm;
   }/*FilHdr_LocElm*/;


Set_OldLocElm(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.OldLocElm == FilHdr->HdrInf.LocElm) {
      return; }/*if*/;
   DeAlloc_ElmInf(FilHdr->HdrInf.OldLocElm);
   FilHdr->HdrInf.OldLocElm = FilHdr->HdrInf.LocElm;
   SetModified(FilHdr);
   }/*Set_OldLocElm*/;


tp_LocElm
FilHdr_OldLocElm(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->HdrInf.OldLocElm;
   }/*FilHdr_OldLocElm*/;



Set_InpLink(FilHdr, LocInp)
   tp_FilHdr FilHdr;
   tp_LocInp LocInp;
{
   FORBIDDEN(FilHdr == ERROR);
   if (LocInp != FilHdr->HdrInf.InpLink) {
      FilHdr->HdrInf.InpLink = LocInp;
      SetModified(FilHdr); }/*if*/;
   }/*Set_InpLink*/;


tp_LocInp
FilHdr_InpLink(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->HdrInf.InpLink;
   }/*FilHdr_InpLink*/;


Set_ElmLink(FilHdr, LocElm)
   tp_FilHdr FilHdr;
   tp_LocElm LocElm;
{
   FORBIDDEN(FilHdr == ERROR);
   if (LocElm != FilHdr->HdrInf.ElmLink) {
      FilHdr->HdrInf.ElmLink = LocElm;
      SetModified(FilHdr); }/*if*/;
   }/*Set_ElmLink*/;


tp_LocElm
FilHdr_ElmLink(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->HdrInf.ElmLink;
   }/*FilHdr_ElmLink*/;


Set_OriginFilHdr(SrcFilHdr, FilHdr)
   tp_FilHdr SrcFilHdr;
   tp_FilHdr FilHdr;
{
   FORBIDDEN(SrcFilHdr == ERROR || FilHdr == ERROR);
   if (SrcFilHdr->HdrInf.OriginLocHdr != FilHdr->HdrInf.LocHdr) {
      SrcFilHdr->HdrInf.OriginLocHdr = FilHdr->HdrInf.LocHdr;
      SetModified(FilHdr); }/*if*/;
   }/*Set_OriginFilHdr*/;


Set_OriginModDate(FilHdr, Date)
   tp_FilHdr FilHdr;
   tp_Date Date;
{
   FORBIDDEN(FilHdr == ERROR);
   if (Date != FilHdr->HdrInf.OriginModDate) {
      FilHdr->HdrInf.OriginModDate = Date;
      SetModified(FilHdr); }/*if*/;
   }/*Set_OriginModDate*/;


tp_Date
FilHdr_OriginModDate(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->HdrInf.OriginModDate;
   }/*FilHdr_OriginModDate*/;


