/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Flag_.h"
#include "inc/RunSpc.h"
#include "inc/Signal_.h"
#include "inc/Status_.h"
#include "inc/Str.h"
#include "inc/TClass_.h"


tp_Status
Exec(SignalPtr, RunSpc, DepStatus, IsRestore)
   tp_Signal *SignalPtr;
   tp_RunSpc RunSpc;
   tp_Status DepStatus;
   boolean IsRestore;
{
   tp_Tool Tool;
   tp_TClass TClass;
   tp_InpFilHdrs Inputs;
   tp_Prms Prms;
   tp_FileName OldErrFileName;
   tps_FileName FileName, ExecErrorFN, ErrorFileName, TmpFileName;
   tps_Str Str;
   tp_FilDsc InFD, OutFD, RefFD;
   tp_Status MinStatus;
   tp_FilHdr FilHdr, ElmFilHdr, NewElmFilHdr, CheckFilHdr, MemFilHdr;
   tp_LocElm LocElm, FirstLocElm, LastLocElm, NewLocElm;
   tp_LocElm InpLocElm, DstLocElm;
   tp_FilElm FilElm;
   int LineCount;
   tp_FilTyp FilTyp;
   int i;
   boolean Err_Flag, End;

   FORBIDDEN(RunSpc == ERROR);

   *SignalPtr = NIL;
   MinStatus = DepStatus;

   FilHdr = Copy_FilHdr(RunSpc->FilHdr);
   Tool = FilHdr_Tool(RunSpc->FilHdr);
   Inputs = RunSpc->InpFilHdrs;

   OldErrFileName = ErrFileName;
   Get_TmpFileName(ExecErrorFN);
   Set_ErrFile(ExecErrorFN);

   TClass = Tool_TClass(Tool);
   switch (TClass) {
      case TC_StructMem: {
	 CheckFilHdr = FilHdr_CheckFilHdr(Copy_FilHdr(FilHdr));
	 FORBIDDEN(CheckFilHdr == ERROR);
	 MemFilHdr =
	  Do_Deriv(Copy_FilHdr(Inputs[0]), DfltPrms, DfltPrms, FilHdr_FilTyp(FilHdr));
	 FORBIDDEN(MemFilHdr == FilHdr);
	 FORBIDDEN(IsAtmc(MemFilHdr) || !IsUpToDate(MemFilHdr));
	 Set_LocElm(FilHdr, Copy_LocElm(FilHdr_LocElm(MemFilHdr), FilHdr));
	 Ret_FilHdr(CheckFilHdr); Ret_FilHdr(MemFilHdr);
	 break;}/*case*/;
      case TC_DrvDirElm: {
	 if (MinStatus > STAT_NoFile) MinStatus = STAT_NoFile;
	 break;}/*case*/;
      case TC_Compound: {
	 FORBIDDEN(RunSpc->NumInps != 1);
	 FilHdr_DataFileName(FileName, Inputs[0]);
	 FirstLocElm = Exec_Compound(Inputs[0], FileName, FilHdr);
	 /*select*/{
	    if (IsStruct(FilHdr)) {
	       if (!IsErr()) {
		  LocElm = FirstLocElm;
		  for (i=0; i<RunSpc->NumOuts; i++) {
		     /*select*/{
			if (LocElm == ERROR) {
			   SystemError(SystemErrorFD(), "Element #%d missing.\n", i+1);
			}else{
			   FilElm = LocElm_FilElm(LocElm);
			   ElmFilHdr = FilElm_FilHdr(FilElm);
			   Set_LocElm(RunSpc->OutFilHdrs[i],
			    Make_LocElm(ElmFilHdr, FilElm_Prms(FilElm),
					RunSpc->OutFilHdrs[i]));
			   Ret_FilHdr(ElmFilHdr);
			   LocElm = FilElm_Next(FilElm);
			   Ret_FilElm(FilElm);
			   };}/*select*/; }/*for*/;
		  if (LocElm != 0) {
		     SystemError(SystemErrorFD(), "Too many elements"); }/*if*/; }/*if*/;
	       DeAlloc_ElmInf(FirstLocElm);
	    }else{
	       Set_LocElm(FilHdr, FirstLocElm); };}/*select*/;
	 break;}/*case*/;
      case TC_Collect: {
	 FORBIDDEN(RunSpc->NumInps < 1 || RunSpc->NumOuts != 1);
	 FirstLocElm = 0; LastLocElm = 0;
	 for (i=0; i<RunSpc->NumInps; i++) {
	    LocElm = Make_LocElm(Inputs[i], FilHdr_Prms(FilHdr), FilHdr);
	    Chain_LocElms(&FirstLocElm, &LastLocElm, LocElm);
	    }/*for*/;
	 Set_LocElm(FilHdr, FirstLocElm);
	 if (IsPntr(FilHdr)) Validate_IsPntr(FilHdr);
	 break;}/*case*/;
      case TC_Name: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 OutFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(OutFD == ERROR);
	 WritePrmOdinName(OutFD, Inputs[0], FilHdr_Prms(FilHdr));
	 Close(OutFD);
	 break;}/*case*/;
      case TC_Names: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 OutFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(OutFD == ERROR);
	 WriteNames(OutFD, Inputs[0], FilHdr_Prms(FilHdr));
	 Close(OutFD);
	 break;}/*case*/;
      case TC_Cat: {
	 FORBIDDEN(RunSpc->NumInps < 1 || RunSpc->NumOuts != 1);
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 OutFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(OutFD == ERROR);
	 for (i=0; i<RunSpc->NumInps; i++) {
	    WriteCat(OutFD, Inputs[i]); }/*for*/;
	 Close(OutFD);
	 break;}/*case*/;
      case TC_Homo: case TC_ImHo: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 FilTyp = FilHdr_FilTyp(FilHdr);
	 FirstLocElm = 0; LastLocElm = 0;
	 LocElm = FilHdr_LocElm(Inputs[0]); LineCount = 1;
	 while (LocElm != 0) {
	    FilElm = LocElm_FilElm(LocElm);
	    ElmFilHdr = FilElm_FilHdr(FilElm);
	    FORBIDDEN(ElmFilHdr == ERROR);

	    NewElmFilHdr = Copy_FilHdr(ElmFilHdr);
	    /*select*/{
	       if (TClass == TC_Homo && IsOdinRef(ElmFilHdr)) {
		  NewElmFilHdr = FilHdr_HomoFilHdr
		     (NewElmFilHdr,
		      Union_Prms(FilHdr_Prms(FilHdr), FilElm_Prms(FilElm)),
		      FilTyp);
	       }else{
		  NewElmFilHdr = Do_Deriv
		     (NewElmFilHdr, FilHdr_Prms(FilHdr), FilElm_Prms(FilElm),
		      FilTyp);
		  };}/*select*/;
	    /*select*/{
	       if (NewElmFilHdr != ERROR) {
		  NewLocElm = Make_LocElm(NewElmFilHdr, DfltPrms, FilHdr);
		  Chain_LocElms(&FirstLocElm, &LastLocElm, NewLocElm);
		  Ret_FilHdr(NewElmFilHdr);
	       }else{
		  FilHdr_OdinName(Str, ElmFilHdr);
		  SystemError(SystemErrorFD(), " from type <%s> at line %d :\n   %s.\n",
			      FilTyp_FTName(FilHdr_FilTyp(ElmFilHdr)),
			      LineCount, Str); };}/*select*/;
	    Ret_FilHdr(ElmFilHdr);
	    LocElm = FilElm_Next(FilElm); Ret_FilElm(FilElm);
	    LineCount += 1; }/*while*/;
	 Set_LocElm(FilHdr, FirstLocElm);
	 break;}/*case*/;
      case TC_DirElms: {
	 FORBIDDEN(!IsSource(Inputs[0]));
	 FilHdr_HostFN(FileName, Inputs[0]);
	 /*select*/{
	    if (IsDirectory_FileName(FileName)) {
	       FirstLocElm = 0; LastLocElm = 0;
	       InFD = OpenDir(FileName);
	       ReadDir(Str, &End, InFD);
	       while (!End) {
		  ElmFilHdr = Do_Key(Copy_FilHdr(Inputs[0]), Str);
		  FilHdr_HostFN(FileName, ElmFilHdr);
		  if (IsDirectory_FileName(FileName)) {
		     ElmFilHdr = FilHdr_DirElmsFilHdr(ElmFilHdr); }/*if*/;
		  LocElm = Make_LocElm(ElmFilHdr, DfltPrms, FilHdr);
		  Ret_FilHdr(ElmFilHdr);
		  Chain_LocElms(&FirstLocElm, &LastLocElm, LocElm);
		  ReadDir(Str, &End, InFD); }/*while*/;
	       CloseDir(InFD);
	       Set_LocElm(FilHdr, FirstLocElm);
	    }else{
	       FilHdr_Error("<%s> is not a directory.\n", Inputs[0]);
	       };}/*select*/;
	 break;}/*case*/;
      case TC_Error: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 OutFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(OutFD == ERROR);
	 GetReport(Inputs[0], STAT_Error, OutFD);
	 Close(OutFD);
	 break;}/*case*/;
      case TC_Warning: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 OutFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(OutFD == ERROR);
	 GetReport(Inputs[0], STAT_Warning, OutFD);
	 Close(OutFD);
	 break;}/*case*/;
      case TC_Label: {
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 OutFD = FileName_WFilDsc(FileName);
	 Writeln(OutFD, FilHdr_Label(Str, Inputs[0]));
	 Close(OutFD);
	 break;}/*case*/;
      case TC_Labels: {
	 FORBIDDEN(!IsCmpd(Inputs[0]));
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 OutFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(OutFD == ERROR);
	 WriteLabels(OutFD, Inputs[0]);
	 Close(OutFD);
	 break;}/*case*/;
      case TC_Union: {
	 FORBIDDEN(RunSpc->NumInps < 1 || RunSpc->NumOuts != 1);
	 FirstLocElm = 0; LastLocElm = 0;
	 for (i=0; i<RunSpc->NumInps; i++) {
            Do_Union(&FirstLocElm, &LastLocElm, Inputs[i],
		     FilHdr_Prms(FilHdr), FilHdr); }/*for*/;
	 for (i=0; i<RunSpc->NumInps; i++) {
	    Clr_ElmFlags(Inputs[i], FLAG_Union); }/*for*/;
	 Set_LocElm(FilHdr, FirstLocElm);
	 break;}/*case*/;
      case TC_Depend: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 FirstLocElm = 0; LastLocElm = 0;
	 GetDepend(&FirstLocElm, &LastLocElm, Inputs[0], FilHdr);
	 Set_LocElm(FilHdr, FirstLocElm);
	 break;}/*case*/;
      case TC_Sentinel: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 Set_LocElm(FilHdr, FilHdr_SentinelLocElm(Inputs[0], FilHdr));
	 break;}/*case*/;
      case TC_CopyCheck: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 2);
	 Exec_CopyCheck(&InpLocElm, &DstLocElm, RunSpc);
	 if (IsErr()) {
	    DeAlloc_ElmInf(InpLocElm); InpLocElm = 0;
	    DeAlloc_ElmInf(DstLocElm); DstLocElm = 0; }/*if*/;
	 Set_LocElm(RunSpc->OutFilHdrs[0], InpLocElm);
	 Set_LocElm(RunSpc->OutFilHdrs[1], DstLocElm);
	 break;}/*case*/;
      case TC_CopyTest: {
	 FORBIDDEN(RunSpc->NumInps != 2 || RunSpc->NumOuts != 1);
	 LocElm = Copy_LocElm(FilHdr_LocElm(Inputs[0]), FilHdr);
	 Prms = GetToolPrms(Tool, RunSpc->Prms);
	 LocElm = Append_LocElm(Prms_LocElm(Prms, FilHdr), LocElm);
	 Make_TestLocElm(LocElm, Inputs[1]);
	 Set_LocElm(FilHdr, LocElm);
	 break;}/*case*/;
      case TC_InternalPntr: {
	 break;}/*case*/;
      case TC_Expand: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 2);
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 OutFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(OutFD == ERROR);
	 I_WorkFileName(FileName, 1);
	 if (Exists(FileName)) Remove(FileName);
	 RefFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(RefFD == ERROR);
	 WriteExpand(OutFD, RefFD, Inputs[0]);
	 Close(OutFD); Close(RefFD);
	 if (!IsErr()) {
	    Set_LocElm(RunSpc->OutFilHdrs[1],
	     Exec_Compound(Inputs[0], FileName, RunSpc->OutFilHdrs[1]));
	    }/*if*/;
	 break;}/*case*/;
      case TC_CmdRef: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 (void)strcpy(Str, FilHdr_Ident(Inputs[0]));
	 Str[strlen(Str)-1] = '\0';
	 FilTyp = FTName_FilTyp(Str);
	 FORBIDDEN(FilTyp == ERROR);
	 I_WorkFileName(FileName, 0);
	 if (Exists(FileName)) Remove(FileName);
	 RefFD = FileName_WFilDsc(FileName);
	 FORBIDDEN(RefFD == ERROR);
	 WriteOdinName(RefFD, Inputs[0]);
	 WriteCmdRef(RefFD, FilTyp, Inputs[0]);
	 Close(RefFD);
	 if (!IsErr()) {
	    Set_LocElm(FilHdr, Exec_Compound(Inputs[0], FileName, FilHdr));
	    }/*if*/;
	 break;}/*case*/;
      case TC_ExpandHooks: {
	 FORBIDDEN(RunSpc->NumInps != 1 || RunSpc->NumOuts != 1);
	 FilHdr_DataFileName(FileName, Inputs[0]);
	 InFD = FileName_RFilDsc(FileName);
	 Get_TmpFileName(TmpFileName);
	 OutFD = FileName_WFilDsc(TmpFileName);
	 ExpandHooks(SignalPtr, OutFD, InFD, RunSpc->Prms, FALSE);
	 if (*SignalPtr == SIGNAL_HookError) *SignalPtr = NIL;
	 Close(InFD); Close(OutFD);
	 I_WorkFileName(FileName, 0);
	 Rename(TmpFileName, FileName);
	 Ret_TmpFileName(TmpFileName);
	 break;}/*case*/;
      default: {
	 FatalError("illegal system tool"); }}/*switch*/;

   Err_Flag = IsErr();
   Set_ErrFile(OldErrFileName);
   /*select*/{
      if (*SignalPtr != NIL) {
	 FORBIDDEN(*SignalPtr == SIGNAL_HookError);
      }else if (Err_Flag) {
	 FilHdr_ErrorFileName(ErrorFileName, FilHdr);
	 Rename(ExecErrorFN, ErrorFileName);
	 MakeReadOnly(ErrorFileName);
	 if (MinStatus > STAT_Error) MinStatus = STAT_Error;
      }else if (Has_ErrorFile(FilHdr)) {
	 FilHdr_ErrorFileName(ErrorFileName, FilHdr);
	 Remove(ErrorFileName); };}/*select*/;
   Ret_TmpFileName(ExecErrorFN);
   if (*SignalPtr == NIL) {
      Do_Update(SignalPtr, RunSpc, MinStatus, IsRestore); }/*if*/;

   Ret_FilHdr(FilHdr);
   }/*Exec*/;


