/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Flag_.h"
#include "inc/InpKind_.h"
#include "inc/Status_.h"


static boolean		Search;


GetDepend(FirstLocElmPtr, LastLocElmPtr, FilHdr, CmpdFilHdr)
   tp_LocElm *FirstLocElmPtr, *LastLocElmPtr;
   tp_FilHdr FilHdr;
   tp_FilHdr CmpdFilHdr;
{
   FORBIDDEN(Search);
   Search = TRUE;
   GetDeps(FirstLocElmPtr, LastLocElmPtr, FilHdr, IK_Trans, CmpdFilHdr);
   Search = FALSE;
   GetDeps(FirstLocElmPtr, LastLocElmPtr, FilHdr, IK_Trans, CmpdFilHdr);
   }/*GetDepend*/;


GetDeps(FirstLocElmPtr, LastLocElmPtr, FilHdr, InpKind, CmpdFilHdr)
   tp_LocElm *FirstLocElmPtr, *LastLocElmPtr;
   tp_FilHdr FilHdr;
   tp_InpKind InpKind;
   tp_FilHdr CmpdFilHdr;
{
   tp_LocElm LocElm;

   FORBIDDEN(FilHdr == ERROR);

   if (!NeedsData(FilHdr, InpKind)) {
      return; }/*if*/;

   /*select*/{
      if (Search) {
	 if (FilHdr_Flag(FilHdr, FLAG_Depend)) {
	    return; }/*if*/;
	 Set_Flag(FilHdr, FLAG_Depend);
      }else{
	 if (!FilHdr_Flag(FilHdr, FLAG_Depend)) {
	    return; }/*if*/;
	 Clr_Flag(FilHdr, FLAG_Depend); };}/*select*/;

   if (IsSource(FilHdr)) {
      if (Search) {
	 LocElm = Make_LocElm(FilHdr, DfltPrms, CmpdFilHdr);
	 Chain_LocElms(FirstLocElmPtr, LastLocElmPtr, LocElm); }/*if*/;
      return; }/*if*/;

   Get_InputDeps(FirstLocElmPtr, LastLocElmPtr, FilHdr, CmpdFilHdr);
   /*select*/{
      if (NeedsElmsData(FilHdr, InpKind)) {
	 Get_TransDeps(FirstLocElmPtr, LastLocElmPtr, FilHdr, TRUE, CmpdFilHdr);
      }else if (InpKind_IsTransName(InpKind)) {
	 Get_TransDeps(FirstLocElmPtr, LastLocElmPtr, FilHdr, FALSE, CmpdFilHdr);
	 };}/*select*/;
   }/*GetDeps*/;


Get_InputDeps(FirstLocElmPtr, LastLocElmPtr, FilHdr, CmpdFilHdr)
   tp_LocElm *FirstLocElmPtr, *LastLocElmPtr;
   tp_FilHdr FilHdr, CmpdFilHdr;
{
   tp_LocInp LocInp;
   tp_FilInp FilInp;
   tp_FilHdr InpFilHdr;

   if (IsSource(FilHdr)) return;

   LocInp = FilHdr_LocInp(FilHdr);
   while (LocInp != 0) {
      FilInp = LocInp_FilInp(LocInp);
      InpFilHdr = FilInp_FilHdr(FilInp);
      GetDeps(FirstLocElmPtr, LastLocElmPtr, InpFilHdr, FilInp_InpKind(FilInp), CmpdFilHdr);
      Ret_FilHdr(InpFilHdr);
      LocInp = FilInp_Next(FilInp);
      Ret_FilInp(FilInp); }/*while*/;
   }/*Get_InputDeps*/;


Get_TransDeps(FirstLocElmPtr, LastLocElmPtr, FilHdr, DataFlag, CmpdFilHdr)
   tp_LocElm *FirstLocElmPtr, *LastLocElmPtr;
   tp_FilHdr FilHdr;
   boolean DataFlag;
   tp_FilHdr CmpdFilHdr;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;

   if (FilHdr_Status(FilHdr) <= STAT_Error || !IsRef(FilHdr)) return;
   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      if (DataFlag || IsRef(ElmFilHdr)) {
	 GetDeps(FirstLocElmPtr, LastLocElmPtr, ElmFilHdr,
		 (DataFlag ? IK_Trans : IK_TransName), CmpdFilHdr); }/*if*/;
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;
   }/*Get_TransDeps*/;


