/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Signal_.h"
#include "inc/Status_.h"
#include "inc/Str.h"


CommandFile(SignalPtr, Root, Check)
   tp_Signal *SignalPtr;
   tp_Nod Root;
   boolean Check;
{
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr, CheckFilHdr;
   tp_Prms Prms;
   tps_FileName FileName;
   tp_FilDsc FilDsc;
   tp_Str Str;
   tps_Str StrBuf;

   *SignalPtr = NIL;
   if (Root == ERROR) return;

   PrmFHdr = Nod_PrmFHdr(Nod_Son(1, Root));
   Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
   if (FilHdr == ERROR) {
      return; }/*if*/;
   FilHdr = FilHdr_AtmFilHdr(FilHdr);
   if (FilHdr == ERROR) {
      return; }/*if*/;

   GetAllReqs(SignalPtr, FilHdr);
   if (*SignalPtr != NIL) {
      Ret_FilHdr(FilHdr);
      return; }/*if*/;
   if (FilHdr_MinStatus(FilHdr) != STAT_OK) {
      ReportStatus(FilHdr);
      Ret_FilHdr(FilHdr);
      return; }/*if*/;
   Deref_Pntrs(&FilHdr, &Prms, FilHdr, FALSE);
   if (FilHdr == ERROR) {
      return; }/*if*/;

   if (Check) {
      CheckFilHdr = Do_Deriv(Copy_FilHdr(FilHdr), Prms, DfltPrms, CheckFilTyp);
      GetAllReqs(SignalPtr, CheckFilHdr);
      if (*SignalPtr != NIL) {
	 Ret_FilHdr(FilHdr); Ret_FilHdr(CheckFilHdr);
	 return; }/*if*/;
      if (FilHdr_MinStatus(CheckFilHdr) != STAT_OK) {
	 CheckFilHdr = Do_Deriv(CheckFilHdr, DfltPrms, DfltPrms, ErrorFilTyp);
	 GetAllReqs(SignalPtr, CheckFilHdr);
	 if (*SignalPtr != NIL) {
	    Ret_FilHdr(FilHdr); Ret_FilHdr(CheckFilHdr);
	    return; }/*if*/;
	 FilHdr_DataFileName(FileName, CheckFilHdr);
	 FilDsc = FileName_RFilDsc(FileName);
	 /*select*/{
	    if (FilDsc == ERROR) {
	       FilHdr_Error("Could not read <%s>.\n", CheckFilHdr);
	    }else{
	       FileCopy(StdOutFD, FilDsc);
	       Close(FilDsc); };}/*select*/;
	 Ret_FilHdr(CheckFilHdr);
	 Ret_FilHdr(FilHdr);
	 return; }/*if*/;
      Ret_FilHdr(CheckFilHdr); }/*if*/;

   FilHdr_DataFileName(FileName, FilHdr);
   FilDsc = FileName_RFilDsc(FileName);
   if (FilDsc == ERROR) {
      FilHdr_Error("Could not read command file <%s>.\n", FilHdr);
      Ret_FilHdr(FilHdr);
      return; }/*if*/;

   Push_CWDFilHdr(FilHdr_SrcDirFilHdr(Copy_FilHdr(FilHdr)));
   Str = ReadLine(StrBuf, FilDsc);
   while (Str != ERROR) {
      if (LogLevel >= 2) {
	 Write(LogFD, "--> ");
	 Writeln(LogFD, Str); }/*if*/;
      CommandInterpreter(SignalPtr, Str);
      /*select*/{
	 if (*SignalPtr != NIL) {
	    Str = ERROR;
	 }else{
	    Str = ReadLine(StrBuf, FilDsc); };}/*select*/; }/*while*/;
   Close(FilDsc);
   Pop_CWDFilHdr();

   Update_Sentinel(SignalPtr);
   Ret_FilHdr(FilHdr);
   }/*CommandFile*/;


Display(SignalPtr, Root)
   tp_Signal *SignalPtr;
   tp_Nod Root;
{
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr, AtmFilHdr;
   tp_Prms Prms;
   tps_FileName FileName;
   tp_FilDsc InFD;

   if (Root == ERROR) return;

   PrmFHdr = Nod_PrmFHdr(Nod_Son(1, Root));
   Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
   if (FilHdr == ERROR) {
      return; }/*if*/;
   FilHdr = FilHdr_ViewFilHdr(FilHdr);
   if (FilHdr == ERROR) {
      return; }/*if*/;

   GetAllReqs(SignalPtr, FilHdr);
   if (*SignalPtr != NIL) {
      Ret_FilHdr(FilHdr);
      return; }/*if*/;
   if (FilHdr_MinStatus(FilHdr) >= STAT_Error) {
      Deref_Pntrs(&AtmFilHdr, &Prms, Copy_FilHdr(FilHdr), FALSE);
      if (AtmFilHdr != ERROR) {
	 FilHdr_DataFileName(FileName, AtmFilHdr);
	 Ret_FilHdr(AtmFilHdr);
	 InFD = FileName_RFilDsc(FileName);
	 /*select*/{
	    if (InFD == ERROR) {
	       FilHdr_Error("Could not read <%s>.\n", FilHdr);
	    }else{
	       FileCopy(StdOutFD, InFD);
	       Close(InFD); };}/*select*/; }/*if*/; }/*if*/;
   ReportStatus(FilHdr);
   Ret_FilHdr(FilHdr);
   }/*Display*/;


Copy(SignalPtr, Root)
   tp_Signal *SignalPtr;
   tp_Nod Root;
{
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr, DestFilHdr;
   tp_Prms Prms;
   tps_FileName DestFileName;

   if (Root == ERROR) return;

   PrmFHdr = Nod_PrmFHdr(Nod_Son(2, Root));
   Use_PrmFHdr(&DestFilHdr, &Prms, PrmFHdr);
   if (DestFilHdr == ERROR) {
      return; }/*if*/;

   GetAllReqs(SignalPtr, DestFilHdr);
   if (*SignalPtr != NIL) {
      Ret_FilHdr(DestFilHdr);
      return; }/*if*/;
   Deref_Pntrs(&DestFilHdr, &Prms, DestFilHdr, TRUE);
   if (DestFilHdr == ERROR) {
      return; }/*if*/;
   if (!IsSource(DestFilHdr)) {
      FilHdr_Error("<%s> must be source.\n", DestFilHdr);
      Ret_FilHdr(DestFilHdr);
      return; }/*if*/;

   PrmFHdr = Nod_PrmFHdr(Nod_Son(1, Root));
   Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
   if (FilHdr == ERROR) {
      Ret_FilHdr(DestFilHdr);
      return; }/*if*/;

   GetAllReqs(SignalPtr, FilHdr);
   if (*SignalPtr != NIL) {
      goto done; }/*if*/;
   if (FilHdr_MinStatus(FilHdr) <= STAT_Error) {
      ReportStatus(FilHdr);
      goto done; }/*if*/;

   FilHdr_DataFileName(DestFileName, DestFilHdr);
   if (IsDirectory_FileName(DestFileName)) {
      Copy_To_Directory(SignalPtr, DestFilHdr, FilHdr);
      goto done; }/*if*/;

   Copy_Atomic(SignalPtr, DestFilHdr, FilHdr);

done:
   Ret_FilHdr(FilHdr); Ret_FilHdr(DestFilHdr);
   }/*Copy*/;


Copy_To_Directory(SignalPtr, DestFilHdr, FilHdr)
   boolean *SignalPtr;
   tp_FilHdr DestFilHdr, FilHdr;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr DataFilHdr, AtmDestFilHdr, ElmFilHdr;
   tp_Prms Prms;
   tps_Str StrBuf;

   Deref_Pntrs(&DataFilHdr, &Prms, Copy_FilHdr(FilHdr), TRUE);
   if (!IsCompound(DataFilHdr)) {
      AtmDestFilHdr = Do_Key(Copy_FilHdr(DestFilHdr),
			     FilHdr_Label(StrBuf, DataFilHdr));
      if (AtmDestFilHdr == ERROR) {
	 Ret_FilHdr(DataFilHdr);
	 return; }/*if*/;
      Copy_Atomic(SignalPtr, AtmDestFilHdr, DataFilHdr);
      Ret_FilHdr(AtmDestFilHdr);
      Ret_FilHdr(DataFilHdr);
      return; }/*if*/;

   LocElm = FilHdr_LocElm(DataFilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      Copy_To_Directory(SignalPtr, DestFilHdr, ElmFilHdr);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm);
      if (*SignalPtr) {
	 return; }/*if*/; }/*while*/;
   Ret_FilHdr(DataFilHdr);
   }/*Copy_To_Directory*/;


Copy_Atomic(SignalPtr, DestFilHdr, FilHdr)
   boolean *SignalPtr;
   tp_FilHdr DestFilHdr, FilHdr;
{
   tp_FilHdr AtmFilHdr;
   tp_Prms Prms;
   boolean Abort;
   tps_FileName DestFileName, DataFileName;
   tp_FilDsc DestFD, InFD;

   AtmFilHdr = FilHdr_AtmFilHdr(Copy_FilHdr(FilHdr));
   if (AtmFilHdr == ERROR) {
      return; }/*if*/;
   GetAllReqs(SignalPtr, AtmFilHdr);
   if (*SignalPtr != NIL) {
      Ret_FilHdr(AtmFilHdr);
      return; }/*if*/;
   if (FilHdr_MinStatus(AtmFilHdr) <= STAT_Error) {
      ReportStatus(AtmFilHdr);
      return; }/*if*/;
   Deref_Pntrs(&AtmFilHdr, &Prms, AtmFilHdr, TRUE);
   if (AtmFilHdr == ERROR) {
      return; }/*if*/;
   Update_SrcFilHdr(SignalPtr, DestFilHdr, FALSE);
   if (*SignalPtr != NIL) {
      FORBIDDEN(*SignalPtr != SIGNAL_SourceMod);
      *SignalPtr = NIL; }/*if*/;
   if (!IsOrigin_FilHdr(AtmFilHdr, DestFilHdr)
       || FilHdr_ModDate(AtmFilHdr) != FilHdr_OriginModDate(DestFilHdr)) {
      FilHdr_DataFileName(DataFileName, AtmFilHdr);
      InFD = FileName_RFilDsc(DataFileName);
      if (InFD == ERROR) {
	 FilHdr_Error("Could not read <%s>.\n", AtmFilHdr);
	 goto done; }/*if*/;
      FilHdr_DataFileName(DestFileName, DestFilHdr);
      MakePlnFile(DestFileName, &Abort);
      if (Abort) {
	 Close(InFD);
	 goto done; }/*if*/;
      DestFD = FileName_RFilDsc(DestFileName);
      if (DestFD == ERROR) {
	 FilHdr_Error("Could not read <%s>.\n", DestFilHdr);
	 Close(InFD);
	 goto done; }/*if*/;
      if (!Equal(DestFD, InFD)) {
	 Rewind(InFD);
	 Close(DestFD); DestFD = FileName_WFilDsc(DestFileName);
	 if (DestFD == ERROR) {
	    FilHdr_Error("Could not write <%s>.\n", DestFilHdr);
	    Close(InFD);
	    goto done; }/*if*/;
	 FileCopy(DestFD, InFD);
	 Copy_Mode(DestFileName, DataFileName, &Abort);
	 MakeReadWrite(DestFileName, &Abort); }/*if*/;
      Close(DestFD); Close(InFD);
      Update_SrcFilHdr(SignalPtr, DestFilHdr, TRUE);
      if (*SignalPtr != NIL) {
	 FORBIDDEN(*SignalPtr != SIGNAL_SourceMod);
	 *SignalPtr = NIL; }/*if*/;
      Set_OriginFilHdr(DestFilHdr, AtmFilHdr);
      Set_OriginModDate(DestFilHdr, FilHdr_ModDate(AtmFilHdr)); }/*if*/;
   ReportStatus(AtmFilHdr);

done:
   Ret_FilHdr(AtmFilHdr);
   }/*Copy_Atomic*/;


Edit(SignalPtr, Root)
   tp_Signal *SignalPtr;
   tp_Nod Root;
{
   tp_PrmFHdr PrmFHdr;
   tps_FileName DataFileName;
   tp_FilHdr FilHdr;
   tp_Prms Prms;
   tp_Str Editor;
   tps_Str CmdStr;

   *SignalPtr = NIL;
   if (Root == ERROR) return;

   PrmFHdr = Nod_PrmFHdr(Nod_Son(1, Root));
   Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
   if (FilHdr == ERROR) goto done;

   Editor = EditorName;
   if (Nod_NumSons(Root) > 1) Editor = Sym_Str(Nod_Sym(Nod_Son(2, Root)));

   FilHdr = FilHdr_AtmFilHdr(FilHdr);
   if (FilHdr == ERROR) goto done;
   GetAllReqs(SignalPtr, FilHdr);
   if (*SignalPtr != NIL) {
      goto done; }/*if*/;
   if (FilHdr_MinStatus(FilHdr) <= STAT_SysAbort) {
      ReportStatus(FilHdr);
      goto done; }/*if*/;

   Deref_Pntrs(&FilHdr, &Prms, FilHdr, FALSE);
   if (FilHdr == ERROR) {
      goto done; }/*if*/;

   FilHdr_DataFileName(DataFileName, FilHdr);

   (void)strcpy(CmdStr, Editor);
   (void)strcat(CmdStr, " ");
   (void)strcat(CmdStr, DataFileName);

   Unlock_Info(SignalPtr);
   if (*SignalPtr != NIL) goto done;
   (void)system(CmdStr);
   Lock_Info(SignalPtr);
   if (*SignalPtr != NIL) goto done;

   /*select*/{
      if (IsSource(FilHdr)) {
	 Test_SrcFilHdr(SignalPtr, FilHdr, TRUE);
	 if (*SignalPtr != NIL) {
	    FORBIDDEN(*SignalPtr != SIGNAL_SourceMod);
	    *SignalPtr = NIL; }/*if*/;
      }else{
	 GetAllReqs(SignalPtr, FilHdr); };}/*select*/;
   if (*SignalPtr != NIL) {
      goto done; }/*if*/;
   ReportStatus(FilHdr);

done:
   Ret_FilHdr(FilHdr);
   }/*Edit*/;


HostCommand(SignalPtr, Root)
   tp_Signal *SignalPtr;
   tp_Nod Root;
{
   tps_Str CmdStr, StrBuf;
   tp_Str Cmd, OdinName;
   tps_FileName RefFileName;
   tp_FilDsc RefFD;
   tp_Status Status, MinStatus;
   tp_FilHdr CWDFilHdr, FilHdr;
   boolean MacroFlag;

   *SignalPtr = NIL;
   MinStatus = STAT_OK;
   (void)strcpy(CmdStr, "csh -f << endcsh\n");
   (void)strcat(CmdStr, "cd ");
   CWDFilHdr = Top_CWDFilHdr();
   FilHdr_HostFN(Tail(CmdStr), CWDFilHdr);
   (void)strcat(CmdStr, "\n");
   Ret_FilHdr(CWDFilHdr);
   Cmd = Sym_Str(Nod_Sym(Root));
   MacroFlag = Has_Macro(Cmd);
   /*select*/{
      if (MacroFlag) {
	 Get_TmpFileName(RefFileName);
	 RefFD = FileName_WFilDsc(RefFileName);
	 FORBIDDEN(RefFD == ERROR);
	 Expand_MacroLine(Tail(CmdStr), RefFD, Cmd,
	  (tp_RunSpc)NIL, (tp_Tool)NIL, (tp_PrmFTLst)NIL, (tp_OutTyps)NIL);
	 Close(RefFD);
	 RefFD = FileName_RFilDsc(RefFileName);
	 OdinName = Readln(StrBuf, RefFD);
	 while (OdinName != ERROR) {
	    FilHdr = OdinName_FilHdr(OdinName);
	    if (!IsSource(FilHdr)) {
	       GetAllReqs(SignalPtr, FilHdr);
	       if (*SignalPtr != NIL) {
		  Close(RefFD);
		  return; }/*if*/;
	       ReportStatus(FilHdr);
	       Status = FilHdr_MinStatus(FilHdr);
	       if (MinStatus > Status) MinStatus = Status; }/*if*/;
	    Ret_FilHdr(FilHdr);
	    OdinName = Readln(StrBuf, RefFD); }/*while*/;
	 FORBIDDEN(!EndOfFile(RefFD));
	 Close(RefFD);
	 Ret_TmpFileName(RefFileName);
      }else{
	 (void)strcat(CmdStr, Cmd); };}/*select*/;
   if (MinStatus <= STAT_Error) {
      return; }/*if*/;
   (void)strcat(CmdStr, "\n");
   (void)strcat(CmdStr, "endcsh\n");
   Unlock_Info(SignalPtr);
   if (*SignalPtr != NIL) {
      return; }/*if*/;
   (void)system(CmdStr);
   Lock_Info(SignalPtr);
   if (*SignalPtr != NIL) {
      return; }/*if*/;
   if (MacroFlag) {
      RefFD = FileName_RFilDsc(RefFileName);
      OdinName = Readln(StrBuf, RefFD);
      while (OdinName != ERROR) {
	 FilHdr = OdinName_FilHdr(OdinName);
	 if (IsSource(FilHdr)) {
	    Test_SrcFilHdr(SignalPtr, FilHdr, TRUE);
	    if (*SignalPtr != NIL) {
	       FORBIDDEN(*SignalPtr != SIGNAL_SourceMod);
	       *SignalPtr = NIL; }/*if*/; }/*if*/;
	 Ret_FilHdr(FilHdr);
	 OdinName = Readln(StrBuf, RefFD); }/*while*/;
      FORBIDDEN(!EndOfFile(RefFD));
      Close(RefFD); }/*if*/;
   }/*HostCommand*/;


