# $Id: Makefile.cpp,v 1.27 91/07/17 17:23:20 waite Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh

# hack for Sun auto-mounter
PWD	= pwd | sed 's,^/tmp_mnt,,'

# Default master cache location
DESTDIR	= `expr \`$(PWD)\`'/' : '\(.*[^/]\)/[^/]*/'`

COFLAGS	= -q

SYS	= eli.l
EXE	= eli.info

TIDY	= *.o *.a core a.out ERRS
CLEAN	= $(TIDY)
CLOBBER	= $(CLEAN) Makefile

all:	$(EXE) $(SYS)
	-@if test ! -d $(DESTDIR)/bin; \
		then umask 002; mkdir $(DESTDIR)/bin; \
		else :; \
	fi
	@for f in $(EXE); do \
		rm -f $(DESTDIR)/bin/$$f; \
		ln -s `$(PWD)`/$$f $(DESTDIR)/bin/$$f; \
	done

install:   $(EXE) $(SYS)
	-@if test ! -d $(DESTDIR)/bin; \
		then umask 002; mkdir $(DESTDIR)/bin; \
		else :; \
	 fi
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/bin/$$f; \
		rm -f $(DESTDIR)/bin/$$f; \
		cp $$f $(DESTDIR)/bin/$$f; \
		chmod 755 $(DESTDIR)/bin/$$f; \
	done
	-@if test ! -d $(DESTDIR)/manl; \
		then umask 002; mkdir $(DESTDIR)/manl; \
		else :; \
	fi
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/manl/$$f; \
		rm -f $(DESTDIR)/manl/$$f; \
		cp $$f $(DESTDIR)/manl/$$f; \
		chmod 644 $(DESTDIR)/manl/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp

SourceDistr:	$(SYS)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean -q $(SYS) Makefile.cpp
	rm -rf $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SYS)
	-rcs -bOriginal.1 -q Makefile.cpp $(SYS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SYS)

.PRECIOUS:	$(SYS)




