# $Id$
# Skeleton for RCS Makefile
# Copyright (c) 1992, The Regents of the University of Colorado

# SUBDIR	Subdirectories having files under RCS control (may be empty)
# RCS		Local files under RCS control (may be empty)
# COPY		Files or subdirectories to be distributed (may be empty)
# GEN		Files (except makefiles) generated by Configure (may be empty)

SHELL	= /bin/sh

# Make the default co quiet.
COFLAGS	= -q

all:	$(RCS)
	@-L='$(SUBDIR)'; if test "$$L" != ''; then \
		for i in $$L; do echo; echo RCSMaking $$i; \
		(cd $$i; make -f rcsmkfile all COFLAGS='$(COFLAGS)'); done; \
		fi

distribute:	$(COPY) Makefile.cpp
	@-if test ! -d $(DESTDIR); then mkdir $(DESTDIR); fi
	@for i in $(COPY) Makefile.cpp; do \
		if test -d $$i; \
		then \
			if test -f $$i/rcsmkfile; \
			then \
				echo; echo Source $$i; \
				(cd $$i; \
				make -f rcsmkfile distribute \
					DESTDIR=$(DESTDIR)/$$i \
					COFLAGS='$(COFLAGS)'); \
			else \
				echo; echo Copying $$i; \
				find $$i -name '*,v' -print > distrib.lst; \
				tar cfX - distrib.lst $$i | \
					(cd $(DESTDIR); tar xf - ); \
				rm -f distrib.lst; \
			fi; \
		else cp $$i $(DESTDIR); \
		fi; \
	done
	@chmod -R u+w $(DESTDIR)

rcsclean:
	@-L='$(SUBDIR)'; if test "$$L" != ''; then \
		for i in $$L; do echo; echo RCScleaning $$i; \
		(cd $$i; make -f rcsmkfile rcsclean COFLAGS='$(COFLAGS)'); done; \
		fi
	-rcsclean -u $(COFLAGS) $(RCS) Makefile.cpp rcsmkfile.cpp
	rm -rf *.o *~ core a.out ERRS Makefile rcsmkfile $(GEN)

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp rcsmkfile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp rcsmkfile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q Makefile.cpp rcsmkfile.cpp $(RCS)
	@-L='$(SUBDIR)'; if test "$$L" != ''; then \
		for i in $$L; do echo; echo Saving $$i; \
		(cd $$i; make -f rcsmkfile save); done; \
		fi

.PRECIOUS:	$(RCS)
