#!/bin/sh
# $Id: format.cmd,v 1.4 1992/07/06 19:20:07 waite Exp $
# Copyright, 1990, The Regents of the University of Colorado

#format <
#   dvi "Device-independent formatted file from TeX"*
#   index_entries "Index entries for this formatted file"*
#   > "Formatted file and index entries"* :
#        USER
#                : aux_tex
#                : tnf

name=`basename (|<<tnf|)/* .tnf`

cd (|<<aux_tex|)
(|$/Tool/texinfo/texindex|) *.??
cp *.??s *.aux (|<<tnf|)
chmod 666 (|<<tnf|)/*.aux

cd (|<<tnf|)

# Produce the formatted version of the document

ln -s (|$/Tool/texinfo/texinfo.tex|) .
ln -s (|$/Tool/texinfo/org.tnf|) .
ln -s (|$/Tool/texinfo/padorg.tnf|) .

ln -s (|$/Tool/liga/Info|)/*.ps (|$/Tool/liga/Info/psfig.tex|) .
if (tex \\batchmode \\input (|<tnf|) > /dev/null) 
then rm -f psfig.tex *.ps
else
	rm -f psfig.tex *.ps
	cp *.log (|>ERROR|) 
	cp /dev/null (|>dvi|)
	cp /dev/null (|>index_entries|)
	exit 0
fi

mv *.dvi (|>dvi|)

# Merge all of the index entries together
# (for later use in production of a global index)

touch (|>index_entries|)
for i in (|<<aux_tex|)/*.??
do
	sed -e "s/}{\([0123456789]*\)}{/}{\1-${name}}{/" \
			< $i >> (|>index_entries|)
done

exit 0

