#include <stdio.h>
#include <string.h>

static char rcsid[]="$Id: map_errors.c,v 1.1 1991/01/07 11:29:01 waite Exp $";
/* Attribute error messages to the proper lines of component files */
/* Copyright (c) 1990, The Regents of the University of Colorado */

FILE *fopen();

static FILE *xt;
static char FileName[BUFSIZ], NextFile[BUFSIZ];
static int Another, NextIncr, Limit, Increment;

/**/
void
NextBreak()
/* Advance to the next breakpoint
 * On entry-
 *    NextFile=File name from the next table line
 *    NextIncr=Increment from the next table line
 * On exit-
 *    FileName=Name of the file from which the next text was taken
 *    Increment=Line number correction
 *    If there is another breakpoint then
 *       Another != 0
 *       Limit=next breakpoint
 *       NextFile=next file name
 *       NextIncr=next line number correction
 *    else
 *       Another == 0
 **/
{
   (void)strcpy(FileName, NextFile); Increment = NextIncr;
   Another = (fscanf(xt, "%d %d %s\n", &Limit, &NextIncr, NextFile) != EOF);
}

/**/
void
ErrTabInit(fn)
char *fn;
/* Initialize Translation Table
 *    On entry-
 *       fn=name of the translation table file
 **/
{
   if ((xt = fopen(fn, "r")) == NULL) {
      (void)fprintf(stderr, "Could not open table %s\n", fn);
      exit(1);
   }
   (void)strcpy(NextFile, "."); NextIncr = 0;
   NextBreak();
   return;
}

main(argc,argv)
int argc; char *argv[];
{
   int c, ErrorLineNumber;

   if (argc != 2) {
      (void)fprintf(stderr, "Usage %s errtab\n", argv[0]);
      exit(1);
   }

   ErrTabInit(argv[1]);

   while (scanf("%d", &ErrorLineNumber) != EOF) {
      while (Another && ErrorLineNumber >= Limit) NextBreak();
      (void)printf("%s %d", FileName, ErrorLineNumber + Increment);
      while ((c = getchar()) && c != '\n') putchar(c);
      putchar('\n');
   }
}
