#!/bin/sh
# $Id: c.o.cmd.cpp,v 1.10 1992/08/10 20:26:56 kadhim Exp $
# Copyright (c) 1990, The Regents of the University of Colorado

# c.o "C object module"* :
# 	USER
# 		: c_srcs
# 		+ debug
# 		+ prof
# 		+ define

umask 0
cd (|<<c_srcs|)

if test -f (|<debug|)
then if test -s (|<debug|)
	then debug=`cat (|<debug|)`
	else debug=-g
     fi
else define='-DODIN_IGNORE'
     if test -f (|<prof|)
        then if test -s (|<prof|)
		then prof=`cat (|<prof|)`
#ifdef ultrix
		else prof=-p
#else
#ifdef hpux
		else prof=-G
#else
		else prof=-pg
#endif
#endif
	     fi
     fi
fi

if test -f (|<define|)
then for def in `cat (|<define|)`; do define="$define -D$def"; done
fi

#ifdef _AIX
CCPROG=${ELI_CC-"cc -qlanglvl=ansi"}
#else
CCPROG=${ELI_CC-cc}
#endif

${CCPROG} -c $debug $prof $define *.c >ERRORS 2>&1
ofile=`basename *.c .c`.o
if test -f $ofile
then
	mv $ofile (|>c.o|)
fi

if test -s ERRORS
then

#ifdef _AIX
	i=`echo *.c`
	sed -e "s/^/$i 0 0 /" ERRORS >ERROR
#else
	# Error formats:
	# cc:  "fred.c", line 9: an error message
	# gcc: fred.c:9: an error message
	# Remove extra gcc messages
	sed -e '/^In file included from /d
		/: At top level/d
		/: In function /d
		/: (Each undeclared identifier/d
		/: for each function/d
		s/^\([^:]*\): *\([0-9]*\):/\1 \2 0/
		s/^"\([^"]*\)". line \([0-9]*\):/\1 \2 0/
		s;^\.\/;;
		/arning/{
			s/.arning: //w WARN
			d
		}' ERRORS >ERROR
#endif

	if test -s ERROR
	then
		echo '(''|(|<c_srcs|):err_map:' >(|>ERROR|)
		cat ERROR >>(|>ERROR|)
		echo '|'')' >>(|>ERROR|)
	fi

	if test -s WARN
	then
		echo '(''|(|<c_srcs|):err_map:' >(|>WARNING|)
		cat WARN >>(|>WARNING|)
		echo '|'')' >>(|>WARNING|)
	fi
fi

exit 0
