# $Id: Makefile.cpp,v 1.14 1992/08/02 21:31:41 kadhim Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/skeleton

COFLAGS	= -q

XCMD	= batch_dbx.cmd batch_gdb.cmd batch_run.cmd err_map.cmd \
	  cpp.cmd cpp_err.cmd cpp_tab.cmd dbx.cmd dg_out.cmd extract.cmd \
	  gdb.cmd incl.cmd incl.dir.cmd index.cmd profile.cmd run.cmd \
	  v.compound.cmd delete.cmd err.cmd warn.cmd no_map.cmd
GENCMD	= c.o.cmd c_dep.cmd
CMD	= $(GENCMD) $(XCMD)
CPPCMD	= c.o.cmd.cpp c_dep.cmd.cpp
SRCCMD	= $(CPPCMD) $(XCMD)
AUX	= idioms.h skeleton.dg execute.dg
SRC	= map_errors.c err_tab.c err_map.c mk_include.c get_incl.c \
	  type_sel.c obstack.c obstack.h cat-n.c
EXE	= map_errors.exe err_tab.exe err_map.exe mk_include.exe \
	get_incl.exe type_sel.exe cat-n.exe
SYS	= line_err.awk
RCS 	= $(SRCCMD) $(AUX) $(SRC) $(SYS)
#ifdef hpux
LIBS	= -lBSD
#endif

TIDY	= core ERRS *.o a.out
CLEAN	= $(TIDY) *.a *.exe
CLOBBER	= $(CLEAN) Makefile $(GENCMD)

all:	$(CMD) $(AUX) $(EXE) $(SYS)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 755 $(DESTDIR)/$(DIR)/$$f; \
	done
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR)/$$f; \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(AUX) $(SRC) $(CPPCMD)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

.SUFFIXES:      .exe
.c.exe:
	$(CC) $(CFLAGS) -o $@ $*.c $(LIBS)

err_map.exe:	err_map.c obstack.c obstack.h
	$(CC) $(CFLAGS) -o err_map.exe err_map.c obstack.c
