#include <stdio.h>

static char rcsid[]="$Id: rel_err.c,v 1.4 1991/04/06 16:55:12 tony Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

FILE *fopen();

static FILE *out;
static char OutFileName[100];
static int OutLineCount;

void
OutputInit(fn)
char *fn;
{
   if ((out = fopen(fn, "w")) == NULL) {
           (void)fprintf(stderr, "Could not open output file %s\n", fn);
           exit(1);
        }

   OutFileName[0] = '\0';
   OutLineCount = 0;
}

void
OutputReport(msg)
char *msg;
{
   if (OutLineCount == 0) {
      (void)fprintf(out, "In file %s:\n", OutFileName);
   }
   (void)fprintf(out, "	%s", msg);
   OutLineCount++;
}

void
SetOutFile(flag)
int flag;
{
   if (OutLineCount != 0) (void)fputc('\n', out);
   if (flag != 0) {
      (void)fprintf(stderr, "# flag = %d\n", flag);
      exit(1);
   }
   OutLineCount = 0;
}

void
OutputFinl()
{
}

static FILE *e;
static char ErrorMessage[BUFSIZ];

int
NextErrorLine()
{
   char ErrorLine[BUFSIZ], *p;
   int lno;

   do { if (fgets(ErrorLine, BUFSIZ, e) == NULL) return(-1); }
   while (ErrorLine[0] == '\n');
   (void)sscanf(ErrorLine, "%d", &lno);
   p = (char *)index(ErrorLine, 'C'); (void)strcpy(ErrorMessage, p);
   return(lno);
}

int
ErrorInit(fn)
char *fn;
{
   if ((e = fopen(fn, "r")) == NULL) {
           (void)fprintf(stderr, "Could not open error file %s\n", fn);
           exit(1);
        }

   return(NextErrorLine());
}

int
ErrorReport(inputline,outputline)
int inputline,outputline;
{
   int lno;
   char ErrorLine[BUFSIZ];

   do {
      (void)sprintf(ErrorLine, "LINE %d %s", outputline, ErrorMessage);
      OutputReport(ErrorLine);
      lno = NextErrorLine();
   } while (inputline == lno);
   return(lno);
}

main(argc,argv)
int argc; char *argv[];
{
   char FileLine[BUFSIZ];
   int FileLineNumber, ErrorLineNumber, OutLineNumber, IncludeFlag;
   FILE *f;

   if (argc != 4) {
      (void)fprintf(stderr, "Usage %s errors file output\n", argv[0]);
      exit(1);
   }

   ErrorLineNumber = ErrorInit(argv[1]);

   if ((f = fopen(argv[2], "r")) == NULL) {
           (void)fprintf(stderr, "Could not open input file %s\n", argv[2]);
           exit(1);
        }

   OutputInit(argv[3]);

   FileLineNumber = 1;
   while (fgets(FileLine, BUFSIZ, f) != NULL) {
      if (FileLine[0] == '#') {
         IncludeFlag = 0;
         (void)sscanf(FileLine, "# %d \"%[^\"]\" %d",
            &OutLineNumber, OutFileName, &IncludeFlag);
         SetOutFile(IncludeFlag);
      } else {
         if (FileLineNumber == ErrorLineNumber) {
            ErrorLineNumber = ErrorReport(FileLineNumber, OutLineNumber);
            if (ErrorLineNumber == -1) break;
         }
         OutLineNumber++;
      }
      FileLineNumber++;
   }

   OutputFinl();
}
