# $Id: Makefile.cpp,v 1.28 1992/07/29 15:33:55 kadhim Exp $
# Copyright (c) 1990, University of Paderborn.

SHELL	= /bin/sh
CFLAGS	=

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/ptg

COFLAGS	= -q

SPECS	= ptgext.h ptgext.c ptgleaf.h ptgleaf.c ptgerr.c \
	  LIGA.h ptg.h ptg.c ptggla.c \
	  ptg.specs ptg.gla ptg.lido mk.ptg
EXE	= ptg.exe
AUX	= ptg.tnf ptg.dg
SYS	= ptg.err ptgadt.head
CMD	= ptg_gen.cmd ptg_out.cmd
SRCS	= $(SPECS) $(SYS) $(AUX) $(CMD)

TIDY	= *.o core a.out ELI *.dvi *.alw *.ps
CLEAN	= $(TIDY) *.exe
CLOBBER	= $(CLEAN) derivedSrcs Makefile

all:	$(EXE) $(AUX) $(SYS) $(CMD)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/ptg; \
		rm -f $(DESTDIR)/Tool/ptg/$$f; \
		cp $$f $(DESTDIR)/Tool/ptg/$$f; \
		chmod 644 $(DESTDIR)/Tool/ptg/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/ptg/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/Tool/ptg; \
		rm -f $(DESTDIR)/Tool/ptg/$$f; \
		cp $$f $(DESTDIR)/Tool/ptg/$$f; \
		chmod 755 $(DESTDIR)/Tool/ptg/$$f; \
	done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/ptg; \
		rm -f $(DESTDIR)/Tool/ptg/$$f; \
		cp $$f $(DESTDIR)/Tool/ptg; \
		chmod 644 $(DESTDIR)/Tool/ptg/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp derivedSrcs $(AUX)

SourceDistr:	$(SYS) $(AUX) $(CMD)
	mkdir derivedSrcs
	cp $(ELI)/derivedSrcs/* derivedSrcs
	cd derivedSrcs; make clean

tidy:
	rm -rf $(TIDY)
	-cd derivedSrcs; make tidy

clean:
	rm -rf $(CLEAN)
	-cd derivedSrcs; make clean

clobber:
	rm -rf $(CLOBBER)

rcsclean:	clean
	-rcsclean $(COFLAGS) $(SRCS) Makefile.cpp
	rm -f Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u $(COFLAGS) Makefile.cpp $(SRCS)
	-rcs -bOriginal.1 $(COFLAGS) Makefile.cpp $(SRCS)
	-ci -fOriginal.1 -m/dev/null $(COFLAGS) -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null $(COFLAGS) $(SRCS)

derive: derivedSRCS

derivedSRCS: $(SPECS) ELI
	$(DESTDIR)/bin/eli -c ELI <mk.ptg

ELI:
	$(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q

.PRECIOUS:	$(SRCS)


$(EXE):
	cd derivedSrcs; make CC="$(CC)" ptg.exe
	rm -f ptg.exe; ln derivedSrcs/ptg.exe .
