SHELL	= /bin/sh

#ifdef _AIX
CC	= cc -qlanglvl=ansi
#endif

CFLAGS	= 

OBJS    = driver.o parse.o err.o source.o glahead.o Ctext.o obstack.o \
	auxScanEOL.o idn.o csm.o CchStr.o str.o Ccomment.o pgs_gen.o treecon.o \
	visitprocs.o ptg_gen.o func.o pdl_gen.o deftbl.o envmod.o name.o type.o \
	header.o treestack.o attrmain.o dfltclp.o

EXE	= pdl.exe

$(EXE):	$(OBJS)
	$(CC) -o $(EXE) $(CFLAGS) $(OBJS)

objects: $(OBJS)

clean:
	rm -f a.out *.o *.a *~ core ERRS $(EXE)

tidy:
	rm -f core a.out *.o *~ *.a ERRS

driver.o:       driver.c HEAD.h INIT.h FINL.h treecon.h pdl_gen.h \
deftbl.h ptg_gen.h name.h type.h func.h header.h treestack.h deftbl.h \
ptg_gen.h func.h header.h envmod.h deftbl.h deftbl.h 
parse.o:        parse.c parse.h pgs_gen.h err.h gla.h 
err.o:  err.c err.h source.h 
source.o:       source.c source.h 
glahead.o:      glahead.c err.h source.h xtables.h xcode.h 
Ctext.o:        Ctext.c err.h source.h gla.h obstack.h 
obstack.o:      obstack.c obstack.h 
auxScanEOL.o:   auxScanEOL.c err.h gla.h source.h 
idn.o:  idn.c err.h idn.h csm.h idntbl.h 
csm.o:  csm.c csm.h err.h csmtbl.h 
CchStr.o:       CchStr.c err.h source.h gla.h 
str.o:  str.c str.h csm.h 
Ccomment.o:     Ccomment.c err.h gla.h source.h 
pgs_gen.o:      pgs_gen.c parse.h treecon.h err.h gla.h treestack.h 
treecon.o:      treecon.c HEAD.h node.h visitprocs.h gsdescr.h \
obstack.h treecon.h pdl_gen.h deftbl.h ptg_gen.h name.h type.h func.h \
header.h treestack.h deftbl.h ptg_gen.h func.h header.h envmod.h \
deftbl.h deftbl.h err.h 
visitprocs.o:   visitprocs.c HEAD.h err.h node.h visitprocs.h glattr.h \
attrpredef.h treecon.h pdl_gen.h deftbl.h ptg_gen.h name.h type.h \
func.h header.h treestack.h deftbl.h ptg_gen.h func.h header.h envmod.h \
deftbl.h deftbl.h err.h 
ptg_gen.o:      ptg_gen.c ptg_gen.h 
func.o: func.c err.h deftbl.h envmod.h ptg_gen.h func.h pdl_gen.h csm.h \
deftbl.h deftbl.h ptg_gen.h func.h header.h 
pdl_gen.o:      pdl_gen.c deftbl.h pdl_gen.h deftbl.h ptg_gen.h func.h \
header.h 
deftbl.o:       deftbl.c err.h deftbl.h 
envmod.o:       envmod.c err.h envmod.h deftbl.h 
name.o: name.c err.h csm.h deftbl.h envmod.h ptg_gen.h func.h header.h \
name.h pdl_gen.h deftbl.h envmod.h deftbl.h deftbl.h ptg_gen.h func.h \
header.h 
type.o: type.c ptg_gen.h deftbl.h envmod.h func.h pdl_gen.h type.h \
deftbl.h deftbl.h ptg_gen.h func.h header.h deftbl.h 
header.o:       header.c err.h deftbl.h envmod.h ptg_gen.h func.h \
pdl_gen.h csm.h deftbl.h deftbl.h ptg_gen.h func.h header.h 
treestack.o:    treestack.c err.h treecon.h treestack.h treestack.h 
attrmain.o:     attrmain.c treecon.h visitprocs.h treestack.h 
dfltclp.o:      dfltclp.c source.h 
