# $Id: Makefile.cpp,v 1.5 1992/07/13 05:04:52 kadhim Exp $
# Property definition language translator
# Copyright (c) 1989, The Regents of the University of Colorado

# Location of the master cache
DESTDIR = ELISYS

# Relative location of the current directory
DIR	= Tool/pdl

# Tool implementation files
SRC	= deftbl.head deftbl.c deftbl.h pdl.err lib.pdl
EXE	= pdl.exe
CMD	= pdlOut.cmd pdlGen.cmd
AUX	= pdl.dg deftbl.tnf derivedSrcs

SHELL	= /bin/sh

TIDY	= core a.out *.o *~
CLEAN	= $(TIDY) $(EXE)

all:	$(SRC) $(CMD) $(EXE)
	@-if test '$(CMD)' != ''; then for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
		done; fi

install:
	@-if test '$(SRC) $(CMD)' != ''; then for f in $(SRC) $(CMD); do \
		echo install -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
		done; fi
	@for f in $(EXE); do \
		echo install -m 755 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 755 $(DESTDIR)/$(DIR)/$$f; \
		done
	@-if test '$(CMD)' != ''; then for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
		done; fi

executable:
	rm -rf $(TIDY) $(AUX) Makefile Makefile.cpp

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(TIDY) $(CLEAN)
	cd derivedSrcs; make clean

pdl.exe:
	cd derivedSrcs; make CC="$(CC)"
	mv derivedSrcs/pdl.exe .
