/*
  $Id: oiladt2b.c,v 1.13 1992/01/21 08:25:10 waite Exp $
Copyright, 1989, The Regents of the University of Colorado
*/

#include <stdio.h>
#include "oiladt2.h"

#ifndef WithIDs
	'WithIds' must be turned on !!!
	for both oiladt2b and oiladt2a
#endif


/******************************************************
  DumpFile - the file to dump the rep on
  */
  FILE * DumpFile;


/******************************************************
  Dump - increment state
  */
#define Dump t->sStat+=1; fprintf( DumpFile,


/******************************************************
  pRef - reference to a ptr
  */
#define pRef(str,dmp,comp) if(t->comp!=nil) dmp(t->comp)


/******************************************************
  First - check the status and emit 'extern' if necessary
  */
#define First(str) if (t->sStat>0) {\
    if (t->sStat==1) RecRef(t->sID,str); t->sStat+=1; return;} else \
    t->sStat+=1;


/******************************************************
  tRef - is the ptr a nil reference ??
  */
#define tRef(str,comp) (t->comp==nil)? NilFmt : FmtRef(t->comp->sID,str)


/******************************************************
  NilFmt - used for representing 'nil' ptr
  */
char *NilFmt="nil";


/******************************************************
  FmtBufs - set of circular buffers us for constructing ptr names
      (see FmtRef)
  */
static char Buf1[18];
static char Buf2[18];
static char Buf3[18];
static char Buf4[18];
char *FmtBufs[]={ Buf1, Buf2, Buf3, Buf4 };


/******************************************************
  FmtName - buffer use to rep name string
  */
char FmtName[41];



/******************************************************
  vOilBufIndex - index into FmtBufs
  */
int vOilBufIndex=0;



/******************************************************
  FmtRef - fmt a reference to a ptr
  */
char *FmtRef( v, s ) int v; char *s; {
	char *rs;
    rs=FmtBufs[vOilBufIndex= (vOilBufIndex+1)%4];
    sprintf( rs, "&%s%d", s, v );
    return( rs );
  }


/******************************************************
  NameRef - fmt an object's name
  */
char *NameRef( n ) int n; {
        char *rs;
    rs=FmtName;
    sprintf( rs, "%d", n );
    return( rs );
    }


/******************************************************
  RecRef - a recursive reference requires an 'extern' declaration
  */
void RecRef( v, s ) int v; char *s; {
    fprintf(DumpFile, "\n  extern struct %s%d;\n", s, v );
  }


/******************************************************
  Object name prefixes
  */
char
	*Ct="Oil_t",
	*Cs="Oil_s",
	*Ccc="Oil_cc",
	*Co="Oil_o",
	*Crs="Oil_rs",
	*Coid="Oil_oid",
	*Css="Oil_ss",
	*Ccoid="Oil_coid",
	*Cco="Oil_co",
	*Ctd="Oil_td",
	*Cc="Oil_c";


/******************************************************
  Declaration prefixes ( which type of object )
  */
char
        *Et="Stype Oil_t",
        *Es="Ssig Oil_s",
        *Ecc="ScoercionSeq Oil_cc",
        *Eo="Sop Oil_o",
        *Ers="StypeSet Oil_rs",
        *Eoid="SopIdent Oil_oid",
        *Ess="SsetSig Oil_ss",
        *Ecoid="SclassOpId Oil_coid",
        *Eco="SclassOp Oil_co",
        *Etd="SclassArgSig Oil_td",
	*Ec="Sclass Oil_c";


/******************************************************
  Declaration formats
  */

#ifdef ForDebugging

#define Dt "struct %s%d={ %d, 0, %s, %s, %s, %s, %s };\n",Et,t->sID,
#define Ds "struct %s%d={ %d, 0, %s, %s, %s };\n",Es,t->sID,
#define Do "struct %s%d={ %d, 0, %s, %d, %s, %s, %s };\n",Eo,t->sID,
#define Dcc "struct %s%d={ %d, 0, %s, %s, %s, %s, %d };\n",Ecc,t->sID,
#define Drs "struct %s%d={ %d, 0, %s, %s, %d };\n",Ers,t->sID,
#define Dss "struct %s%d={ %d, 0, %s, %s };\n",Ess,t->sID,
#define Doid "struct %s%d={ %d, 0, %s, %s };\n",Eoid,t->sID,
#define Dtd "struct %s%d={ %d, 0, %s, %s, %s, %s, %d };\n",Etd,t->sID,
#define Dcoid "struct %s%d={ %d, 0, %s, %s };\n",Ecoid,t->sID,
#define Dco "struct %s%d={ %d, 0, %s, %s, %s, %d, %d, %s };\n",Eco,t->sID,
#define Dc "struct %s%d={ %d, 0, %s, %d, %s };\n",Ec,t->sID,

#else

#define Dt "struct %s%d={ %s, %s, %s, %s, %s };\n",Et,
#define Ds "struct %s%d={ %s, %s, %s };\n",Es,
#define Do "struct %s%d={ %s, %d, %s, %s, %s };\n",Eo,
#define Dcc "struct %s%d={ %s, %s, %s, %s, %d };\n",Ecc,
#define Drs "struct %s%d={ %s, %s, %d };\n",Ers,
#define Dss "struct %s%d={ %s, %s };\n",Ess,
#define Doid "struct %s%d={ %s, %s };\n",Eoid,
#define Dtd "struct %s%d={ %s, %s, %s, %s, %d };\n",Etd,
#define Dcoid "struct %s%d={ %s, %s };\n",Ecoid,
#define Dco "struct %s%d={ %s, %s, %s, %d, %d, %s };\n",Eco,
#define Dc "struct %s%d={ %s, %d, %s };\n",Ec,

#endif

/******************************************************
  Some forward refs
  */

extern void OilDumpCoercionCost(); /* ( t ) tOilCoercionSeq t; */
extern void OilDumpOp();
extern void OilDumpSig();
extern void OilDumpTypeSet();

void OilDumpType( t ) tOilType t; {
  First(Et)
     pRef(Ccc,OilDumpCoercionCost,sCoercionCosts);
     pRef(Cs,OilDumpSig,sSigs);
     pRef(Crs,OilDumpTypeSet,sResultSets);
     pRef(Co,OilDumpOp,sOps);
 Dump
    Dt
    t->sID,
    NameRef(t->sName),
    tRef(Ccc,sCoercionCosts),
    tRef(Cs,sSigs),
    tRef(Crs,sResultSets),
    tRef(Co,sOps)
    );
  }

void OilDumpSig( t ) tOilArgSig t; {
  First(Es)
    pRef(Cs,OilDumpSig,sNext);
    pRef(Ct,OilDumpType,sArg);
    pRef(Cs,OilDumpSig,sSameType);
  Dump
    Ds
    t->sID,
    tRef(Cs,sNext),
    tRef(Ct,sArg),
    tRef(Cs,sSameType)
    );
  }

extern void OilDumpOpId();

void OilDumpOp( t ) tOilOp t; {
  First(Eo)
    pRef(Cs,OilDumpSig,sArgs);
    pRef(Co,OilDumpOp,sSameType);
    pRef(Coid,OilDumpOpId,sIndOps);
  Dump
    Do
    t->sID,
    NameRef(t->sName),
    t->sCost,
    tRef(Cs,sArgs),
    tRef(Co,sSameType),
    tRef(Coid,sIndOps)
    );
  }

void OilDumpCoercionCost( t ) tOilCoercionSeq t; {
  First(Ecc)
    pRef(Ct,OilDumpType,sResultType);
    pRef(Ccc,OilDumpCoercionCost,sNextCost);
    pRef(Co,OilDumpOp,sCoercionOp);
    pRef(Ccc,OilDumpCoercionCost,sCoercionSeq);
  Dump
    Dcc
    t->sID,
    tRef(Ct,sResultType),
    tRef(Ccc,sNextCost),
    tRef(Co,sCoercionOp),
    tRef(Ccc,sCoercionSeq),
    t->sCost
    );
  }

void OilDumpTypeSet( t ) tOilTypeSet t; {
  First(Ers)
    pRef(Ct,OilDumpType,sBaseType);
    pRef(Crs,OilDumpTypeSet,sNext);
  Dump
    Drs
    t->sID,
    tRef(Ct,sBaseType),
    tRef(Crs,sNext),
    t->sCost
    );
  }

void OilDumpSetOilArgSig( t ) tOilSetSig t; {
  First(Ess)
    pRef(Css,OilDumpSetOilArgSig,sNext);
    pRef(Crs,OilDumpTypeSet,sResultTypes);
 Dump
    Dss
    t->sID,
    tRef(Css,sNext),
    tRef(Crs,sResultTypes)
    );
  }

void OilDumpOpId( t ) tOilOpIdentification t; {
  First(Eoid)
    pRef(Coid,OilDumpOpId,sNext);
    pRef(Co,OilDumpOp,sOp);
 Dump
    Doid
    t->sID,
    tRef(Coid,sNext),
    tRef(Co,sOp)
    );
  }


char *OilDumpArgDescInd[]= {
	"eClassRef",
	"eElementRef",
	"eSpecTypeRef"
  };

void OilDumpArgDesc( t ) tOilClassArgSig t; {
  First(Etd)
    pRef(Ctd,OilDumpArgDesc,sAnother);
    pRef(Ctd,OilDumpArgDesc,sNext);
    pRef(Ct,OilDumpType,sRefdType);
  Dump
    Dtd
    t->sID,
    tRef(Ctd,sAnother),
    tRef(Ctd,sNext),
    OilDumpArgDescInd[((int)(t->sDescPattern))],
    tRef(Ct,sRefdType),
    t->sParamIndex
    );
  }

void OilDumpClassOpId( t ) tOilClassOpId t; {
  First(Ecoid)
    pRef(Ccoid,OilDumpClassOpId,sNext);
    pRef(Co,OilDumpOp,sOpInd);
  Dump
    Dcoid
    t->sID,
    tRef(Ccoid,sNext),
    tRef(Co,sOpInd)
    );
  }

void OilDumpClassOp( t ) tOilClassOp t; {
  First(Eco)
    pRef(Cco,OilDumpClassOp,sNext);
    pRef(Ctd,OilDumpArgDesc,sArgDesc);
    pRef(Ccoid,OilDumpClassOpId,sIdents);
  Dump
    Dco
    t->sID,
    tRef(Cco,sNext),
    NameRef(t->sName),
    tRef(Ctd,sArgDesc),
    t->sCost,
    t->isCoercion,
    tRef(Ccoid,sIdents)
    );
  }

void OilDumpClass( t ) tOilClass t; {
  First(Ec)
    pRef(Cco,OilDumpClassOp,sClassOps);
  Dump
    Dc
    t->sID,
    NameRef(t->sName),
    t->sNumArg,
    tRef(Cco,sClassOps)
    );
  }

FILE * OilDumpInit(fname)
    char *fname;
  {
  DumpFile= fopen(fname,"w");
  fprintf(DumpFile, "\n#include \"oiladt2.h\"\n\n");
  return(DumpFile);
  }

	/* the end of oiladt2b.c */
