/* Output from p2c, the Pascal-to-C translator */
/* From input file "walk.p" */


#include "p2c.h"


/* $Id: vsfile.ext.h,v 1.2 89/10/20 16:42:42 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

extern Void VSFILE PP((long offset));

extern long SECTTAB PP((long RULENR, long VSINDEX));

extern long VSTAB PP((long VSINDEX));

extern long RULEFIRSTSEMCODE PP((long RULENR));


/* $Id: frame.h,v 7.5 90/01/23 15:21:51 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */


#define MAXTREEDEPTH    500




typedef struct POSITION {
  long LINE, COL;
} POSITION;

typedef enum {
  SYSINFORM, SYNTAXERROR, SCANNERERROR, CONDFAILS, IMPLCONDFAILS, QUAFAILS,
  INCLFAILS, SYSERROR, SYSLIMIT
} MESSAGETYPE;



Static POSITION GLOBPOS;


extern Void MESSAGE PP((MESSAGETYPE class_, long msgid, long gram, long line,
			long col));


/* $Id: attr_h.pp,v 1.2 89/10/20 16:41:42 waite Exp $ */
/* Copyright, 1989, Universitaet Paderborn */



#define MAXCODETERMCODE  3

/*&END GEN INCLUDE*/


#define EMPTYRULE       0
#define R410GEN         1
#define R411GEN         2
#define R412GEN         3
#define R413GEN         4
#define R414GEN         5
#define R415GEN         6
#define R417GEN         7
#define R418GEN         8
#define R419GEN         9
#define R420GEN         10
#define R421GEN         11
#define R422GEN         12
#define R423GEN         13
#define R424GEN         14
#define R425GEN         15
#define R426GEN         16
#define R427GEN         17
#define R428GEN         18
#define R429GEN         19
#define R430GEN         20
#define R431GEN         21
#define R432GEN         22
#define R433GEN         23
#define R434GEN         24
#define R435GEN         25
#define R436GEN         26
#define R437GEN         27
#define R438GEN         28
#define R439GEN         29
#define R440GEN         30
#define R441GEN         31
#define R442GEN         32
#define R443GEN         33
#define R444GEN         34
#define R445GEN         35
#define R446GEN         36
#define R447GEN         37
#define R448GEN         38
#define R449GEN         39
#define R450GEN         40
#define LISTRULE        41
#define TERMRULE        42
#define LISTEND         43


#define N303Identifier  2
#define N354IntegerValue  3
#define FIRSTTERM       1
#define LASTTERM        3


#define N304OIL         4
#define N308xStmtList   5
#define N310xOpRef      6
#define N312xStmt       7
#define N314xParamTypeDef  8
#define N315xParamList  9
#define N326xParamId    10
#define N328xForId      11
#define N329xTypeExpr   12
#define N332xTypeExprId  13
#define N334xCoerSig    14
#define N335xOpCost     15
#define N337xOpDef      16
#define N338xTypeId     17
#define N342xFuncSig    18
#define N343xArgSig     19
#define N345xBinOp      20
#define N347xTypeList   21
#define N350xIndDef     22
#define N351xOpList     23
#define FIRSTNTERM      4
#define LASTNTERM       23

#define MAXSYMB         2048

#define FIRSTALLTYPES   0
#define U87INT          0
#define U88BOOL         1
#define U89CHAR         2
#define U90SYMB         3
#define U91STRING       4
#define U92LIST         5
#define U144tKey        6
#define U147tObjKind    7
#define U149tTypeKind   8
#define U151tOpKind     9
#define U154tOilClass   10
#define U156tOilType    11
#define U158tOilOp      12
#define U160tStructTypeSet  13
#define U184tKeyList    14
#define U209tOilArgSig  15
#define U213tOilClassArgSig  16
#define U215tOilClassOp  17
#define U230tTypeKindSet  18
#define U231tArgSig     19
#define U232tTypeSet    20
#define U234tTypeSetOp  21
#define U245tAnyOp      22
#define U246tSetOp      23
#define U247tIdentPair  24
#define U250tIdentMap   25
#define U275tSetSig     26
#define U276tArgSetValues  27
#define U277tArgSetValue  28
#define U289tArgValues  29
#define U290tArgValue   30
#define U291tArgValueList  31
#define U307tEnv        32
#define U356tOilSetSig  33
#define U357tOilTypeSet  34
#define U361tOilClassOpId  35
#define U362tOilClassCoercion  36
#define U364tOilCoercionSeq  37
#define U452GEN         38
#define U453GEN         39
#define U454GEN         40
#define UNNODEPTR       41
#define UNARRAY         42
#define LASTALLTYPES    42

/*&END GEN INCLUDE*/
/* next 2 consts are used in UNIONTYPE */
#define MAXSTACK        10   /* INITIAL LENGTH OF ATTRIBUTE STACKS */
#define LINK_           11   /* MAXSTACK + 1: LINK OF ATTRIBUTE STACK UNITS */



/* ============ TREE NODE AND ATTRIBUTE TYPES =============== */

/* next 3 types are used in UNIONTYPE */
/* GENERAL TYPE FOR ATTRIBUTE STACKS:      */
/* ALL STACKS ARE MAPPED TO A UNIFORM      */
/* POINTER TYPE REFERRING STACK 'PORTIONS' */
/* RANGE OF A STACK POINTER   */
/* RANGE OF ONE STACK PORTION */

/* MUST INCLUDE STRINGTABLE RANGE OF GAG */
/*   "   */



/* imported data base types */

/* tKey: key of an object in the database;
   defined in dbtypes.h, imported here as a generic pointer
*/



/* tKeyList: a list of object keys;
   defined in dbtypes.h, imported here as a generic pointer
*/



/*
  $Id: oiladt2a.pp,v 1.8 90/04/05 08:50:40 swain Exp $
Copyright, 1989, The Regents of the University of Colorado
*/








/* types imported from environment module */

/* type of environment is defined in envmod.h:
   imported here as a generic pointer type
*/





typedef enum {
  S216eType, S217eOp, S218eClass, S219eErrorObj
} T147tObjKind;
typedef enum {
  S220ePrimType, S221eParamType, S222eForType, S223ePrimSet, S224eParamSet
} T149tTypeKind;
typedef enum {
  S225ePrimOp, S226eSetOp, S227eClassOp
} T151tOpKind;
typedef enum {
  S235eTSunion, S236eTSintersect, S237eTSdiff
} T234tTypeSetOp;

typedef struct TPLIST {
  struct TPLISTELEM *HEAD, *LAST;
} TPLIST;

typedef TPLIST T231tArgSig;
typedef TPLIST T232tTypeSet;
typedef TPLIST T246tSetOp;
typedef TPLIST T250tIdentMap;
typedef TPLIST T275tSetSig;
typedef TPLIST T276tArgSetValues;
typedef TPLIST T289tArgValues;
typedef TPLIST T291tArgValueList;
typedef TPLIST T452GEN;
typedef TPLIST T453GEN;
typedef TPLIST T454GEN;
typedef T147tObjKind atptObjKind;
typedef T149tTypeKind atptTypeKind;
typedef T151tOpKind atptOpKind;

typedef struct V160tStructTypeSet {

  TPLIST L233value;
} V160tStructTypeSet;

typedef struct V245tAnyOp {
  char DISCR;
  union {
    long *C158tOilOp;
    long *C215tOilClassOp;
    TPLIST C246tSetOp;
  } UU;
} V245tAnyOp;

typedef struct V247tIdentPair {

  long L248op, *L249indication;
} V247tIdentPair;

typedef struct V277tArgSetValue {

  Char *L253id;
  TPLIST L233value;
} V277tArgSetValue;

typedef struct V290tArgValue {

  Char *L253id;
  long *L233value;
} V290tArgValue;

typedef struct UNIONTYPE {
  char DISCR;
  union {
    long C87INT;
    boolean C88BOOL;
    Char C89CHAR;
    long C90SYMB;
    long C91STRING;
    Char *C144tKey;
    T147tObjKind C147tObjKind;
    T149tTypeKind C149tTypeKind;
    T151tOpKind C151tOpKind;
    long *C154tOilClass;
    long *C156tOilType;
    long *C158tOilOp;
    V160tStructTypeSet *C160tStructTypeSet;
    Char *C184tKeyList;
    long *C209tOilArgSig;
    long *C213tOilClassArgSig;
    long *C215tOilClassOp;
    long C230tTypeKindSet;
    T234tTypeSetOp C234tTypeSetOp;
    V245tAnyOp *C245tAnyOp;
    V247tIdentPair *C247tIdentPair;
    V277tArgSetValue *C277tArgSetValue;
    V290tArgValue *C290tArgValue;
    Char *C307tEnv;
    long *C356tOilSetSig;
    long *C357tOilTypeSet;
    long *C361tOilClassOpId;
    long *C362tOilClassCoercion;
    long *C364tOilCoercionSeq;
    TPLIST COLIST;
    struct NODE *CONODEPTR;
    struct UNIONTYPE *COARRAY;
  } UU;
} UNIONTYPE;

typedef UNIONTYPE ATARRAY[LINK_ + 1];

typedef struct TPLISTELEM {
  UNIONTYPE *ELEMENT;
  struct TPLISTELEM *NEXT;
} TPLISTELEM;


/*&END GEN INCLUDE*/


typedef union TERMATTYPE {
  long TERMAT;
  long id;
  long value;
} TERMATTYPE;

typedef struct NODE {
  struct NODE *BROTHER;
  char RULE;
  union {
    struct NODE *ELEMS;
    struct {
      POSITION POS;
      struct NODE *SONS;
      char NTSEL;
      union {
	struct {
	  Char *A304305defEnv, *A304306refEnv;
	  TPLIST A304254identMap;
	} U4;
	long *A308214class;
	struct {
	  long *A310249indication;
	  V247tIdentPair *A310311identification;
	  Char *A310162key;
	  T147tObjKind A310195otype;
	  T151tOpKind A310352operkind;
	} U6;
	struct {
	  Char *A312305defEnv, *A312306refEnv;
	  TPLIST A312461GEN;
	} U7;
	struct {
	  long *A314214class;
	  Char *A314305defEnv;
	} U8;
	struct {
	  long A315317len;
	  Char *A315305defEnv;
	} U9;
	long A335210cost;
	Char *A337162key;
	long A338253id;
      } UU;
    } U1;
    struct {
      char TERMSEL;
      TERMATTYPE TERMAT;
    } U42;
  } UU;
} NODE;


/*&END GEN INCLUDE*/


/* $Id: tree_h.pp,v 1.4 91/06/23 16:24:34 waite Exp $ */
/* Copyright, 1989, Universitaet Paderborn */



#define MAXINCLKEY      24


/*&END GEN INCLUDE*/





/*&END GEN INCLUDE*/

typedef struct GRUNDSYMBOLDESKRIPTOR {
  POSITION POS;
  long SYNTAXCODE, ATTR;
} GRUNDSYMBOLDESKRIPTOR;


Static NODE *CURRNODE;
Static short NODESTACKTOP;


/* for tree construction with a stack           */
/*PRE: NODESTACKTOP=1; NODESTACK[1]=NIL (dummy) */
/*INV: NODESTACKTOP=topmost entry               */
/*POST:NODESTACK[2]=root of tree                */

extern Void PUSHNODE PP((NODE *PTR));

extern NODE *POPNODE PV();

/* tree movements for attribute evaluation*/
/* PRE: stack as above, call TREENEXT to start with first tree*/
/* INV: CURRNODE->current node or CURRNODE=nil, see below */
/*      CURRNODE^.SONS resp. CURRNODE^.ELEMS are accessible */

extern Void TREENEXT PV();

/* Move to root of next tree to be evaluated.
   If nil evaluation stops */

extern Void TREEANCESTOR PV();

/*  move to ancestor */

extern Void TREEDESCENDANT PP((long I));

/*  move to I-th descendant */

extern Void TREEFIRSTELEM PV();

/*  move to first element of a listnode */

extern Void TREEBROTHER PV();

/* PRE: CURRNODE is list node, reached by an immediately
        preceeding TREEANCESTOR form an element */
/*  move to next element of the listnode */

extern Void EMPTYLIST PP((long ELZAHL));

extern Void ANFLIST PP((long ELZAHL));

extern Void CONTLIST PP((long ELZAHL));

extern Void EMPTYNODE PP((long I));

/* reaching up in the tree:*/
extern Void INCLUDING PP((int INCLKEY, UNIONTYPE *HIVAR));

extern char ANCRULETEST PV();

extern Void MAKENODE PP((int RULEIND, int NTIND, long SUCCS));

extern Void SourceInit PV();

/* Functions to construct new trees */

extern NODE *Leaf PP((long a));

extern NODE *Link PP((NODE *f, NODE *r));

extern NODE *Rule PP((long r, NODE *s));

extern boolean Tree PP((long n, NODE *t));

extern NODE *Bottom PV();

extern NODE *Empty PV();

extern NODE *EmptyL PV();

extern NODE *List PP((NODE *l));

/* $Id: dbgen.ext.h,v 1.9 91/07/07 14:13:30 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

/*
 *   dbgen.ext.h:
 *   Pascal interface declarations for generic database functions
 */


/* value representing "no object": */

extern Char *dbfNull PV();




/* access to relations */

/*
 * dbFind: scans relation relId and finds all tuples whose
 * roleId1 component is the object key;
 * the objects in the roleId2 component of the tuples found
 * are returned as an object list
 */

extern Char *dbFind PP((long relId, long roleId1, Char *key, long roleId2));




/* access functions for object lists: */


/*
 * dbOlReset: "rewinds" the object list keyList and returns it;
 * the next call to dbOlNext will return the first member of keyList
 */

extern Char *dbOlReset PP((Char *keyList));


/*
 * dbOlNext: returns the next member of the object list keyList;
 * a "current position" within an object list is defined by calling dbOlReset
 * (or dbOlFind);
 * each call to dbOlNext returns the member at the current position
 * and advances the current position;
 * when the end of the list is reached, the object dbNull is returned
 */

extern Char *dbOlNext PP((Char *keyList));




/* other database access functions */


/*
 * dbNewObject: constructor function for database objects -
 * creates and returns a new object of the specified object type
 * with undefined properties
 */

extern Char *dbNewObject PP((long otype));



/* dbGetObjectType: returns the object type of a given surrogate */

extern long dbGetObjectType PP((Char *key));



/*
 * dbSetObjectType: sets the object type of an existing object in the database;
 *    the object key is moved into the object class given by otype;
 *    otype must be a specialization of the current type of key;
 *    if key has any attributes defined that are inconsistent with the new
 *    object type, an error message is produced;
 *    the function returns TRUE if the object key was successfully moved
 *    to the object type otype, otherwise FALSE.
 */

extern boolean dbSetObjectType PP((Char *key, long otype));



/*
 * dbTestObjectType: debugging function
 * dbTestObjectType (key, otype, msg) returns true if the current attributes
 *    defined for the object key are consistent with the declared object
 *    type otype, i.e., exactly the attributes declared for otype are
 *    defined for key;
 *    conversely, the call returns false if either a declared attribute
 *    of otype is missing for key, or an attribute of key was not declared
 *    for otype, or both;
 *    if the function is called with msg = 0, it will be quiet about the
 *    test result;  if msg is nonzero and the attributes of key are not
 *    consistent with object type otype, the function writes an error
 *    message describing the inconsistency.
 */

extern boolean dbTestObjectType PP((Char *key, long otype, long msg));


/*
 * dbInit: initialize database module --
 * returns true iff everything was initialized successfully;
 * called from &MACRO EXT_INIT section
 */

extern boolean dbInit PV();

/* $Id: dbgen.pp,v 1.8 90/04/04 17:38:37 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */


/* $Id: deftbl.ext.h,v 1.7 91/07/07 14:37:37 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

/* declarations of constant (non-generated) definition table functions */


/* NewDef: returns a new definition table key */
extern Char *NewDef PV();

/* NoDef: returns the distinguished definition table key "no definition" */
extern Char *NoDef PV();

/* DefInit: initializes the definition table module */
extern boolean DefInit PV();

/* $Id: deftbl.pp,v 1.2 89/10/20 13:21:49 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */
/* $Id: envmod.ext.h,v 1.7 90/04/04 17:41:13 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */


/* functions imported from environment module */


/* NewEnv: obtain a new environment
   On exit -
      NewEnv returns an environment consisting of an empty scope
*/

extern Char *NewEnv PV();



/* NewScope: create a new scope within a given environment
   on entry -
      e = environment in which to create the new scope
   on exit-
      a new empty scope is created in e on top of the previously
      current scope in e;
      the new scope is made the current scope of the environment;
      NewScope returns the updated environment
*/

extern Char *NewScope PP((Char *e));




/* KeyInEnv: obtain the definition of an identifier in a given environment
   on entry -
      e = environment in which the definition is sought
      i = identifier whose definition is sought
   on exit -
      if i is defined in e
         the definition table key of i is returned,
      otherwise,
         the reserved key NoDef() is returned
*/

extern Char *KeyInEnv PP((Char *e, long i));




/* KeyInScope: obtain a definition from the current scope of an environment
   on entry -
      e = environment in which the definition is sought
      i = identifier whose definition is sought
   on exit -
      if i is defined in the current scope of e
         the definition table key of i (in the current scope of e)
         is returned,
      otherwise,
         the reserved key NoDef() is returned
*/

extern Char *KeyInScope PP((Char *e, long i));




/* DefineIdn: define an identifier in the inner scope of an environment --
   on entry -
      e = environment in which to define the identifier
      i = identifier to be defined
   on exit -
      if i was already defined in the inner scope of e,
      the corresponding definition table key is returned
      otherwise,
      a new definition table key is returned and entered
      into the inner scope of e
*/

extern Char *DefineIdn PP((Char *e, long i));




/* AddIdn: define an identifier in the inner scope of an environment
   with a given key --
   on entry -
      e = environment in which to define the identifier
      i = identifier to be defined
      k = definition table key
   on exit -
      if i was already defined in the inner scope of e,
         the corresponding definition table key is returned
      otherwise,
         i becomes defined in the inner scope of e with the
         given definition table key k
*/

extern Char *AddIdn PP((Char *e, long i, Char *k));


/* $Id: envmod.pp,v 1.3 89/10/20 13:53:53 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */



/*&INCLUDE ATTR_CONST_LOC*/

/*  ERROR MESSAGES ACCORDING TO <USER>.C.SCANTAB:  */

#define CONDFAILSMSG    2   /* attr eval */
#define SYSTEMERRORMSG  6   /* attr eval */
#define HEADFAILSMSG    8   /* attr eval */
#define LASTFAILSMSG    9   /* attr eval */
#define KEYFAILSMSG     10   /* attr eval */
#define VSTABLEWRONGMSG  11   /* attr eval */
#define GENSYMBFULLMSG  22   /* attr eval */



#define C100MININT      (-2147483647L)
#define C101MAXINT      2147483647L

#define C181tDef        0
#define C270eParamRef   1
#define C271eSpecTypeRef  2
#define C363eClassRef   0


/*&END GEN INCLUDE*/

/*&END INCLUDE*/





typedef Char filename[100];   /* File name parameter */






Static filename filearg;




Static boolean dbInitDummy;   /* result from dbInit */




/* $Id: cstsupp.h,v 7.6 89/10/20 16:41:48 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

Static POSITION curpos;


extern long glalex PP((long *SYMBOLATTR));

extern Void SCANINIT PP((Char *s, long fold));

extern Void WRAPUP PV();


Static Void errtoken(T, ATTR)
long T, *ATTR;
{
  /*================*/
  /* Create attribute of a generated symbol
     on entry-
        T=Code for the created symbol
     on exit-
        ATTR contains the attribute value if any
  */
  *ATTR = 0;   /* change to appropriate values */
}  /* errtoken */


/*===============*/




/*
   Get/Set<Property> Functions
*/
extern T147tObjKind GetaKind PP((Char *key, T147tObjKind default_));

extern T147tObjKind SetaKind PP((Char *key, T147tObjKind added,
				 T147tObjKind changed));

extern T149tTypeKind GetaTypeKind PP((Char *key, T149tTypeKind default_));

extern T149tTypeKind SetaTypeKind PP((Char *key, T149tTypeKind added,
				      T149tTypeKind changed));

extern T151tOpKind GetaOpKind PP((Char *key, T151tOpKind default_));

extern T151tOpKind SetaOpKind PP((Char *key, T151tOpKind added,
				  T151tOpKind changed));

extern long GetaValue PP((Char *key, long default_));

extern long SetaValue PP((Char *key, long added, long changed));

extern long *GetaClassId PP((Char *key, long *default_));

extern long *SetaClassId PP((Char *key, long *added, long *changed));

extern long *GetaTypeId PP((Char *key, long *default_));

extern long *SetaTypeId PP((Char *key, long *added, long *changed));

extern long *GetaOpId PP((Char *key, long *default_));

extern long *SetaOpId PP((Char *key, long *added, long *changed));

extern V160tStructTypeSet *GetaSetValue PP((Char *key,
					    V160tStructTypeSet *default_));

extern V160tStructTypeSet *SetaSetValue PP((Char *key,
					    V160tStructTypeSet *added,
					    V160tStructTypeSet *changed));

/*
   Add a tuple to a relation
*/
/*
   Delete a tuple from a relation
*/

extern long *OilNewArgSig PP((int dummy));

/* a zero length signature */

extern long *OilAddArgSig PP((long *arg, long *sig));

extern long *OilNewSetSig PP((int dummy));

/* no args */
extern long *OilAddSetSig PP((long *arg, long *sig));

extern long *OilNewOp PP((long id, long cost, long *sig));

extern long *OilErrorOp PV();



extern boolean OilAddIdentification PP((long *id, long *op));



extern long *OilNewType PP((long id));

extern long *OilErrorType PV();

/* define a new type of class 'c' with element type 'et' with name 'id' */
extern long *OilNewTypeInClass PP((long *c, long *as, long id));

/* validate that type 't2' is in the type set 't1'*/
extern boolean OilSetIncludes PP((long *t1, long *t2));

extern boolean OilEmptyTS PP((long *ts));

extern long *OilHeadTS PP((long *ts));

extern long *OilTailTS PP((long *ts));

extern boolean OilIsCoercibleTo PP((long *t1, long *t2));

/* Check the sets of possible actual argument types to see if they might
        be coerced to the corresponding formal type */
extern boolean OilCanIdSigs PP((long *src, long *dest));

/* check for valid coercion*/
extern boolean OilIsValidCS PP((long *ccs));

extern long *OilErrorCS PV();

/* check for valid operator*/
extern boolean OilIsValidOp PP((long *op));

/* return coercion sequence for coercing 't1' to 't2'*/
extern long *OilCoerce PP((long *t1, long *t2));

extern boolean OilAddCoercion PP((long *op));

extern boolean OilEmptyCS PP((long *cs));

extern long *OilHeadCS PP((long *cs));

extern long *OilTailCS PP((long *cs));



/* find all possible result types which might be indicated by 'ind'
        with arguments 'setsig' */
extern long *OilIdResultSet PP((long *ind, long *setsig));

extern long *OilTypeToSet PP((long *t));

extern long *OilBalance PP((long *ts1, long *ts2));


extern long *OilNewClass PP((long id, long argNum));


extern long *OilNewClassSigArg PP((int dummy));

extern long *OilAddClassSigArg PP((long td, long *st, long pi, long *cs));


extern long *OilAddClassOp PP((long id, long *sig, long cost, long *class_));

extern boolean OilAddClassOpId PP((long *ind, long *op));


extern boolean OilAddClassCoercion PP((long *op));


/* Get type of argument #n of operator 'op' */
extern long *OilGetArgType PP((long *op, long n));


/* the end of oiladt2a.pp */
/*              begin OIL.pp PROC               */

/************************************************
  InitCompilerAdt - init compiler's ADT
  EmitCompilerAdt - output the Compiler's tables
  */
extern Void InitCompilerAdt PV();

extern Void EmitCompilerAdt PV();



/**************************************************
  cErrorType, cErrorOp -
        define the error handling values
  ****************/
extern long *cErrorType PV();

extern long *cErrorOp PV();

extern long *cErrorClass PV();



/**************************************************
  DefClass, DefType, DefOp, DefClassOp -
        Calls the OilAdt to construct the object and adds it to the
        corresponding local table.
  ****************/

extern long *DefClass PP((long name, long numArgs));

extern long *DefType PP((long name));

extern long *DefOp PP((long name, long *sig, long cost));

extern long *DefClassOp PP((long name, long *sig, long cost, long *class_));

extern long *DefSetOp PP((long name, long *sig, long cost));


/*              end of OIL.pp PROC              */



extern Void Zerteiler PV();


#define ANCESTORVISIT   0   /* VS-CODE OF VISIT TO THE ANCESTOR */



#define MAXSEMCODE      77
#define MINSEMRELCODE   10
#define MAXVSTAB        85
#define MAXSECTTAB      36
#define MAXVSSYMBNO     3
#define MAXVSNUMBER     3
#define VISITSTOROOT    1


/*&END GEN INCLUDE*/




/*&END GEN INCLUDE*/



/* Local variables for ATTREVAL: */
struct LOC_ATTREVAL {


  boolean FIRSTTIME;

  long GENSYMBCOUNTER, GENNUMCOUNTER;

  NODE *AUXPTR;
  TPLISTELEM *AUXELEMPTR, *FIRSTELEM, *LASTELEM;
  TPLIST EMPTY;


  /* VARIABLES TO MEASURE PERFORMANCE: */

  long MC;   /* COUNTS MARK/RELEASE AROUND CONDITIONS */
  long LCOUNT, LPOPCOUNT;   /* COUNTS LIST LINK RECORDS ALLOCATED    */
  long STCOUNT, STPOPCOUNT;   /* COUNTS STACK PORTIONS ALLOCATED       */
  long BCOUNT;   /* COUNTS LIST NODES                     */
  long SCPCOUNT;   /* COUNTS ELIM. SEM. CHAIN PRODUCTIONS   */
  long ECOUNT;   /* COUNTS EMPTY NODES                    */


  Char *A350162key;
  UNIONTYPE *A338162key;
  char Q338162key;
  long A314205numArgs;
  TPLIST A343208sig, A337208sig;
  UNIONTYPE *A342210cost;
  char Q342210cost;
  TPLIST A347233value;
  UNIONTYPE *A329233value;
  char Q329233value;
  long *A351249indication, A350253id;
  Char *A342305defEnv;
  boolean A337311identification;
  T147tObjKind A350320okind;
  T149tTypeKind A350324tkind;
  UNIONTYPE *A338324tkind;
  char Q338324tkind;
  UNIONTYPE *A329330definingId;
  char Q329330definingId;
  long A343339sigDesc, A337339sigDesc;
  V245tAnyOp *A337340oid;
  UNIONTYPE *A345346setOp;
  char Q345346setOp;
  long *A338348tid;
  TPLIST A351461GEN;
  Char *C182dbNull;
  V160tStructTypeSet *C284cErrorTypeSet;
} ;

Local boolean COMPAREUNION PP((UNIONTYPE U1, UNIONTYPE U2,
			       struct LOC_ATTREVAL *LINK));
Local boolean E144tKey PP((Char *U1, Char *U2, struct LOC_ATTREVAL *LINK));
Local boolean E154tOilClass PP((long *U1, long *U2, struct LOC_ATTREVAL *LINK));
Local boolean E156tOilType PP((long *U1, long *U2, struct LOC_ATTREVAL *LINK));
Local boolean E158tOilOp PP((long *U1, long *U2, struct LOC_ATTREVAL *LINK));
Local boolean E160tStructTypeSet PP((V160tStructTypeSet *U1,
				     V160tStructTypeSet *U2,
				     struct LOC_ATTREVAL *LINK));
Local boolean E184tKeyList PP((Char *U1, Char *U2, struct LOC_ATTREVAL *LINK));
Local boolean E209tOilArgSig PP((long *U1, long *U2, struct LOC_ATTREVAL *LINK));
Local boolean E213tOilClassArgSig PP((long *U1, long *U2,
				      struct LOC_ATTREVAL *LINK));
Local boolean E215tOilClassOp PP((long *U1, long *U2,
				  struct LOC_ATTREVAL *LINK));
Local boolean E245tAnyOp PP((V245tAnyOp *U1, V245tAnyOp *U2,
			     struct LOC_ATTREVAL *LINK));
Local boolean E247tIdentPair PP((V247tIdentPair *U1, V247tIdentPair *U2,
				 struct LOC_ATTREVAL *LINK));
Local boolean E277tArgSetValue PP((V277tArgSetValue *U1, V277tArgSetValue *U2,
				   struct LOC_ATTREVAL *LINK));
Local boolean E290tArgValue PP((V290tArgValue *U1, V290tArgValue *U2,
				struct LOC_ATTREVAL *LINK));
Local boolean E307tEnv PP((Char *U1, Char *U2, struct LOC_ATTREVAL *LINK));
Local boolean E356tOilSetSig PP((long *U1, long *U2, struct LOC_ATTREVAL *LINK));
Local boolean E357tOilTypeSet PP((long *U1, long *U2,
				  struct LOC_ATTREVAL *LINK));
Local boolean E361tOilClassOpId PP((long *U1, long *U2,
				    struct LOC_ATTREVAL *LINK));
Local boolean E362tOilClassCoercion PP((long *U1, long *U2,
					struct LOC_ATTREVAL *LINK));
Local boolean E364tOilCoercionSeq PP((long *U1, long *U2,
				      struct LOC_ATTREVAL *LINK));
Local Void HEAD PP((TPLIST L, UNIONTYPE *FTHEAD, struct LOC_ATTREVAL *LINK));
Local Void LAST PP((TPLIST L, UNIONTYPE *FTLAST, struct LOC_ATTREVAL *LINK));
Local Void FRONT PP((TPLIST L, UNIONTYPE *FTFRONT, struct LOC_ATTREVAL *LINK));
Local Void TAIL PP((TPLIST L, UNIONTYPE *FTTAIL, struct LOC_ATTREVAL *LINK));
Local long LENGTH PP((TPLIST L, struct LOC_ATTREVAL *LINK));
Local boolean ELEMINLIST PP((UNIONTYPE E, TPLIST L, struct LOC_ATTREVAL *LINK));
Local boolean LISTINCLUSION PP((TPLIST L1, TPLIST L2,
				struct LOC_ATTREVAL *LINK));
Local boolean UNIQUEELEMS PP((TPLIST L, struct LOC_ATTREVAL *LINK));
Local T147tObjKind F161GetaKind PP((Char *X162key, T147tObjKind X163default,
				    struct LOC_ATTREVAL *LINK));
Local T147tObjKind F164SetaKind PP((Char *X162key, T147tObjKind X165added,
				    T147tObjKind X166changed,
				    struct LOC_ATTREVAL *LINK));
Local T149tTypeKind F167GetaTypeKind PP((Char *X162key,
					 T149tTypeKind X163default,
					 struct LOC_ATTREVAL *LINK));
Local T149tTypeKind F168SetaTypeKind PP((Char *X162key,
    T149tTypeKind X165added, T149tTypeKind X166changed,
    struct LOC_ATTREVAL *LINK));
Local T151tOpKind F169GetaOpKind PP((Char *X162key, T151tOpKind X163default,
				     struct LOC_ATTREVAL *LINK));
Local T151tOpKind F170SetaOpKind PP((Char *X162key, T151tOpKind X165added,
				     T151tOpKind X166changed,
				     struct LOC_ATTREVAL *LINK));
Local long F171GetaValue PP((Char *X162key, long X163default,
			     struct LOC_ATTREVAL *LINK));
Local long F172SetaValue PP((Char *X162key, long X165added, long X166changed,
			     struct LOC_ATTREVAL *LINK));
Local long *F173GetaClassId PP((Char *X162key, long *X163default,
				struct LOC_ATTREVAL *LINK));
Local long *F174SetaClassId PP((Char *X162key, long *X165added,
				long *X166changed,
				struct LOC_ATTREVAL *LINK));
Local long *F175GetaTypeId PP((Char *X162key, long *X163default,
			       struct LOC_ATTREVAL *LINK));
Local long *F176SetaTypeId PP((Char *X162key, long *X165added,
			       long *X166changed, struct LOC_ATTREVAL *LINK));
Local long *F177GetaOpId PP((Char *X162key, long *X163default,
			     struct LOC_ATTREVAL *LINK));
Local long *F178SetaOpId PP((Char *X162key, long *X165added,
			     long *X166changed, struct LOC_ATTREVAL *LINK));
Local V160tStructTypeSet *F179GetaSetValue PP((Char *X162key,
    V160tStructTypeSet *X163default, struct LOC_ATTREVAL *LINK));
Local V160tStructTypeSet *F180SetaSetValue PP((Char *X162key,
    V160tStructTypeSet *X165added, V160tStructTypeSet *X166changed,
    struct LOC_ATTREVAL *LINK));
Local Char *F183dbfNull PP((struct LOC_ATTREVAL *LINK));
Local Char *F186dbFind PP((long X187relId, long X188roleId1, Char *X162key,
			   long X189roleId2, struct LOC_ATTREVAL *LINK));
Local Char *F190dbOlReset PP((Char *X191keyList, struct LOC_ATTREVAL *LINK));
Local Char *F192dbOlNext PP((Char *X191keyList, struct LOC_ATTREVAL *LINK));
Local Char *F193dbOlFirst PP((Char *X191keyList, struct LOC_ATTREVAL *LINK));
Local Char *F194dbNewObject PP((long X195otype, struct LOC_ATTREVAL *LINK));
Local long F196dbGetObjectType PP((Char *X162key, struct LOC_ATTREVAL *LINK));
Local boolean F197dbSetObjectType PP((Char *X162key, long X195otype,
				      struct LOC_ATTREVAL *LINK));
Local boolean F198dbTestObjectType PP((Char *X162key, long X195otype,
				       long X199msg,
				       struct LOC_ATTREVAL *LINK));
Local Char *F200NewDef PP((struct LOC_ATTREVAL *LINK));
Local Char *F201NoDef PP((struct LOC_ATTREVAL *LINK));
Local boolean F202DefInit PP((struct LOC_ATTREVAL *LINK));
Local long *F203DefClass PP((long X204name, long X205numArgs,
			     struct LOC_ATTREVAL *LINK));
Local long *F206DefType PP((long X204name, struct LOC_ATTREVAL *LINK));
Local long *F207DefOp PP((long X204name, long *X208sig, long X210cost,
			  struct LOC_ATTREVAL *LINK));
Local long *F211DefSetOp PP((long X204name, long *X208sig, long X210cost,
			     struct LOC_ATTREVAL *LINK));
Local long *F212DefClassOp PP((long X204name, long *X208sig, long X210cost,
			       long *X214class, struct LOC_ATTREVAL *LINK));
Local boolean F228ObjKindCheck PP((T147tObjKind X195otype,
				   T147tObjKind X229typeWanted,
				   struct LOC_ATTREVAL *LINK));
Local Void P238SetUnion PP((TPLIST X239left, TPLIST X240right,
			    UNIONTYPE *F238SetUnion,
			    struct LOC_ATTREVAL *LINK));
Local Void P243SetIntersect PP((TPLIST X239left, TPLIST X240right,
				UNIONTYPE *F243SetIntersect,
				struct LOC_ATTREVAL *LINK));
Local Void P244SetDifference PP((TPLIST X239left, TPLIST X240right,
				 UNIONTYPE *F244SetDifference,
				 struct LOC_ATTREVAL *LINK));
Local boolean F251AddIdentification PP((V245tAnyOp *X252Op, long *X214class,
					long X253id, TPLIST X254identMap,
					struct LOC_ATTREVAL *LINK));
Local boolean F257OilAddIdentification PP((long *X253id, long *X248op,
					   struct LOC_ATTREVAL *LINK));
Local boolean F258OilAddClassOpId PP((long *X391ind, long *X248op,
				      struct LOC_ATTREVAL *LINK));
Local boolean F259AddSetOpId PP((long *X253id, TPLIST X248op,
				 struct LOC_ATTREVAL *LINK));
Local long *F260PrimSig PP((TPLIST X261argSig, struct LOC_ATTREVAL *LINK));
Local long *F262OilNewArgSig PP((int X316dummy, struct LOC_ATTREVAL *LINK));
Local long *F263OilAddArgSig PP((long *X267arg, long *X208sig,
				 struct LOC_ATTREVAL *LINK));
Local long *F264cErrorType PP((struct LOC_ATTREVAL *LINK));
Local long *F265ClassSig PP((TPLIST X261argSig, struct LOC_ATTREVAL *LINK));
Local long *F266OilNewClassSigArg PP((int X316dummy, struct LOC_ATTREVAL *LINK));
Local long *F274OilAddClassSigArg PP((long X269td, long *X272st, long X273pi,
				      long *X387cs,
				      struct LOC_ATTREVAL *LINK));
Local Void P278SetSig PP((TPLIST X261argSig, UNIONTYPE *F278SetSig,
			  struct LOC_ATTREVAL *LINK));
Local Void P280UniqueIds PP((TPLIST X279uids, TPLIST X285actualSig,
			     UNIONTYPE *F280UniqueIds,
			     struct LOC_ATTREVAL *LINK));
Local Void P282UniqueValues PP((TPLIST X279uids, UNIONTYPE *F282UniqueValues,
				struct LOC_ATTREVAL *LINK));
Local Void P283UniqueSigs PP((TPLIST X279uids, TPLIST X285actualSig,
			      UNIONTYPE *F283UniqueSigs,
			      struct LOC_ATTREVAL *LINK));
Local Void P288MapIdToSet PP((Char *X286aid, TPLIST X279uids,
			      UNIONTYPE *F288MapIdToSet,
			      struct LOC_ATTREVAL *LINK));
Local Void P292ConsValueS PP((Char *X253id, TPLIST X233value,
			      TPLIST X293others, UNIONTYPE *F292ConsValueS,
			      struct LOC_ATTREVAL *LINK));
Local Void P294ConsValue PP((Char *X253id, TPLIST X233value,
			     TPLIST X293others, UNIONTYPE *F294ConsValue,
			     struct LOC_ATTREVAL *LINK));
Local long *F295UniqueSig PP((TPLIST X296avs, TPLIST X285actualSig,
			      struct LOC_ATTREVAL *LINK));
Local Void P298AddSetOp PP((long X253id, TPLIST X208sig, long X210cost,
			    UNIONTYPE *F298AddSetOp,
			    struct LOC_ATTREVAL *LINK));
Local boolean F299AddSetCoercion PP((TPLIST X248op, struct LOC_ATTREVAL *LINK));
Local boolean F300OilAddCoercion PP((long *X248op, struct LOC_ATTREVAL *LINK));
Local long *F301cErrorOp PP((struct LOC_ATTREVAL *LINK));
Local long *F302cErrorClass PP((struct LOC_ATTREVAL *LINK));
Local Char *F309NewEnv PP((struct LOC_ATTREVAL *LINK));
Local Char *F319DefineIdn PP((Char *X406e, long X407i,
			      struct LOC_ATTREVAL *LINK));
Local Char *F322KeyInScope PP((Char *X406e, long X407i,
			       struct LOC_ATTREVAL *LINK));
Local Char *F323NewScope PP((Char *X406e, struct LOC_ATTREVAL *LINK));
Local Char *F325KeyInEnv PP((Char *X406e, long X407i,
			     struct LOC_ATTREVAL *LINK));
Local boolean F341OilAddClassCoercion PP((long *X248op,
					  struct LOC_ATTREVAL *LINK));
Local long *F366OilNewSetSig PP((int X316dummy, struct LOC_ATTREVAL *LINK));
Local long *F367OilAddSetSig PP((long *X267arg, long *X208sig,
				 struct LOC_ATTREVAL *LINK));
Local long *F368OilNewOp PP((long X253id, long X210cost, long *X208sig,
			     struct LOC_ATTREVAL *LINK));
Local long *F369OilErrorOp PP((struct LOC_ATTREVAL *LINK));
Local long *F370OilNewType PP((long X253id, struct LOC_ATTREVAL *LINK));
Local long *F371OilErrorType PP((struct LOC_ATTREVAL *LINK));
Local long *F372OilNewTypeInClass PP((long *X321c, long *X373as, long X253id,
				      struct LOC_ATTREVAL *LINK));
Local boolean F374OilSetIncludes PP((long *X375t1, long *X376t2,
				     struct LOC_ATTREVAL *LINK));
Local boolean F377OilIsCoercibleTo PP((long *X375t1, long *X376t2,
				       struct LOC_ATTREVAL *LINK));
Local boolean F378OilCanIdSigs PP((long *X379src, long *X380dest,
				   struct LOC_ATTREVAL *LINK));
Local boolean F381OilIsValidCS PP((long *X382ccs, struct LOC_ATTREVAL *LINK));
Local long *F383OilErrorCS PP((struct LOC_ATTREVAL *LINK));
Local boolean F384OilIsValidOp PP((long *X248op, struct LOC_ATTREVAL *LINK));
Local long *F385OilCoerce PP((long *X375t1, long *X376t2,
			      struct LOC_ATTREVAL *LINK));
Local boolean F386OilEmptyCS PP((long *X387cs, struct LOC_ATTREVAL *LINK));
Local long *F388OilHeadCS PP((long *X387cs, struct LOC_ATTREVAL *LINK));
Local long *F389OilTailCS PP((long *X387cs, struct LOC_ATTREVAL *LINK));
Local long *F390OilIdResultSet PP((long *X391ind, long *X392setsig,
				   struct LOC_ATTREVAL *LINK));
Local long *F393OilTypeToSet PP((long *X394t, struct LOC_ATTREVAL *LINK));
Local long *F395OilBalance PP((long *X396ts1, long *X397ts2,
			       struct LOC_ATTREVAL *LINK));
Local long *F398OilSelectTypeFromTS PP((long *X399ts,
					struct LOC_ATTREVAL *LINK));
Local long *F400OilNewClass PP((long X253id, long X401argNum,
				struct LOC_ATTREVAL *LINK));
Local long *F402OilAddClassOp PP((long X253id, long *X208sig, long X210cost,
				  long *X321c, struct LOC_ATTREVAL *LINK));
Local long *F403OilGetArgType PP((long *X248op, long X404n,
				  struct LOC_ATTREVAL *LINK));
Local Char *F408AddIdn PP((Char *X406e, long X407i, Char *X349k,
			   struct LOC_ATTREVAL *LINK));


Local boolean COMPARELIST(L1, L2, LINK)
TPLIST L1, L2;
struct LOC_ATTREVAL *LINK;
{
  boolean WEITER, RESULT;
  TPLISTELEM *P1, *P2;


  if (L1.HEAD == L2.HEAD && L1.LAST == L2.LAST) {
    RESULT = true;
    return RESULT;
  }

  P1 = L1.HEAD;
  P2 = L2.HEAD;
  WEITER = true;
  while (P1 != NULL && P2 != NULL && WEITER) {
    if (P1->ELEMENT == P2->ELEMENT)
      WEITER = true;
    else
      WEITER = COMPAREUNION(*P1->ELEMENT, *P2->ELEMENT, LINK);
    if (P1 == L1.LAST)
      P1 = NULL;
    else
      P1 = P1->NEXT;
    if (P2 == L2.LAST)
      P2 = NULL;
    else
      P2 = P2->NEXT;
  }

  RESULT = (WEITER && P1 == NULL && P2 == NULL);
  return RESULT;

}  /*COMPARELIST*/

Local boolean COMPAREUNION(U1, U2, LINK)
UNIONTYPE U1, U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:UNIONTYPE):Boolean*/
  boolean RESULT;

  if (U1.DISCR != U2.DISCR) {
    RESULT = false;
    return RESULT;
  }
  switch (U1.DISCR) {

  case U87INT:
    RESULT = (U1.UU.C87INT == U2.UU.C87INT);
    break;

  case U88BOOL:
    RESULT = (U1.UU.C88BOOL == U2.UU.C88BOOL);
    break;

  case U89CHAR:
    RESULT = (U1.UU.C89CHAR == U2.UU.C89CHAR);
    break;

  case U90SYMB:
    RESULT = (U1.UU.C90SYMB == U2.UU.C90SYMB);
    break;

  case U91STRING:
    RESULT = (U1.UU.C91STRING == U2.UU.C91STRING);
    break;

  case U144tKey:
    RESULT = E144tKey(U1.UU.C144tKey, U2.UU.C144tKey, LINK);
    break;

  case U147tObjKind:
    RESULT = (U1.UU.C147tObjKind == U2.UU.C147tObjKind);
    break;

  case U149tTypeKind:
    RESULT = (U1.UU.C149tTypeKind == U2.UU.C149tTypeKind);
    break;

  case U151tOpKind:
    RESULT = (U1.UU.C151tOpKind == U2.UU.C151tOpKind);
    break;

  case U154tOilClass:
    RESULT = E154tOilClass(U1.UU.C154tOilClass, U2.UU.C154tOilClass, LINK);
    break;

  case U156tOilType:
    RESULT = E156tOilType(U1.UU.C156tOilType, U2.UU.C156tOilType, LINK);
    break;

  case U158tOilOp:
    RESULT = E158tOilOp(U1.UU.C158tOilOp, U2.UU.C158tOilOp, LINK);
    break;

  case U160tStructTypeSet:
    RESULT = E160tStructTypeSet(U1.UU.C160tStructTypeSet,
				U2.UU.C160tStructTypeSet, LINK);
    break;

  case U184tKeyList:
    RESULT = E184tKeyList(U1.UU.C184tKeyList, U2.UU.C184tKeyList, LINK);
    break;

  case U209tOilArgSig:
    RESULT = E209tOilArgSig(U1.UU.C209tOilArgSig, U2.UU.C209tOilArgSig, LINK);
    break;

  case U213tOilClassArgSig:
    RESULT = E213tOilClassArgSig(U1.UU.C213tOilClassArgSig,
				 U2.UU.C213tOilClassArgSig, LINK);
    break;

  case U215tOilClassOp:
    RESULT = E215tOilClassOp(U1.UU.C215tOilClassOp, U2.UU.C215tOilClassOp,
			     LINK);
    break;

  case U230tTypeKindSet:
    RESULT = (U1.UU.C230tTypeKindSet == U2.UU.C230tTypeKindSet);
    break;

  case U234tTypeSetOp:
    RESULT = (U1.UU.C234tTypeSetOp == U2.UU.C234tTypeSetOp);
    break;

  case U245tAnyOp:
    RESULT = E245tAnyOp(U1.UU.C245tAnyOp, U2.UU.C245tAnyOp, LINK);
    break;

  case U247tIdentPair:
    RESULT = E247tIdentPair(U1.UU.C247tIdentPair, U2.UU.C247tIdentPair, LINK);
    break;

  case U277tArgSetValue:
    RESULT = E277tArgSetValue(U1.UU.C277tArgSetValue, U2.UU.C277tArgSetValue,
			      LINK);
    break;

  case U290tArgValue:
    RESULT = E290tArgValue(U1.UU.C290tArgValue, U2.UU.C290tArgValue, LINK);
    break;

  case U307tEnv:
    RESULT = E307tEnv(U1.UU.C307tEnv, U2.UU.C307tEnv, LINK);
    break;

  case U356tOilSetSig:
    RESULT = E356tOilSetSig(U1.UU.C356tOilSetSig, U2.UU.C356tOilSetSig, LINK);
    break;

  case U357tOilTypeSet:
    RESULT = E357tOilTypeSet(U1.UU.C357tOilTypeSet, U2.UU.C357tOilTypeSet,
			     LINK);
    break;

  case U361tOilClassOpId:
    RESULT = E361tOilClassOpId(U1.UU.C361tOilClassOpId,
			       U2.UU.C361tOilClassOpId, LINK);
    break;

  case U362tOilClassCoercion:
    RESULT = E362tOilClassCoercion(U1.UU.C362tOilClassCoercion,
				   U2.UU.C362tOilClassCoercion, LINK);
    break;

  case U364tOilCoercionSeq:
    RESULT = E364tOilCoercionSeq(U1.UU.C364tOilCoercionSeq,
				 U2.UU.C364tOilCoercionSeq, LINK);
    break;

  case U92LIST:
  case U231tArgSig:
  case U232tTypeSet:
  case U246tSetOp:
  case U250tIdentMap:
  case U275tSetSig:
  case U276tArgSetValues:
  case U289tArgValues:
  case U291tArgValueList:
  case U452GEN:
  case U453GEN:
  case U454GEN:
    RESULT = COMPARELIST(U1.UU.COLIST, U2.UU.COLIST, LINK);
    break;
  }
  return RESULT;
}

Local boolean E144tKey(U1, U2, LINK)
Char *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T144tKey):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E154tOilClass(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T154tOilClass):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E156tOilType(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T156tOilType):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E158tOilOp(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T158tOilOp):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E160tStructTypeSet(U1, U2, LINK)
V160tStructTypeSet *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T160tStructTypeSet):Boolean
  */
  boolean RESULT;

  if (U1 == U2)
    RESULT = true;
  else {
    RESULT = COMPARELIST(U1->L233value, U2->L233value, LINK);

  }
  return RESULT;
}

Local boolean E184tKeyList(U1, U2, LINK)
Char *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T184tKeyList):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E209tOilArgSig(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T209tOilArgSig):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E213tOilClassArgSig(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T213tOilClassArgSig):
  Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E215tOilClassOp(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T215tOilClassOp):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E245tAnyOp(U1, U2, LINK)
V245tAnyOp *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T245tAnyOp):Boolean*/
  boolean RESULT;

  if (U1 == U2) {
    RESULT = true;
    return RESULT;
  }
  if (U1->DISCR != U2->DISCR) {
    RESULT = false;
    return RESULT;
  }
  switch (U1->DISCR) {

  case U158tOilOp:
    RESULT = E158tOilOp(U1->UU.C158tOilOp, U2->UU.C158tOilOp, LINK);
    break;

  case U215tOilClassOp:
    RESULT = E215tOilClassOp(U1->UU.C215tOilClassOp, U2->UU.C215tOilClassOp,
			     LINK);
    break;

  case U246tSetOp:
    RESULT = COMPARELIST(U1->UU.C246tSetOp, U2->UU.C246tSetOp, LINK);
    break;
  }
  return RESULT;
}

Local boolean E247tIdentPair(U1, U2, LINK)
V247tIdentPair *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T247tIdentPair):Boolean*/
  boolean RESULT;

  if (U1 == U2) {
    RESULT = true;
    return RESULT;
  }
  RESULT = false;
  if (U1->L248op == U2->L248op) {
    if (E158tOilOp(U1->L249indication, U2->L249indication, LINK))
      RESULT = true;
  }
  return RESULT;
}

Local boolean E277tArgSetValue(U1, U2, LINK)
V277tArgSetValue *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T277tArgSetValue):Boolean*/
  boolean RESULT;

  if (U1 == U2) {
    RESULT = true;
    return RESULT;
  }
  RESULT = false;
  if (E144tKey(U1->L253id, U2->L253id, LINK)) {
    if (COMPARELIST(U1->L233value, U2->L233value, LINK))
      RESULT = true;
  }
  return RESULT;
}

Local boolean E290tArgValue(U1, U2, LINK)
V290tArgValue *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T290tArgValue):Boolean*/
  boolean RESULT;

  if (U1 == U2) {
    RESULT = true;
    return RESULT;
  }
  RESULT = false;
  if (E144tKey(U1->L253id, U2->L253id, LINK)) {
    if (E156tOilType(U1->L233value, U2->L233value, LINK))
      RESULT = true;
  }
  return RESULT;
}

Local boolean E307tEnv(U1, U2, LINK)
Char *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T307tEnv):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E356tOilSetSig(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T356tOilSetSig):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E357tOilTypeSet(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T357tOilTypeSet):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E361tOilClassOpId(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T361tOilClassOpId):Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E362tOilClassCoercion(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T362tOilClassCoercion):
  Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}

Local boolean E364tOilCoercionSeq(U1, U2, LINK)
long *U1, *U2;
struct LOC_ATTREVAL *LINK;
{
  /*(U1,U2:T364tOilCoercionSeq):
  Boolean*/
  boolean RESULT;

  RESULT = (U1 == U2);
  return RESULT;
}


/*&END GEN INCLUDE*/

/* OPERATIONS PUSH AND POP ON ATTRIBUTE STACKS */

Local Void ATPUSH(HIVAR, SP, AT, LINK)
UNIONTYPE HIVAR;
char *SP;
UNIONTYPE **AT;
struct LOC_ATTREVAL *LINK;
{
  UNIONTYPE *WITH;

  if (*AT == NULL) {
    *AT = (UNIONTYPE *)Malloc(sizeof(ATARRAY));
    (*AT)[LINK_].UU.COARRAY = NULL;
    (*AT)[0].UU.COARRAY = NULL;
    *SP = 1;
  } else {
    if (*SP == MAXSTACK) {
      if ((*AT)[LINK_].UU.COARRAY == NULL) {
	(*AT)[LINK_].UU.COARRAY = (UNIONTYPE *)Malloc(sizeof(ATARRAY));
	WITH = &(*AT)[LINK_];
	WITH->UU.COARRAY[0].UU.COARRAY = *AT;
	WITH->UU.COARRAY[LINK_].UU.COARRAY = NULL;
      }
      *AT = (*AT)[LINK_].UU.COARRAY;
      *SP = 1;
    } else
      (*SP)++;
  }
  (*AT)[*SP] = HIVAR;
}  /* ATPUSH */

Local Void ATPOP(SP, AT, LINK)
char *SP;
UNIONTYPE **AT;
struct LOC_ATTREVAL *LINK;
{
  if (*AT == NULL || *SP <= 0) {
    MESSAGE(SYSERROR, (long)SYSTEMERRORMSG, 0L, GLOBPOS.LINE, GLOBPOS.COL);
    return;
  }
  if (*SP != 1) {
    (*SP)--;
    return;
  }
  if ((*AT)[0].UU.COARRAY == NULL)
    *SP = 0;
  else {
    *AT = (*AT)[0].UU.COARRAY;
    *SP = MAXSTACK;
  }
}



/* GENERAL INITIALIZATION */

Local Void INIT(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*====*/
  /* PERFORMANCE MEASUREMENT */
  LINK->MC = 0;
  LINK->ECOUNT = 0;
  LINK->BCOUNT = 0;
  LINK->SCPCOUNT = 0;
  LINK->STCOUNT = 0;
  LINK->STPOPCOUNT = 0;
  LINK->LCOUNT = 0;
  LINK->LPOPCOUNT = 0;

  LINK->GENNUMCOUNTER = 0;

  LINK->EMPTY.HEAD = NULL;
  LINK->EMPTY.LAST = NULL;



  LINK->A338162key = NULL;
  LINK->A342210cost = NULL;
  LINK->A329233value = NULL;
  LINK->A338324tkind = NULL;
  LINK->A329330definingId = NULL;
  LINK->A345346setOp = NULL;



  /*&END GEN INCLUDE*/


}  /*INIT*/


/* functions for ALADIN list processing */

Local Void COPYLIST(L, RES, LINK)
TPLIST L, *RES;
struct LOC_ATTREVAL *LINK;
{
  /*========*/
  TPLISTELEM *AUXL1, *AUXL2;



  /* ASSERT(L.HEAD <> NIL) */

  RES->HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  AUXL1 = RES->HEAD;
  AUXL2 = L.HEAD;
  AUXL1->ELEMENT = AUXL2->ELEMENT;
  while (AUXL2 != L.LAST) {
    AUXL2 = AUXL2->NEXT;
    AUXL1->NEXT = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
    AUXL1 = AUXL1->NEXT;
    AUXL1->ELEMENT = AUXL2->ELEMENT;
  }

  AUXL1->NEXT = NULL;
  RES->LAST = AUXL1;


}  /* COPYLIST */


Local Void CONCATELIST(L1, L2, RES, LINK)
TPLIST L1, L2, *RES;
struct LOC_ATTREVAL *LINK;
{
  /*===========*/
  /* RES := L1 + L2 */
  TPLIST LL;
  boolean CONT;
  TPLISTELEM *AUXL1, *AUXL2;


  if (L1.HEAD == NULL) {
    *RES = L2;
    return;
  }
  if (L2.HEAD == NULL) {
    *RES = L1;
    return;
  }
  LL = L1;   /* DEFAULT FIRST OPERAND (IF NO COPY NECESSARY) */
  CONT = false;
  if (L1.LAST->NEXT != NULL) {
    if (L1.LAST->NEXT != L2.HEAD)   /* CONTINUATION IMPOSSIBLE */
      COPYLIST(L1, &LL, LINK);
    else
      CONT = true;
  } else
    CONT = true;
  if (CONT) {  /* CHECK CYCLES */
    AUXL1 = L1.HEAD;
    AUXL2 = L2.LAST;   /* COMPARE ELEMENT */
    while (AUXL1 != NULL) {
      if (AUXL1 == AUXL2) {  /* CYCLE! */
	COPYLIST(L1, &LL, LINK);
	AUXL1 = NULL;   /* STOP LOOP */
      } else {
	if (AUXL1 == L1.LAST)
	  AUXL1 = NULL;   /* STOP */
	else
	  AUXL1 = AUXL1->NEXT;
      }
    }  /* WHILE AUXL1 */
  }  /* IF CONT */
  /* NOW LL HOLDS THE CORRECT FIRST OPERAND OF CONCATE */

  LL.LAST->NEXT = L2.HEAD;
  RES->HEAD = LL.HEAD;
  RES->LAST = L2.LAST;


}  /* CONCATELIST */


Local Void CONCATESTRING(S1, S2, RES, LINK)
long S1, S2, *RES;
struct LOC_ATTREVAL *LINK;
{
  /*=============*/
  *RES = S1;   /* NOT_YET_IMPLEMENTED; */

}


Local Void LINLIST(L1, RES, LINK)
TPLIST L1, *RES;
struct LOC_ATTREVAL *LINK;
{
  /*=======*/
  TPLISTELEM *AUXLISTPTR;
  TPLIST AUXLIST;
  UNIONTYPE *WITH;


  RES->HEAD = NULL;
  RES->LAST = NULL;

  AUXLISTPTR = L1.HEAD;

  while (AUXLISTPTR != NULL) {
    WITH = AUXLISTPTR->ELEMENT;

    /* ASSERT(AUXLISTPTR^.ELEMENT^.DISCR IN [HI_LIST,... ] */

    /* FALLS NOETIG, TEIL-LISTE KOPIEREN, DAMIT NICHT */
    /* SPAETER DIE GANZE LISTE KOPIERT WERDEN MUSS    */

    if (WITH->UU.COLIST.HEAD != NULL && AUXLISTPTR != L1.LAST) {
      /* (COLIST.LAST <> NIL) AND */
      if (WITH->UU.COLIST.LAST->NEXT != NULL) {
	if (WITH->UU.COLIST.LAST->NEXT !=
	    AUXLISTPTR->NEXT->ELEMENT->UU.COLIST.HEAD)
	  COPYLIST(WITH->UU.COLIST, &AUXLIST, LINK);
	else
	  AUXLIST = WITH->UU.COLIST;
      } else
	AUXLIST = WITH->UU.COLIST;
    } else
      AUXLIST = WITH->UU.COLIST;
    CONCATELIST(*RES, AUXLIST, RES, LINK);
    if (AUXLISTPTR == L1.LAST)
      AUXLISTPTR = NULL;
    else
      AUXLISTPTR = AUXLISTPTR->NEXT;

  }  /* WHILE */


}  /* LINLIST */


Local Void HEAD(L, FTHEAD, LINK)
TPLIST L;
UNIONTYPE *FTHEAD;
struct LOC_ATTREVAL *LINK;
{
  /* (L :TPLIST ;
                     VAR FTHEAD:UNIONTYPE) */
  /*HEAD*/
  if (L.HEAD == NULL)
    MESSAGE(IMPLCONDFAILS, (long)HEADFAILSMSG, 0L, GLOBPOS.LINE, GLOBPOS.COL);
  else {
    *FTHEAD = *L.HEAD->ELEMENT;
    /* ELEMENT IS OF ^UNIONTYPE */

  }
}



Local Void LAST(L, FTLAST, LINK)
TPLIST L;
UNIONTYPE *FTLAST;
struct LOC_ATTREVAL *LINK;
{
  /* (L: TPLIST ;
                     VAR FTLAST:UNIONTYPE) */
  /*LAST*/
  if (L.LAST == NULL)
    MESSAGE(IMPLCONDFAILS, (long)LASTFAILSMSG, 0L, GLOBPOS.LINE, GLOBPOS.COL);
  else {
    *FTLAST = *L.LAST->ELEMENT;
    /* ELEMENT IS OF ^UNIONTYPE */

  }
}



Local Void FRONT(L, FTFRONT, LINK)
TPLIST L;
UNIONTYPE *FTFRONT;
struct LOC_ATTREVAL *LINK;
{
  /* (L: TPLIST ;
                      VAR FTFRONT:UNIONTYPE) */
  TPLISTELEM *LPTR;


  /*FRONT*/
  if (L.HEAD == L.LAST) {
    FTFRONT->UU.COLIST.HEAD = NULL;
    FTFRONT->UU.COLIST.LAST = NULL;
    return;
  }
  /* ALADIN-TYP VON FTFRONT IST TPLIST => KEINE DISCR NOETIG */

  FTFRONT->UU.COLIST.HEAD = L.HEAD;
  LPTR = L.HEAD;
  while (LPTR->NEXT != L.LAST)
    LPTR = LPTR->NEXT;
  FTFRONT->UU.COLIST.LAST = LPTR;
}


Local Void TAIL(L, FTTAIL, LINK)
TPLIST L;
UNIONTYPE *FTTAIL;
struct LOC_ATTREVAL *LINK;
{
  /* (L: TPLIST ;
                     VAR FTTAIL:UNIONTYPE) */
  /*TAIL*/
  if (L.HEAD == L.LAST) {
    FTTAIL->UU.COLIST.HEAD = NULL;
    FTTAIL->UU.COLIST.LAST = NULL;
  } else {
    FTTAIL->UU.COLIST.HEAD = L.HEAD->NEXT;
    FTTAIL->UU.COLIST.LAST = L.LAST;
  }
  /* ALADIN-TYP VON FTTAIL IST TPLIST => KEINE DISCR NOETIG */

}


Local long LENGTH(L, LINK)
TPLIST L;
struct LOC_ATTREVAL *LINK;
{
  /* (L: TPLIST ):INTEGER */
  TPLISTELEM *LPTR;
  long LE;


  /*LENGTH*/
  if (L.HEAD == NULL)
    return 0;
  else {
    LPTR = L.HEAD;
    LE = 1;
    while (LPTR != L.LAST) {
      LE++;
      LPTR = LPTR->NEXT;
    }
    return LE;
  }


}

/*FUNCTION EMPTY    (L: TPLIST ):Boolean */
/*BEGIN  EMPTY := L.HEAD=NIL  END;       */


Local boolean ELEMINLIST(E, L, LINK)
UNIONTYPE E;
TPLIST L;
struct LOC_ATTREVAL *LINK;
{
  /* (E:UNIONTYPE; L:TPLIST ):Boolean */
  TPLISTELEM *LL;
  boolean FOUND;


  /*ELEMINLIST*/
  FOUND = false;
  LL = L.HEAD;
  while (LL != NULL && !FOUND) {
    if (COMPAREUNION(*LL->ELEMENT, E, LINK)) {
      FOUND = true;
      break;
    }
    if (LL == L.LAST)
      LL = NULL;
    else
      LL = LL->NEXT;
  }
  return FOUND;

}


Local boolean LISTINCLUSION(L1, L2, LINK)
TPLIST L1, L2;
struct LOC_ATTREVAL *LINK;
{
  /*(L1: TPLIST; L2: TPLIST ): Boolean */
  boolean HIVAR1, HIVAR2;
  TPLISTELEM *LL1, *LL2;


  /*LIST_INCLUSION*/
  LL1 = L1.HEAD;
  HIVAR1 = true;
  while (LL1 != NULL && HIVAR1) {
    LL2 = L2.HEAD;
    HIVAR2 = false;
    while (LL2 != NULL && !HIVAR2) {
      if (COMPAREUNION(*LL1->ELEMENT, *LL2->ELEMENT, LINK)) {
	HIVAR2 = true;
	break;
      }
      if (LL2 == L2.LAST)
	LL2 = NULL;
      else
	LL2 = LL2->NEXT;
    }
    HIVAR1 = HIVAR2;
    if (LL1 == L1.LAST)
      LL1 = NULL;
    else
      LL1 = LL1->NEXT;
  }
  return HIVAR1;

}


Local boolean UNIQUEELEMS(L, LINK)
TPLIST L;
struct LOC_ATTREVAL *LINK;
{
  /*(L: TPLIST ):Boolean;*/
  TPLISTELEM *LL, *LLT;
  boolean HIVAR0;


  /*UNIQUE_ELEMS*/
  LL = L.HEAD;
  HIVAR0 = true;
  while (LL != NULL && HIVAR0) {
    if (LL == L.LAST) {
      LL = NULL;
      break;
    }
    LLT = LL->NEXT;
    while (LLT != NULL && HIVAR0) {
      if (COMPAREUNION(*LL->ELEMENT, *LLT->ELEMENT, LINK)) {
	HIVAR0 = false;
	break;
      }
      if (LLT == L.LAST)
	LLT = NULL;
      else
	LLT = LLT->NEXT;
    }
    if (HIVAR0)
      LL = LL->NEXT;
  }
  return HIVAR0;

}

/*KEY functions*/

Local boolean KEYINLIST(LK, L, KEYDISCR, LINK)
UNIONTYPE LK;
TPLIST L;
char KEYDISCR;
struct LOC_ATTREVAL *LINK;
{
  TPLISTELEM *LL;
  UNIONTYPE HIVAR1;
  boolean FOUND;

  LL = L.HEAD;
  FOUND = false;
  while (LL != NULL && !FOUND) {
    HIVAR1 = *LL->ELEMENT;
    /* CASE KEYDISCR OF <ALL KEYLISTS> */


    switch (KEYDISCR) {

    case U250tIdentMap:
      HIVAR1.UU.C90SYMB = HIVAR1.UU.C247tIdentPair->L248op;
      HIVAR1.DISCR = U90SYMB;
      break;

    case U276tArgSetValues:
      HIVAR1.UU.C144tKey = HIVAR1.UU.C277tArgSetValue->L253id;
      HIVAR1.DISCR = U144tKey;
      break;

    case U289tArgValues:
      HIVAR1.UU.C144tKey = HIVAR1.UU.C290tArgValue->L253id;
      HIVAR1.DISCR = U144tKey;
      break;
    }

    /*&END GEN INCLUDE*/

    if (COMPAREUNION(HIVAR1, LK, LINK)) {
      FOUND = true;
      break;
    }
    if (LL == L.LAST)
      LL = NULL;
    else
      LL = LL->NEXT;
  }
  return FOUND;
}


Local Void SELECTBYKEY(LK, L, KEYDISCR, FTSELECTBYKEY, LINK)
UNIONTYPE LK;
TPLIST L;
char KEYDISCR;
UNIONTYPE *FTSELECTBYKEY;
struct LOC_ATTREVAL *LINK;
{
  TPLISTELEM *LL;
  UNIONTYPE HIVAR1;
  boolean FOUND;

  LL = L.HEAD;
  FOUND = false;
  while (LL != NULL && !FOUND) {
    HIVAR1 = *LL->ELEMENT;
    /* CASE KEYDISCR OF <ALL KEYLISTS> */


    switch (KEYDISCR) {

    case U250tIdentMap:
      HIVAR1.UU.C90SYMB = HIVAR1.UU.C247tIdentPair->L248op;
      HIVAR1.DISCR = U90SYMB;
      break;

    case U276tArgSetValues:
      HIVAR1.UU.C144tKey = HIVAR1.UU.C277tArgSetValue->L253id;
      HIVAR1.DISCR = U144tKey;
      break;

    case U289tArgValues:
      HIVAR1.UU.C144tKey = HIVAR1.UU.C290tArgValue->L253id;
      HIVAR1.DISCR = U144tKey;
      break;
    }

    /*&END GEN INCLUDE*/

    if (COMPAREUNION(HIVAR1, LK, LINK)) {
      FOUND = true;
      break;
    }
    if (LL == L.LAST)
      LL = NULL;
    else
      LL = LL->NEXT;
  }
  if (FOUND)
    *FTSELECTBYKEY = *LL->ELEMENT;
  else
    MESSAGE(IMPLCONDFAILS, (long)KEYFAILSMSG, 0L, GLOBPOS.LINE, GLOBPOS.COL);

}

Local boolean UNIQUEKEYS(L, KEYDISCR, LINK)
TPLIST L;
char KEYDISCR;
struct LOC_ATTREVAL *LINK;
{
  boolean UNIQUE;
  UNIONTYPE HIVAR1;
  TPLISTELEM *LL;
  TPLIST L2;

  L2 = L;
  LL = L.HEAD;
  UNIQUE = true;
  while (LL != NULL && UNIQUE) {
    if (LL == L.LAST) {
      LL = NULL;
      break;
    }
    HIVAR1 = *LL->ELEMENT;
    LL = LL->NEXT;
    /* CASE KEYDISCR OF <ALL KEYLISTS> */


    switch (KEYDISCR) {

    case U250tIdentMap:
      HIVAR1.UU.C90SYMB = HIVAR1.UU.C247tIdentPair->L248op;
      HIVAR1.DISCR = U90SYMB;
      break;

    case U276tArgSetValues:
      HIVAR1.UU.C144tKey = HIVAR1.UU.C277tArgSetValue->L253id;
      HIVAR1.DISCR = U144tKey;
      break;

    case U289tArgValues:
      HIVAR1.UU.C144tKey = HIVAR1.UU.C290tArgValue->L253id;
      HIVAR1.DISCR = U144tKey;
      break;
    }

    /*&END GEN INCLUDE*/

    L2.HEAD = LL;
    UNIQUE = !KEYINLIST(HIVAR1, L2, KEYDISCR, LINK);
  }
  return UNIQUE;
}

/*end of KEY-list functions*/

/*end of list functions*/

Local long REPETITION(LNODE, LINK)
NODE *LNODE;
struct LOC_ATTREVAL *LINK;
{
  /*==========*/
  long I;

  I = 0;
  LNODE = LNODE->UU.ELEMS;
  while (LNODE != NULL) {
    I++;
    LNODE = LNODE->BROTHER;
  }
  return I;

}  /* REPETITION */

Local long GENNUM(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*GENNUM*/
  LINK->GENNUMCOUNTER++;
  return LINK->GENNUMCOUNTER;
}

Local long GENSYMB(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*GENSYMB*/
  if (LINK->GENSYMBCOUNTER == MAXSYMB)
    MESSAGE(SYSLIMIT, (long)GENSYMBFULLMSG, 0L, GLOBPOS.LINE, GLOBPOS.COL);
  else
    LINK->GENSYMBCOUNTER++;
  return LINK->GENSYMBCOUNTER;
}

/*&END GEN INCLUDE*/



/*  19,  10 */
Local T147tObjKind F161GetaKind(X162key, X163default, LINK)
Char *X162key;
T147tObjKind X163default;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X163default:T147tObjKind):T147tObjKind;*/
  /*GetaKind*/
  return (GetaKind(X162key, X163default));
}

/*  20,  10 */
Local T147tObjKind F164SetaKind(X162key, X165added, X166changed, LINK)
Char *X162key;
T147tObjKind X165added, X166changed;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X165added:T147tObjKind;
            X166changed:T147tObjKind):T147tObjKind;*/
  /*SetaKind*/
  return (SetaKind(X162key, X165added, X166changed));
}

/*  22,  10 */
Local T149tTypeKind F167GetaTypeKind(X162key, X163default, LINK)
Char *X162key;
T149tTypeKind X163default;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X163default:T149tTypeKind):T149tTypeKind;*/
  /*GetaTypeKind*/
  return (GetaTypeKind(X162key, X163default));
}

/*  23,  10 */
Local T149tTypeKind F168SetaTypeKind(X162key, X165added, X166changed, LINK)
Char *X162key;
T149tTypeKind X165added, X166changed;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X165added:T149tTypeKind;
            X166changed:T149tTypeKind):T149tTypeKind;*/
  /*SetaTypeKind*/
  return (SetaTypeKind(X162key, X165added, X166changed));
}

/*  25,  10 */
Local T151tOpKind F169GetaOpKind(X162key, X163default, LINK)
Char *X162key;
T151tOpKind X163default;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X163default:T151tOpKind):T151tOpKind;*/
  /*GetaOpKind*/
  return (GetaOpKind(X162key, X163default));
}

/*  26,  10 */
Local T151tOpKind F170SetaOpKind(X162key, X165added, X166changed, LINK)
Char *X162key;
T151tOpKind X165added, X166changed;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X165added:T151tOpKind;
            X166changed:T151tOpKind):T151tOpKind;*/
  /*SetaOpKind*/
  return (SetaOpKind(X162key, X165added, X166changed));
}

/*  28,  10 */
Local long F171GetaValue(X162key, X163default, LINK)
Char *X162key;
long X163default;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X163default:T87INT):T87INT;*/
  /*GetaValue*/
  return (GetaValue(X162key, X163default));
}

/*  29,  10 */
Local long F172SetaValue(X162key, X165added, X166changed, LINK)
Char *X162key;
long X165added, X166changed;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X165added:T87INT;
            X166changed:T87INT):T87INT;*/
  /*SetaValue*/
  return (SetaValue(X162key, X165added, X166changed));
}

/*  31,  10 */
Local long *F173GetaClassId(X162key, X163default, LINK)
Char *X162key;
long *X163default;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X163default:T154tOilClass):T154tOilClass;*/
  /*GetaClassId*/
  return (GetaClassId(X162key, X163default));
}

/*  32,  10 */
Local long *F174SetaClassId(X162key, X165added, X166changed, LINK)
Char *X162key;
long *X165added, *X166changed;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X165added:T154tOilClass;
            X166changed:T154tOilClass):T154tOilClass;*/
  /*SetaClassId*/
  return (SetaClassId(X162key, X165added, X166changed));
}

/*  34,  10 */
Local long *F175GetaTypeId(X162key, X163default, LINK)
Char *X162key;
long *X163default;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X163default:T156tOilType):T156tOilType;*/
  /*GetaTypeId*/
  return (GetaTypeId(X162key, X163default));
}

/*  35,  10 */
Local long *F176SetaTypeId(X162key, X165added, X166changed, LINK)
Char *X162key;
long *X165added, *X166changed;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X165added:T156tOilType;
            X166changed:T156tOilType):T156tOilType;*/
  /*SetaTypeId*/
  return (SetaTypeId(X162key, X165added, X166changed));
}

/*  37,  10 */
Local long *F177GetaOpId(X162key, X163default, LINK)
Char *X162key;
long *X163default;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X163default:T158tOilOp):T158tOilOp;*/
  /*GetaOpId*/
  return (GetaOpId(X162key, X163default));
}

/*  38,  10 */
Local long *F178SetaOpId(X162key, X165added, X166changed, LINK)
Char *X162key;
long *X165added, *X166changed;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X165added:T158tOilOp;
            X166changed:T158tOilOp):T158tOilOp;*/
  /*SetaOpId*/
  return (SetaOpId(X162key, X165added, X166changed));
}

/*  40,  10 */
Local V160tStructTypeSet *F179GetaSetValue(X162key, X163default, LINK)
Char *X162key;
V160tStructTypeSet *X163default;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X163default:T160tStructTypeSet):T160tStructTypeSet;*/
  /*GetaSetValue*/
  return (GetaSetValue(X162key, X163default));
}

/*  41,  10 */
Local V160tStructTypeSet *F180SetaSetValue(X162key, X165added, X166changed,
					   LINK)
Char *X162key;
V160tStructTypeSet *X165added, *X166changed;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X165added:T160tStructTypeSet;
            X166changed:T160tStructTypeSet):T160tStructTypeSet;*/
  /*SetaSetValue*/
  return (SetaSetValue(X162key, X165added, X166changed));
}

/*  68,  18 */
Local Char *F183dbfNull(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T144tKey;*/
  /*dbfNull*/
  return (dbfNull());
}

/*  85,  10 */
Local Char *F186dbFind(X187relId, X188roleId1, X162key, X189roleId2, LINK)
long X187relId, X188roleId1;
Char *X162key;
long X189roleId2;
struct LOC_ATTREVAL *LINK;
{
  /*(X187relId:T87INT;
            X188roleId1:T87INT;
            X162key:T144tKey;
            X189roleId2:T87INT):T184tKeyList;*/
  /*dbFind*/
  return (dbFind(X187relId, X188roleId1, X162key, X189roleId2));
}

/*  97,  10 */
Local Char *F190dbOlReset(X191keyList, LINK)
Char *X191keyList;
struct LOC_ATTREVAL *LINK;
{
  /*(X191keyList:T184tKeyList):T184tKeyList;*/
  /*dbOlReset*/
  return (dbOlReset(X191keyList));
}

/*  109,  10 */
Local Char *F192dbOlNext(X191keyList, LINK)
Char *X191keyList;
struct LOC_ATTREVAL *LINK;
{
  /*(X191keyList:T184tKeyList):T144tKey;*/
  /*dbOlNext*/
  return (dbOlNext(X191keyList));
}

/*  117,  10 */
Local Char *F193dbOlFirst(X191keyList, LINK)
Char *X191keyList;
struct LOC_ATTREVAL *LINK;
{
  /*(X191keyList:T184tKeyList):T144tKey;*/
  /*dbOlFirst*/
  return (F192dbOlNext(F190dbOlReset(X191keyList, LINK), LINK));
}

/*  132,  10 */
Local Char *F194dbNewObject(X195otype, LINK)
long X195otype;
struct LOC_ATTREVAL *LINK;
{
  /*(X195otype:T87INT):T144tKey;*/
  /*dbNewObject*/
  return (dbNewObject(X195otype));
}

/*  139,  10 */
Local long F196dbGetObjectType(X162key, LINK)
Char *X162key;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey):T87INT;*/
  /*dbGetObjectType*/
  return (dbGetObjectType(X162key));
}

/*  152,  10 */
Local boolean F197dbSetObjectType(X162key, X195otype, LINK)
Char *X162key;
long X195otype;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X195otype:T87INT):T88BOOL;*/
  /*dbSetObjectType*/
  return (dbSetObjectType(X162key, X195otype));
}

/*  169,  10 */
Local boolean F198dbTestObjectType(X162key, X195otype, X199msg, LINK)
Char *X162key;
long X195otype, X199msg;
struct LOC_ATTREVAL *LINK;
{
  /*(X162key:T144tKey;
            X195otype:T87INT;
            X199msg:T87INT):T88BOOL;*/
  /*dbTestObjectType*/
  return (dbTestObjectType(X162key, X195otype, X199msg));
}

/*  183,  10 */
Local Char *F200NewDef(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T144tKey;*/
  /*NewDef*/
  return (NewDef());
}

/*  189,  10 */
Local Char *F201NoDef(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T144tKey;*/
  /*NoDef*/
  return (NoDef());
}

/*  195,  10 */
Local boolean F202DefInit(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T88BOOL;*/
  /*DefInit*/
  return (DefInit());
}

/*  212,  10 */
Local long *F203DefClass(X204name, X205numArgs, LINK)
long X204name, X205numArgs;
struct LOC_ATTREVAL *LINK;
{
  /*(X204name:T90SYMB;
            X205numArgs:T87INT):T154tOilClass;*/
  /*DefClass*/
  return (DefClass(X204name, X205numArgs));
}

/*  214,  10 */
Local long *F206DefType(X204name, LINK)
long X204name;
struct LOC_ATTREVAL *LINK;
{
  /*(X204name:T90SYMB):T156tOilType;*/
  /*DefType*/
  return (DefType(X204name));
}

/*  216,  10 */
Local long *F207DefOp(X204name, X208sig, X210cost, LINK)
long X204name, *X208sig, X210cost;
struct LOC_ATTREVAL *LINK;
{
  /*(X204name:T90SYMB;
            X208sig:T209tOilArgSig;
            X210cost:T87INT):T158tOilOp;*/
  /*DefOp*/
  return (DefOp(X204name, X208sig, X210cost));
}

/*  218,  10 */
Local long *F211DefSetOp(X204name, X208sig, X210cost, LINK)
long X204name, *X208sig, X210cost;
struct LOC_ATTREVAL *LINK;
{
  /*(X204name:T90SYMB;
            X208sig:T209tOilArgSig;
            X210cost:T87INT):T158tOilOp;*/
  /*DefSetOp*/
  return (DefSetOp(X204name, X208sig, X210cost));
}

/*  220,  10 */
Local long *F212DefClassOp(X204name, X208sig, X210cost, X214class, LINK)
long X204name, *X208sig, X210cost, *X214class;
struct LOC_ATTREVAL *LINK;
{
  /*(X204name:T90SYMB;
            X208sig:T213tOilClassArgSig;
            X210cost:T87INT;
            X214class:T154tOilClass):T215tOilClassOp;*/
  /*DefClassOp*/
  return (DefClassOp(X204name, X208sig, X210cost, X214class));
}

/*  240,  10 */
Local boolean F228ObjKindCheck(X195otype, X229typeWanted, LINK)
T147tObjKind X195otype, X229typeWanted;
struct LOC_ATTREVAL *LINK;
{
  /*(X195otype:T147tObjKind;
            X229typeWanted:T147tObjKind):T88BOOL;*/
  UNIONTYPE HIVAR1;

  /*ObjKindCheck*/
  if (X195otype != S219eErrorObj)
    HIVAR1.UU.C88BOOL = (X195otype == X229typeWanted);
  else
    HIVAR1.UU.C88BOOL = true;

  return (HIVAR1.UU.C88BOOL);
}

/*  271,  10 */
Local Void P238SetUnion(X239left, X240right, F238SetUnion, LINK)
TPLIST X239left, X240right;
UNIONTYPE *F238SetUnion;
struct LOC_ATTREVAL *LINK;
{
  /*(X239left:T232tTypeSet;
            X240right:T232tTypeSet;
            var F238SetUnion:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6;

  /*SetUnion*/
_L1:
  if (X239left.HEAD != NULL) {
    HEAD(X239left, &HIVAR3, LINK);
    HIVAR2.UU.C156tOilType = HIVAR3.UU.C156tOilType;
    HIVAR4.UU.C156tOilType = HIVAR2.UU.C156tOilType;
    HIVAR4.DISCR = U156tOilType;
    if (ELEMINLIST(HIVAR4, X240right, LINK))
      HIVAR4.UU.COLIST = X240right;
    else {
      HIVAR6.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
      HIVAR6.UU.COLIST.LAST = HIVAR6.UU.COLIST.HEAD;
      HIVAR6.UU.COLIST.LAST->NEXT = NULL;
      HIVAR6.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
      HIVAR6.UU.COLIST.HEAD->ELEMENT->DISCR = U156tOilType;
      HIVAR6.UU.COLIST.HEAD->ELEMENT->UU.C156tOilType = HIVAR2.UU.C156tOilType;
      CONCATELIST(HIVAR6.UU.COLIST, X240right, &HIVAR5.UU.COLIST, LINK);
      HIVAR4.UU.COLIST = HIVAR5.UU.COLIST;
    }
    HIVAR3.UU.COLIST = HIVAR4.UU.COLIST;
    TAIL(X239left, &HIVAR4, LINK);
    X239left = HIVAR4.UU.COLIST;
    X240right = HIVAR3.UU.COLIST;
    goto _L1;
  }

  HIVAR1.UU.COLIST = X240right;
  F238SetUnion->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  279,  10 */
Local Void P243SetIntersect(X239left, X240right, F243SetIntersect, LINK)
TPLIST X239left, X240right;
UNIONTYPE *F243SetIntersect;
struct LOC_ATTREVAL *LINK;
{
  /*(X239left:T232tTypeSet;
            X240right:T232tTypeSet;
            var F243SetIntersect:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6;

  /*SetIntersect*/
  if (X239left.HEAD == NULL)
    HIVAR1.UU.COLIST = LINK->EMPTY;
  else {
    HEAD(X239left, &HIVAR3, LINK);
    HIVAR2.UU.C156tOilType = HIVAR3.UU.C156tOilType;
    TAIL(X239left, &HIVAR5, LINK);
    P243SetIntersect(HIVAR5.UU.COLIST, X240right, &HIVAR4, LINK);
    HIVAR5.UU.C156tOilType = HIVAR2.UU.C156tOilType;
    HIVAR5.DISCR = U156tOilType;
    if (ELEMINLIST(HIVAR5, X240right, LINK)) {
      HIVAR6.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
      HIVAR6.UU.COLIST.LAST = HIVAR6.UU.COLIST.HEAD;
      HIVAR6.UU.COLIST.LAST->NEXT = NULL;
      HIVAR6.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
      HIVAR6.UU.COLIST.HEAD->ELEMENT->DISCR = U156tOilType;
      HIVAR6.UU.COLIST.HEAD->ELEMENT->UU.C156tOilType = HIVAR2.UU.C156tOilType;
      HIVAR5.UU.COLIST = HIVAR6.UU.COLIST;
    } else
      HIVAR5.UU.COLIST = LINK->EMPTY;
    CONCATELIST(HIVAR5.UU.COLIST, HIVAR4.UU.COLIST, &HIVAR3.UU.COLIST, LINK);
    HIVAR1.UU.COLIST = HIVAR3.UU.COLIST;
  }

  F243SetIntersect->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  290,  10 */
Local Void P244SetDifference(X239left, X240right, F244SetDifference, LINK)
TPLIST X239left, X240right;
UNIONTYPE *F244SetDifference;
struct LOC_ATTREVAL *LINK;
{
  /*(X239left:T232tTypeSet;
            X240right:T232tTypeSet;
            var F244SetDifference:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6;

  /*SetDifference*/
  if (X239left.HEAD == NULL)
    HIVAR1.UU.COLIST = LINK->EMPTY;
  else {
    HEAD(X239left, &HIVAR3, LINK);
    HIVAR2.UU.C156tOilType = HIVAR3.UU.C156tOilType;
    TAIL(X239left, &HIVAR5, LINK);
    P244SetDifference(HIVAR5.UU.COLIST, X240right, &HIVAR4, LINK);
    HIVAR5.UU.C156tOilType = HIVAR2.UU.C156tOilType;
    HIVAR5.DISCR = U156tOilType;
    if (ELEMINLIST(HIVAR5, X240right, LINK))
      HIVAR5.UU.COLIST = LINK->EMPTY;
    else {
      HIVAR6.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
      HIVAR6.UU.COLIST.LAST = HIVAR6.UU.COLIST.HEAD;
      HIVAR6.UU.COLIST.LAST->NEXT = NULL;
      HIVAR6.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
      HIVAR6.UU.COLIST.HEAD->ELEMENT->DISCR = U156tOilType;
      HIVAR6.UU.COLIST.HEAD->ELEMENT->UU.C156tOilType = HIVAR2.UU.C156tOilType;
      HIVAR5.UU.COLIST = HIVAR6.UU.COLIST;
    }
    CONCATELIST(HIVAR5.UU.COLIST, HIVAR4.UU.COLIST, &HIVAR3.UU.COLIST, LINK);
    HIVAR1.UU.COLIST = HIVAR3.UU.COLIST;
  }

  F244SetDifference->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  318,  10 */
Local boolean F251AddIdentification(X252Op, X214class, X253id, X254identMap,
				    LINK)
V245tAnyOp *X252Op;
long *X214class, X253id;
TPLIST X254identMap;
struct LOC_ATTREVAL *LINK;
{
  /*(X252Op:T245tAnyOp;
            X214class:T154tOilClass;
            X253id:T90SYMB;
            X254identMap:T250tIdentMap):T88BOOL;*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6;

  /*AddIdentification*/
  if (X254identMap.HEAD == NULL) {
    HIVAR1.UU.C88BOOL = true;
    return (HIVAR1.UU.C88BOOL);
  }

  HEAD(X254identMap, &HIVAR3, LINK);
  HIVAR2.UU.C247tIdentPair = HIVAR3.UU.C247tIdentPair;
  TAIL(X254identMap, &HIVAR4, LINK);
  HIVAR3.UU.COLIST = HIVAR4.UU.COLIST;
  if (HIVAR2.UU.C247tIdentPair->L248op == X253id) {
    HIVAR5.UU.C245tAnyOp = X252Op;
    switch (HIVAR5.UU.C245tAnyOp->DISCR) {

    case U158tOilOp:
      HIVAR6.UU.C88BOOL = F257OilAddIdentification(
	  HIVAR2.UU.C247tIdentPair->L249indication,
	  HIVAR5.UU.C245tAnyOp->UU.C158tOilOp, LINK);
      break;

    case U215tOilClassOp:
      HIVAR6.UU.C88BOOL = F258OilAddClassOpId(
	  HIVAR2.UU.C247tIdentPair->L249indication,
	  HIVAR5.UU.C245tAnyOp->UU.C215tOilClassOp, LINK);
      break;

    case U246tSetOp:
      HIVAR6.UU.C88BOOL = F259AddSetOpId(
	  HIVAR2.UU.C247tIdentPair->L249indication,
	  HIVAR5.UU.C245tAnyOp->UU.C246tSetOp, LINK);
      break;
    }
    HIVAR4.UU.C88BOOL = HIVAR6.UU.C88BOOL;
  } else
    HIVAR4.UU.C88BOOL = true;
  HIVAR1.UU.C88BOOL = (F251AddIdentification(X252Op, X214class, X253id,
					     HIVAR3.UU.COLIST, LINK) &&
		       HIVAR4.UU.C88BOOL);
  return (HIVAR1.UU.C88BOOL);
}

/*  1212,  10 */
Local boolean F257OilAddIdentification(X253id, X248op, LINK)
long *X253id, *X248op;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T158tOilOp;
            X248op:T158tOilOp):T88BOOL;*/
  /*OilAddIdentification*/
  return (OilAddIdentification(X253id, X248op));
}

/*  1301,  10 */
Local boolean F258OilAddClassOpId(X391ind, X248op, LINK)
long *X391ind, *X248op;
struct LOC_ATTREVAL *LINK;
{
  /*(X391ind:T158tOilOp;
            X248op:T215tOilClassOp):T88BOOL;*/
  /*OilAddClassOpId*/
  return (OilAddClassOpId(X391ind, X248op));
}

/*  476,  10 */
Local boolean F259AddSetOpId(X253id, X248op, LINK)
long *X253id;
TPLIST X248op;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T158tOilOp;
            X248op:T246tSetOp):T88BOOL;*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3;

  /*AddSetOpId*/
  if (X248op.HEAD == NULL) {
    HIVAR1.UU.C88BOOL = true;
    return (HIVAR1.UU.C88BOOL);
  }

  TAIL(X248op, &HIVAR2, LINK);
  HEAD(X248op, &HIVAR3, LINK);
  HIVAR1.UU.C88BOOL = F257OilAddIdentification(X253id, HIVAR3.UU.C158tOilOp,
	LINK) & F259AddSetOpId(X253id, HIVAR2.UU.COLIST, LINK);
  return (HIVAR1.UU.C88BOOL);
}

/*  342,  10 */
Local long *F260PrimSig(X261argSig, LINK)
TPLIST X261argSig;
struct LOC_ATTREVAL *LINK;
{
  /*(X261argSig:T231tArgSig):T209tOilArgSig;*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3;

  /*PrimSig*/
  if (X261argSig.HEAD == NULL) {
    HIVAR1.UU.C209tOilArgSig = F262OilNewArgSig(true, LINK);
    return (HIVAR1.UU.C209tOilArgSig);
  }

  HEAD(X261argSig, &HIVAR2, LINK);
  TAIL(X261argSig, &HIVAR3, LINK);
  HIVAR1.UU.C209tOilArgSig = F263OilAddArgSig(
      F175GetaTypeId(HIVAR2.UU.C144tKey, F264cErrorType(LINK), LINK),
      F260PrimSig(HIVAR3.UU.COLIST, LINK), LINK);
  return (HIVAR1.UU.C209tOilArgSig);
}

/*  1195,  10 */
Local long *F262OilNewArgSig(X316dummy, LINK)
boolean X316dummy;
struct LOC_ATTREVAL *LINK;
{
  /*(X316dummy:T88BOOL):T209tOilArgSig;*/
  /*OilNewArgSig*/
  return (OilNewArgSig(X316dummy));
}

/*  1197,  10 */
Local long *F263OilAddArgSig(X267arg, X208sig, LINK)
long *X267arg, *X208sig;
struct LOC_ATTREVAL *LINK;
{
  /*(X267arg:T156tOilType;
            X208sig:T209tOilArgSig):T209tOilArgSig;*/
  /*OilAddArgSig*/
  return (OilAddArgSig(X267arg, X208sig));
}

/*  501,  10 */
Local long *F264cErrorType(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T156tOilType;*/
  /*cErrorType*/
  return (cErrorType());
}

/*  350,  10 */
Local long *F265ClassSig(X261argSig, LINK)
TPLIST X261argSig;
struct LOC_ATTREVAL *LINK;
{
  /*(X261argSig:T231tArgSig):
  T213tOilClassArgSig;*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6, HIVAR7;

  /*ClassSig*/
  if (X261argSig.HEAD == NULL) {
    HIVAR1.UU.C213tOilClassArgSig = F266OilNewClassSigArg(true, LINK);
    return (HIVAR1.UU.C213tOilClassArgSig);
  }

  HEAD(X261argSig, &HIVAR3, LINK);
  HIVAR2.UU.C144tKey = HIVAR3.UU.C144tKey;
  HIVAR3.UU.C88BOOL = (F167GetaTypeKind(HIVAR2.UU.C144tKey, S220ePrimType,
					LINK) == S221eParamType);
  if (HIVAR3.UU.C88BOOL)
    HIVAR5.UU.C87INT = C270eParamRef;
  else
    HIVAR5.UU.C87INT = C271eSpecTypeRef;
  HIVAR4.UU.C87INT = HIVAR5.UU.C87INT;
  if (HIVAR3.UU.C88BOOL)
    HIVAR6.UU.C156tOilType = F264cErrorType(LINK);
  else
    HIVAR6.UU.C156tOilType = F175GetaTypeId(HIVAR2.UU.C144tKey,
					    F264cErrorType(LINK), LINK);
  HIVAR5.UU.C156tOilType = HIVAR6.UU.C156tOilType;
  if (HIVAR3.UU.C88BOOL)
    HIVAR7.UU.C87INT = F171GetaValue(HIVAR2.UU.C144tKey, 0L, LINK);
  else
    HIVAR7.UU.C87INT = 0;
  HIVAR6.UU.C87INT = HIVAR7.UU.C87INT;
  TAIL(X261argSig, &HIVAR7, LINK);
  HIVAR1.UU.C213tOilClassArgSig = F274OilAddClassSigArg(HIVAR4.UU.C87INT,
      HIVAR5.UU.C156tOilType, HIVAR6.UU.C87INT,
      F265ClassSig(HIVAR7.UU.COLIST, LINK), LINK);
  return (HIVAR1.UU.C213tOilClassArgSig);
}

/*  1285,  10 */
Local long *F266OilNewClassSigArg(X316dummy, LINK)
boolean X316dummy;
struct LOC_ATTREVAL *LINK;
{
  /*(X316dummy:T88BOOL):
  T213tOilClassArgSig;*/
  /*OilNewClassSigArg*/
  return (OilNewClassSigArg(X316dummy));
}

/*  1287,  10 */
Local long *F274OilAddClassSigArg(X269td, X272st, X273pi, X387cs, LINK)
long X269td, *X272st, X273pi, *X387cs;
struct LOC_ATTREVAL *LINK;
{
  /*(X269td:T87INT;
            X272st:T156tOilType;
            X273pi:T87INT;
            X387cs:T213tOilClassArgSig):T213tOilClassArgSig;*/
  /*OilAddClassSigArg*/
  return (OilAddClassSigArg(X269td, X272st, X273pi, X387cs));
}

/*  382,  10 */
Local Void P278SetSig(X261argSig, F278SetSig, LINK)
TPLIST X261argSig;
UNIONTYPE *F278SetSig;
struct LOC_ATTREVAL *LINK;
{
  /*(X261argSig:T231tArgSig;
            var F278SetSig:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3;

  /*SetSig*/
  P280UniqueIds(LINK->EMPTY, X261argSig, &HIVAR2, LINK);
  HIVAR1.UU.COLIST = HIVAR2.UU.COLIST;
  P282UniqueValues(HIVAR1.UU.COLIST, &HIVAR3, LINK);
  HIVAR2.UU.COLIST = HIVAR3.UU.COLIST;
  P283UniqueSigs(HIVAR2.UU.COLIST, X261argSig, &HIVAR3, LINK);

  F278SetSig->UU.COLIST = HIVAR3.UU.COLIST;
}

/*  390,  10 */
Local Void P280UniqueIds(X279uids, X285actualSig, F280UniqueIds, LINK)
TPLIST X279uids, X285actualSig;
UNIONTYPE *F280UniqueIds;
struct LOC_ATTREVAL *LINK;
{
  /*(X279uids:T276tArgSetValues;
            X285actualSig:T231tArgSig;
            var F280UniqueIds:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4;

  /*UniqueIds*/
_L1:
  if (X285actualSig.HEAD != NULL) {
    HEAD(X285actualSig, &HIVAR3, LINK);
    HIVAR2.UU.C144tKey = HIVAR3.UU.C144tKey;
    P288MapIdToSet(HIVAR2.UU.C144tKey, X279uids, &HIVAR4, LINK);
    HIVAR3.UU.COLIST = HIVAR4.UU.COLIST;
    TAIL(X285actualSig, &HIVAR4, LINK);
    X279uids = HIVAR3.UU.COLIST;
    X285actualSig = HIVAR4.UU.COLIST;
    goto _L1;
  }

  HIVAR1.UU.COLIST = X279uids;
  F280UniqueIds->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  415,  10 */
Local Void P282UniqueValues(X279uids, F282UniqueValues, LINK)
TPLIST X279uids;
UNIONTYPE *F282UniqueValues;
struct LOC_ATTREVAL *LINK;
{
  /*(X279uids:T276tArgSetValues;
            var F282UniqueValues:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5;

  /*UniqueValues*/
  if (X279uids.HEAD == NULL)
    HIVAR1.UU.COLIST = LINK->EMPTY;
  else {
    HEAD(X279uids, &HIVAR3, LINK);
    HIVAR2.UU.C277tArgSetValue = HIVAR3.UU.C277tArgSetValue;
    TAIL(X279uids, &HIVAR5, LINK);
    P282UniqueValues(HIVAR5.UU.COLIST, &HIVAR4, LINK);
    P292ConsValueS(HIVAR2.UU.C277tArgSetValue->L253id,
		   HIVAR2.UU.C277tArgSetValue->L233value, HIVAR4.UU.COLIST,
		   &HIVAR3, LINK);
    HIVAR1.UU.COLIST = HIVAR3.UU.COLIST;
  }

  F282UniqueValues->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  447,  10 */
Local Void P283UniqueSigs(X279uids, X285actualSig, F283UniqueSigs, LINK)
TPLIST X279uids, X285actualSig;
UNIONTYPE *F283UniqueSigs;
struct LOC_ATTREVAL *LINK;
{
  /*(X279uids:T291tArgValueList;
            X285actualSig:T231tArgSig;
            var F283UniqueSigs:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5;

  /*UniqueSigs*/
  if (X279uids.HEAD == NULL)
    HIVAR1.UU.COLIST = LINK->EMPTY;
  else {
    HEAD(X279uids, &HIVAR4, LINK);
    HIVAR3.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
    HIVAR3.UU.COLIST.LAST = HIVAR3.UU.COLIST.HEAD;
    HIVAR3.UU.COLIST.LAST->NEXT = NULL;
    HIVAR3.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
    HIVAR3.UU.COLIST.HEAD->ELEMENT->DISCR = U209tOilArgSig;
    HIVAR3.UU.COLIST.HEAD->ELEMENT->UU.C209tOilArgSig = F295UniqueSig(
	HIVAR4.UU.COLIST, X285actualSig, LINK);
    TAIL(X279uids, &HIVAR5, LINK);
    P283UniqueSigs(HIVAR5.UU.COLIST, X285actualSig, &HIVAR4, LINK);
    CONCATELIST(HIVAR4.UU.COLIST, HIVAR3.UU.COLIST, &HIVAR2.UU.COLIST, LINK);
    HIVAR1.UU.COLIST = HIVAR2.UU.COLIST;
  }

  F283UniqueSigs->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  398,  10 */
Local Void P288MapIdToSet(X286aid, X279uids, F288MapIdToSet, LINK)
Char *X286aid;
TPLIST X279uids;
UNIONTYPE *F288MapIdToSet;
struct LOC_ATTREVAL *LINK;
{
  /*(X286aid:T144tKey;
            X279uids:T276tArgSetValues;
            var F288MapIdToSet:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5;
  V277tArgSetValue *WITH;

  /*MapIdToSet*/
  HIVAR1.UU.C144tKey = X286aid;
  HIVAR1.DISCR = U144tKey;
  if (KEYINLIST(HIVAR1, X279uids, U276tArgSetValues, LINK))
    HIVAR1.UU.COLIST = X279uids;
  else {
    HIVAR3.UU.C149tTypeKind = F167GetaTypeKind(X286aid, S220ePrimType, LINK);
    if (((1L << ((long)HIVAR3.UU.C149tTypeKind)) &
	 ((1L << ((long)S220ePrimType)) | (1L << ((long)S223ePrimSet)) |
	  (1L << ((long)S222eForType)))) != 0) {
/* p2c: walk.p, line 4322: Note:
 * Line breaker spent 1.0+0.54 seconds, 551 tries on line 3270 [251] */
      switch (HIVAR3.UU.C149tTypeKind) {

      case S220ePrimType:
	HIVAR5.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
	HIVAR5.UU.COLIST.LAST = HIVAR5.UU.COLIST.HEAD;
	HIVAR5.UU.COLIST.LAST->NEXT = NULL;
	HIVAR5.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
	HIVAR5.UU.COLIST.HEAD->ELEMENT->DISCR = U156tOilType;
	HIVAR5.UU.COLIST.HEAD->ELEMENT->UU.C156tOilType = F175GetaTypeId(
	    X286aid, F264cErrorType(LINK), LINK);
	HIVAR4.UU.COLIST = HIVAR5.UU.COLIST;
	break;

      case S223ePrimSet:
	HIVAR5.UU.C160tStructTypeSet = F179GetaSetValue(X286aid,
	    LINK->C284cErrorTypeSet, LINK);
	HIVAR4.UU.COLIST = HIVAR5.UU.C160tStructTypeSet->L233value;
	break;

      case S222eForType:
	HIVAR5.UU.C160tStructTypeSet = F179GetaSetValue(X286aid,
	    LINK->C284cErrorTypeSet, LINK);
	HIVAR4.UU.COLIST = HIVAR5.UU.C160tStructTypeSet->L233value;
	break;
      }
    } else
      HIVAR4.UU.COLIST = LINK->C284cErrorTypeSet->L233value;
    HIVAR2.UU.COLIST = HIVAR4.UU.COLIST;
    HIVAR5.UU.C277tArgSetValue = (V277tArgSetValue *)
				 Malloc(sizeof(V277tArgSetValue));
    WITH = HIVAR5.UU.C277tArgSetValue;
    WITH->L253id = X286aid;
    WITH->L233value = HIVAR2.UU.COLIST;
    HIVAR4.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
    HIVAR4.UU.COLIST.LAST = HIVAR4.UU.COLIST.HEAD;
    HIVAR4.UU.COLIST.LAST->NEXT = NULL;
    HIVAR4.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
    HIVAR4.UU.COLIST.HEAD->ELEMENT->DISCR = U277tArgSetValue;
    HIVAR4.UU.COLIST.HEAD->ELEMENT->UU.C277tArgSetValue = HIVAR5.UU.C277tArgSetValue;
    CONCATELIST(X279uids, HIVAR4.UU.COLIST, &HIVAR3.UU.COLIST, LINK);
    HIVAR1.UU.COLIST = HIVAR3.UU.COLIST;
  }

  F288MapIdToSet->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  423,  10 */
Local Void P292ConsValueS(X253id, X233value, X293others, F292ConsValueS, LINK)
Char *X253id;
TPLIST X233value, X293others;
UNIONTYPE *F292ConsValueS;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T144tKey;
            X233value:T232tTypeSet;
            X293others:T291tArgValueList;
            var F292ConsValueS:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6;

  /*ConsValueS*/
  if (X293others.HEAD == NULL) {
    P294ConsValue(X253id, X233value, LINK->EMPTY, &HIVAR2, LINK);
    HIVAR1.UU.COLIST = HIVAR2.UU.COLIST;
  } else {
    HEAD(X293others, &HIVAR4, LINK);
    P294ConsValue(X253id, X233value, HIVAR4.UU.COLIST, &HIVAR3, LINK);
    TAIL(X293others, &HIVAR4, LINK);
    if (HIVAR4.UU.COLIST.HEAD == NULL)
      HIVAR4.UU.COLIST = LINK->EMPTY;
    else {
      TAIL(X293others, &HIVAR6, LINK);
      P292ConsValueS(X253id, X233value, HIVAR6.UU.COLIST, &HIVAR5, LINK);
      HIVAR4.UU.COLIST = HIVAR5.UU.COLIST;
    }
    CONCATELIST(HIVAR4.UU.COLIST, HIVAR3.UU.COLIST, &HIVAR2.UU.COLIST, LINK);
    HIVAR1.UU.COLIST = HIVAR2.UU.COLIST;
  }

  F292ConsValueS->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  434,  10 */
Local Void P294ConsValue(X253id, X233value, X293others, F294ConsValue, LINK)
Char *X253id;
TPLIST X233value, X293others;
UNIONTYPE *F294ConsValue;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T144tKey;
            X233value:T232tTypeSet;
            X293others:T289tArgValues;
            var F294ConsValue:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6, HIVAR7, HIVAR8;
  V290tArgValue *WITH;

  /*ConsValue*/
  if (X233value.HEAD == NULL)
    HIVAR1.UU.COLIST = LINK->EMPTY;
  else {
    TAIL(X233value, &HIVAR4, LINK);
    P294ConsValue(X253id, HIVAR4.UU.COLIST, X293others, &HIVAR3, LINK);
    HIVAR7.UU.C290tArgValue = (V290tArgValue *)Malloc(sizeof(V290tArgValue));
    WITH = HIVAR7.UU.C290tArgValue;
    HEAD(X233value, &HIVAR8, LINK);
    WITH->L253id = X253id;
    WITH->L233value = HIVAR8.UU.C156tOilType;
    HIVAR6.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
    HIVAR6.UU.COLIST.LAST = HIVAR6.UU.COLIST.HEAD;
    HIVAR6.UU.COLIST.LAST->NEXT = NULL;
    HIVAR6.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
    HIVAR6.UU.COLIST.HEAD->ELEMENT->DISCR = U290tArgValue;
    HIVAR6.UU.COLIST.HEAD->ELEMENT->UU.C290tArgValue = HIVAR7.UU.C290tArgValue;
    CONCATELIST(HIVAR6.UU.COLIST, X293others, &HIVAR5.UU.COLIST, LINK);
    HIVAR4.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
    HIVAR4.UU.COLIST.LAST = HIVAR4.UU.COLIST.HEAD;
    HIVAR4.UU.COLIST.LAST->NEXT = NULL;
    HIVAR4.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
    HIVAR4.UU.COLIST.HEAD->ELEMENT->DISCR = U289tArgValues;
    HIVAR4.UU.COLIST.HEAD->ELEMENT->UU.COLIST = HIVAR5.UU.COLIST;
    CONCATELIST(HIVAR4.UU.COLIST, HIVAR3.UU.COLIST, &HIVAR2.UU.COLIST, LINK);
    HIVAR1.UU.COLIST = HIVAR2.UU.COLIST;
  }

  F294ConsValue->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  452,  10 */
Local long *F295UniqueSig(X296avs, X285actualSig, LINK)
TPLIST X296avs, X285actualSig;
struct LOC_ATTREVAL *LINK;
{
  /*(X296avs:T289tArgValues;
            X285actualSig:T231tArgSig):T209tOilArgSig;*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5;

  /*UniqueSig*/
  if (X285actualSig.HEAD == NULL) {
    HIVAR1.UU.C209tOilArgSig = F262OilNewArgSig(true, LINK);
    return (HIVAR1.UU.C209tOilArgSig);
  }

  HEAD(X285actualSig, &HIVAR3, LINK);
  HIVAR2.UU.C144tKey = HIVAR3.UU.C144tKey;
  HIVAR5.UU.C144tKey = HIVAR2.UU.C144tKey;
  HIVAR5.DISCR = U144tKey;
  SELECTBYKEY(HIVAR5, X296avs, U289tArgValues, &HIVAR4, LINK);
  HIVAR3.UU.C290tArgValue = HIVAR4.UU.C290tArgValue;
  HIVAR4.UU.C156tOilType = HIVAR3.UU.C290tArgValue->L233value;
  TAIL(X285actualSig, &HIVAR5, LINK);
  HIVAR1.UU.C209tOilArgSig = F263OilAddArgSig(HIVAR4.UU.C156tOilType,
      F295UniqueSig(X296avs, HIVAR5.UU.COLIST, LINK), LINK);
  return (HIVAR1.UU.C209tOilArgSig);
}

/*  464,  10 */
Local Void P298AddSetOp(X253id, X208sig, X210cost, F298AddSetOp, LINK)
long X253id;
TPLIST X208sig;
long X210cost;
UNIONTYPE *F298AddSetOp;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T90SYMB;
            X208sig:T275tSetSig;
            X210cost:T87INT;
            var F298AddSetOp:UNIONTYPE);*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5;

  /*AddSetOp*/
  if (X208sig.HEAD == NULL)
    HIVAR1.UU.COLIST = LINK->EMPTY;
  else {
    TAIL(X208sig, &HIVAR4, LINK);
    P298AddSetOp(X253id, HIVAR4.UU.COLIST, X210cost, &HIVAR3, LINK);
    HEAD(X208sig, &HIVAR5, LINK);
    HIVAR4.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
    HIVAR4.UU.COLIST.LAST = HIVAR4.UU.COLIST.HEAD;
    HIVAR4.UU.COLIST.LAST->NEXT = NULL;
    HIVAR4.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
    HIVAR4.UU.COLIST.HEAD->ELEMENT->DISCR = U158tOilOp;
    HIVAR4.UU.COLIST.HEAD->ELEMENT->UU.C158tOilOp = F211DefSetOp(X253id,
	HIVAR5.UU.C209tOilArgSig, X210cost, LINK);
    CONCATELIST(HIVAR4.UU.COLIST, HIVAR3.UU.COLIST, &HIVAR2.UU.COLIST, LINK);
    HIVAR1.UU.COLIST = HIVAR2.UU.COLIST;
  }

  F298AddSetOp->UU.COLIST = HIVAR1.UU.COLIST;
}

/*  487,  10 */
Local boolean F299AddSetCoercion(X248op, LINK)
TPLIST X248op;
struct LOC_ATTREVAL *LINK;
{
  /*(X248op:T246tSetOp):T88BOOL;*/
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3;

  /*AddSetCoercion*/
  if (X248op.HEAD == NULL) {
    HIVAR1.UU.C88BOOL = true;
    return (HIVAR1.UU.C88BOOL);
  }

  TAIL(X248op, &HIVAR2, LINK);
  HEAD(X248op, &HIVAR3, LINK);
  HIVAR1.UU.C88BOOL = F300OilAddCoercion(HIVAR3.UU.C158tOilOp, LINK) &
		      F299AddSetCoercion(HIVAR2.UU.COLIST, LINK);
  return (HIVAR1.UU.C88BOOL);
}

/*  1255,  10 */
Local boolean F300OilAddCoercion(X248op, LINK)
long *X248op;
struct LOC_ATTREVAL *LINK;
{
  /*(X248op:T158tOilOp):T88BOOL;*/
  /*OilAddCoercion*/
  return (OilAddCoercion(X248op));
}

/*  503,  10 */
Local long *F301cErrorOp(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T158tOilOp;*/
  /*cErrorOp*/
  return (cErrorOp());
}

/*  505,  10 */
Local long *F302cErrorClass(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T154tOilClass;*/
  /*cErrorClass*/
  return (cErrorClass());
}

/*  1338,  10 */
Local Char *F309NewEnv(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T307tEnv;*/
  /*NewEnv*/
  return (NewEnv());
}

/*  1402,  10 */
Local Char *F319DefineIdn(X406e, X407i, LINK)
Char *X406e;
long X407i;
struct LOC_ATTREVAL *LINK;
{
  /*(X406e:T307tEnv;
            X407i:T90SYMB):T144tKey;*/
  /*DefineIdn*/
  return (DefineIdn(X406e, X407i));
}

/*  1385,  10 */
Local Char *F322KeyInScope(X406e, X407i, LINK)
Char *X406e;
long X407i;
struct LOC_ATTREVAL *LINK;
{
  /*(X406e:T307tEnv;
            X407i:T90SYMB):T144tKey;*/
  /*KeyInScope*/
  return (KeyInScope(X406e, X407i));
}

/*  1352,  10 */
Local Char *F323NewScope(X406e, LINK)
Char *X406e;
struct LOC_ATTREVAL *LINK;
{
  /*(X406e:T307tEnv):T307tEnv;*/
  /*NewScope*/
  return (NewScope(X406e));
}

/*  1368,  10 */
Local Char *F325KeyInEnv(X406e, X407i, LINK)
Char *X406e;
long X407i;
struct LOC_ATTREVAL *LINK;
{
  /*(X406e:T307tEnv;
            X407i:T90SYMB):T144tKey;*/
  /*KeyInEnv*/
  return (KeyInEnv(X406e, X407i));
}

/*  1306,  10 */
Local boolean F341OilAddClassCoercion(X248op, LINK)
long *X248op;
struct LOC_ATTREVAL *LINK;
{
  /*(X248op:T215tOilClassOp):T88BOOL
  ;*/
  /*OilAddClassCoercion*/
  return (OilAddClassCoercion(X248op));
}

/*  1199,  10 */
Local long *F366OilNewSetSig(X316dummy, LINK)
boolean X316dummy;
struct LOC_ATTREVAL *LINK;
{
  /*(X316dummy:T88BOOL):T209tOilArgSig;*/
  /*OilNewSetSig*/
  return (OilNewSetSig(X316dummy));
}

/*  1200,  10 */
Local long *F367OilAddSetSig(X267arg, X208sig, LINK)
long *X267arg, *X208sig;
struct LOC_ATTREVAL *LINK;
{
  /*(X267arg:T357tOilTypeSet;
            X208sig:T209tOilArgSig):T209tOilArgSig;*/
  /*OilAddSetSig*/
  return (OilAddSetSig(X267arg, X208sig));
}

/*  1202,  10 */
Local long *F368OilNewOp(X253id, X210cost, X208sig, LINK)
long X253id, X210cost, *X208sig;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T87INT;
            X210cost:T87INT;
            X208sig:T209tOilArgSig):T158tOilOp;*/
  /*OilNewOp*/
  return (OilNewOp(X253id, X210cost, X208sig));
}

/*  1208,  10 */
Local long *F369OilErrorOp(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T158tOilOp;*/
  /*OilErrorOp*/
  return (OilErrorOp());
}

/*  1216,  10 */
Local long *F370OilNewType(X253id, LINK)
long X253id;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T87INT):T156tOilType;*/
  /*OilNewType*/
  return (OilNewType(X253id));
}

/*  1218,  10 */
Local long *F371OilErrorType(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T156tOilType;*/
  /*OilErrorType*/
  return (OilErrorType());
}

/*  1221,  10 */
Local long *F372OilNewTypeInClass(X321c, X373as, X253id, LINK)
long *X321c, *X373as, X253id;
struct LOC_ATTREVAL *LINK;
{
  /*(X321c:T154tOilClass;
            X373as:T209tOilArgSig;
            X253id:T87INT):T156tOilType;*/
  /*OilNewTypeInClass*/
  return (OilNewTypeInClass(X321c, X373as, X253id));
}

/*  1230,  11 */
Local boolean F374OilSetIncludes(X375t1, X376t2, LINK)
long *X375t1, *X376t2;
struct LOC_ATTREVAL *LINK;
{
  /*(X375t1:T357tOilTypeSet;
            X376t2:T156tOilType):T88BOOL;*/
  /*OilSetIncludes*/
  return (OilSetIncludes(X375t1, X376t2));
}

/*  1235,  10 */
Local boolean F377OilIsCoercibleTo(X375t1, X376t2, LINK)
long *X375t1, *X376t2;
struct LOC_ATTREVAL *LINK;
{
  /*(X375t1:T156tOilType;
            X376t2:T156tOilType):T88BOOL;*/
  /*OilIsCoercibleTo*/
  return (OilIsCoercibleTo(X375t1, X376t2));
}

/*  1239,  10 */
Local boolean F378OilCanIdSigs(X379src, X380dest, LINK)
long *X379src, *X380dest;
struct LOC_ATTREVAL *LINK;
{
  /*(X379src:T356tOilSetSig;
            X380dest:T209tOilArgSig):T88BOOL;*/
  /*OilCanIdSigs*/
  return (OilCanIdSigs(X379src, X380dest));
}

/*  1245,  10 */
Local boolean F381OilIsValidCS(X382ccs, LINK)
long *X382ccs;
struct LOC_ATTREVAL *LINK;
{
  /*(X382ccs:T364tOilCoercionSeq):T88BOOL;
  */
  /*OilIsValidCS*/
  return (OilIsValidCS(X382ccs));
}

/*  1247,  10 */
Local long *F383OilErrorCS(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*:T364tOilCoercionSeq;*/
  /*OilErrorCS*/
  return (OilErrorCS());
}

/*  1250,  10 */
Local boolean F384OilIsValidOp(X248op, LINK)
long *X248op;
struct LOC_ATTREVAL *LINK;
{
  /*(X248op:T158tOilOp):T88BOOL;*/
  /*OilIsValidOp*/
  return (OilIsValidOp(X248op));
}

/*  1253,  10 */
Local long *F385OilCoerce(X375t1, X376t2, LINK)
long *X375t1, *X376t2;
struct LOC_ATTREVAL *LINK;
{
  /*(X375t1:T156tOilType;
            X376t2:T156tOilType):T364tOilCoercionSeq;*/
  /*OilCoerce*/
  return (OilCoerce(X375t1, X376t2));
}

/*  1257,  10 */
Local boolean F386OilEmptyCS(X387cs, LINK)
long *X387cs;
struct LOC_ATTREVAL *LINK;
{
  /*(X387cs:T364tOilCoercionSeq):T88BOOL;*/
  /*OilEmptyCS*/
  return (OilEmptyCS(X387cs));
}

/*  1259,  10 */
Local long *F388OilHeadCS(X387cs, LINK)
long *X387cs;
struct LOC_ATTREVAL *LINK;
{
  /*(X387cs:T364tOilCoercionSeq):T158tOilOp;*/
  /*OilHeadCS*/
  return (OilHeadCS(X387cs));
}

/*  1261,  10 */
Local long *F389OilTailCS(X387cs, LINK)
long *X387cs;
struct LOC_ATTREVAL *LINK;
{
  /*(X387cs:T364tOilCoercionSeq):
  T364tOilCoercionSeq;*/
  /*OilTailCS*/
  return (OilTailCS(X387cs));
}

/*  1267,  10 */
Local long *F390OilIdResultSet(X391ind, X392setsig, LINK)
long *X391ind, *X392setsig;
struct LOC_ATTREVAL *LINK;
{
  /*(X391ind:T158tOilOp;
            X392setsig:T356tOilSetSig):T357tOilTypeSet;*/
  /*OilIdResultSet*/
  return (OilIdResultSet(X391ind, X392setsig));
}

/*  1272,  10 */
Local long *F393OilTypeToSet(X394t, LINK)
long *X394t;
struct LOC_ATTREVAL *LINK;
{
  /*(X394t:T156tOilType):T357tOilTypeSet;*/
  /*OilTypeToSet*/
  return (OilTypeToSet(X394t));
}

/*  1274,  10 */
Local long *F395OilBalance(X396ts1, X397ts2, LINK)
long *X396ts1, *X397ts2;
struct LOC_ATTREVAL *LINK;
{
  /*(X396ts1:T357tOilTypeSet;
            X397ts2:T357tOilTypeSet):T156tOilType;*/
  /*OilBalance*/
  return (OilBalance(X396ts1, X397ts2));
}

/*  1276,  10 */
Local long *F398OilSelectTypeFromTS(X399ts, LINK)
long *X399ts;
struct LOC_ATTREVAL *LINK;
{
  /*(X399ts:T357tOilTypeSet):
  T156tOilType;*/
  /*OilSelectTypeFromTS*/
  return (F395OilBalance(X399ts, X399ts, LINK));
}

/*  1279,  10 */
Local long *F400OilNewClass(X253id, X401argNum, LINK)
long X253id, X401argNum;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T87INT;
            X401argNum:T87INT):T154tOilClass;*/
  /*OilNewClass*/
  return (OilNewClass(X253id, X401argNum));
}

/*  1294,  10 */
Local long *F402OilAddClassOp(X253id, X208sig, X210cost, X321c, LINK)
long X253id, *X208sig, X210cost, *X321c;
struct LOC_ATTREVAL *LINK;
{
  /*(X253id:T87INT;
            X208sig:T213tOilClassArgSig;
            X210cost:T87INT;
            X321c:T154tOilClass):T215tOilClassOp;*/
  /*OilAddClassOp*/
  return (OilAddClassOp(X253id, X208sig, X210cost, X321c));
}

/*  1312,  10 */
Local long *F403OilGetArgType(X248op, X404n, LINK)
long *X248op, X404n;
struct LOC_ATTREVAL *LINK;
{
  /*(X248op:T158tOilOp;
            X404n:T87INT):T156tOilType;*/
  /*OilGetArgType*/
  return (OilGetArgType(X248op, X404n));
}

/*  1421,  10 */
Local Char *F408AddIdn(X406e, X407i, X349k, LINK)
Char *X406e;
long X407i;
Char *X349k;
struct LOC_ATTREVAL *LINK;
{
  /*(X406e:T307tEnv;
            X407i:T90SYMB;
            X349k:T144tKey):T144tKey;*/
  /*AddIdn*/
  return (AddIdn(X406e, X407i, X349k));
}

/* Local variables for SEMANALYSE: */
struct LOC_SEMANALYSE {
  struct LOC_ATTREVAL *LINK;


  UNIONTYPE HIVAR0, HIVAR1, HIVAR2;
} ;


Local Void SEMINIT(LINK)
struct LOC_SEMANALYSE *LINK;
{
  /*======*/
  V160tStructTypeSet *WITH;

  VSFILE(EMPTYRULE + 1L);




  LINK->LINK->C182dbNull = F183dbfNull(LINK->LINK);
  LINK->HIVAR1.UU.C160tStructTypeSet =
    (V160tStructTypeSet *)Malloc(sizeof(V160tStructTypeSet));
  WITH = LINK->HIVAR1.UU.C160tStructTypeSet;
  LINK->HIVAR2.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  LINK->HIVAR2.UU.COLIST.LAST = LINK->HIVAR2.UU.COLIST.HEAD;
  LINK->HIVAR2.UU.COLIST.LAST->NEXT = NULL;
  LINK->HIVAR2.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
  LINK->HIVAR2.UU.COLIST.HEAD->ELEMENT->DISCR = U156tOilType;
  LINK->HIVAR2.UU.COLIST.HEAD->ELEMENT->UU.C156tOilType = F264cErrorType(LINK->LINK);
  WITH->L233value = LINK->HIVAR2.UU.COLIST;
  LINK->LINK->C284cErrorTypeSet = LINK->HIVAR1.UU.C160tStructTypeSet;



  /*&END GEN INCLUDE*/

}  /*SEMINIT*/



Local Void SEM0(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  525,  9 */
  WITH->UU.U1.UU.U4.A304305defEnv = F309NewEnv(LINK->LINK);

}  /*SEM0*/

Local Void SEM1(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  527,  9 */
  WITH->UU.U1.UU.U4.A304306refEnv = LINK->LINK->A342305defEnv;
  /*  528,  15 */
  LINK->LINK->A342305defEnv = WITH->UU.U1.UU.U4.A304306refEnv;

}  /*SEM1*/

Local Void SEM2(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  529,  9 */
  WITH->UU.U1.UU.U4.A304254identMap = LINK->LINK->A351461GEN;
  /*  526,  15 */
  WITH->UU.U1.SONS->UU.U1.UU.A308214class = F302cErrorClass(LINK->LINK);

}  /*SEM2*/

Local Void SEM3(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;
  TPLISTELEM *WITH1;
  UNIONTYPE *WITH2;

  WITH = CURRNODE;
  /*  543,  15 */
  LINK->LINK->FIRSTTIME = true;
  LINK->LINK->FIRSTELEM = NULL;
  LINK->LINK->LASTELEM = NULL;
  LINK->LINK->AUXPTR = WITH->UU.U1.SONS->UU.ELEMS;
  while (LINK->LINK->AUXPTR != NULL) {
    LINK->LINK->AUXELEMPTR = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
    LINK->LINK->AUXELEMPTR->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
    WITH1 = LINK->LINK->AUXELEMPTR;
    WITH2 = WITH1->ELEMENT;
    WITH2->DISCR = U307tEnv;
    WITH2->UU.C307tEnv = LINK->LINK->AUXPTR->UU.U1.UU.U7.A312305defEnv;
    WITH1->NEXT = NULL;
    if (LINK->LINK->FIRSTTIME) {
      LINK->LINK->FIRSTTIME = false;
      LINK->LINK->FIRSTELEM = LINK->LINK->AUXELEMPTR;
      LINK->LINK->LASTELEM = LINK->LINK->AUXELEMPTR;
    } else {
      LINK->LINK->LASTELEM->NEXT = LINK->LINK->AUXELEMPTR;
      LINK->LINK->LASTELEM = LINK->LINK->LASTELEM->NEXT;
    }
    LINK->LINK->AUXPTR = LINK->LINK->AUXPTR->BROTHER;
  }
  HIVAR2.DISCR = U453GEN;
  HIVAR2.UU.COLIST.HEAD = LINK->LINK->FIRSTELEM;
  HIVAR2.UU.COLIST.LAST = LINK->LINK->LASTELEM;
  HIVAR1.UU.COLIST = HIVAR2.UU.COLIST;
  INCLUDING(1, &HIVAR2);
  LINK->LINK->A342305defEnv = HIVAR2.UU.C307tEnv;

}  /*SEM3*/

Local Void SEM4(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;

  WITH = CURRNODE;
  /*  542,  14 */
  HIVAR1.UU.C307tEnv = LINK->LINK->A342305defEnv;
  LINK->LINK->AUXPTR = WITH->UU.U1.SONS->UU.ELEMS;
  while (LINK->LINK->AUXPTR != NULL) {
    LINK->LINK->AUXPTR->UU.U1.UU.U7.A312306refEnv = HIVAR1.UU.C307tEnv;
    LINK->LINK->AUXPTR = LINK->LINK->AUXPTR->BROTHER;

  }

}  /*SEM4*/

Local Void SEM5(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;

  WITH = CURRNODE;
  /*  540,  3 */
  HIVAR1.DISCR = U452GEN;
  HIVAR1.UU.COLIST.HEAD = NULL;
  HIVAR1.UU.COLIST.LAST = NULL;
  LINK->LINK->AUXPTR = WITH->UU.U1.SONS->UU.ELEMS;
  while (LINK->LINK->AUXPTR != NULL) {
    CONCATELIST(HIVAR1.UU.COLIST, LINK->LINK->AUXPTR->UU.U1.UU.U7.A312461GEN,
		&HIVAR1.UU.COLIST, LINK->LINK);
    LINK->LINK->AUXPTR = LINK->LINK->AUXPTR->BROTHER;
  }
  LINK->LINK->A351461GEN = HIVAR1.UU.COLIST;

}  /*SEM5*/

Local Void SEM6(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  579,  19 */
  LINK->LINK->A314205numArgs = WITH->UU.U1.SONS->BROTHER->UU.U1.UU.U9.A315317len;

}  /*SEM6*/

Local Void SEM7(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;

  WITH = CURRNODE;
  /*  578,  11 */
  HIVAR1.UU.C307tEnv = WITH->UU.U1.SONS->UU.U1.UU.U8.A314305defEnv;
  WITH->UU.U1.UU.U7.A312305defEnv = LINK->LINK->A342305defEnv;

}  /*SEM7*/

Local Void SEM8(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  580,  16 */
  WITH->UU.U1.SONS->BROTHER->UU.U1.UU.U9.A315305defEnv = LINK->LINK->A342305defEnv;

}  /*SEM8*/

Local Void SEM9(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  576,  3 */
  WITH->UU.U1.UU.U7.A312461GEN = LINK->LINK->A351461GEN;

}  /*SEM9*/

Local Void SEM10(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  582,  15 */
  WITH->UU.U1.SONS->BROTHER->BROTHER->UU.U1.UU.A308214class =
    WITH->UU.U1.SONS->UU.U1.UU.U8.A314214class;

}  /*SEM10*/

Local Void SEM11(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6;
  NODE *WITH;

  WITH = CURRNODE;
  /*  596,  17 */
  INCLUDING(1, &HIVAR2);
  HIVAR1.UU.C307tEnv = HIVAR2.UU.C307tEnv;
  HIVAR2.UU.C144tKey = F319DefineIdn(HIVAR1.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  HIVAR3.UU.C147tObjKind = F164SetaKind(HIVAR2.UU.C144tKey, S218eClass,
					S219eErrorObj, LINK->LINK);
  HIVAR4.UU.C87INT = F172SetaValue(HIVAR2.UU.C144tKey,
      LINK->LINK->A314205numArgs, 0L, LINK->LINK);
  HIVAR5.UU.C154tOilClass = F203DefClass(WITH->UU.U1.SONS->UU.U42.TERMAT.id,
					 HIVAR4.UU.C87INT, LINK->LINK);
  HIVAR6.UU.C154tOilClass = F174SetaClassId(HIVAR2.UU.C144tKey,
      HIVAR5.UU.C154tOilClass, HIVAR5.UU.C154tOilClass, LINK->LINK);
  WITH->UU.U1.UU.U8.A314305defEnv = HIVAR1.UU.C307tEnv;

}  /*SEM11*/

Local Void SEM12(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5;
  NODE *WITH;

  /*  620,  13 */

  WITH = CURRNODE;
  LINK->LINK->MC++;
  INCLUDING(3, &HIVAR2);
  HIVAR1.UU.C144tKey = F325KeyInEnv(HIVAR2.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  if (F161GetaKind(HIVAR1.UU.C144tKey, S219eErrorObj, LINK->LINK) ==
      S219eErrorObj)
    MESSAGE(CONDFAILS, 30L, 620L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  605,  17 */
  HIVAR1.UU.C144tKey = F322KeyInScope(WITH->UU.U1.UU.U8.A314305defEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  WITH->UU.U1.UU.U8.A314214class = F173GetaClassId(HIVAR1.UU.C144tKey,
      F302cErrorClass(LINK->LINK), LINK->LINK);
  /*  609,  17 */
  INCLUDING(3, &HIVAR2);
  HIVAR1.UU.C307tEnv = F323NewScope(HIVAR2.UU.C307tEnv, LINK->LINK);
  HIVAR2.UU.C144tKey = F319DefineIdn(HIVAR1.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  HIVAR3.UU.C147tObjKind = F164SetaKind(HIVAR2.UU.C144tKey, S216eType,
					S219eErrorObj, LINK->LINK);
  HIVAR4.UU.C149tTypeKind = F168SetaTypeKind(HIVAR2.UU.C144tKey,
      S221eParamType, S221eParamType, LINK->LINK);
  HIVAR5.UU.C87INT = F172SetaValue(HIVAR2.UU.C144tKey, 0L, 0L, LINK->LINK);
  LINK->LINK->A342305defEnv = HIVAR1.UU.C307tEnv;

}  /*SEM12*/

Local Void SEM13(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5;
  NODE *WITH;

  WITH = CURRNODE;
  /*  631,  12 */
  INCLUDING(5, &HIVAR2);
  HIVAR1.UU.C307tEnv = HIVAR2.UU.C307tEnv;
  HIVAR2.UU.C144tKey = F319DefineIdn(HIVAR1.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  HIVAR3.UU.C147tObjKind = F164SetaKind(HIVAR2.UU.C144tKey, S216eType,
					S219eErrorObj, LINK->LINK);
  HIVAR4.UU.C149tTypeKind = F168SetaTypeKind(HIVAR2.UU.C144tKey,
      S221eParamType, S221eParamType, LINK->LINK);
  HIVAR5.UU.C87INT = F172SetaValue(HIVAR2.UU.C144tKey,
      LINK->LINK->A314205numArgs, LINK->LINK->A314205numArgs, LINK->LINK);
  LINK->LINK->A350162key = HIVAR2.UU.C144tKey;
  /*  639,  13 */

  LINK->LINK->MC++;
  if (F161GetaKind(LINK->LINK->A350162key, S219eErrorObj, LINK->LINK) ==
      S219eErrorObj)
    MESSAGE(CONDFAILS, 30L, 639L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;

}  /*SEM13*/

Local Void SEM14(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  655,  16 */
  WITH->UU.U1.UU.U9.A315317len = 0;

}  /*SEM14*/

Local Void SEM15(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  656,  16 */
  LINK->LINK->A342305defEnv = WITH->UU.U1.UU.U9.A315305defEnv;

}  /*SEM15*/

Local Void SEM16(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  662,  16 */
  WITH->UU.U1.UU.U9.A315317len = 1;

}  /*SEM16*/

Local Void SEM17(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  663,  14 */
  LINK->LINK->A314205numArgs = 1;

}  /*SEM17*/

Local Void SEM18(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  664,  16 */
  LINK->LINK->A342305defEnv = WITH->UU.U1.UU.U9.A315305defEnv;

}  /*SEM18*/

Local Void SEM19(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  671,  19 */
  WITH->UU.U1.UU.U9.A315317len = WITH->UU.U1.SONS->UU.U1.UU.U9.A315317len + 1;

}  /*SEM19*/

Local Void SEM20(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  670,  13 */
  WITH->UU.U1.SONS->UU.U1.UU.U9.A315305defEnv = WITH->UU.U1.UU.U9.A315305defEnv;

}  /*SEM20*/

Local Void SEM21(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  672,  14 */
  LINK->LINK->A314205numArgs = WITH->UU.U1.UU.U9.A315317len;

}  /*SEM21*/

Local Void SEM22(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  682,  11 */
  WITH->UU.U1.UU.U7.A312305defEnv = LINK->LINK->A342305defEnv;

}  /*SEM22*/

Local Void SEM23(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  686,  12 */
  LINK->LINK->A347233value =
    LINK->LINK->A329233value[LINK->LINK->Q329233value].UU.COLIST;
  /*  686,  12 */
  ATPOP(&LINK->LINK->Q329233value, &LINK->LINK->A329233value, LINK->LINK);

}  /*SEM23*/

Local Void SEM24(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  685,  15 */
  LINK->HIVAR0.UU.C90SYMB = LINK->LINK->A350253id;
  /*  685,  15 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q329330definingId,
	 &LINK->LINK->A329330definingId, LINK->LINK);

}  /*SEM24*/

Local Void SEM25(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  680,  3 */
  WITH->UU.U1.UU.U7.A312461GEN = LINK->LINK->A351461GEN;

}  /*SEM25*/

Local Void SEM26(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;

  WITH = CURRNODE;
  /*  684,  15 */
  INCLUDING(6, &HIVAR1);
  WITH->UU.U1.SONS->BROTHER->BROTHER->UU.U1.UU.A308214class =
    HIVAR1.UU.C154tOilClass;

}  /*SEM26*/

Local Void SEM27(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6;
  NODE *WITH;
  V160tStructTypeSet *WITH1;

  WITH = CURRNODE;
  /*  708,  10 */
  LINK->LINK->A350253id = WITH->UU.U1.SONS->UU.U42.TERMAT.id;
  /*  700,  10 */
  INCLUDING(3, &HIVAR2);
  HIVAR1.UU.C307tEnv = F323NewScope(HIVAR2.UU.C307tEnv, LINK->LINK);
  HIVAR2.UU.C144tKey = F319DefineIdn(HIVAR1.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  HIVAR3.UU.C147tObjKind = F164SetaKind(HIVAR2.UU.C144tKey, S216eType,
					S219eErrorObj, LINK->LINK);
  HIVAR4.UU.C149tTypeKind = F168SetaTypeKind(HIVAR2.UU.C144tKey, S222eForType,
					     S222eForType, LINK->LINK);
  HIVAR6.UU.C160tStructTypeSet = (V160tStructTypeSet *)
				 Malloc(sizeof(V160tStructTypeSet));
  WITH1 = HIVAR6.UU.C160tStructTypeSet;
  WITH1->L233value = LINK->LINK->A347233value;
  HIVAR5.UU.C160tStructTypeSet = HIVAR6.UU.C160tStructTypeSet;
  HIVAR6.UU.C160tStructTypeSet = F180SetaSetValue(HIVAR2.UU.C144tKey,
      HIVAR5.UU.C160tStructTypeSet, HIVAR5.UU.C160tStructTypeSet, LINK->LINK);
  LINK->LINK->A342305defEnv = HIVAR1.UU.C307tEnv;

}  /*SEM27*/

Local Void SEM28(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  719,  11 */
  WITH->UU.U1.UU.U7.A312305defEnv = LINK->LINK->A342305defEnv;

}  /*SEM28*/

Local Void SEM29(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  720,  17 */
  LINK->LINK->A347233value =
    LINK->LINK->A329233value[LINK->LINK->Q329233value].UU.COLIST;
  /*  720,  17 */
  ATPOP(&LINK->LINK->Q329233value, &LINK->LINK->A329233value, LINK->LINK);

}  /*SEM29*/

Local Void SEM30(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  718,  15 */
  LINK->HIVAR0.UU.C90SYMB = LINK->LINK->A350253id;
  /*  718,  15 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q329330definingId,
	 &LINK->LINK->A329330definingId, LINK->LINK);

}  /*SEM30*/

Local Void SEM31(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  716,  3 */
  WITH->UU.U1.UU.U7.A312461GEN = LINK->LINK->EMPTY;

}  /*SEM31*/

Local Void SEM32(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4;
  NODE *WITH;

  WITH = CURRNODE;
  /*  734,  15 */
  INCLUDING(1, &HIVAR2);
  HIVAR1.UU.C307tEnv = HIVAR2.UU.C307tEnv;
  HIVAR2.UU.C144tKey = F319DefineIdn(HIVAR1.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  HIVAR3.UU.C147tObjKind = F164SetaKind(HIVAR2.UU.C144tKey, S216eType,
					S219eErrorObj, LINK->LINK);
  HIVAR4.UU.C149tTypeKind = F168SetaTypeKind(HIVAR2.UU.C144tKey, S223ePrimSet,
					     S223ePrimSet, LINK->LINK);
  LINK->LINK->A342305defEnv = HIVAR1.UU.C307tEnv;

}  /*SEM32*/

Local Void SEM33(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3;
  NODE *WITH;
  V160tStructTypeSet *WITH1;

  /*  750,  13 */

  WITH = CURRNODE;
  LINK->LINK->MC++;
  INCLUDING(3, &HIVAR2);
  HIVAR1.UU.C144tKey = F325KeyInEnv(HIVAR2.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  if (F161GetaKind(HIVAR1.UU.C144tKey, S219eErrorObj, LINK->LINK) ==
      S219eErrorObj)
    MESSAGE(CONDFAILS, 30L, 750L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  741,  15 */
  LINK->LINK->A350253id = WITH->UU.U1.SONS->UU.U42.TERMAT.id;
  /*  742,  15 */
  INCLUDING(3, &HIVAR2);
  HIVAR1.UU.C144tKey = F325KeyInEnv(HIVAR2.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  HIVAR3.UU.C160tStructTypeSet = (V160tStructTypeSet *)
				 Malloc(sizeof(V160tStructTypeSet));
  WITH1 = HIVAR3.UU.C160tStructTypeSet;
  WITH1->L233value = LINK->LINK->A347233value;
  HIVAR2.UU.C160tStructTypeSet = HIVAR3.UU.C160tStructTypeSet;
  HIVAR3.UU.C160tStructTypeSet = F180SetaSetValue(HIVAR1.UU.C144tKey,
      HIVAR2.UU.C160tStructTypeSet, HIVAR2.UU.C160tStructTypeSet, LINK->LINK);
  LINK->LINK->A347233value = HIVAR3.UU.C160tStructTypeSet->L233value;

}  /*SEM33*/

Local Void SEM34(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;

  WITH = CURRNODE;
  /*  760,  11 */
  HIVAR1.UU.C307tEnv = LINK->LINK->A342305defEnv;
  INCLUDING(1, &HIVAR2);
  WITH->UU.U1.UU.U7.A312305defEnv = HIVAR2.UU.C307tEnv;

}  /*SEM34*/

Local Void SEM35(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  758,  3 */
  WITH->UU.U1.UU.U7.A312461GEN = LINK->LINK->EMPTY;

}  /*SEM35*/

Local Void SEM36(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  761,  14 */
  LINK->LINK->A314205numArgs = WITH->UU.U1.SONS->BROTHER->UU.U1.UU.A335210cost;

}  /*SEM36*/

Local Void SEM37(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;

  WITH = CURRNODE;
  /*  774,  14 */
  HIVAR1.UU.C144tKey = WITH->UU.U1.SONS->UU.U1.UU.A337162key;
  INCLUDING(1, &HIVAR2);
  LINK->LINK->A342305defEnv = HIVAR2.UU.C307tEnv;

}  /*SEM37*/

Local Void SEM38(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4;
  NODE *WITH;

  WITH = CURRNODE;
  /*  776,  12 */
  if (LINK->LINK->Q338162key > 1)
    HIVAR4 = LINK->LINK->A338162key[LINK->LINK->Q338162key - 1];
  else
    HIVAR4 = LINK->LINK->A338162key[0].UU.COARRAY[LINK->LINK->Q338162key + 9];
  HIVAR2.UU.C144tKey = LINK->LINK->A338162key[LINK->LINK->Q338162key].UU.C144tKey;
  HIVAR3.UU.C144tKey = HIVAR4.UU.C144tKey;
  LINK->LINK->AUXELEMPTR = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  LINK->LINK->FIRSTELEM = LINK->LINK->AUXELEMPTR;
  LINK->LINK->AUXELEMPTR->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
  LINK->LINK->AUXELEMPTR->ELEMENT->DISCR = U144tKey;
  LINK->LINK->AUXELEMPTR->ELEMENT->UU.C144tKey = HIVAR2.UU.C144tKey;
  LINK->LINK->AUXELEMPTR->NEXT = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  LINK->LINK->AUXELEMPTR = LINK->LINK->AUXELEMPTR->NEXT;
  LINK->LINK->AUXELEMPTR->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
  LINK->LINK->AUXELEMPTR->ELEMENT->DISCR = U144tKey;
  LINK->LINK->AUXELEMPTR->ELEMENT->UU.C144tKey = HIVAR3.UU.C144tKey;
  LINK->LINK->AUXELEMPTR->NEXT = NULL;
  HIVAR1.UU.COLIST.HEAD = LINK->LINK->FIRSTELEM;
  HIVAR1.UU.COLIST.LAST = LINK->LINK->AUXELEMPTR;
  LINK->LINK->A337208sig = HIVAR1.UU.COLIST;
  /*  776,  12 */
  ATPOP(&LINK->LINK->Q338162key, &LINK->LINK->A338162key, LINK->LINK);
  /*  776,  12 */
  ATPOP(&LINK->LINK->Q338162key, &LINK->LINK->A338162key, LINK->LINK);
  /*  777,  12 */
  if (LINK->LINK->Q338324tkind > 1)
    HIVAR1 = LINK->LINK->A338324tkind[LINK->LINK->Q338324tkind - 1];
  else
    HIVAR1 = LINK->LINK->A338324tkind[0].UU.COARRAY[LINK->LINK->Q338324tkind + 9];
  LINK->LINK->A337339sigDesc =
    (1L << ((long)LINK->LINK->A338324tkind[LINK->LINK->Q338324tkind].UU.
		  C149tTypeKind)) | (1L << ((long)HIVAR1.UU.C149tTypeKind));
/* p2c: walk.p, line 4322: Note:
 * Line breaker spent 3.2+0.60 seconds, 1176 tries on line 4528 [251] */
  /*  777,  12 */
  ATPOP(&LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind, LINK->LINK);
  /*  777,  12 */
  ATPOP(&LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind, LINK->LINK);

}  /*SEM38*/

Local Void SEM39(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;

  WITH = CURRNODE;
  /*  779,  14 */
  HIVAR1.UU.C245tAnyOp = LINK->LINK->A337340oid;
  switch (HIVAR1.UU.C245tAnyOp->DISCR) {

  case U158tOilOp:
    HIVAR2.UU.C88BOOL = F300OilAddCoercion(HIVAR1.UU.C245tAnyOp->UU.C158tOilOp,
					   LINK->LINK);
    break;

  case U215tOilClassOp:
    HIVAR2.UU.C88BOOL = F341OilAddClassCoercion(
	HIVAR1.UU.C245tAnyOp->UU.C215tOilClassOp, LINK->LINK);
    break;

  case U246tSetOp:
    HIVAR2.UU.C88BOOL = F299AddSetCoercion(HIVAR1.UU.C245tAnyOp->UU.C246tSetOp,
					   LINK->LINK);
    break;
  }
  LINK->LINK->A337311identification = HIVAR2.UU.C88BOOL;

}  /*SEM39*/

Local Void SEM40(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;

  WITH = CURRNODE;
  /*  795,  11 */
  HIVAR1.UU.C307tEnv = LINK->LINK->A342305defEnv;
  INCLUDING(1, &HIVAR2);
  WITH->UU.U1.UU.U7.A312305defEnv = HIVAR2.UU.C307tEnv;

}  /*SEM40*/

Local Void SEM41(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  793,  3 */
  WITH->UU.U1.UU.U7.A312461GEN = LINK->LINK->EMPTY;

}  /*SEM41*/

Local Void SEM42(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  796,  14 */
  LINK->HIVAR0.UU.C87INT = WITH->UU.U1.SONS->BROTHER->UU.U1.UU.A335210cost;
  /*  796,  14 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q342210cost, &LINK->LINK->A342210cost,
	 LINK->LINK);

}  /*SEM42*/

Local Void SEM43(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;

  WITH = CURRNODE;
  /*  810,  14 */
  HIVAR1.UU.C144tKey = WITH->UU.U1.SONS->UU.U1.UU.A337162key;
  INCLUDING(1, &HIVAR2);
  LINK->LINK->A342305defEnv = HIVAR2.UU.C307tEnv;

}  /*SEM43*/

Local Void SEM44(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;

  /*  811,  14 */
  WITH = CURRNODE;
  HIVAR2.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  HIVAR2.UU.COLIST.LAST = HIVAR2.UU.COLIST.HEAD;
  HIVAR2.UU.COLIST.LAST->NEXT = NULL;
  HIVAR2.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
  HIVAR2.UU.COLIST.HEAD->ELEMENT->DISCR = U144tKey;
  HIVAR2.UU.COLIST.HEAD->ELEMENT->UU.C144tKey =
    LINK->LINK->A338162key[LINK->LINK->Q338162key].UU.C144tKey;
  CONCATELIST(HIVAR2.UU.COLIST, LINK->LINK->A343208sig, &HIVAR1.UU.COLIST,
	      LINK->LINK);
  LINK->LINK->A343208sig = HIVAR1.UU.COLIST;
  /*  811,  14 */
  ATPOP(&LINK->LINK->Q338162key, &LINK->LINK->A338162key, LINK->LINK);
  /*  812,  14 */
  LINK->LINK->A343339sigDesc |= 1L <<
      ((long)LINK->LINK->A338324tkind[LINK->LINK->Q338324tkind].UU.C149tTypeKind);
  /*  812,  14 */
  ATPOP(&LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind, LINK->LINK);
  /*  814,  12 */
  LINK->LINK->A337208sig = LINK->LINK->A343208sig;
  /*  815,  12 */
  LINK->LINK->A337339sigDesc = LINK->LINK->A343339sigDesc;
  /*  809,  18 */
  LINK->LINK->A314205numArgs =
    LINK->LINK->A342210cost[LINK->LINK->Q342210cost].UU.C87INT;
  /*  809,  18 */
  ATPOP(&LINK->LINK->Q342210cost, &LINK->LINK->A342210cost, LINK->LINK);

}  /*SEM44*/

Local Void SEM45(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3;
  NODE *WITH;

  WITH = CURRNODE;
  /*  830,  17 */
  HIVAR1.UU.C307tEnv = LINK->LINK->A342305defEnv;
  HIVAR2.UU.C144tKey = WITH->UU.U1.SONS->UU.U1.UU.A337162key;
  INCLUDING(1, &HIVAR3);
  LINK->LINK->A342305defEnv = HIVAR3.UU.C307tEnv;

}  /*SEM45*/

Local Void SEM46(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  824,  17 */
  LINK->HIVAR0.UU.C87INT = LINK->LINK->A342210cost[LINK->LINK->Q342210cost].
			   UU.C87INT;
  /*  824,  17 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q342210cost, &LINK->LINK->A342210cost,
	 LINK->LINK);

}  /*SEM46*/

Local Void SEM47(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  826,  12 */
  LINK->LINK->A337208sig = LINK->LINK->A343208sig;
  /*  827,  12 */
  LINK->LINK->A337339sigDesc = LINK->LINK->A343339sigDesc;
  /*  828,  12 */
  LINK->LINK->A314205numArgs =
    LINK->LINK->A342210cost[LINK->LINK->Q342210cost].UU.C87INT;
  /*  828,  12 */
  ATPOP(&LINK->LINK->Q342210cost, &LINK->LINK->A342210cost, LINK->LINK);

}  /*SEM47*/

Local Void SEM48(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4;
  NODE *WITH;

  WITH = CURRNODE;
  /*  848,  16 */
  HIVAR1.UU.C234tTypeSetOp =
    LINK->LINK->A345346setOp[LINK->LINK->Q345346setOp].UU.C234tTypeSetOp;
  switch (HIVAR1.UU.C234tTypeSetOp) {

  case S235eTSunion:
    if (LINK->LINK->Q329233value > 1)
      HIVAR4 = LINK->LINK->A329233value[LINK->LINK->Q329233value - 1];
    else
      HIVAR4 = LINK->LINK->A329233value[0].UU.COARRAY[LINK->LINK->Q329233value + 9];
    P238SetUnion(HIVAR4.UU.COLIST,
		 LINK->LINK->A329233value[LINK->LINK->Q329233value].UU.COLIST,
		 &HIVAR3, LINK->LINK);
    HIVAR2.UU.COLIST = HIVAR3.UU.COLIST;
    break;

  case S236eTSintersect:
    if (LINK->LINK->Q329233value > 1)
      HIVAR4 = LINK->LINK->A329233value[LINK->LINK->Q329233value - 1];
    else
      HIVAR4 = LINK->LINK->A329233value[0].UU.COARRAY[LINK->LINK->Q329233value + 9];
    P243SetIntersect(HIVAR4.UU.COLIST,
      LINK->LINK->A329233value[LINK->LINK->Q329233value].UU.COLIST, &HIVAR3,
      LINK->LINK);
    HIVAR2.UU.COLIST = HIVAR3.UU.COLIST;
    break;

  case S237eTSdiff:
    if (LINK->LINK->Q329233value > 1)
      HIVAR4 = LINK->LINK->A329233value[LINK->LINK->Q329233value - 1];
    else
      HIVAR4 = LINK->LINK->A329233value[0].UU.COARRAY[LINK->LINK->Q329233value + 9];
    P244SetDifference(HIVAR4.UU.COLIST,
      LINK->LINK->A329233value[LINK->LINK->Q329233value].UU.COLIST, &HIVAR3,
      LINK->LINK);
    HIVAR2.UU.COLIST = HIVAR3.UU.COLIST;
    break;
  }
  LINK->HIVAR0.UU.COLIST = HIVAR2.UU.COLIST;
  /*  848,  16 */
  ATPOP(&LINK->LINK->Q345346setOp, &LINK->LINK->A345346setOp, LINK->LINK);
  /*  848,  16 */
  ATPOP(&LINK->LINK->Q329233value, &LINK->LINK->A329233value, LINK->LINK);
  /*  848,  16 */
  ATPOP(&LINK->LINK->Q329233value, &LINK->LINK->A329233value, LINK->LINK);
  /*  848,  16 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q329233value, &LINK->LINK->A329233value,
	 LINK->LINK);

}  /*SEM48*/

Local Void SEM49(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  847,  12 */
  LINK->HIVAR0.UU.C90SYMB =
    LINK->LINK->A329330definingId[LINK->LINK->Q329330definingId].UU.C90SYMB;
  /*  847,  12 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q329330definingId,
	 &LINK->LINK->A329330definingId, LINK->LINK);

}  /*SEM49*/

Local Void SEM50(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  858,  8 */
  LINK->HIVAR0.UU.COLIST = LINK->LINK->A347233value;
  /*  858,  8 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q329233value, &LINK->LINK->A329233value,
	 LINK->LINK);

}  /*SEM50*/

Local Void SEM51(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  0,  1 */
  ATPOP(&LINK->LINK->Q329330definingId, &LINK->LINK->A329330definingId,
	LINK->LINK);

}  /*SEM51*/

Local Void SEM52(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4;
  NODE *WITH;

  WITH = CURRNODE;
  /*  867,  13 */
  HIVAR1.UU.C144tKey = LINK->LINK->A338162key[LINK->LINK->Q338162key].UU.C144tKey;
  HIVAR2.UU.C149tTypeKind =
    LINK->LINK->A338324tkind[LINK->LINK->Q338324tkind].UU.C149tTypeKind;
  if (((1L << ((long)HIVAR2.UU.C149tTypeKind)) &
       ((1L << ((long)S220ePrimType)) | (1L << ((long)S223ePrimSet)))) != 0) {
    switch (HIVAR2.UU.C149tTypeKind) {

    case S220ePrimType:
      HIVAR4.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
      HIVAR4.UU.COLIST.LAST = HIVAR4.UU.COLIST.HEAD;
      HIVAR4.UU.COLIST.LAST->NEXT = NULL;
      HIVAR4.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
      HIVAR4.UU.COLIST.HEAD->ELEMENT->DISCR = U156tOilType;
      HIVAR4.UU.COLIST.HEAD->ELEMENT->UU.C156tOilType = F175GetaTypeId(
	  HIVAR1.UU.C144tKey, F264cErrorType(LINK->LINK), LINK->LINK);
      HIVAR3.UU.COLIST = HIVAR4.UU.COLIST;
      break;

    case S223ePrimSet:
      HIVAR4.UU.C160tStructTypeSet = F179GetaSetValue(HIVAR1.UU.C144tKey,
	  LINK->LINK->C284cErrorTypeSet, LINK->LINK);
      HIVAR3.UU.COLIST = HIVAR4.UU.C160tStructTypeSet->L233value;
      break;
    }
  } else {
    HIVAR4.UU.COLIST = LINK->LINK->C284cErrorTypeSet->L233value;

    LINK->LINK->MC++;
    if (true)
      MESSAGE(CONDFAILS, 44L, 872L, GLOBPOS.LINE, GLOBPOS.COL);
    LINK->LINK->MC--;
    HIVAR3.UU.COLIST = HIVAR4.UU.COLIST;
  }
  LINK->HIVAR0.UU.COLIST = HIVAR3.UU.COLIST;
  /*  867,  13 */
  ATPOP(&LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind, LINK->LINK);
  /*  867,  13 */
  ATPOP(&LINK->LINK->Q338162key, &LINK->LINK->A338162key, LINK->LINK);
  /*  867,  13 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q329233value, &LINK->LINK->A329233value,
	 LINK->LINK);

}  /*SEM52*/

Local Void SEM53(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  /*  865,  17 */

  WITH = CURRNODE;
  LINK->LINK->MC++;
  if (LINK->LINK->A329330definingId[LINK->LINK->Q329330definingId].UU.C90SYMB ==
      WITH->UU.U1.SONS->UU.U1.UU.A338253id)
    MESSAGE(CONDFAILS, 43L, 865L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  865,  17 */
  ATPOP(&LINK->LINK->Q329330definingId, &LINK->LINK->A329330definingId,
	LINK->LINK);

}  /*SEM53*/

Local Void SEM54(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  880,  13 */
  LINK->HIVAR0.UU.COLIST = LINK->LINK->C284cErrorTypeSet->L233value;
  /*  880,  13 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q329233value, &LINK->LINK->A329233value,
	 LINK->LINK);

}  /*SEM54*/

Local Void SEM55(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  0,  1 */
  ATPOP(&LINK->LINK->Q329330definingId, &LINK->LINK->A329330definingId,
	LINK->LINK);

}  /*SEM55*/

Local Void SEM56(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  889,  10 */
  LINK->HIVAR0.UU.C234tTypeSetOp = S236eTSintersect;
  /*  889,  10 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q345346setOp, &LINK->LINK->A345346setOp,
	 LINK->LINK);

}  /*SEM56*/

Local Void SEM57(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  896,  10 */
  LINK->HIVAR0.UU.C234tTypeSetOp = S236eTSintersect;
  /*  896,  10 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q345346setOp, &LINK->LINK->A345346setOp,
	 LINK->LINK);

}  /*SEM57*/

Local Void SEM58(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  903,  10 */
  LINK->HIVAR0.UU.C234tTypeSetOp = S236eTSintersect;
  /*  903,  10 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q345346setOp, &LINK->LINK->A345346setOp,
	 LINK->LINK);

}  /*SEM58*/

Local Void SEM59(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  910,  10 */
  LINK->HIVAR0.UU.C234tTypeSetOp = S235eTSunion;
  /*  910,  10 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q345346setOp, &LINK->LINK->A345346setOp,
	 LINK->LINK);

}  /*SEM59*/

Local Void SEM60(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  917,  10 */
  LINK->HIVAR0.UU.C234tTypeSetOp = S237eTSdiff;
  /*  917,  10 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q345346setOp, &LINK->LINK->A345346setOp,
	 LINK->LINK);

}  /*SEM60*/

Local Void SEM61(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  929,  15 */
  LINK->LINK->A347233value = LINK->LINK->EMPTY;

}  /*SEM61*/

Local Void SEM62(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;

  WITH = CURRNODE;
  /*  0,  1 */
  ATPOP(&LINK->LINK->Q338162key, &LINK->LINK->A338162key, LINK->LINK);
  /*  936,  17 */

  LINK->LINK->MC++;
  if (LINK->LINK->A338324tkind[LINK->LINK->Q338324tkind].UU.C149tTypeKind !=
      S220ePrimType)
    MESSAGE(CONDFAILS, 51L, 936L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  936,  17 */
  ATPOP(&LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind, LINK->LINK);
  /*  938,  15 */
  HIVAR1.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  HIVAR1.UU.COLIST.LAST = HIVAR1.UU.COLIST.HEAD;
  HIVAR1.UU.COLIST.LAST->NEXT = NULL;
  HIVAR1.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
  HIVAR1.UU.COLIST.HEAD->ELEMENT->DISCR = U156tOilType;
  HIVAR1.UU.COLIST.HEAD->ELEMENT->UU.C156tOilType = LINK->LINK->A338348tid;
  LINK->LINK->A347233value = HIVAR1.UU.COLIST;

}  /*SEM62*/

Local Void SEM63(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;

  WITH = CURRNODE;
  /*  0,  1 */
  ATPOP(&LINK->LINK->Q338162key, &LINK->LINK->A338162key, LINK->LINK);
  /*  945,  17 */

  LINK->LINK->MC++;
  if (LINK->LINK->A338324tkind[LINK->LINK->Q338324tkind].UU.C149tTypeKind !=
      S220ePrimType)
    MESSAGE(CONDFAILS, 51L, 945L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  945,  17 */
  ATPOP(&LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind, LINK->LINK);
  /*  947,  18 */
  HIVAR2.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  HIVAR2.UU.COLIST.LAST = HIVAR2.UU.COLIST.HEAD;
  HIVAR2.UU.COLIST.LAST->NEXT = NULL;
  HIVAR2.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
  HIVAR2.UU.COLIST.HEAD->ELEMENT->DISCR = U156tOilType;
  HIVAR2.UU.COLIST.HEAD->ELEMENT->UU.C156tOilType = LINK->LINK->A338348tid;
  P238SetUnion(HIVAR2.UU.COLIST, LINK->LINK->A347233value, &HIVAR1,
	       LINK->LINK);
  LINK->LINK->A347233value = HIVAR1.UU.COLIST;

}  /*SEM63*/

Local Void SEM64(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  961,  13 */
  LINK->LINK->A343339sigDesc = 0;
  /*  960,  13 */
  LINK->LINK->A343208sig = LINK->LINK->EMPTY;

}  /*SEM64*/

Local Void SEM65(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;

  WITH = CURRNODE;
  /*  968,  13 */
  LINK->LINK->A343339sigDesc = 1L <<
      ((long)LINK->LINK->A338324tkind[LINK->LINK->Q338324tkind].UU.C149tTypeKind);
  /*  968,  13 */
  ATPOP(&LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind, LINK->LINK);
  /*  967,  13 */
  HIVAR1.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  HIVAR1.UU.COLIST.LAST = HIVAR1.UU.COLIST.HEAD;
  HIVAR1.UU.COLIST.LAST->NEXT = NULL;
  HIVAR1.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
  HIVAR1.UU.COLIST.HEAD->ELEMENT->DISCR = U144tKey;
  HIVAR1.UU.COLIST.HEAD->ELEMENT->UU.C144tKey =
    LINK->LINK->A338162key[LINK->LINK->Q338162key].UU.C144tKey;
  LINK->LINK->A343208sig = HIVAR1.UU.COLIST;
  /*  967,  13 */
  ATPOP(&LINK->LINK->Q338162key, &LINK->LINK->A338162key, LINK->LINK);

}  /*SEM65*/

Local Void SEM66(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2;
  NODE *WITH;

  WITH = CURRNODE;
  /*  975,  16 */
  LINK->LINK->A343339sigDesc |= 1L <<
      ((long)LINK->LINK->A338324tkind[LINK->LINK->Q338324tkind].UU.C149tTypeKind);
  /*  975,  16 */
  ATPOP(&LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind, LINK->LINK);
  /*  974,  16 */
  HIVAR2.UU.COLIST.HEAD = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
  HIVAR2.UU.COLIST.LAST = HIVAR2.UU.COLIST.HEAD;
  HIVAR2.UU.COLIST.LAST->NEXT = NULL;
  HIVAR2.UU.COLIST.HEAD->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
  HIVAR2.UU.COLIST.HEAD->ELEMENT->DISCR = U144tKey;
  HIVAR2.UU.COLIST.HEAD->ELEMENT->UU.C144tKey =
    LINK->LINK->A338162key[LINK->LINK->Q338162key].UU.C144tKey;
  CONCATELIST(LINK->LINK->A343208sig, HIVAR2.UU.COLIST, &HIVAR1.UU.COLIST,
	      LINK->LINK);
  LINK->LINK->A343208sig = HIVAR1.UU.COLIST;
  /*  974,  16 */
  ATPOP(&LINK->LINK->Q338162key, &LINK->LINK->A338162key, LINK->LINK);

}  /*SEM66*/

Local Void SEM67(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6, HIVAR7;
  NODE *WITH;

  WITH = CURRNODE;
  /*  991,  11 */
  WITH->UU.U1.UU.A338253id = WITH->UU.U1.SONS->UU.U42.TERMAT.id;
  /*  992,  11 */
  INCLUDING(3, &HIVAR2);
  HIVAR1.UU.C307tEnv = HIVAR2.UU.C307tEnv;
  if (E144tKey(F325KeyInEnv(HIVAR1.UU.C307tEnv, WITH->UU.U1.UU.A338253id,
			    LINK->LINK), LINK->LINK->C182dbNull,
	       LINK->LINK)) {
    INCLUDING(17, &HIVAR4);
    HIVAR3.UU.C144tKey = F319DefineIdn(HIVAR4.UU.C307tEnv,
				       WITH->UU.U1.UU.A338253id, LINK->LINK);
    HIVAR4.UU.C147tObjKind = F164SetaKind(HIVAR3.UU.C144tKey, S216eType,
					  S216eType, LINK->LINK);
    HIVAR5.UU.C149tTypeKind = F168SetaTypeKind(HIVAR3.UU.C144tKey,
	S220ePrimType, S220ePrimType, LINK->LINK);
    HIVAR6.UU.C156tOilType = F206DefType(WITH->UU.U1.UU.A338253id, LINK->LINK);
    HIVAR7.UU.C156tOilType = F176SetaTypeId(HIVAR3.UU.C144tKey,
	HIVAR6.UU.C156tOilType, HIVAR6.UU.C156tOilType, LINK->LINK);
    HIVAR2.UU.C144tKey = HIVAR3.UU.C144tKey;
  } else
    HIVAR2.UU.C144tKey = F325KeyInEnv(HIVAR1.UU.C307tEnv,
				      WITH->UU.U1.UU.A338253id, LINK->LINK);
  LINK->HIVAR0.UU.C144tKey = HIVAR2.UU.C144tKey;
  /*  992,  11 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q338162key, &LINK->LINK->A338162key,
	 LINK->LINK);
  /*  1005,  11 */
  LINK->LINK->A338348tid = F175GetaTypeId(
      LINK->LINK->A338162key[LINK->LINK->Q338162key].UU.C144tKey,
      F264cErrorType(LINK->LINK), LINK->LINK);
  /*  1004,  11 */
  LINK->LINK->A350320okind = F161GetaKind(
      LINK->LINK->A338162key[LINK->LINK->Q338162key].UU.C144tKey,
      S219eErrorObj, LINK->LINK);
  /*  1007,  17 */

  LINK->LINK->MC++;
  if (!F228ObjKindCheck(LINK->LINK->A350320okind, S216eType, LINK->LINK))
    MESSAGE(CONDFAILS, 52L, 1007L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  1008,  11 */
  LINK->HIVAR0.UU.C149tTypeKind = F167GetaTypeKind(
      LINK->LINK->A338162key[LINK->LINK->Q338162key].UU.C144tKey,
      S220ePrimType, LINK->LINK);
  /*  1008,  11 */
  ATPUSH(LINK->HIVAR0, &LINK->LINK->Q338324tkind, &LINK->LINK->A338324tkind,
	 LINK->LINK);

}  /*SEM67*/

Local Void SEM68(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;

  WITH = CURRNODE;
  /*  1019,  11 */
  INCLUDING(1, &HIVAR1);
  WITH->UU.U1.UU.U7.A312305defEnv = HIVAR1.UU.C307tEnv;

}  /*SEM68*/

Local Void SEM69(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  1017,  3 */
  WITH->UU.U1.UU.U7.A312461GEN = LINK->LINK->A351461GEN;

}  /*SEM69*/

Local Void SEM70(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5;
  NODE *WITH;

  WITH = CURRNODE;
  /*  1034,  11 */
  LINK->LINK->A350253id = WITH->UU.U1.SONS->UU.U42.TERMAT.id;
  /*  1035,  11 */
  INCLUDING(3, &HIVAR2);
  HIVAR1.UU.C307tEnv = HIVAR2.UU.C307tEnv;
  if (E144tKey(F325KeyInEnv(HIVAR1.UU.C307tEnv, LINK->LINK->A350253id,
			    LINK->LINK), LINK->LINK->C182dbNull,
	       LINK->LINK)) {
    HIVAR3.UU.C144tKey = F319DefineIdn(HIVAR1.UU.C307tEnv,
				       LINK->LINK->A350253id, LINK->LINK);
    HIVAR4.UU.C147tObjKind = F164SetaKind(HIVAR3.UU.C144tKey, S217eOp,
					  S217eOp, LINK->LINK);
    HIVAR5.UU.C151tOpKind = F170SetaOpKind(HIVAR3.UU.C144tKey, S225ePrimOp,
					   S225ePrimOp, LINK->LINK);
    HIVAR2.UU.C144tKey = HIVAR3.UU.C144tKey;
  } else
    HIVAR2.UU.C144tKey = F325KeyInEnv(HIVAR1.UU.C307tEnv,
				      LINK->LINK->A350253id, LINK->LINK);
  LINK->LINK->A350162key = HIVAR2.UU.C144tKey;
  /*  1045,  11 */
  HIVAR1.UU.C158tOilOp = F177GetaOpId(LINK->LINK->A350162key,
				      F301cErrorOp(LINK->LINK), LINK->LINK);
  if (!E158tOilOp(HIVAR1.UU.C158tOilOp, F301cErrorOp(LINK->LINK), LINK->LINK))
    HIVAR2.UU.C158tOilOp = HIVAR1.UU.C158tOilOp;
  else {
    HIVAR3.UU.C158tOilOp = F207DefOp(LINK->LINK->A350253id,
	F262OilNewArgSig(true, LINK->LINK), 0L, LINK->LINK);
    HIVAR2.UU.C158tOilOp = F178SetaOpId(LINK->LINK->A350162key,
	HIVAR3.UU.C158tOilOp, HIVAR3.UU.C158tOilOp, LINK->LINK);
  }
  LINK->LINK->A351249indication = HIVAR2.UU.C158tOilOp;
  /*  1053,  11 */
  LINK->LINK->A350320okind = F161GetaKind(LINK->LINK->A350162key,
					  S219eErrorObj, LINK->LINK);
  /*  1055,  17 */

  LINK->LINK->MC++;
  if (!F228ObjKindCheck(LINK->LINK->A350320okind, S217eOp, LINK->LINK))
    MESSAGE(CONDFAILS, 54L, 1055L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  1056,  11 */
  LINK->LINK->A350324tkind = F167GetaTypeKind(LINK->LINK->A350162key,
					      S220ePrimType, LINK->LINK);

}  /*SEM70*/

Local Void SEM71(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4;
  NODE *WITH;

  WITH = CURRNODE;
  /*  1073,  10 */
  INCLUDING(1, &HIVAR2);
  HIVAR1.UU.C307tEnv = HIVAR2.UU.C307tEnv;
  HIVAR2.UU.C144tKey = F319DefineIdn(HIVAR1.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  HIVAR3.UU.C147tObjKind = F164SetaKind(HIVAR2.UU.C144tKey, S217eOp,
					S219eErrorObj, LINK->LINK);
  HIVAR4.UU.C151tOpKind = F170SetaOpKind(HIVAR2.UU.C144tKey, S225ePrimOp,
					 S225ePrimOp, LINK->LINK);
  WITH->UU.U1.UU.A337162key = HIVAR2.UU.C144tKey;

}  /*SEM71*/

Local Void SEM72(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1, HIVAR2, HIVAR3, HIVAR4, HIVAR5, HIVAR6, HIVAR7, HIVAR8,
	    HIVAR9;
  NODE *WITH;
  V245tAnyOp *WITH1;

  /*  1102,  13 */

  WITH = CURRNODE;
  LINK->LINK->MC++;
  INCLUDING(3, &HIVAR2);
  HIVAR1.UU.C144tKey = F325KeyInEnv(HIVAR2.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  if (F161GetaKind(HIVAR1.UU.C144tKey, S219eErrorObj, LINK->LINK) ==
      S219eErrorObj)
    MESSAGE(CONDFAILS, 30L, 1102L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  1080,  10 */
  INCLUDING(6, &HIVAR2);
  HIVAR1.UU.C154tOilClass = HIVAR2.UU.C154tOilClass;
  HIVAR2.UU.C87INT = LINK->LINK->A314205numArgs;
  HIVAR3.UU.C230tTypeKindSet = LINK->LINK->A337339sigDesc;
  HIVAR4.UU.COLIST = LINK->LINK->A337208sig;
  if (((1L << ((long)S221eParamType)) & HIVAR3.UU.C230tTypeKindSet) != 0) {
    HIVAR6.UU.C245tAnyOp = (V245tAnyOp *)Malloc(sizeof(V245tAnyOp));
    WITH1 = HIVAR6.UU.C245tAnyOp;
    WITH1->DISCR = U215tOilClassOp;
    WITH1->UU.C215tOilClassOp = F212DefClassOp(
	WITH->UU.U1.SONS->UU.U42.TERMAT.id,
	F265ClassSig(HIVAR4.UU.COLIST, LINK->LINK), HIVAR2.UU.C87INT,
	HIVAR1.UU.C154tOilClass, LINK->LINK);
    HIVAR5.UU.C245tAnyOp = HIVAR6.UU.C245tAnyOp;
  } else {
    if (((1L << ((long)S222eForType)) & HIVAR3.UU.C230tTypeKindSet) != 0 ||
	((1L << ((long)S223ePrimSet)) & HIVAR3.UU.C230tTypeKindSet) != 0) {
      P278SetSig(HIVAR4.UU.COLIST, &HIVAR9, LINK->LINK);
      P298AddSetOp(WITH->UU.U1.SONS->UU.U42.TERMAT.id, HIVAR9.UU.COLIST,
		   HIVAR2.UU.C87INT, &HIVAR8, LINK->LINK);
      HIVAR7.UU.C245tAnyOp = (V245tAnyOp *)Malloc(sizeof(V245tAnyOp));
      WITH1 = HIVAR7.UU.C245tAnyOp;
      WITH1->DISCR = U246tSetOp;
      WITH1->UU.C246tSetOp = HIVAR8.UU.COLIST;
      HIVAR6.UU.C245tAnyOp = HIVAR7.UU.C245tAnyOp;
    } else {
      if (((1L << ((long)S224eParamSet)) & HIVAR3.UU.C230tTypeKindSet) != 0) {
	HIVAR9.UU.C158tOilOp = F301cErrorOp(LINK->LINK);

	LINK->LINK->MC++;
	if (true)
	  MESSAGE(CONDFAILS, 55L, 1093L, GLOBPOS.LINE, GLOBPOS.COL);
	LINK->LINK->MC--;
	HIVAR8.UU.C158tOilOp = HIVAR9.UU.C158tOilOp;
      } else {
	HIVAR9.UU.C158tOilOp = F207DefOp(WITH->UU.U1.SONS->UU.U42.TERMAT.id,
	    F260PrimSig(HIVAR4.UU.COLIST, LINK->LINK), HIVAR2.UU.C87INT,
	    LINK->LINK);
	HIVAR8.UU.C158tOilOp = F178SetaOpId(WITH->UU.U1.UU.A337162key,
	    HIVAR9.UU.C158tOilOp, HIVAR9.UU.C158tOilOp, LINK->LINK);
      }
      HIVAR7.UU.C245tAnyOp = (V245tAnyOp *)Malloc(sizeof(V245tAnyOp));
      WITH1 = HIVAR7.UU.C245tAnyOp;
      WITH1->DISCR = U158tOilOp;
      WITH1->UU.C158tOilOp = HIVAR8.UU.C158tOilOp;
      HIVAR6.UU.C245tAnyOp = HIVAR7.UU.C245tAnyOp;
    }
    HIVAR5.UU.C245tAnyOp = HIVAR6.UU.C245tAnyOp;
  }
  LINK->LINK->A337340oid = HIVAR5.UU.C245tAnyOp;
  /*  1104,  10 */
  INCLUDING(6, &HIVAR1);
  INCLUDING(24, &HIVAR2);
  LINK->LINK->A337311identification = F251AddIdentification(
      LINK->LINK->A337340oid, HIVAR1.UU.C154tOilClass,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, HIVAR2.UU.COLIST, LINK->LINK);

}  /*SEM72*/

Local Void SEM73(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;

  WITH = CURRNODE;
  /*  1120,  12 */
  HIVAR1.UU.C158tOilOp = LINK->LINK->A351249indication;
  LINK->LINK->AUXPTR = WITH->UU.U1.SONS->UU.ELEMS;
  while (LINK->LINK->AUXPTR != NULL) {
    LINK->LINK->AUXPTR->UU.U1.UU.U6.A310249indication = HIVAR1.UU.C158tOilOp;
    LINK->LINK->AUXPTR = LINK->LINK->AUXPTR->BROTHER;

  }

}  /*SEM73*/

Local Void SEM74(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;
  TPLISTELEM *WITH1;
  UNIONTYPE *WITH2;

  WITH = CURRNODE;
  /*  1118,  3 */
  LINK->LINK->FIRSTTIME = true;
  LINK->LINK->FIRSTELEM = NULL;
  LINK->LINK->LASTELEM = NULL;
  LINK->LINK->AUXPTR = WITH->UU.U1.SONS->UU.ELEMS;
  while (LINK->LINK->AUXPTR != NULL) {
    LINK->LINK->AUXELEMPTR = (TPLISTELEM *)Malloc(sizeof(TPLISTELEM));
    LINK->LINK->AUXELEMPTR->ELEMENT = (UNIONTYPE *)Malloc(sizeof(UNIONTYPE));
    WITH1 = LINK->LINK->AUXELEMPTR;
    WITH2 = WITH1->ELEMENT;
    WITH2->DISCR = U247tIdentPair;
    WITH2->UU.C247tIdentPair = LINK->LINK->AUXPTR->
			       UU.U1.UU.U6.A310311identification;
    WITH1->NEXT = NULL;
    if (LINK->LINK->FIRSTTIME) {
      LINK->LINK->FIRSTTIME = false;
      LINK->LINK->FIRSTELEM = LINK->LINK->AUXELEMPTR;
      LINK->LINK->LASTELEM = LINK->LINK->AUXELEMPTR;
    } else {
      LINK->LINK->LASTELEM->NEXT = LINK->LINK->AUXELEMPTR;
      LINK->LINK->LASTELEM = LINK->LINK->LASTELEM->NEXT;
    }
    LINK->LINK->AUXPTR = LINK->LINK->AUXPTR->BROTHER;
  }
  HIVAR1.DISCR = U452GEN;
  HIVAR1.UU.COLIST.HEAD = LINK->LINK->FIRSTELEM;
  HIVAR1.UU.COLIST.LAST = LINK->LINK->LASTELEM;
  LINK->LINK->A351461GEN = HIVAR1.UU.COLIST;

}  /*SEM74*/

Local Void SEM75(LINK)
struct LOC_SEMANALYSE *LINK;
{
  UNIONTYPE HIVAR1;
  NODE *WITH;
  V247tIdentPair *WITH1;

  /*  1141,  10 */
  WITH = CURRNODE;
  HIVAR1.UU.C247tIdentPair = (V247tIdentPair *)Malloc(sizeof(V247tIdentPair));
  WITH1 = HIVAR1.UU.C247tIdentPair;
  WITH1->L248op = WITH->UU.U1.SONS->UU.U42.TERMAT.id;
  WITH1->L249indication = WITH->UU.U1.UU.U6.A310249indication;
  WITH->UU.U1.UU.U6.A310311identification = HIVAR1.UU.C247tIdentPair;
  /*  1134,  10 */
  INCLUDING(3, &HIVAR1);
  WITH->UU.U1.UU.U6.A310162key = F325KeyInEnv(HIVAR1.UU.C307tEnv,
      WITH->UU.U1.SONS->UU.U42.TERMAT.id, LINK->LINK);
  /*  1136,  17 */

  LINK->LINK->MC++;
  if (E144tKey(WITH->UU.U1.UU.U6.A310162key, LINK->LINK->C182dbNull,
	       LINK->LINK))
    MESSAGE(CONDFAILS, 56L, 1136L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  1137,  10 */
  WITH->UU.U1.UU.U6.A310195otype = F161GetaKind(WITH->UU.U1.UU.U6.A310162key,
						S219eErrorObj, LINK->LINK);
  /*  1139,  17 */

  LINK->LINK->MC++;
  if (!F228ObjKindCheck(WITH->UU.U1.UU.U6.A310195otype, S217eOp, LINK->LINK))
    MESSAGE(CONDFAILS, 57L, 1139L, GLOBPOS.LINE, GLOBPOS.COL);
  LINK->LINK->MC--;
  /*  1140,  10 */
  WITH->UU.U1.UU.U6.A310352operkind = F169GetaOpKind(
      WITH->UU.U1.UU.U6.A310162key, S225ePrimOp, LINK->LINK);

}  /*SEM75*/

Local Void SEM76(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  1156,  11 */
  WITH->UU.U1.UU.A335210cost = 1;

}  /*SEM76*/

Local Void SEM77(LINK)
struct LOC_SEMANALYSE *LINK;
{
  NODE *WITH;

  WITH = CURRNODE;
  /*  1162,  11 */
  WITH->UU.U1.UU.A335210cost = WITH->UU.U1.SONS->UU.U42.TERMAT.value;

}  /*SEM77*/

/*&END GEN INCLUDE*/



Local Void SEMANALYSE(LINK)
struct LOC_ATTREVAL *LINK;
{
  /*==========*/
  struct LOC_SEMANALYSE V;

  /*&END GEN INCLUDE*/

  uchar VSELEM;
  char VSDESCIND;
  char VSNUMBER;
  char SEMCODE;
  long I;   /* COMPUTE TOPINDEX */

  char RETURNSTACK[MAXTREEDEPTH];
  char VSINDEX;

  /*&END GEN INCLUDE*/



  V.LINK = LINK;
  SEMINIT(&V);



  RETURNSTACK[NODESTACKTOP - 1] = ANCESTORVISIT;
      /* DUMMY FOR STOP CONDITION */

  TREENEXT();   /* get first tree */

  while (CURRNODE != NULL)   /* there is a tree to be attributed */
  {  /* CURRNODE is its root */
    VSINDEX = SECTTAB((long)CURRNODE->RULE, 0L);
	/* index of next VS-action*/
    /* ROOTCOUNT */
    /* pass eval not yet implemented */

    /* THE STATE OF THE EVALUATOR IS DETERMINED BY THE PAIR            */
    /* (CURRNODE, VSINDEX) AND THE STACK OF SUCH PAIRS IMPLEMENTED BY  */
    /* THE TWO STACKS NODESTACK (in tree module) AND RETURNSTACK       */

    do {


      VSELEM = VSTAB((long)VSINDEX);
      /* decode next action */
      if (VSELEM == ANCESTORVISIT) {  /* ancestor visit     */
	TREEANCESTOR();

	if (CURRNODE != NULL) {  /* still in the tree */
	  VSINDEX = RETURNSTACK[NODESTACKTOP];

	  if (CURRNODE->RULE == LISTRULE) {  /* evaluating a list*/
	    TREEBROTHER();
	    if (CURRNODE != NULL) {   /* more elems in list */
	      VSELEM = VSTAB((long)VSINDEX);
	      VSNUMBER = (VSELEM - 1) / MAXVSSYMBNO + 1;
	      VSINDEX = SECTTAB((long)CURRNODE->RULE, VSNUMBER - 1L);


	    } else {  /* list is completed */
	      TREEANCESTOR();   /* pop list node */
	      VSINDEX = RETURNSTACK[NODESTACKTOP - 1];
	      TREEANCESTOR();   /* pop ancest. of list */
	    }
	  }  /* end list node */
	}  /* end CURRNODE<>nil*/

      }  /* end ANCESTOR VISIT*/
      else {
	if (VSELEM < MINSEMRELCODE) {  /*   DESCENDANT VISIT */
	  VSDESCIND = (VSELEM - 1) % MAXVSSYMBNO + 1;   /* NO. SUCCESSOR   */
/* p2c: walk.p, line 4171:
 * Note: Using % for possibly-negative arguments [317] */
	  VSNUMBER = (VSELEM - 1) / MAXVSSYMBNO + 1;   /* NO. VISIT TO IT */


	  TREEDESCENDANT((long)VSDESCIND);
	  RETURNSTACK[NODESTACKTOP - 1] = VSINDEX + 1;

	  if (CURRNODE->RULE == LISTRULE) {   /* VISIT TO A LIST */
	    if (CURRNODE->UU.ELEMS == NULL)
	    {  /* EMPTY LIST: VISIT ANCS IMMEDIATELY */
	      VSINDEX = RETURNSTACK[NODESTACKTOP - 1];
	      TREEANCESTOR();
	    } else {
	      TREEFIRSTELEM();   /* PUSH LIST ANCHOR */
	      RETURNSTACK[NODESTACKTOP - 1] = VSINDEX;
	      /* ASSERT(CURRNODE^.RULE IS AG-RULE) */
	      VSINDEX = SECTTAB((long)CURRNODE->RULE, VSNUMBER - 1L);
	    }

	  } else {  /*end visit to a list*/
	    if (CURRNODE->RULE == EMPTYRULE) {  /* IMMEDIATE ANCESTOR VISIT */
	      VSINDEX = RETURNSTACK[NODESTACKTOP - 1];
	      TREEANCESTOR();   /* POP A NODE */

	    } else  /* AG-RULE */
	      VSINDEX = SECTTAB((long)CURRNODE->RULE, VSNUMBER - 1L);


	  }



	}  /*end of DESCENDANT VISIT */
	else {  /* EVALUATION OF SEMANTIC RULES */
	  SEMCODE = VSELEM - MINSEMRELCODE + RULEFIRSTSEMCODE((long)CURRNODE->RULE);
	  GLOBPOS = CURRNODE->UU.U1.POS;


	  VSINDEX++;




	  switch (SEMCODE) {   /*case SEMCODE*/

	  case 0:
	    SEM0(&V);
	    break;

	  case 1:
	    SEM1(&V);
	    break;

	  case 2:
	    SEM2(&V);
	    break;

	  case 3:
	    SEM3(&V);
	    break;

	  case 4:
	    SEM4(&V);
	    break;

	  case 5:
	    SEM5(&V);
	    break;

	  case 6:
	    SEM6(&V);
	    break;

	  case 7:
	    SEM7(&V);
	    break;

	  case 8:
	    SEM8(&V);
	    break;

	  case 9:
	    SEM9(&V);
	    break;

	  case 10:
	    SEM10(&V);
	    break;

	  case 11:
	    SEM11(&V);
	    break;

	  case 12:
	    SEM12(&V);
	    break;

	  case 13:
	    SEM13(&V);
	    break;

	  case 14:
	    SEM14(&V);
	    break;

	  case 15:
	    SEM15(&V);
	    break;

	  case 16:
	    SEM16(&V);
	    break;

	  case 17:
	    SEM17(&V);
	    break;

	  case 18:
	    SEM18(&V);
	    break;

	  case 19:
	    SEM19(&V);
	    break;

	  case 20:
	    SEM20(&V);
	    break;

	  case 21:
	    SEM21(&V);
	    break;

	  case 22:
	    SEM22(&V);
	    break;

	  case 23:
	    SEM23(&V);
	    break;

	  case 24:
	    SEM24(&V);
	    break;

	  case 25:
	    SEM25(&V);
	    break;

	  case 26:
	    SEM26(&V);
	    break;

	  case 27:
	    SEM27(&V);
	    break;

	  case 28:
	    SEM28(&V);
	    break;

	  case 29:
	    SEM29(&V);
	    break;

	  case 30:
	    SEM30(&V);
	    break;

	  case 31:
	    SEM31(&V);
	    break;

	  case 32:
	    SEM32(&V);
	    break;

	  case 33:
	    SEM33(&V);
	    break;

	  case 34:
	    SEM34(&V);
	    break;

	  case 35:
	    SEM35(&V);
	    break;

	  case 36:
	    SEM36(&V);
	    break;

	  case 37:
	    SEM37(&V);
	    break;

	  case 38:
	    SEM38(&V);
	    break;

	  case 39:
	    SEM39(&V);
	    break;

	  case 40:
	    SEM40(&V);
	    break;

	  case 41:
	    SEM41(&V);
	    break;

	  case 42:
	    SEM42(&V);
	    break;

	  case 43:
	    SEM43(&V);
	    break;

	  case 44:
	    SEM44(&V);
	    break;

	  case 45:
	    SEM45(&V);
	    break;

	  case 46:
	    SEM46(&V);
	    break;

	  case 47:
	    SEM47(&V);
	    break;

	  case 48:
	    SEM48(&V);
	    break;

	  case 49:
	    SEM49(&V);
	    break;

	  case 50:
	    SEM50(&V);
	    break;

	  case 51:
	    SEM51(&V);
	    break;

	  case 52:
	    SEM52(&V);
	    break;

	  case 53:
	    SEM53(&V);
	    break;

	  case 54:
	    SEM54(&V);
	    break;

	  case 55:
	    SEM55(&V);
	    break;

	  case 56:
	    SEM56(&V);
	    break;

	  case 57:
	    SEM57(&V);
	    break;

	  case 58:
	    SEM58(&V);
	    break;

	  case 59:
	    SEM59(&V);
	    break;

	  case 60:
	    SEM60(&V);
	    break;

	  case 61:
	    SEM61(&V);
	    break;

	  case 62:
	    SEM62(&V);
	    break;

	  case 63:
	    SEM63(&V);
	    break;

	  case 64:
	    SEM64(&V);
	    break;

	  case 65:
	    SEM65(&V);
	    break;

	  case 66:
	    SEM66(&V);
	    break;

	  case 67:
	    SEM67(&V);
	    break;

	  case 68:
	    SEM68(&V);
	    break;

	  case 69:
	    SEM69(&V);
	    break;

	  case 70:
	    SEM70(&V);
	    break;

	  case 71:
	    SEM71(&V);
	    break;

	  case 72:
	    SEM72(&V);
	    break;

	  case 73:
	    SEM73(&V);
	    break;

	  case 74:
	    SEM74(&V);
	    break;

	  case 75:
	    SEM75(&V);
	    break;

	  case 76:
	    SEM76(&V);
	    break;

	  case 77:
	    SEM77(&V);
	    break;
	  }

	  /*&END GEN INCLUDE*/


	}  /* EVALUATION OF SEMANTIC RULES */

      }



    } while (CURRNODE != NULL);
    /*this tree is evaluated, last action
                               TREEANCESTOR yielded NIL */

    TREENEXT();

  }  /* while CURRNODE <> nil */






}  /* SEMANALYSE */

#undef MAXSEMCODE
#undef MINSEMRELCODE
#undef MAXVSTAB
#undef MAXSECTTAB
#undef MAXVSSYMBNO
#undef MAXVSNUMBER
#undef VISITSTOROOT


/*&INCLUDE ATTR_PROC_LOC*/

/*===============================================================*/







/*FUNCTION EMPTY (L:TPLIST ) : Boolean;
FORWARD; ------- BUILT IN!    */































/*&END GEN INCLUDE*/


Static Void ATTREVAL()
{
  /*========*/
  struct LOC_ATTREVAL V;
  /* END OF PERFORMANCE DATA */

  /* VARIABLES TO MEASURE HEAP STORAGE: */
  long *HEAPPOINTER;




  INIT(&V);

  SEMANALYSE(&V);



}  /* ATTREVAL */

#undef ANCESTORVISIT


/*==================================================================*/

/*&END INCLUDE*/



main(argc, argv)
int argc;
Char *argv[];
{
  PASCAL_MAIN(argc, argv);
  if (P_argc < 2) {
    fprintf(stderr, "No source file specified\n");
    _Escape(0);
  }
  P_sun_argv(filearg, sizeof(filename), 1);

  SCANINIT(filearg, 0L);


  SourceInit();



  Zerteiler();


  /* initialize database */
  dbInitDummy = dbInit();

  /*begin OIL.pp INIT
    $Id: oil.pp,v 1.7 89/10/06 11:44:46 swain Exp $
    Copyright, 1989, The Regents of the University of Colorado
    */

  InitCompilerAdt();

  /*end of OIL.pp INIT*/



  ATTREVAL();



  /*              begin OIL.pp FINL               */

  EmitCompilerAdt();

  /** *  the end of OIL(2).pp  * **/




  WRAPUP();


  exit(0);
}




/* End. */
