/*
  $Id: oil.c,v 1.7 89/11/27 10:44:37 swain Exp $
  Copyright, 1989, The Regents of the University of Colorado
  */

#include <stdio.h>
#include "oiladt2.h"
#include "oiladt2a.h"


/**********************************************
  references to lexemes
  */
extern char *(string[]);


/**********************************************
  Use fix size tables for simplicity
  */
#define maxClass 100
#define maxType 200
#define maxOp 300
#define maxName 400

int ClassCnt;
tOilClass ClassMap[maxClass];

int TypeCnt;
tOilType TypeMap[maxType];

int OpCnt;
tOilOp OpMap[maxOp];

int NameCnt;
char * NameMap[maxName];


/**********************************************
  Add a name to the name table; if it isn't there yet
  */
int AddName( id ) int id; {
    int i;
    int result= -1;
    char *str;
    str=string[id];
    for(i=0; i<NameCnt && result==-1; i++)
        if(str==NameMap[i]) result=i;
    if(result==-1) {
	result= NameCnt++;
	NameMap[result]=str;
    }
    return(result);
}

/* referencing the name of the object with index 'i' in map 'tbl' */

#define NameRef(tbl,i) NameMap[tbl[i]->sName]



/**************************************************
  DefClass, DefType, DefOp, DefSetOp -
	Calls the OilAdt to construct the object and adds it to the
	corresponding local table.
  ****************/

tOilClass DefClass( id, numArgs )
        int id;
        int numArgs;
    {
	tOilClass result;
	result= OilNewClass( AddName(id),numArgs );
	ClassMap[ClassCnt++]= result;
	return(result);
    }

tOilType DefType( id )
        int id;
    {
	tOilType result;
	result= OilNewType( AddName(id) );
	TypeMap[TypeCnt++]= result;
	return( result );
    }

tOilOp DefOp( id, sig, cost )
        int id;
        tOilArgSig sig;
        int cost;
    {
	tOilOp result;
	result= OilNewOp( AddName(id),sig,cost );
	OpMap[OpCnt++]= result;
	return(result);
    }

tOilClassOp DefClassOp( id, sig, cost, class )
        int id;
        tOilClassArgSig sig;
        int cost;
        tOilClass class;
    {
	tOilClassOp result;
	result= OilAddClassOp( AddName(id),sig,cost,class );
	return(result);
    }

tOilOp DefSetOp( id, sig, cost )
        int id;
        tOilArgSig sig;
        int cost;
    {
	tOilOp result;
	result= OilNewOp( AddName(id),sig,cost );
	return(result);
    }


/*******************************************
  cErrorType, cErrorOp
  */
tOilType vErrorType;
tOilType cErrorType()
    {
	return( vErrorType );
    }

tOilOp vErrorOp;
tOilOp cErrorOp()
    {
	return( vErrorOp );
    }

tOilClass vErrorClass;
tOilClass cErrorClass()
    {
	return( vErrorClass );
    }

/*******************************************
  InitCompilerAdt - initialize Compiler's Adt
  */
void InitCompilerAdt()
    {
    OpCnt=0;
    TypeCnt=0;
    ClassCnt=0;
    NameCnt=0;

    vErrorType= OilNewType( "BadType" );
    vErrorOp= OilNewOp( "BadOp", nil, 1 );
    }

extern FILE  *OilDumpInit();
extern FILE  *fopen();

/*******************************************
  EmitCompilerAdt - output the Compiler's tables
  */
void EmitCompilerAdt()
    {
	int i;
	FILE *cFile;
	FILE *hFile;
	FILE *aFile;
	FILE *nFile;

	cFile= OilDumpInit("OilDecls.c");
	hFile= fopen("OilDecls.h","w");
	aFile= fopen("OilDecls.ala","w");

	for(i=0;i<TypeCnt; i++){ OilDumpType( TypeMap[i] ); }
	for(i=0;i<OpCnt; i++){ OilDumpOp( OpMap[i] ); }
	for(i=0;i<ClassCnt; i++){ OilDumpClass( ClassMap[i] ); }

	fprintf(cFile,"\n tOilType OilTypeMap[]={\n");
	for(i=0;i<TypeCnt; i++){
	    fprintf(hFile,"#define %s OilTypeIndex(%d)\n",NameRef(TypeMap,i), i);
	    fprintf(aFile,"CONST %s: OilTypeIndex(%d);\n",NameRef(TypeMap,i), i);
	    fprintf(cFile,"\t&Oil_t%d,\t/* %s */\n", TypeMap[i]->sID,
		    NameRef(TypeMap,i) ); }
	fprintf(cFile,"\t0 };\n");

	fprintf(cFile,"\n tOilOp OilOpMap[]={\n");
	for(i=0;i<OpCnt; i++){
	    fprintf(hFile,"#define %s OilOpIndex(%d)\n",NameRef(OpMap,i), i);
	    fprintf(aFile,"CONST %s: OilOpIndex(%d);\n",NameRef(OpMap,i), i);
	    fprintf(cFile,"\t&Oil_o%d,\t/* %s */\n", OpMap[i]->sID,
		    NameRef(OpMap,i) ); }
	fprintf(cFile,"\t0 };\n");

	fprintf(cFile,"\n tOilClass OilClassMap[]={\n");
	for(i=0;i<ClassCnt; i++){
	    fprintf(hFile,"#define %s OilClassIndex(%d)\n",NameRef(ClassMap,i),i);
	    fprintf(aFile,"CONST %s: OilClassIndex(%d);\n",NameRef(ClassMap,i),i);
	    fprintf(cFile,"\t&Oil_c%d\t/* %s */,\n", ClassMap[i]->sID,
		    NameRef(ClassMap,i) ); }
	fprintf(cFile,"\t0 };\n");
	fprintf(cFile,"\n\nint OilMaxName=%d;\n",NameCnt);

	fprintf(hFile,"\n");
	fprintf(aFile,"\n");

	nFile= fopen("OilDecls.names","w");
	fprintf(nFile,"\n\nint OilMaxSpecName=%d;\n",NameCnt);
	fprintf(nFile,"\n\nchar * OilSpecNames[]={\n");

	for(i=0; i<NameCnt; i++){
	    fprintf(hFile,"#define %s_name %d\n",NameMap[i],i);
	    fprintf(aFile,"CONST %s_name:%d;\n",NameMap[i],i);
	    fprintf(nFile,"\t\"%s\",\n",NameMap[i]);
	    }
	fprintf(nFile,"\t0 };\n");
    }


/******************** the end of oil.c ******************************/
