(* $Id: dbgen.ext.h,v 1.9 91/07/07 14:13:30 waite Exp $ *)
(* Copyright, 1989, The Regents of the University of Colorado *)

(* 
 *   dbgen.ext.h:
 *   Pascal interface declarations for generic database functions
 *)


(* value representing "no object": *)

function dbfNull: exttKey; external;




(* access to relations *)

(*
 * dbFind: scans relation relId and finds all tuples whose
 * roleId1 component is the object key;
 * the objects in the roleId2 component of the tuples found
 * are returned as an object list
 *)

function dbFind
   (relId, roleId1: integer; key: exttKey; roleId2: integer):
      exttKeyList; external;




(* access functions for object lists: *)


(*
 * dbOlReset: "rewinds" the object list keyList and returns it;
 * the next call to dbOlNext will return the first member of keyList
 *)

function dbOlReset (keyList: exttKeyList) : exttKeyList; external;


(*
 * dbOlNext: returns the next member of the object list keyList;
 * a "current position" within an object list is defined by calling dbOlReset
 * (or dbOlFind);
 * each call to dbOlNext returns the member at the current position
 * and advances the current position;
 * when the end of the list is reached, the object dbNull is returned
 *)

function dbOlNext(keyList: exttKeyList) : exttKey; external;




(* other database access functions *)


(*
 * dbNewObject: constructor function for database objects -
 * creates and returns a new object of the specified object type
 * with undefined properties
 *)

function dbNewObject (otype: integer) : exttKey; external;



(* dbGetObjectType: returns the object type of a given surrogate *)

function dbGetObjectType(key: exttKey) : integer; external;



(*
 * dbSetObjectType: sets the object type of an existing object in the database;
 *    the object key is moved into the object class given by otype;
 *    otype must be a specialization of the current type of key;
 *    if key has any attributes defined that are inconsistent with the new
 *    object type, an error message is produced;
 *    the function returns TRUE if the object key was successfully moved
 *    to the object type otype, otherwise FALSE.
 *)

function dbSetObjectType(key: exttKey; otype: integer) : boolean; external;



(*
 * dbTestObjectType: debugging function
 * dbTestObjectType (key, otype, msg) returns true if the current attributes
 *    defined for the object key are consistent with the declared object
 *    type otype, i.e., exactly the attributes declared for otype are
 *    defined for key;
 *    conversely, the call returns false if either a declared attribute
 *    of otype is missing for key, or an attribute of key was not declared
 *    for otype, or both;
 *    if the function is called with msg = 0, it will be quiet about the
 *    test result;  if msg is nonzero and the attributes of key are not
 *    consistent with object type otype, the function writes an error
 *    message describing the inconsistency.
 *)

function dbTestObjectType
	(key: exttKey; otype, msg: integer) : boolean; external;


(*
 * dbInit: initialize database module --
 * returns true iff everything was initialized successfully;
 * called from &MACRO EXT_INIT section
 *)

function dbInit : boolean; external;
