# $Id: Makefile.cpp,v 1.54 1992/05/01 14:51:56 waite Exp $
# Copyright (c) 1989, The Regents of the University of Colorado.

SHELL	= /bin/sh

# Location of the master cache
DESTDIR = ELISYS

ODIN	= $(DESTDIR)/bin/eli

DESTDIR	= /tmp
COFLAGS	= -q
CFLAGS	= -I../../..
PFLAGS	= -w -temp=.

SPECS	=  oil.eli oil.specs oil.ala oil.con \
	oil.ddl oil.pp oil.c oil.sym oil.cull oil.gla

SRCS	= $(SPECS)

ADTREFS	= oiladt2.h oiladt2a.h oiladt2a.ala oiladt2a.pp \
	oiladt2a.c oiladt2b.c 

TIDY	= *.o core a.out $(ADTREFS)
CLEAN	= $(TIDY) ELI oil.exe ../oil.exe *~
CLOBBER	= $(CLEAN) derivedSrcs Makefile


# the OIL specification compiler

all:	../oil.exe

install:
	rm -f $(DESTDIR)/Tool/oil/oil.exe
	cp oil.exe $(DESTDIR)/Tool/oil
	chmod 755 $(DESTDIR)/Tool/oil/oil.exe

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(SRCS)
 
SourceDistr:
	mkdir derivedSrcs
	cp $(ELI)/compiler/derivedSrcs/* derivedSrcs
	cd derivedSrcs; make clean

# Housekeeping
tidy:	
	rm -rf $(TIDY)
#	-cd derivedSrcs; make tidy
	rm -f derivedSrcs/*.o

clean:
	rm -rf $(CLEAN)
#	-cd derivedSrcs; make clean
	rm -f derivedSrcs/*.o derivedSrcs/oil.exe

clobber:
	rm -rf $(CLOBBER)

rcsclean:	clean
	-rcsclean $(COFLAGS) $(SRCS) Makefile.cpp
	rm -f Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SRCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(SRCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SRCS)

# Creating compilable sources from Eli specifications

derive: derivedSRCS

derivedSRCS: $(SRCS) ELI $(ADTREFS)
	$(ODIN) -c ELI <oil.eli

ELI:
	$(ODIN) -c $(DESTDIR) -n ELI -q

# references to the ADT library functions by the compiler

$(ADTREFS):
	-for f in $(ADTREFS); do \
		rm -f $$f; ln ../$$f .; done

# Creating an executable compiler from derived sources

../oil.exe:	derivedSrcs/oil.exe
	cd ..; rm -f oil.exe; ln compiler/derivedSrcs/oil.exe .

derivedSrcs/oil.exe:
	cd derivedSrcs; \
	make CFLAGS="$(CFLAGS)" PFLAGS="$(PFLAGS)" CC="$(CC)" oil.exe
