/* Map line numbers to the proper lines of component files */

static char rcsid[]="$Id: map_errors.c,v 3.1 1992/03/04 15:21:30 uwe Exp $";

#include <stdio.h>
#include <string.h>

#define	MAXFILES	100

static char FileName[MAXFILES][BUFSIZ];
static int Limit[MAXFILES], Increment[MAXFILES];
static int TopEntry;

void ErrTabInit (f)
	FILE	*f;
{	int	more;

   (void)strcpy(FileName[0], "no file associated"); 
   Limit[0] = 0; Increment[0] = 0;
   TopEntry = 1;
   do {
   	more = (fscanf(f, "%d %d %s\n", 
		&(Limit[TopEntry]), &(Increment[TopEntry]), 
		FileName[TopEntry]) == 3);
	TopEntry++;
   } while (more && (TopEntry <MAXFILES));
   if (more) {
	(void)fprintf(stderr, "too many files for error map\n");
	exit(1);
   }
   TopEntry = TopEntry-2;
/* input test only
for (more=0; more<=TopEntry; more++)
printf(" %d %d %s\n", Limit[more], Increment[more], FileName[more]);
exit(1);
*/
}

void MapCoord (linein, findex, line)
	int	linein;
	int	*findex, *line;
{	int	ind = 0, search = 1;
   while (search && (ind <= TopEntry))
	if (linein >= Limit[ind]) ind++; else search = 0;

(*findex) = ind-1; (*line) = linein + Increment[ind-1];
}/*MapCoord*/

char * GetErrMapFileName (ind)
	int	ind;
{
if ((ind < 0) || (ind >= MAXFILES)) return ("");
return (FileName[ind]);
}/*GetErrMapFileName*/
