/* $Id: order.h,v 3.2 1992/07/03 09:25:30 cogito Exp $ */

/************************************************************************
*									*
*	FILE: order.h							*
*									*
************************************************************************/

/*********  
Includes 
*********/

#include "set.h"
#include <string.h>
#include "LIGA.h"
#include "LIGAMacros.h"

/*****************
Macro Definitions 
*****************/

#define MAX_ENTRIES 10000
#define WORD_LENGTH (sizeof(unsigned int)*8)
#define MAX_INT 0x7FFFFFFF
#define MAX_ATNO 200
/* #define MAX_SYMBNO 10 */
extern	int	MAX_SYMBNO;

#define MAX_RULENO 300

/* ref_tab item tags */
#define EMPTY -1
#define SYMB 0
#define PROD 1
#define ATTR 2


/* graph states */
#define DIRECT 		0
#define TRANSITIVE	1
#define INDUCED		2
#define ARRANGED	3
#define PARTITIONED 	4

/* printed graphs */
#define PDIRECT_SYMBOL 0
#define PTRANSITIV_SYMBOL 1
#define PINDUCED_SYMBOL 2
#define PDIRECT_RULE 3
#define PTRANSITIV_RULE 4
#define PINDUCED_RULE 5
#define PPARTITIONED_RULE 6
#define PPARTITION 7
#define PVISITSEQUENCE 8

/* visit classes */
#define	VSASSIG 	0
#define VSCOND 		1
#define VSVISIT 	2
#define VSPUSH		3
#define VSPOP		4

/* printing indications */

#define PRINT_ALL 	-100
#define END_OF_PRINT    -200

/* operations */
#define ODD(x) ((x)%2 == 1)
#define EVEN(x) ((x)%2 == 0)

/*************** 
Type Definitions 
***************/

typedef BITVECTOR *BITMATRIX; /* BITMATRIX is the internal data representation
				 of attribute dependency graphs */

/*************************************************
Data Structure for Symbol Occurence Nodes in Rules
*************************************************/

typedef struct slnode { /* node structure of the list of symbol occurrences of
		           a production */
	int sid;  	/* did of the symbol */
	int sno; 	/* symbno of this symbol occ in this rule */
	int pid;  	/* did of the production */
	int start_row;  /* the starting row of the attribute occurrences of
			   this symbol occurrence in the init-dp */
	int start_col;  /* the starting colume of the attribute occurrences of
			   this symbol occurrence in the init-dp */
 	struct slnode *right;  /* right points to the next symbol 
				in the production */
	struct slnode *down;   /* down points to the next symbol 
				with the same sid  */
} SLNODE;	

/***************************************************
 Data structures used for computing visit sequences
****************************************************/

typedef struct {
        int aid, apos;
        int sid, sno;
        Call idldef;       /* pointer to the idl definition */
} ASSIGINFO;

typedef struct {
        Call idldef;       /* pointer to the idl definition */
} CONDINFO;

typedef struct {
        BITVECTOR evalset;
        int vssid;
        int vssno;
        int vsord;
} VISITINFO;

typedef struct vselem {
        BITVECTOR deps;
        struct vselem  *next;
        int     vscls;  /* VSASSIG | VSCOND | VSVISIT | VSPUSH | VSPOP */
        union   {
        ASSIGINFO       assig;
        CONDINFO        cond;
        VISITINFO       visit;
        } vsinfo;
} VSELEM;

typedef VSELEM *VSPTR;

/******************************************
 Data Structures for the Reference Table
*******************************************/

typedef struct {        /* structure of symbol entry in the ref. table */
	Symb symb_def;  /* reference to the liga definition from IDL */
	BITMATRIX init_ds;   /* initial attr. dependency graph of the symbol,
			        which will remain unchanged.  */
	BITMATRIX ds;	/* dependency graph of this symbol which will be 
			   evolved. */
	bool	cyclic;
	bool 	changed;
	bool 	deferred;
	SLNODE *hddown; /* head pointer of symbol list with the same did */
	int attr_num;   /* number of attributes of this symbol */
	int part_num;	/* number of partitioned attribute sets */
}SYMBENTRY;

typedef struct {	/* structure of production entry in the ref. table */
	Prod prod_def;	/* reference to the liga definition from IDL */
	BITMATRIX init_dp;	/* initial attr. dependency graph 
				of the production,
			        which will remain unchanged.  */
	BITMATRIX dp;	/* dependency graph of this production which will be 
			   evolved. */
	bool 	cyclic;
	bool 	changed;
	int check_row;  /* index of last row of init_dp, which is used to 
			   check the well-definedness of AG */
	int check_col;  /* index of last word of init_dp and dp */
	SLNODE *hdright; /* head pointer of symbol list of the production */
	VSPTR  visitseq; /* head pointer to the list of visit sequences */
} PRODENTRY;

typedef struct {	/* structure of attribute entry in the ref. table */
	Attrdef attr_def; /* reference to the liga definition from IDL */
	int pos;	/* relative position in the bit vector */
 	int early;  	/* used in partition by branch-and-bound */
	int part;       /* the partition no. used as "late" first */
} ATTRENTRY;

typedef struct {
	int etag;
	union {
	SYMBENTRY symb;
	PRODENTRY prod;
	ATTRENTRY attr;
 	} entry;
} ALLENTRIES;

/******************************************* 
Data Structures  Used in brach_and_bound () 
********************************************/

typedef struct atnode{
	int atord;	/* order of consideration of this attribute,
			   its also the index number of this attr
			   in the atsort[] array  */
	int partno;	/* its  current test allocation */
	int cost; 	/* cost of the partial solution */
	struct atnode *father;  /* pointer to its predecessor in the
			partial solution */
	struct atnode *next;
} ATNODE;

	
/*********************
variable declarations 
*********************/

extern ALLENTRIES ref_tab[MAX_ENTRIES]; /* the reference table of symbols,
               		      productios, and attributes indexed by did */
extern int max_entry; 	/* the maximum did used */
extern int min_entry;   /* the minimum did used */
extern int graphstate;  /* the state of graphs */
extern int *PrintList; /* list of dids of symbols or rules whose graphs to be printed */

extern BBLIMIT; 	/* the limit to control branch and bound */


/********** 
 Files 
**********/

extern FILE *IN;  /* input file */
extern FILE *Out; /* file pointer for graph output */
extern FILE *Prot; /* Protocol file */
extern FILE *Err; /* Error message file */

/*********************** 
Function Declarations 
***********************/

extern int lookup_attr();
extern void init_ref_tab(/* IS */);
extern void cons_init_dp();
extern void cons_init_ds();
extern void transitivecloure();
extern void partit();
extern void check_cycle();
extern void visitsequence();
extern void write_dataStruct();
extern void read_orderOption();
extern void read_printOption();
extern void print_VisitSequences();
extern void print_SymbGraphs();
extern void print_RuleGraphs();
extern void print_stat();

/* interface between option.c and predefdp.c */
typedef struct RArrangeHelp {
	int toAttrId;
	int fromAttrId;
	int toOrd;
	int toSymbId;
	int fromOrd;
	int fromSymbId;
	int prodId;
} *ArrangeHelp;
#define	KArrangeHelp 2
#define	NArrangeHelp ((ArrangeHelp)calloc(1, sizeof(struct RArrangeHelp)))

extern
void enter_depSymbol (/*
	ArrangeHelp   Ptr;
*/);

extern 
ArrangeHelp getIdArrangeSymbol (/*
	String symb, fromattr, toattr;
*/);

extern
void PredefDp (/*
	AttrEval	ae;
*/);

extern	VSPTR   *symbvsvect;/* now dynamic allocated array of size MAX_SYMBNO */
extern	SLNODE **symbvect;  /* now dynamic allocated array of size MAX_SYMBNO */

