/* $Id: initds.c,v 2.1 1991/06/10 13:25:45 cogito Exp $ */
/* $Log: initds.c,v $
 * Revision 2.1  1991/06/10  13:25:45  cogito
 * sources for ORDER combined with GORTO
 * */
static char rcs_id[]= "$Id: initds.c,v 2.1 1991/06/10 13:25:45 cogito Exp $";

/************************************************************************
*                                                                       *
*       Module  : initds.c                                              *
*                                                                       *
*       Version : 1.0                                                   *
*                                                                       *
*       Author  : Jiyang Liu                                            *
*                                                                       *
*       Contains routines for Building the direct attribute dependency  *
*       graphs for  Symbols of the AG.					*
*                                                                       *
************************************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool).
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		25.04.90	Volker Niepel
	 */

#ifndef GORTO
#include "order.h"
#else
#include "Gorto.h"
#endif

/****************************************************************
*                                                               *
*    void cons_init_ds()                                        *
*    construct the initial dependency graph for each symbol.    *
*    the dependency relations in the init_dp's are projected    *
*    into the init_ds's.                                        *
*                                                               *
****************************************************************/

void
cons_init_ds()
{
int i, atnum;
int pid, sid;
int row, col_word, st_row, st_col_word;
SLNODE  *slnptr;

for (i=0; i<max_entry; i++) 

   if ((ref_tab[i].etag == SYMB) &&
       (atnum = ref_tab[i].entry.symb.attr_num)) {

	/* construct the initial dependency graph of this symbol */
	sid = i;
	slnptr = ref_tab[sid].entry.symb.hddown;
	while (slnptr != NULL ) {

	   pid = slnptr->pid;
	   st_row = slnptr->start_row;
#ifndef GORTO
	   st_col_word = slnptr->start_col;

	   for (row=0; row < atnum; row++)
	      for (col_word=0; col_word<(atnum-1)/WORD_LENGTH+1; col_word++) {
	        ref_tab[sid].entry.symb.init_ds[row][col_word] |= 
	        ref_tab[pid].entry.prod.init_dp[st_row+row][st_col_word+col_word];
	        ref_tab[sid].entry.symb.ds[row][col_word] |= 
	        ref_tab[pid].entry.prod.init_dp[st_row+row][st_col_word+col_word];
	      }
#else
	   st_col_word = slnptr->start_row;

	   for (row=0; row < atnum; row++)
	      for (col_word=0; col_word<atnum; col_word++) {
		if (ref_tab[pid].entry.prod.dp
			[st_row+row][st_col_word+col_word] & T_DIR)
		{
		   ref_tab[sid].entry.symb.ds[row][col_word] = T_DIR;
		   ref_tab[sid].entry.symb.ds_detail[row][col_word]
			.induced.from = slnptr;
		}
	      }
#endif

	   slnptr = slnptr->down; /* next occurrence of this symbol */

	}
   }


return;
} /* cons_init_ds() */

