# $Id: src.order.Makefile.cpp,v 3.4 1992/07/22 15:13:54 cogito Exp $
# 
# Makefile of the directory order
# 

SHELL= 		/bin/sh

# IDL

X_INC_DIR= XINC

IDL=		../idl
IDLLIGA= 	$(IDL)/LIGA.h $(IDL)/LIGAMacros.h $(IDL)/global.h

# GORTO
GORTO=		../gorto
GORTOOBJDIR=	gorto
GORTOLIB=	$(GORTO)/order.a

# option handler
OPTHANDLER= 	../option

DISTRIB = /tmp

SOURCES	= order.c reftab.c initdp.c initds.c induce.c option.c part.c \
	  visit.c write.c ordout.c stat.c mem.c set.c printerr.c predefdp.c

INCL	= order.h set.h Gorto.h printerr.h

# compiler options
# -DDEBUGNEW=14 -DDEBUG=14

#ifdef XINC
CFLAGS= -I$(IDL) -I$(OPTHANDLER) -I../ligascel -I$(X_INC_DIR) $(EXTCFLAGS)
#else
CFLAGS= -I$(IDL) -I$(OPTHANDLER) -I../ligascel $(EXTCFLAGS)
#endif

# objects

OBJ = order.o \
      reftab.o \
      initdp.o \
      initds.o \
      induce.o \
      option.o \
      part.o \
      visit.o \
      write.o \
      ordout.o \
      stat.o \
      mem.o \
      set.o \
      printerr.o \
	predefdp.o \
      $(OPTHANDLER)/opt_input.o

# object for GORTO
GORTOOBJ= $(GORTOOBJDIR)/reftab.o \
	$(GORTOOBJDIR)/initdp.o \
	$(GORTOOBJDIR)/initds.o \
	$(GORTOOBJDIR)/option.o \
	$(GORTOOBJDIR)/induce.o \
	$(GORTOOBJDIR)/part.o \
	$(GORTOOBJDIR)/set.o \
	$(GORTOOBJDIR)/visit.o \
	$(GORTOOBJDIR)/write.o \
	$(GORTOOBJDIR)/printerr.o \
	$(GORTOOBJDIR)/predefdp.o

LIBS= $(IDL)/IDL.a ../ligascel/err.o ../ligascel/source.o

TIDY	= core *.o a.out
CLEAN	= $(TIDY) order ../ligaOrd.exe gorto
CLOBBER	= $(CLEAN) Makefile
RCS	= $(SOURCES) $(INCL)
COFLAGS = -q

# generates the executable order

all:	../ligaOrd.exe

../ligaOrd.exe:  $(OBJ) $(LIBS)
	$(CC) $(CFLAGS) $(OBJ) $(LIBS) -o ../ligaOrd.exe

# generates gorto order objects
# (should be called from gorto directory with the specific options)

$(GORTOLIB):	$(GORTOOBJDIR) $(GORTOOBJ)
	rm -f $(GORTOLIB)
	ar q $(GORTOLIB) $(GORTOOBJ)
	ranlib $(GORTOLIB)

$(GORTOOBJDIR):	
	mkdir $(GORTOOBJDIR)

# Here is a dependency, which works with my make. See, if you can
# use it.
#
#$(GORTOOBJDIR)/%.o: %.c
#	$(CC) $(CFLAGS) -c $(@:gorto/%.o=%).c -o $@
#
# In order to be compatible with all the different make-versions out
# there, i included a set of simpler dependency rules.

$(GORTOOBJDIR)/reftab.o: reftab.c
	$(CC) $(CFLAGS) -c reftab.c -o $@

$(GORTOOBJDIR)/initdp.o: initdp.c
	$(CC) $(CFLAGS) -c initdp.c -o $@

$(GORTOOBJDIR)/initds.o: initds.c
	$(CC) $(CFLAGS) -c initds.c -o $@

$(GORTOOBJDIR)/option.o: option.c
	$(CC) $(CFLAGS) -c option.c -o $@

$(GORTOOBJDIR)/induce.o: induce.c
	$(CC) $(CFLAGS) -c induce.c -o $@

$(GORTOOBJDIR)/part.o: part.c
	$(CC) $(CFLAGS) -c part.c -o $@

$(GORTOOBJDIR)/set.o: set.c
	$(CC) $(CFLAGS) -c set.c -o $@

$(GORTOOBJDIR)/visit.o: visit.c
	$(CC) $(CFLAGS) -c visit.c -o $@

$(GORTOOBJDIR)/write.o: write.c 
	$(CC) $(CFLAGS) -c write.c -o $@

$(GORTOOBJDIR)/printerr.o: printerr.c
	$(CC) $(CFLAGS) -c printerr.c -o $@

$(GORTOOBJDIR)/predefdp.o: predefdp.c
	$(CC) $(CFLAGS) -c predefdp.c -o $@

# checkout

checkout:
	-co $(COFLAGS) $(RCS)

# installation

install:
	rm -f $(DESTDIR)/Tool/liga/ligaOrd.exe
	cp order $(DESTDIR)/Tool/liga/ligaOrd.exe
	chmod 755 $(DESTDIR)/Tool/liga/ligaOrd.exe

# distribution
 
distrib:	$(SOURCES) $(INCL) Makefile.cpp
	rm -rf $(DISTRIB)/order
	mkdir $(DISTRIB)/order
	cp $(SOURCES) $(INCL) Makefile.cpp $(DISTRIB)/order
	cd $(DISTRIB)/order; chmod 0644 $(SOURCES) $(INCL) Makefile.cpp

# SourceDistr

SourceDistr: $(SOURCES) $(INCL) Makefile.cpp

# cleaning targets

.PHONY:		tidy clean rcsclean clobber

tidy:
		rm -rf $(TIDY)

clean:
		rm -rf $(CLEAN)

clobber:
		rm -rf $(CLOBBER)

rcsclean:
		rm -rf $(CLEAN) Makefile
		-rcsclean $(COFLAGS) $(RCS) Makefile.cpp

save:
		-mkdir RCS
		-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
		-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
		-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
		-ci -fOriginal.1 -m/dev/null -q $(RCS)

induce.o: order.h set.h ../idl/LIGA.h ../idl/global.h
initdp.o: order.h set.h  
initdp.o:  ../idl/LIGA.h ../idl/global.h ../ligascel/ligaconsts.h
initds.o: order.h set.h ../idl/LIGA.h ../idl/global.h
option.o: order.h set.h ../idl/LIGA.h ../idl/global.h
option.o: ../option/option_enums.h ../option/option_types.h
option.o: ../option/opt_input.h
order.o: order.h set.h ../idl/LIGA.h ../idl/liga_func.h ../idl/global.h
order.o: ../option/option_enums.h ../option/option_types.h 
order.o: ../option/opt_input.h
ordout.o: order.h set.h ../idl/LIGA.h ../idl/global.h ../ligascel/ligaconsts.h
part.o: order.h set.h ../idl/LIGA.h ../idl/global.h ../ligascel/ligaconsts.h
reftab.o: order.h set.h ../idl/LIGA.h ../idl/global.h
set.o: set.h 
stat.o: order.h set.h ../idl/LIGA.h ../idl/global.h
visit.o: order.h set.h ../idl/LIGA.h ../idl/global.h
write.o: order.h set.h ../idl/LIGA.h ../idl/global.h
predefdp.o: order.h

$(GORTOOBJDIR)/induce.o: Gorto.h set.h ../idl/LIGA.h ../idl/global.h
$(GORTOOBJDIR)/initdp.o: Gorto.h set.h  
$(GORTOOBJDIR)/initdp.o: ../idl/LIGA.h ../idl/global.h 
$(GORTOOBJDIR)/initdp.o: ../ligascel/ligaconsts.h
$(GORTOOBJDIR)/initds.o: Gorto.h set.h ../idl/LIGA.h ../idl/global.h
$(GORTOOBJDIR)/option.o: Gorto.h set.h ../idl/LIGA.h ../idl/global.h
$(GORTOOBJDIR)/option.o: ../option/option_enums.h ../option/option_types.h
$(GORTOOBJDIR)/option.o: ../option/opt_input.h
$(GORTOOBJDIR)/part.o: Gorto.h set.h ../idl/LIGA.h ../idl/global.h 
$(GORTOOBJDIR)/part.o: ../ligascel/ligaconsts.h
$(GORTOOBJDIR)/reftab.o: Gorto.h set.h ../idl/LIGA.h ../idl/global.h
$(GORTOOBJDIR)/set.o: set.h 
$(GORTOOBJDIR)/visit.o: Gorto.h set.h ../idl/LIGA.h ../idl/global.h
$(GORTOOBJDIR)/write.o: Gorto.h set.h ../idl/LIGA.h ../idl/global.h
$(GORTOOBJDIR)/predefdp.o: Gorto.h
