
/* $Id: optim.c,v 1.10 1992/01/29 13:17:35 cogito Exp $ */
/* $Log: optim.c,v $
 * Revision 1.10  1992/01/29  13:17:35  cogito
 * Call to Function: init_did_table modified
 *
 * Revision 1.9  1991/10/31  14:53:15  cogito
 * Changed Default from INCLUDING ON to INCLUDING OFF
 *
 * Revision 1.8  1991/10/02  12:58:34  cogito
 * Error Output via err.c added
 *
 * Revision 1.7  1991/01/15  17:49:40  cogito
 * new IDL interface
 *
 * Revision 1.6  91/01/08  10:26:17  cogito
 * changed input of options
 *  */
static char rcs_id[]= "$Id: optim.c,v 1.10 1992/01/29 13:17:35 cogito Exp $";

/************************************************/
/*                                              */ 
/*       Version : 1.0                          */ 
/*                                              */ 
/*       Module  : optim.c                      */ 
/*                                              */ 
/*       Contains the main-routine of           */  
/*       liga.optim                             */         
/*                                              */ 
/************************************************/
 
 
 
/************************************************/
/*                   includes                   */
/************************************************/
 

#include <stdio.h>
#include "lookup_idl.h"
#include "OPTIM.h"
#include "OPTIMMacros.h"

/* Includes for option handling */
#include "option_enums.h"
#include "option_types.h"
#include "opt_input.h"

#include "optglobal.h"
#include "optfct.h"
#include "optidl.h"

#include "opterr.h"

/*****************************************/
/*           global options              */
/*****************************************/


Boolean   optimize_option         = TRUE;  /* default */
Boolean   protocol_option         = FALSE; /* default */
Boolean   exp_incl_option         = FALSE; /* default */ /* changed ! */
Boolean   parsetime_option        = FALSE; /* default */
Boolean   no_var_option  	  = FALSE; /* default */
Boolean   no_stack_option         = FALSE; /* default */
Boolean   var_group_option        = FALSE; /* default */
Boolean   stack_group_option      = FALSE; /* default */
Boolean   group_all_option        = FALSE; /* default */
Boolean   var_list_option         = FALSE; /* default */
Boolean   stack_list_option       = FALSE; /* default */
Boolean   tree_list_option        = FALSE; /* default */
Boolean   var_group_list_option   = FALSE; /* default */
Boolean   stack_group_list_option = FALSE; /* default */
Boolean   grammar_option          = FALSE; /* default */


/*****************************************/
/*             global variables          */
/*****************************************/

AttrEval		ligaroot;
Visit_Sequences		optimroot;

FILE	*listing = stdout;
FILE	*optim_optionfile1, *optim_optionfile2;

OptCollect optim_opts;

int   max_definitions;

int   neverusedcounter=0;

int   pushcounter=0, popcounter=0, topcounter=0, swapcounter=0, clobbercounter=0;

int   globvarcounter=0, globstackcounter=0, treeattrcounter=0;
int   vargroupcounter=0, stackgroupcounter=0;

int   totalassigns=0, identassigns=0;

int   inclattrcounter=0;



/************************************************/
/*                   functions                  */
/************************************************/

int main();



/************************************************/
/*                     main                     */
/************************************************/

int main (argc, argv) 
 int argc;
char *argv[]; 
{
  FILE   *in = stdin, *out = stdout;

  argv++;
  if (argc  < 2 || (*argv)[0] != '-') {
     fprintf(stderr,"\nUsage: optim [-i in] [-o out] [-p list] [-c ctl1 ctl2]\n\n");
     exit(5);
  }
  for ( ; argc>1 ; argc--, argv++)
     if ((*argv)[0] == '-') {
       switch((*argv)[1]) {
	  case 'c' :
	    argv++;
	    argc--;
	    if (!(optim_optionfile1= fopen (*argv, "r")))
	    {
		fprintf (stderr, "\nCan't open optionfile 1 %s\n", *argv);
		exit (5);
	    }
	    argv++;
	    argc--;
	    if (!(optim_optionfile2= fopen (*argv, "r")))
	    {
		fprintf (stderr, "\nCan't open optionfile 2 %s\n", *argv);
		exit (5);
	    }
	    break;
	  case 'g' : /* for tests only */
	     group_all_option = TRUE;
	     break;
	  case 'i' : 
	     argv++; argc--;
	     in = fopen(*argv,"r");
	     if (in == NULL)
	     {
		fprintf(stderr,"\nCan't open Inputfile %s\n",*argv);
		exit(5);
	     }
	     break;
	  case 'l' : /* for tests only */
	     grammar_option = TRUE;
	     break;
	  case 'o' : 
	     argv++; argc--;
	     out = fopen(*argv,"w");
	     if (out == NULL)
             {
		fprintf(stderr,"\nCan't open Outputfile %s\n",*argv);
		exit(5);
	     }
	     break;
	  case 'p' :
	     argv++; argc--;
	     listing = fopen(*argv,"w");
	     if (listing == NULL)
	     {
		fprintf(stderr,"\nCan't open Protocolfile %s\n",*argv);
		exit(5);
	     }
	     break;
	  case 'v' : /* for tests only */
	     no_var_option = TRUE;
	     break;
	  case 'x' : /* for tests only */
	     protocol_option = TRUE;
	     break;
	  default :
	     fprintf(stderr,"\n find illegal option %s\n", *argv);
	     fprintf(stderr," possible options: -i -o -p -c\n\n");
	     exit(5); 
	} /* end of switch */
     }
     else {
       fprintf(stderr,"\nUsage: optim [-i in] [-o out] [-p list] [-c ctl1 ctl2]\n");
       exit(5);
     }


  /* read files for option handling */
  optim_opts= (OptCollect) malloc (sizeof (struct _optcollect));
  optim_opts->opt_opts= (OptList) NULL;
  OptionInput (optim_opts, optim_optionfile1);
  fclose (optim_optionfile1);
  OptionInput (optim_opts, optim_optionfile2);
  fclose (optim_optionfile2);

  fprintf(listing,"\n\n\n");
  fprintf(listing,"***    THIS IS OPTIM, A DEPENDENCY-PASS OF LIGA    ***");
  fprintf(listing,"\n\n");

  ligaroot = ligain(in);
  InitOptimOptions();
  if (optimize_option)
  {
	max_definitions = init_did_table(ligaroot->defseq);
	if (max_definitions > MAX_DEFS)
	{
	  fprintf(listing,"*** ERROR: TOO MANY DEFINITIONS   \n\n\n");
	  err_setpos(0,0);
	  err_print_deadly("Too many definitions.");
          exit(5);
	}
	(void) InitOptimStructure();
	(void) InitAttrArray();
	if (!exp_incl_option)
        {
          (void) HandleExpInclOption(optimroot);
        }
	if (tree_list_option)
	{
	  (void) HandleTreeListOption(optimroot);
	}
	(void) AnalyzeAttributes(optimroot);
	if (var_list_option)
	{
	  HandleVarListOption(optimroot);
	}
	if (stack_list_option)
	{
	  HandleStackListOption(optimroot);
	}
	if (!no_stack_option)
	{
	  InsertStackOperations(optimroot);
	}
	if (grammar_option)
	{
	  (void) GrammarLifetimeAnalysis(optimroot->tree_attrs);
	}
	(void) GroupAttributes(optimroot);
	(void) OptResultsOut(optimroot);
  }
  else
  {
      HandleOptimizeOption(ligaroot);
  }
  ligaout(out, ligaroot);
  return (0);

} /* end of main */


