# $Id: src.optim.Makefile.cpp,v 1.6 1992/03/03 12:32:39 uwe Exp $
# 
# Makefile of the directory optim
# 

SHELL	= /bin/sh

# IDL

IDL	=	../idl
IDLLOOK	= $(IDL)/LIGA.h $(IDL)/LIGAMacros.h $(IDL)/lookup_idl.h

# option handler
OPTHANDLER= ../option
ERRHANDLER= ../ligascel

DISTRIB = /tmp

# compiler options

CFLAGS	= -I$(IDL) -I$(OPTHANDLER) -I$(ERRHANDLER) # -DDEBUGG -DLIFETIME
COFLAGS	=  -q

RM	="/bin/rm"
RMFLAGS	= -f

# objects

OBJ= optim.o  OPTIM.o opterr.o optbuildstr.o optidl.o optfct.o optvar.o \
     optgroup.o optstack.o optout.o optlifet.o  \
     $(ERRHANDLER)/err.o $(ERRHANDLER)/source.o $(OPTHANDLER)/opt_input.o

LIBS= $(IDL)/IDL.a

SOURCES	= OPTIM.c optbuildstr.c optfct.c optgroup.c optidl.c optim.c \
	   optlifet.c optout.c optstack.c optvar.c opterr.c

HEADER = OPTIM.h OPTIMMacros.h optglobal.h optfct.h optidl.h optdid.h opterr.h

TIDY	= *.o
CLEAN	= $(TIDY) optim ../ligaOptim.exe
CLOBBER	= $(CLEAN) Makefile
RCS	= $(SOURCES) $(HEADER)

# MAKE

all:	../ligaOptim.exe

../ligaOptim.exe: optim
	rm -f ../ligaOptim.exe
	ln optim ../ligaOptim.exe

optim: $(OBJ) $(LIBS)
	${CC} $(CFLAGS) $(OBJ) $(LIBS) -o optim

OPTIM.o:	$(HEADER) $(IDL)/writer.h $(IDL)/reader.h \
	$(IDL)/global.h

optim.o:	$(HEADER) $(IDLLOOK) $(IDL)/global.h \
	$(OPTHANDLER)/option_enums.h $(OPTHANDLER)/option_types.h \
	$(OPTHANDLER)/opt_input.h

optbuildstr.o:	$(HEADER) $(IDLLOOK) $(IDL)/global.h

optidl.o:	$(HEADER)

optfct.o:	$(HEADER)

optsivi.o:	$(HEADER)

optvar.o:	$(HEADER)

optgroup.o:	$(HEADER)

optstack.o:	$(HEADER)

optout.o:	$(HEADER)

optlifet.o:	$(HEADER)


# checkout
 
checkout:
	-co $(COFLAGS) $(RCS)
	-co $(COFLAGS) src.optim.README; mv src.optim.README README

# installation

install:
	rm -f $(DESTDIR)/Tool/liga/ligaOptim.exe
	cp optim $(DESTDIR)/Tool/liga/ligaOptim.exe
	chmod 755 $(DESTDIR)/Tool/liga/ligaOptim.exe

# distribution

distrib:	$(SOURCES) $(HEADER) Makefile.cpp README
	- rm -rf $(DISTRIB)/optim
	mkdir $(DISTRIB)/optim
	cp $(SOURCES) $(HEADER) Makefile.cpp README $(DISTRIB)/optim
	cd $(DISTRIB)/optim; chmod 0644 $(SOURCES) $(HEADER) Makefile.cpp README

# SourceDistr

SourceDistr: $(SOURCES) $(HEADER) Makefile.cpp README

# cleaning targets

.PHONY:	tidy clean rcsclean clobber

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	rm -rf $(CLEAN) Makefile
	-rcsclean $(COFLAGS) $(RCS) Makefile.cpp

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(RCS)




