/* $Id: Message.c,v 1.3 1991/12/18 16:02:28 cogito Exp $ */
static char rcs_id[]= "$Id: Message.c,v 1.3 1991/12/18 16:02:28 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Popup/Message.c					*
 *									*
 *	CONTENTS:	Implementation of messages to the user		*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

       /************************ WARNING ************************ 
	*							*
 	*	This file depends on the Athena Widget Set	*
 	*	of X Version 11, Release 4			*
	*							*
	*********************************************************/

#include "Misc.h"
#include "Create.h"
#include "Main.h"
#include "Popup.h"

#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Command.h>


/************************************************************************
 *			Private widget definitions			*
 ************************************************************************/

PRIVATE Widget Popup, Dialog, Confirm;


/************************************************************************
 *			     ConfirmMessageCB				*
 ************************************************************************/

/* Callback used for confirming the message.
 */

/*ARGSUSED*/
PRIVATE void ConfirmMessageCB (w, client_data, call_data)
        Widget  w;
        caddr_t client_data;
        caddr_t call_data;
{
	XtPopdown	(Popup);
	XtDestroyWidget	(Popup);
}


/************************************************************************
 *				 Message				*
 ************************************************************************/

/* Gives the message <message> to the user and prompts for a confirm.
 * The popup window is placed over the window of the specified production
 * or symbol with did <did>.
 */

PUBLIC void Message (did, message)
	int	did;
	String	message;
{
	Arg		args[10];
	int		n;
	Position	x,y;

      /* Popup shell */
	GetPopupPositions (did, &x, &y);
        n = 0;
        XtSetArg (args[n], XtNx, x); n++;
        XtSetArg (args[n], XtNy, y); n++;
        Popup = XtCreatePopupShell ("Message", transientShellWidgetClass,
                                                Toplevel, args, n);

      /* Dialog */
	n = 0;
	XtSetArg (args[n], XtNlabel, message); n++;
	Dialog = CreateDialog ("msg", Popup);

      /* Confirm */
	n = 0;
	CreateCommand (Confirm, "Ok", Dialog, ConfirmMessageCB, NULL);

      /* Popup the message */
	XtPopup (Popup, XtGrabExclusive);
}
