
#include <stdio.h>
#include <malloc.h>
#include "ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG7 *_PPTG7;
struct _SPTG7{
  _PTGProc _print;
  PTGNode _desc [7];
};

typedef struct _SPTG6 *_PPTG6;
struct _SPTG6{
  _PTGProc _print;
  PTGNode _desc [6];
};

typedef struct _SPTG5 *_PPTG5;
struct _SPTG5{
  _PTGProc _print;
  PTGNode _desc [5];
};

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGNumb *_PPTGNumb;
struct _SPTGNumb{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGAsIs *_PPTGAsIs;
struct _SPTGAsIs{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGC_Str *_PPTGC_Str;
struct _SPTGC_Str{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGP_Str *_PPTGP_Str;
struct _SPTGP_Str{
  _PTGProc _print;
  char *_t0;
};

void _PrPTGDescName(n)
_PPTG1 n;
{
  fputs ("_desc", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGVisitProcName(n)
_PPTG2 n;
{
  fputs ("_VS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGInclGlobName(n)
_PPTG1 n;
{
  fputs ("_IG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGInclLocName(n)
_PPTG1 n;
{
  fputs ("_IL", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGSymbStructName(n)
_PPTG1 n;
{
  fputs ("struct _TS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGSymbPtrTypeName(n)
_PPTG1 n;
{
  fputs ("_TSP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGProdStructName(n)
_PPTG1 n;
{
  fputs ("struct _TP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGProdPtrTypeName(n)
_PPTG1 n;
{
  fputs ("_TPP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGMkProcName(n)
_PPTG1 n;
{
  fputs ("Mk", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGNullNodePtr(n)
_PPTG0 n;
{
  fputs ("NULLNODEPTR ", f);
}

void _PrPTGMkParmName(n)
_PPTG1 n;
{
  fputs ("_tr", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGTermGetName(n)
_PPTG2 n;
{
  fputs ("GET", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGLhsStackAttrName(n)
_PPTG1 n;
{
  fputs ("_AS0", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGRhsStackAttrName(n)
_PPTG2 n;
{
  fputs ("_AS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGVarAttrName(n)
_PPTG1 n;
{
  fputs ("_AV", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGTreeAttrName(n)
_PPTG1 n;
{
  fputs ("_AT", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGRuleAttrName(n)
_PPTG2 n;
{
  fputs ("_AR", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGStmt(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

void _PrPTGCall(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")", f);
}

void _PrPTGAssign(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGIfStmt(n)
_PPTG3 n;
{
  fputs ("\nif (", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (") {\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n} else {\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\n}", f);
}

void _PrPTGIfExpr(n)
_PPTG3 n;
{
  fputs ("\n((", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n) ? (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n) : (", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("))\n", f);
}

void _PrPTGParen(n)
_PPTG1 n;
{
  fputs ("\n(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")\n", f);
}

void _PrPTGPtrTo(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("*", f);
}

void _PrPTGSelectPtr(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("->", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGContent(n)
_PPTG1 n;
{
  fputs ("(* ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

void _PrPTGAddr(n)
_PPTG1 n;
{
  fputs ("(& ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

void _PrPTGDecl(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";\n", f);
}

void _PrPTGSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGComElem(n)
_PPTG1 n;
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGComSeq(n)
_PPTG2 n;
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGSeqCom(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (",", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGEmpty(n)
_PPTG0 n;
{
}

void _PrPTGSep(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
}

void _PrPTGFile(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
}

void _PrPTGNumb(n)
_PPTGNumb n;
{
  fprintf (f, "%d",n->_t0);
}

void _PrPTGAsIs(n)
_PPTGAsIs n;
{
  fprintf (f, "%s",n->_t0);
}

extern void C_outstr();

void _PrPTGC_Str(n)
_PPTGC_Str n;
{
C_outstr(f,n->_t0);
}

extern void P_outstr();

void _PrPTGP_Str(n)
_PPTGP_Str n;
{
P_outstr(f,n->_t0);
}

void _PrPTGGramCodeHead(n)
_PPTG0 n;
{
  fputs ("\n$CODE\nEOF=1.\n", f);
}

void _PrPTGDefineCode(n)
_PPTG2 n;
{
  fputs ("#define ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n", f);
}

void _PrPTGGramCode(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (".\n", f);
}

void _PrPTGGramStackHead(n)
_PPTG0 n;
{
  fputs ("\n$STACK\n", f);
}

void _PrPTGGramStack(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (".\n", f);
}

void _PrPTGGramProdHead(n)
_PPTG1 n;
{
  fputs ("\n$GRAMMAR\n<$START_SYMBOL>: ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (".\n", f);
}

void _PrPTGProduction(n)
_PPTG4 n;
{
  fputs ("\n%", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (": ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (".\n", f);
}

void _PrPTGGramLit(n)
_PPTG1 n;
{
  fputs (" ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
}

void _PrPTGProdAction(n)
_PPTG2 n;
{
  fputs ("\n&'", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_nst[_nsp] =", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";'", f);
}

void _PrPTGDecrStack(n)
_PPTG1 n;
{
  fputs ("_nsp -=", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

void _PrPTGIncrStack(n)
_PPTG0 n;
{
  fputs ("_incrnodestack ();", f);
}

void _PrPTGMkProcCall(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(&curpos", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")", f);
}

void _PrPTGChainMkProcCall(n)
_PPTG3 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(&(", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("->_pos)", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (")", f);
}

void _PrPTGStackArg(n)
_PPTG1 n;
{
  fputs ("_nst[_nsp+", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("]", f);
}

void _PrPTGTreeConFileHead(n)
_PPTG0 n;
{
  fputs ("\n#include \"HEAD.h\"\n", f);
  fputs ("\n#include \"node.h\"\n", f);
  fputs ("\n#include \"visitprocs.h\"\n", f);
  fputs ("\n#include \"gsdescr.h\"\n", f);
  fputs ("\nextern void free();\n", f);
  fputs ("\nextern char *malloc();\n", f);
  fputs ("\n#include \"obstack.h\"\n", f);
  fputs ("\nstatic struct obstack TreeSpace;\n", f);
  fputs ("\n#define obstack_chunk_alloc malloc\n", f);
  fputs ("\n#define obstack_chunk_free free\n", f);
  fputs ("\nchar* TreeNodeAlloc(size) int size;\n", f);
  fputs ("\n{return (obstack_alloc(&TreeSpace, size));}\n", f);
  fputs ("\nvoid InitTree() { obstack_init(&TreeSpace); }\n", f);
}

void _PrPTGTermDefineGet(n)
_PPTG2 n;
{
  fputs ("\n#ifndef ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n#define ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("(x) (x)", f);
  fputs ("\n#endif\n", f);
}

void _PrPTGLeafProc(n)
_PPTG1 n;
{
  fputs ("\nvoid SourceLeaf(d) GRUNDSYMBOLDESKRIPTOR *d;\n", f);
  fputs ("{_incrnodestack ();\n", f);
  fputs ("switch (d->SyntaxCode) {\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("}}\n", f);
}

void _PrPTGTermNodeCase(n)
_PPTG3 n;
{
  fputs ("\ncase ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": _nst[_nsp] =", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("(&(d->Pos)", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("); break;\n", f);
}

void _PrPTGTermArg(n)
_PPTG1 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" (d->Attr)", f);
}

void _PrPTGMkTermFct(n)
_PPTG7 n;
{
  fputs ("\nNODEPTR ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(_coordref", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")\n", f);
  fputs ("POSITION *_coordref;\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("{\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (" n;\n", f);
  fputs ("n = (", f);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs (") TreeNodeAlloc (sizeof (", f);
  (* (n->_desc [5]->_print))(n->_desc[5]);
  fputs ("));\n", f);
  fputs ("n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;\n", f);
  (* (n->_desc [6]->_print))(n->_desc[6]);
  fputs ("\nreturn ((NODEPTR) n);\n}\n", f);
}

void _PrPTGTermAttrAssign(n)
_PPTG2 n;
{
  fputs ("\nn->", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
}

void _PrPTGTreeConHeaderHead(n)
_PPTG0 n;
{
  fputs ("\ntypedef void (* _VPROCPTR) ();\n", f);
  fputs ("\ntypedef struct {int line, col;} _Coord;\n", f);
  fputs ("\ntypedef struct {_Coord _pos; _VPROCPTR _proc;}* NODEPTR;\n", f);
  fputs ("\n#define NULLNODEPTR ((NODEPTR)0)\n", f);
  fputs ("\n#include \"treestack.h\"\n", f);
  fputs ("\nextern void SourceLeaf ();\n", f);
  fputs ("\nextern void InitTree();\n", f);
}

void _PrPTGMkProcHeader(n)
_PPTG1 n;
{
  fputs ("\nextern NODEPTR ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("( );\n", f);
}

void _PrPTGMkFctHead(n)
_PPTG4 n;
{
  fputs ("\nNODEPTR ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(_coordref", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")\n", f);
  fputs ("POSITION *_coordref;\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("{", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (" n;\n", f);
}

void _PrPTGMkParmSpec(n)
_PPTG1 n;
{
  fputs ("NODEPTR ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

void _PrPTGMkFctBody(n)
_PPTG4 n;
{
  fputs ("n = (", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (") TreeNodeAlloc (sizeof (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("));\n", f);
  fputs ("n->_proc =", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (";\n", f);
  fputs ("n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs ("return ( (NODEPTR) n);\n}\n", f);
}

void _PrPTGTreeAssign(n)
_PPTG3 n;
{
  fputs ("n->", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("= (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (";\n", f);
}

PTGNode PTGDescName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGDescName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGVisitProcName(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGVisitProcName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGInclGlobName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGInclGlobName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGInclLocName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGInclLocName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSymbStructName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGSymbStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSymbPtrTypeName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGSymbPtrTypeName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGProdStructName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGProdStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGProdPtrTypeName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGProdPtrTypeName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGMkProcName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGMkProcName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNullNodePtr()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGNullNodePtr;
  return ((PTGNode) n);
}

PTGNode PTGMkParmName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGMkParmName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGTermGetName(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGTermGetName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGLhsStackAttrName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGLhsStackAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGRhsStackAttrName(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGRhsStackAttrName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGVarAttrName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGVarAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGTreeAttrName(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGTreeAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGRuleAttrName(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGRuleAttrName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGStmt(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGStmt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGCall(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGCall;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGAssign(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGIfStmt(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGIfStmt;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGIfExpr(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGIfExpr;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGParen(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGParen;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGPtrTo(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPtrTo;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSelectPtr(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSelectPtr;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGContent(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGContent;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGAddr(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGAddr;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGDecl(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGComElem(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGComElem;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGComSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGComSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSeqCom(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeqCom;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGEmpty()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGEmpty;
  return ((PTGNode) n);
}

PTGNode PTGSep(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGSep;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGFile(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGFile;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNumb(_t0)
  int _t0;
{
  _PPTGNumb n;

  if ((n = (_PPTGNumb) malloc (sizeof (struct _SPTGNumb)))  ==  (_PPTGNumb)NULL)
	MEMERR
  n->_print = _PrPTGNumb;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGAsIs(_t0)
  char *_t0;
{
  _PPTGAsIs n;

  if ((n = (_PPTGAsIs) malloc (sizeof (struct _SPTGAsIs)))  ==  (_PPTGAsIs)NULL)
	MEMERR
  n->_print = _PrPTGAsIs;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGC_Str(_t0)
  char *_t0;
{
  _PPTGC_Str n;

  if ((n = (_PPTGC_Str) malloc (sizeof (struct _SPTGC_Str)))  ==  (_PPTGC_Str)NULL)
	MEMERR
  n->_print = _PrPTGC_Str;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGP_Str(_t0)
  char *_t0;
{
  _PPTGP_Str n;

  if ((n = (_PPTGP_Str) malloc (sizeof (struct _SPTGP_Str)))  ==  (_PPTGP_Str)NULL)
	MEMERR
  n->_print = _PrPTGP_Str;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGGramCodeHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGGramCodeHead;
  return ((PTGNode) n);
}

PTGNode PTGDefineCode(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGDefineCode;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGGramCode(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGGramCode;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGGramStackHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGGramStackHead;
  return ((PTGNode) n);
}

PTGNode PTGGramStack(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGGramStack;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGGramProdHead(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGGramProdHead;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGProduction(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGProduction;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGGramLit(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGGramLit;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGProdAction(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGProdAction;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGDecrStack(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGDecrStack;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGIncrStack()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGIncrStack;
  return ((PTGNode) n);
}

PTGNode PTGMkProcCall(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGMkProcCall;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGChainMkProcCall(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGChainMkProcCall;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGStackArg(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGStackArg;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGTreeConFileHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGTreeConFileHead;
  return ((PTGNode) n);
}

PTGNode PTGTermDefineGet(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGTermDefineGet;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGLeafProc(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGLeafProc;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGTermNodeCase(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGTermNodeCase;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGTermArg(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGTermArg;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGMkTermFct(_t0,_t1,_t2,_t3,_t4,_t5,_t6)
PTGNode _t0,_t1,_t2,_t3,_t4,_t5,_t6;
{
  _PPTG7 n;

  if ((n = (_PPTG7) malloc (sizeof (struct _SPTG7)))  ==  (_PPTG7)NULL)
	MEMERR
  n->_print = _PrPTGMkTermFct;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  n->_desc[5]=_t5;
  n->_desc[6]=_t6;
  return ((PTGNode) n);
}

PTGNode PTGTermAttrAssign(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGTermAttrAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGTreeConHeaderHead()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGTreeConHeaderHead;
  return ((PTGNode) n);
}

PTGNode PTGMkProcHeader(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGMkProcHeader;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGMkFctHead(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGMkFctHead;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGMkParmSpec(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGMkParmSpec;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGMkFctBody(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGMkFctBody;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGTreeAssign(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGTreeAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

